/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.starter.testservices.jmx;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.servlets.annotations.SlingServletPathsStrict;
import org.osgi.service.component.annotations.Component;

@Component(service={Servlet.class})
@SlingServletPathsStrict(paths={"/bin/jmx"}, extensions={"json"})
public class JmxServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectName queryName = new ObjectName("org.apache.sling:*");
            response.setContentType("application/json");
            response.setStatus(200);
            response.getWriter().write("[");
            boolean first = true;
            for (ObjectName name : server.queryNames(queryName, null)) {
                if (first) {
                    first = false;
                } else {
                    response.getWriter().write(",");
                }
                response.getWriter().write("\"" + String.valueOf(name) + "\"");
            }
            response.getWriter().write("]");
        }
        catch (MalformedObjectNameException e) {
            throw new ServletException((Throwable)e);
        }
    }
}

