/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.lang.ref.SoftReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import org.apache.sis.image.SourceAlignedImage;
import org.apache.sis.internal.coverage.j2d.FillValues;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.coverage.j2d.TilePlaceholder;
import org.apache.sis.internal.util.Numerics;

final class MaskedImage
extends SourceAlignedImage {
    private final Shape clip;
    private final boolean maskInside;
    private volatile transient Rectangle maskBounds;
    private volatile transient Rectangle maskTiles;
    private transient SoftReference<ByteBuffer> maskRef;
    private transient int maskScanlineStride;
    private final FillValues fillValues;
    private volatile transient TilePlaceholder emptyTiles;

    MaskedImage(RenderedImage renderedImage, Shape shape, boolean bl, Number[] numberArray) {
        super(renderedImage);
        this.clip = shape;
        this.maskInside = bl;
        this.fillValues = new FillValues(this.sampleModel, numberArray, true);
    }

    @Override
    public Object getProperty(String string) {
        return POSITIONAL_PROPERTIES.contains(string) ? this.getSource().getProperty(string) : super.getProperty(string);
    }

    @Override
    public String[] getPropertyNames() {
        return MaskedImage.filterPropertyNames(this.getSource().getPropertyNames(), POSITIONAL_PROPERTIES, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Rectangle getMaskTiles() {
        Rectangle rectangle = this.maskTiles;
        if (rectangle == null) {
            MaskedImage maskedImage = this;
            synchronized (maskedImage) {
                rectangle = this.maskTiles;
                if (rectangle == null) {
                    RenderedImage renderedImage = this.getSource();
                    Rectangle rectangle2 = this.clip.getBounds();
                    ImageUtilities.clipBounds(renderedImage, rectangle2);
                    rectangle = new Rectangle();
                    if (!rectangle2.isEmpty()) {
                        int n = ImageUtilities.pixelToTileX(renderedImage, rectangle2.x + rectangle2.width - 1) + 1;
                        int n2 = ImageUtilities.pixelToTileY(renderedImage, rectangle2.y + rectangle2.height - 1) + 1;
                        rectangle.x = ImageUtilities.pixelToTileX(renderedImage, rectangle2.x);
                        rectangle.width = n - rectangle.x;
                        rectangle.y = ImageUtilities.pixelToTileY(renderedImage, rectangle2.y);
                        rectangle.height = n2 - rectangle.y;
                    }
                    this.maskBounds = rectangle2;
                    this.maskTiles = rectangle;
                }
            }
        }
        return rectangle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ByteBuffer getMask() {
        ByteBuffer byteBuffer;
        if (this.maskRef == null || (byteBuffer = this.maskRef.get()) == null) {
            Object object;
            Rectangle rectangle = this.maskBounds;
            int n = Numerics.ceilDiv(rectangle.width, 8) * rectangle.height;
            int n2 = n & 7;
            if (n2 != 0) {
                n += 8 - n2;
            }
            DataBufferByte dataBufferByte = new DataBufferByte(n);
            byte[] byArray = new byte[]{0, -1};
            IndexColorModel indexColorModel = new IndexColorModel(1, byArray.length, byArray, byArray, byArray);
            WritableRaster writableRaster = Raster.createPackedRaster(dataBufferByte, rectangle.width, rectangle.height, 1, null);
            Graphics2D graphics2D = new BufferedImage(indexColorModel, writableRaster, indexColorModel.isAlphaPremultiplied(), null).createGraphics();
            try {
                graphics2D.translate(-rectangle.x, -rectangle.y);
                graphics2D.setColor(Color.WHITE);
                graphics2D.fill(this.clip);
            }
            finally {
                graphics2D.dispose();
            }
            byteBuffer = ByteBuffer.wrap(dataBufferByte.getData());
            if (this.maskInside) {
                object = byteBuffer.order(ByteOrder.nativeOrder()).asLongBuffer();
                while (((Buffer)object).hasRemaining()) {
                    ((LongBuffer)object).put(((Buffer)object).position(), ((LongBuffer)object).get() ^ 0xFFFFFFFFFFFFFFFFL);
                }
            }
            byteBuffer = byteBuffer.order(ByteOrder.BIG_ENDIAN).asReadOnlyBuffer();
            object = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
            assert (((MultiPixelPackedSampleModel)object).getNumDataElements() == 1 && ((MultiPixelPackedSampleModel)object).getPixelBitStride() == 1 && ((MultiPixelPackedSampleModel)object).getDataBitOffset() == 0);
            this.maskScanlineStride = ((MultiPixelPackedSampleModel)object).getScanlineStride() * 8;
            this.maskRef = new SoftReference<ByteBuffer>(byteBuffer);
        }
        return byteBuffer;
    }

    @Override
    protected Raster computeTile(int n, int n2, WritableRaster writableRaster) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        RenderedImage renderedImage = this.getSource();
        int n9 = ImageUtilities.tileToPixelX(renderedImage, n);
        int n10 = ImageUtilities.tileToPixelY(renderedImage, n2);
        if (!this.getMaskTiles().contains(n, n2)) {
            if (this.maskInside) {
                return renderedImage.getTile(n, n2);
            }
            return this.createEmptyTile(n9, n10);
        }
        Rectangle rectangle = this.maskBounds;
        LongBuffer longBuffer = this.getMask().asLongBuffer();
        int n11 = n9 + renderedImage.getTileWidth();
        int n12 = n10 + renderedImage.getTileHeight();
        int n13 = Math.min(n11, rectangle.x + rectangle.width);
        int n14 = Math.min(n12, rectangle.y + rectangle.height);
        int n15 = Math.max(n9, rectangle.x);
        int n16 = Math.max(n10, rectangle.y);
        int n17 = n13 - rectangle.x;
        int n18 = n15 - rectangle.x;
        Raster raster = null;
        Object object = null;
        int n19 = 0;
        long l = -1L;
        block6: for (n8 = n16; n8 < n14; ++n8) {
            n7 = (n8 - rectangle.y) * this.maskScanlineStride;
            n6 = n7 + n17 >>> 6;
            n5 = (n7 += n18) & 0x3F;
            n4 = n15 - ((n7 >>>= 6) * 64 + n5);
            n3 = n13 - (n4 + n6 * 64);
            assert (n3 >= 0 && n3 < 64) : n3;
            long l2 = longBuffer.get(n7);
            long l3 = Numerics.bitmask(64 - n5) - 1L;
            if (n7 == n6 && n3 != 0) {
                l3 &= -(1L << 64 - n3);
            }
            l &= l2 | l3 ^ 0xFFFFFFFFFFFFFFFFL;
            l2 &= l3;
            while (true) {
                if (l2 != 0L) {
                    int n20 = Long.numberOfLeadingZeros(l2);
                    int n21 = Long.numberOfLeadingZeros((l2 ^ 0xFFFFFFFFFFFFFFFFL) & (1L << 63 - n20) - 1L);
                    int n22 = n4 + n7 * 64 + n20;
                    int n23 = n21 - n20;
                    assert (n23 > 0 && n23 <= 64) : n23;
                    if (n23 > n19) {
                        if (raster == null) {
                            raster = renderedImage.getTile(n, n2);
                            assert (raster.getMinX() == n9 && raster.getMinY() == n10);
                            boolean bl = this.needCreate(writableRaster, raster);
                            if (bl) {
                                writableRaster = this.createTile(n, n2);
                                bl = this.fillValues.isFullyZero;
                            }
                            if (!bl) {
                                this.fillValues.fill(writableRaster);
                            }
                        }
                        n19 = n23;
                        object = null;
                    }
                    object = raster.getDataElements(n22, n8, n23, 1, object);
                    writableRaster.setDataElements(n22, n8, n23, 1, object);
                    l2 &= (1L << 64 - n21) - 1L;
                    continue;
                }
                if (++n7 < n6) {
                    l2 = longBuffer.get(n7);
                    l &= l2;
                    continue;
                }
                if (n7 != n6 || n3 == 0) continue block6;
                l3 = (1L << 64 - n3) - 1L;
                l2 = longBuffer.get(n7);
                l &= l2 | l3;
                l2 &= l3 ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        int n24 = n8 = n15 == n9 && n16 == n10 && n13 == n11 && n14 == n12 ? 1 : 0;
        if (raster == null) {
            if (n8 != 0) {
                return this.createEmptyTile(n9, n10);
            }
            raster = renderedImage.getTile(n, n2);
            n7 = this.needCreate(writableRaster, raster) ? 1 : 0;
            if (n7 != 0) {
                writableRaster = this.createTile(n, n2);
                n7 = this.fillValues.isFullyZero ? 1 : 0;
            }
            if (n7 == 0) {
                this.fillValues.fill(writableRaster);
            }
        }
        assert (raster.getMinX() == n9 && raster.getMinY() == n10);
        if (l == -1L && (n8 | this.maskInside) != 0) {
            return raster;
        }
        if (this.maskInside) {
            n7 = n11 - n9;
            n6 = n14 - n16;
            n5 = 0;
            block8: while (true) {
                switch (n5) {
                    case 0: {
                        n4 = n10;
                        n3 = n16 - n4;
                        break;
                    }
                    case 1: {
                        n4 = n14;
                        n3 = n12 - n4;
                        break;
                    }
                    case 2: {
                        n4 = n9;
                        n3 = n15 - n4;
                        break;
                    }
                    case 3: {
                        n4 = n13;
                        n3 = n11 - n4;
                        break;
                    }
                    default: {
                        break block8;
                    }
                }
                boolean bl = (n5 & 2) == 0;
                int n25 = n3 * (bl ? n7 : n6);
                if (n25 > 0) {
                    if (n25 > n19) {
                        n19 = n25;
                        object = null;
                    }
                    if (bl) {
                        object = raster.getDataElements(n9, n4, n7, n3, object);
                        writableRaster.setDataElements(n9, n4, n7, n3, object);
                    } else {
                        object = raster.getDataElements(n4, n16, n3, n6, object);
                        writableRaster.setDataElements(n4, n16, n3, n6, object);
                    }
                }
                ++n5;
            }
        }
        return writableRaster;
    }

    private Raster createEmptyTile(int n, int n2) {
        TilePlaceholder tilePlaceholder = this.emptyTiles;
        if (tilePlaceholder == null) {
            this.emptyTiles = tilePlaceholder = TilePlaceholder.filled(this.sampleModel, this.fillValues);
        }
        return tilePlaceholder.create(new Point(n, n2));
    }

    private boolean needCreate(WritableRaster writableRaster, Raster raster) {
        if (writableRaster == null || writableRaster.getDataBuffer() == raster.getDataBuffer()) {
            return true;
        }
        TilePlaceholder tilePlaceholder = this.emptyTiles;
        return tilePlaceholder != null && tilePlaceholder.isCreatorOf(writableRaster);
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            MaskedImage maskedImage = (MaskedImage)object;
            return this.clip.equals(maskedImage.clip) && this.fillValues.equals(maskedImage.fillValues);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.clip.hashCode() + this.fillValues.hashCode();
    }
}

