/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.quality;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.metadata.iso.quality.AbstractResult;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.content.CoverageDescription;
import org.opengis.metadata.content.RangeDimension;
import org.opengis.metadata.distribution.DataFile;
import org.opengis.metadata.distribution.Format;
import org.opengis.metadata.quality.CoverageResult;
import org.opengis.metadata.spatial.SpatialRepresentation;
import org.opengis.metadata.spatial.SpatialRepresentationType;

@XmlType(name="QE_CoverageResult_Type", propOrder={"spatialRepresentationType", "resultSpatialRepresentation", "resultContentDescription", "resultFormat", "resultFile"})
@XmlRootElement(name="QE_CoverageResult")
public class DefaultCoverageResult
extends AbstractResult
implements CoverageResult {
    private static final long serialVersionUID = 5860811052940576277L;
    private SpatialRepresentationType spatialRepresentationType;
    private SpatialRepresentation resultSpatialRepresentation;
    private Collection<RangeDimension> resultContent;
    @Deprecated
    private CoverageDescription resultContentDescription;
    private Format resultFormat;
    private DataFile resultFile;

    public DefaultCoverageResult() {
    }

    public DefaultCoverageResult(CoverageResult coverageResult) {
        super(coverageResult);
        if (coverageResult != null) {
            this.spatialRepresentationType = coverageResult.getSpatialRepresentationType();
            this.resultSpatialRepresentation = coverageResult.getResultSpatialRepresentation();
            this.resultContentDescription = coverageResult.getResultContentDescription();
            this.resultFormat = coverageResult.getResultFormat();
            this.resultFile = coverageResult.getResultFile();
            if (coverageResult instanceof DefaultCoverageResult) {
                this.resultContent = this.copyCollection(((DefaultCoverageResult)coverageResult).getResultContent(), RangeDimension.class);
            }
        }
    }

    public static DefaultCoverageResult castOrCopy(CoverageResult coverageResult) {
        if (coverageResult == null || coverageResult instanceof DefaultCoverageResult) {
            return (DefaultCoverageResult)coverageResult;
        }
        return new DefaultCoverageResult(coverageResult);
    }

    @Override
    @XmlElement(name="spatialRepresentationType", required=true)
    public SpatialRepresentationType getSpatialRepresentationType() {
        return this.spatialRepresentationType;
    }

    public void setSpatialRepresentationType(SpatialRepresentationType spatialRepresentationType) {
        this.checkWritePermission(this.spatialRepresentationType);
        this.spatialRepresentationType = spatialRepresentationType;
    }

    @Override
    @XmlElement(name="resultSpatialRepresentation", required=true)
    public SpatialRepresentation getResultSpatialRepresentation() {
        return this.resultSpatialRepresentation;
    }

    public void setResultSpatialRepresentation(SpatialRepresentation spatialRepresentation) {
        this.checkWritePermission(this.resultSpatialRepresentation);
        this.resultSpatialRepresentation = spatialRepresentation;
    }

    @UML(identifier="resultContent", obligation=Obligation.CONDITIONAL, specification=Specification.UNSPECIFIED)
    public Collection<RangeDimension> getResultContent() {
        this.resultContent = this.nonNullCollection(this.resultContent, RangeDimension.class);
        return this.resultContent;
    }

    public void setResultContent(Collection<RangeDimension> collection) {
        this.resultContent = this.writeCollection(collection, this.resultContent, RangeDimension.class);
    }

    @Override
    @Deprecated
    @XmlElement(name="resultContentDescription", namespace="http://standards.iso.org/iso/19115/-2/gmi/1.0")
    public CoverageDescription getResultContentDescription() {
        return FilterByVersion.LEGACY_METADATA.accept() ? this.resultContentDescription : null;
    }

    @Deprecated
    public void setResultContentDescription(CoverageDescription coverageDescription) {
        this.checkWritePermission(this.resultContentDescription);
        this.resultContentDescription = coverageDescription;
    }

    @Override
    @XmlElement(name="resultFormat", required=true)
    public Format getResultFormat() {
        return this.resultFormat;
    }

    public void setResultFormat(Format format) {
        this.checkWritePermission(this.resultFormat);
        this.resultFormat = format;
    }

    @Override
    @XmlElement(name="resultFile", required=true)
    public DataFile getResultFile() {
        return this.resultFile;
    }

    public void setResultFile(DataFile dataFile) {
        this.checkWritePermission(this.resultFile);
        this.resultFile = dataFile;
    }
}

