/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.cache;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.wss4j.common.cache.ReplayCache;

public class MemoryReplayCache
implements ReplayCache {
    public static final long DEFAULT_TTL = 300L;
    public static final long MAX_TTL = 3600L;
    private final SortedMap<Instant, List<String>> cache = new TreeMap<Instant, List<String>>();
    private final Set<String> ids = Collections.synchronizedSet(new HashSet());

    @Override
    public void add(String identifier) {
        this.add(identifier, Instant.now().plusSeconds(300L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(String identifier, Instant expiry) {
        if (identifier == null || identifier.length() == 0) {
            return;
        }
        Instant now = Instant.now();
        Instant maxTTL = now.plusSeconds(3600L);
        if (expiry == null || expiry.isBefore(now) || expiry.isAfter(maxTTL)) {
            expiry = now.plusSeconds(300L);
        }
        SortedMap<Instant, List<String>> sortedMap = this.cache;
        synchronized (sortedMap) {
            ArrayList<String> list = (ArrayList<String>)this.cache.get(expiry);
            if (list == null) {
                list = new ArrayList<String>(1);
                this.cache.put(expiry, list);
            }
            list.add(identifier);
        }
        this.ids.add(identifier);
    }

    @Override
    public boolean contains(String identifier) {
        this.processTokenExpiry();
        if (identifier != null && identifier.length() != 0) {
            return this.ids.contains(identifier);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTokenExpiry() {
        Instant current = Instant.now();
        SortedMap<Instant, List<String>> sortedMap = this.cache;
        synchronized (sortedMap) {
            Map.Entry<Instant, List<String>> entry;
            Iterator<Map.Entry<Instant, List<String>>> it = this.cache.entrySet().iterator();
            while (it.hasNext() && (entry = it.next()).getKey().isBefore(current)) {
                for (String id : entry.getValue()) {
                    this.ids.remove(id);
                }
                it.remove();
            }
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.cache.clear();
        this.ids.clear();
    }
}

