NAME
    RISCOS::Module -- manipulate relocatable modules

SYNOPSIS
        use RISCOS::Module;

        $mod = grab RISCOS::Module $mod;
        print scalar $mod->Dump if $mod;

        $cooked = rm_unsqueeze $raw;

        $code	= rm_grab $mod;
        $workspace	= rm_workspace $mod;


DESCRIPTION
    `RISCOS::Module' provides a class to hold details about a
    relocatable module, and a variety of subroutines to manipulate
    entire relocatable modules and their workspace from disc and the
    `RMA'.

  Subroutines

    rm_private_word <module_name>
        Returns the contents of a module's private word. Typically
        this points to the modules workspace.

    rm_workspace <module_name>
        Returns the contents of the module workspace (by assuming
        that the module's private word points to an area of
        workspace in the RMA, where the length of workspace is
        stored in the preceding word)

    rm_code_addr <module_name>
        Returns the address of the module's code.

    rm_grab <module_name>
        Returns the module's code.

    rmensure <module> [, <path> [,<version>]]
        Emulates the `RMEnsure' command. If a copy of *module* of
        version *version* or higher is not present will attempt to
        `RMLoad' a module from *path*. *version* defaults to 0,
        *path* defaults to '`System:Modules.*module*''.

        Returns undefined if an error occurs, 0 if the module is
        still absent after the `RMLoad' command, 1 if the module is
        present (before or after the command is run).

        The method used is a perl conversion of an idea by Darren
        Salt <arcsalt@spuddy.mew.co.uk>.

    rm_unsqueeze <module>
        Returns the "unsqeezed" version of the module passed in. The
        entire module code should be in the scalar, not the name of
        a module. "unsqeezing" requires the '`UNSqeeze'' module and
        use of a disc file. (The '`UNSqueeze'' module found in
        `!Patch' - `rm_unsqueeze' will look there and in
        `!System.Modules' for this module).

    split_help_string <string>
        Splits a module help string into *Name*, *Version*, *Date*
        and *Comment*. Returns an array with these four elements.

    modules
        Unlike `modules_only' this will include multiply
        instantiated modules multiple times - *i.e.*:

            FileCore%ADFS
            FileCore%Base


    modules_only
        Returns a list of the names of all modules in the `RMA'.
        Multiply instantiated modules are only returned once in the
        list.


  Methods

    The `RISCOS::Module' class provides the following methods:

    new <module>
        Creates a new `RISCOS::Module' object from the module code
        passed in. `new' automatically calls `rm_unsqueeze'. Returns
        the object.

    grab <module_name>
        Grabs the named module from the `RMA' and calls `new' with
        it.

    load <filename>
        Loads the file using `RISCOS::File::load' and calls `new'.
        Hence *filename* can be a filename, a reference to a
        filehandle, or a reference to a scalar which is used as the
        file's contents.

    Title
        Returns the module's title (as found from the `title'
        offset).

    Name
        Returns the module's name (obtained by splitting the help
        string).

    Version
        Returns the module's version.

    Date
        Returns the module's date.

    Comment
        Returns the module's comment (any text in the help string
        after the date).

    Length
        Returns the module's length.

    Start
        Returns the module's start offset. If the start offset is
        non-zero but invalid (not a multiple of four within the
        module) it is disassembled and the instruction returned.
        Returns undefined if the start offset is zero.

    Init
        Returns the module's initialisation code offset, or
        undefined if there is no initialisation code.

    Final
        Returns the module's finalisation code offset, or undefined
        if there is no finalisation code.

    Service
        Returns the module's service call handler offset, or
        undefined if there is no service call code.

    TokenFile
        Returns the name of the textfile containing tokens used in
        the module's command text.

    CommandTable
        Returns a reference to an array of `RISCOS::Module::Command'
        objects (see below) that describe the `*' commands provided
        by the module. If the module provides no commands,
        `CommandTable' returns undefined.

    CommandHash
        Returns a reference to an array of `RISCOS::Module::Command'
        objects, keyed by command name. If the module provides no
        commands, `CommandHash' returns undefined.

    Command <name>
        Looks up *name* in the hash of `*' commands provided by the
        module. Returns a `RISCOS::Module::Command' object if found,
        else undefined.

    SWIchunk
        Returns the module's `SWI' chunk number, or undefined if the
        module does not provide `SWI's (using the module header
        entries).

    SWIhandler
        Returns the module's `SWI' handler code offset, or undefined
        if there is no `SWI' handler code.

    SWIdecode
        Returns the module's `SWI' decoding code offset, or
        undefined if there is no `SWI' decoding code.

    SWIPrefix
        Returns the module's `SWI' prefix, or undefined if the
        module does not provide `SWI's.

    SWITable
        Returns a reference to an array of `SWI' names provided by
        the module. These are not prefixed by the `SWI' prefix - for
        example the WindowManager will return

            ['Initialise', 'CreateWindow', 'CreateIcon',


        *etc.*

    Dump
        Returns a text dump of the module. In array context returns
        a list of lines. In scalar context joins these with "\n";


  RISCOS::Module::Command

    The `RISCOS::Module::Command' class provides the following
    methods:

    new <module_data>, <offset>
        Creates a new Command object from the command table entry
        stored at *offset* in the module data supplied. Returns this
        object in scalar context - in list context returns `(object,
        new-offset, name). '

    Name
        Returns the command's name.

    Min Returns the minimum number of parameters to the command.

    Max Returns the maximum number of parameters to the command.

    GS_Flags
        Returns the command's `GSTrans' flags. In scalar context
        returns a byte corresponding to the byte in the command
        table. For any bit set that number parameter will be passed
        to `GSTrans' before the command is called. In array context
        expands this byte and returns a list with 8 elements, each
        either 0 or 1. Element 0 refers to parameter 0.

    Code
        Returns the offset to the command's code.

    Syntax
        Returns the command's syntax text.

    Help
        Returns the command's help text, or the offset to the
        command's help code.

    Flags
        Returns the command's flags. In array context returns a list
        of text strings. In scalar context joins these with ', '

    Dump
        Returns a text dump of the command. In array context returns
        a list of lines. In scalar context joins these with "\n";


BUGS
    None known. However, running `new' on all modules in my `RMA'
    found a couple that I fixed (*e.g.* `Fileswitch' has a non-word
    aligned command table, which is legal, but caught me out), so
    there may still be some.

AUTHOR
    Nicholas Clark <nick@unfortu.net>

