// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package telemetry

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// OpenConfigTelemetryClient is the client API for OpenConfigTelemetry service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type OpenConfigTelemetryClient interface {
	// Request an inline subscription for data at the specified path.
	// The device should send telemetry data back on the same
	// connection as the subscription request.
	TelemetrySubscribe(ctx context.Context, in *SubscriptionRequest, opts ...grpc.CallOption) (OpenConfigTelemetry_TelemetrySubscribeClient, error)
	// Terminates and removes an existing telemetry subscription
	CancelTelemetrySubscription(ctx context.Context, in *CancelSubscriptionRequest, opts ...grpc.CallOption) (*CancelSubscriptionReply, error)
	// Get the list of current telemetry subscriptions from the
	// target. This command returns a list of existing subscriptions
	// not including those that are established via configuration.
	GetTelemetrySubscriptions(ctx context.Context, in *GetSubscriptionsRequest, opts ...grpc.CallOption) (*GetSubscriptionsReply, error)
	// Get Telemetry Agent Operational States
	GetTelemetryOperationalState(ctx context.Context, in *GetOperationalStateRequest, opts ...grpc.CallOption) (*GetOperationalStateReply, error)
	// Return the set of data encodings supported by the device for
	// telemetry data
	GetDataEncodings(ctx context.Context, in *DataEncodingRequest, opts ...grpc.CallOption) (*DataEncodingReply, error)
}

type openConfigTelemetryClient struct {
	cc grpc.ClientConnInterface
}

func NewOpenConfigTelemetryClient(cc grpc.ClientConnInterface) OpenConfigTelemetryClient {
	return &openConfigTelemetryClient{cc}
}

func (c *openConfigTelemetryClient) TelemetrySubscribe(ctx context.Context, in *SubscriptionRequest, opts ...grpc.CallOption) (OpenConfigTelemetry_TelemetrySubscribeClient, error) {
	stream, err := c.cc.NewStream(ctx, &OpenConfigTelemetry_ServiceDesc.Streams[0], "/telemetry.OpenConfigTelemetry/telemetrySubscribe", opts...)
	if err != nil {
		return nil, err
	}
	x := &openConfigTelemetryTelemetrySubscribeClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type OpenConfigTelemetry_TelemetrySubscribeClient interface {
	Recv() (*OpenConfigData, error)
	grpc.ClientStream
}

type openConfigTelemetryTelemetrySubscribeClient struct {
	grpc.ClientStream
}

func (x *openConfigTelemetryTelemetrySubscribeClient) Recv() (*OpenConfigData, error) {
	m := new(OpenConfigData)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *openConfigTelemetryClient) CancelTelemetrySubscription(ctx context.Context, in *CancelSubscriptionRequest, opts ...grpc.CallOption) (*CancelSubscriptionReply, error) {
	out := new(CancelSubscriptionReply)
	err := c.cc.Invoke(ctx, "/telemetry.OpenConfigTelemetry/cancelTelemetrySubscription", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openConfigTelemetryClient) GetTelemetrySubscriptions(ctx context.Context, in *GetSubscriptionsRequest, opts ...grpc.CallOption) (*GetSubscriptionsReply, error) {
	out := new(GetSubscriptionsReply)
	err := c.cc.Invoke(ctx, "/telemetry.OpenConfigTelemetry/getTelemetrySubscriptions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openConfigTelemetryClient) GetTelemetryOperationalState(ctx context.Context, in *GetOperationalStateRequest, opts ...grpc.CallOption) (*GetOperationalStateReply, error) {
	out := new(GetOperationalStateReply)
	err := c.cc.Invoke(ctx, "/telemetry.OpenConfigTelemetry/getTelemetryOperationalState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openConfigTelemetryClient) GetDataEncodings(ctx context.Context, in *DataEncodingRequest, opts ...grpc.CallOption) (*DataEncodingReply, error) {
	out := new(DataEncodingReply)
	err := c.cc.Invoke(ctx, "/telemetry.OpenConfigTelemetry/getDataEncodings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// OpenConfigTelemetryServer is the server API for OpenConfigTelemetry service.
// All implementations must embed UnimplementedOpenConfigTelemetryServer
// for forward compatibility
type OpenConfigTelemetryServer interface {
	// Request an inline subscription for data at the specified path.
	// The device should send telemetry data back on the same
	// connection as the subscription request.
	TelemetrySubscribe(*SubscriptionRequest, OpenConfigTelemetry_TelemetrySubscribeServer) error
	// Terminates and removes an existing telemetry subscription
	CancelTelemetrySubscription(context.Context, *CancelSubscriptionRequest) (*CancelSubscriptionReply, error)
	// Get the list of current telemetry subscriptions from the
	// target. This command returns a list of existing subscriptions
	// not including those that are established via configuration.
	GetTelemetrySubscriptions(context.Context, *GetSubscriptionsRequest) (*GetSubscriptionsReply, error)
	// Get Telemetry Agent Operational States
	GetTelemetryOperationalState(context.Context, *GetOperationalStateRequest) (*GetOperationalStateReply, error)
	// Return the set of data encodings supported by the device for
	// telemetry data
	GetDataEncodings(context.Context, *DataEncodingRequest) (*DataEncodingReply, error)
	mustEmbedUnimplementedOpenConfigTelemetryServer()
}

// UnimplementedOpenConfigTelemetryServer must be embedded to have forward compatible implementations.
type UnimplementedOpenConfigTelemetryServer struct {
}

func (UnimplementedOpenConfigTelemetryServer) TelemetrySubscribe(*SubscriptionRequest, OpenConfigTelemetry_TelemetrySubscribeServer) error {
	return status.Errorf(codes.Unimplemented, "method TelemetrySubscribe not implemented")
}
func (UnimplementedOpenConfigTelemetryServer) CancelTelemetrySubscription(context.Context, *CancelSubscriptionRequest) (*CancelSubscriptionReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelTelemetrySubscription not implemented")
}
func (UnimplementedOpenConfigTelemetryServer) GetTelemetrySubscriptions(context.Context, *GetSubscriptionsRequest) (*GetSubscriptionsReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTelemetrySubscriptions not implemented")
}
func (UnimplementedOpenConfigTelemetryServer) GetTelemetryOperationalState(context.Context, *GetOperationalStateRequest) (*GetOperationalStateReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTelemetryOperationalState not implemented")
}
func (UnimplementedOpenConfigTelemetryServer) GetDataEncodings(context.Context, *DataEncodingRequest) (*DataEncodingReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataEncodings not implemented")
}
func (UnimplementedOpenConfigTelemetryServer) mustEmbedUnimplementedOpenConfigTelemetryServer() {}

// UnsafeOpenConfigTelemetryServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to OpenConfigTelemetryServer will
// result in compilation errors.
type UnsafeOpenConfigTelemetryServer interface {
	mustEmbedUnimplementedOpenConfigTelemetryServer()
}

func RegisterOpenConfigTelemetryServer(s grpc.ServiceRegistrar, srv OpenConfigTelemetryServer) {
	s.RegisterService(&OpenConfigTelemetry_ServiceDesc, srv)
}

func _OpenConfigTelemetry_TelemetrySubscribe_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(SubscriptionRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(OpenConfigTelemetryServer).TelemetrySubscribe(m, &openConfigTelemetryTelemetrySubscribeServer{stream})
}

type OpenConfigTelemetry_TelemetrySubscribeServer interface {
	Send(*OpenConfigData) error
	grpc.ServerStream
}

type openConfigTelemetryTelemetrySubscribeServer struct {
	grpc.ServerStream
}

func (x *openConfigTelemetryTelemetrySubscribeServer) Send(m *OpenConfigData) error {
	return x.ServerStream.SendMsg(m)
}

func _OpenConfigTelemetry_CancelTelemetrySubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenConfigTelemetryServer).CancelTelemetrySubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/telemetry.OpenConfigTelemetry/cancelTelemetrySubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenConfigTelemetryServer).CancelTelemetrySubscription(ctx, req.(*CancelSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenConfigTelemetry_GetTelemetrySubscriptions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSubscriptionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenConfigTelemetryServer).GetTelemetrySubscriptions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/telemetry.OpenConfigTelemetry/getTelemetrySubscriptions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenConfigTelemetryServer).GetTelemetrySubscriptions(ctx, req.(*GetSubscriptionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenConfigTelemetry_GetTelemetryOperationalState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOperationalStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenConfigTelemetryServer).GetTelemetryOperationalState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/telemetry.OpenConfigTelemetry/getTelemetryOperationalState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenConfigTelemetryServer).GetTelemetryOperationalState(ctx, req.(*GetOperationalStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenConfigTelemetry_GetDataEncodings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DataEncodingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenConfigTelemetryServer).GetDataEncodings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/telemetry.OpenConfigTelemetry/getDataEncodings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenConfigTelemetryServer).GetDataEncodings(ctx, req.(*DataEncodingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// OpenConfigTelemetry_ServiceDesc is the grpc.ServiceDesc for OpenConfigTelemetry service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var OpenConfigTelemetry_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "telemetry.OpenConfigTelemetry",
	HandlerType: (*OpenConfigTelemetryServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "cancelTelemetrySubscription",
			Handler:    _OpenConfigTelemetry_CancelTelemetrySubscription_Handler,
		},
		{
			MethodName: "getTelemetrySubscriptions",
			Handler:    _OpenConfigTelemetry_GetTelemetrySubscriptions_Handler,
		},
		{
			MethodName: "getTelemetryOperationalState",
			Handler:    _OpenConfigTelemetry_GetTelemetryOperationalState_Handler,
		},
		{
			MethodName: "getDataEncodings",
			Handler:    _OpenConfigTelemetry_GetDataEncodings_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "telemetrySubscribe",
			Handler:       _OpenConfigTelemetry_TelemetrySubscribe_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "oc/oc.proto",
}
