# Telegraf Documentation

* [FAQ][]
* [Install Guide][]
* [Quick Start][]

## Usage

* [Commands and Flags][]
* [Configuration][]
* [Docker][]
* [Windows Service][]
* [Releases][]
* [Supported Platforms][]

## Plugins

* [Aggregators][]
* [External Plugins][]
* [Inputs][]
  * [SQL Drivers Input][]
* [Parsers: Input Data Formats][]
* [Outputs][]
* [Secret Stores][]
* [Serializers: Output Data Formats][]
* [Processors][]

## Developers

* [Custom Builds][]
* [Integration Tests][]
* [License of Dependencies][]
* [Nightlies][]
* [Profiling][]

## Reference

* [Aggregators & Processors][]
* [AppArmor][]
* [Metrics][]
* [Parsing Data][]
* [Template Pattern][]
* [TOML][]
* [TLS][]

## Blog Posts

* [Common Expression Language][]
* [Config Recommendations and Performance Monitoring][]
* [Deploying Telegraf via Docker Compose][]
* [Reduce Binary Size][]
* [Storing Secrets][]

[Aggregators & Processors]: /docs/AGGREGATORS_AND_PROCESSORS.md
[Aggregators]: /docs/AGGREGATORS.md
[AppArmor]: /docs/APPARMOR.md
[Commands and Flags]: /docs/COMMANDS_AND_FLAGS.md
[Configuration]: /docs/CONFIGURATION.md
[Custom Builds]: /docs/CUSTOMIZATION.md
[Parsers: Input Data Formats]: /docs/DATA_FORMATS_INPUT.md
[Serializers: Output Data Formats]: /docs/DATA_FORMATS_OUTPUT.md
[Docker]: /docs/DOCKER.md
[External Plugins]: /docs/EXTERNAL_PLUGINS.md
[FAQ]: /docs/FAQ.md
[Inputs]: /docs/INPUTS.md
[Install Guide]: /docs/INSTALL_GUIDE.md
[Integration Tests]: /docs/INTEGRATION_TESTS.md
[License of Dependencies]: /docs/LICENSE_OF_DEPENDENCIES.md
[Metrics]: /docs/METRICS.md
[Nightlies]: /docs/NIGHTLIES.md
[Outputs]: /docs/OUTPUTS.md
[Parsing Data]: /docs/PARSING_DATA.md
[Processors]: /docs/PROCESSORS.md
[Profiling]: /docs/PROFILING.md
[Quick Start]: /docs/QUICK_START.md
[Releases]: /docs/RELEASES.md
[Secret Stores]: /docs/SECRETSTORES.md
[SQL Drivers Input]: /docs/SQL_DRIVERS_INPUT.md
[Supported Platforms]: /docs/SUPPORTED_PLATFORMS.md
[Template Pattern]: /docs/TEMPLATE_PATTERN.md
[TLS]: /docs/TLS.md
[TOML]: /docs/TOML.md
[Windows Service]: /docs/WINDOWS_SERVICE.md

[Config Recommendations and Performance Monitoring]: https://www.influxdata.com/blog/telegraf-best-practices/
[Deploying Telegraf via Docker Compose]: https://www.influxdata.com/blog/telegraf-deployment-strategies-docker-compose/
[Common Expression Language]: https://www.influxdata.com/blog/using-common-expression-language-metric-filtering-telegraf/
[Storing Secrets]: https://www.influxdata.com/blog/storing-secrets-telegraf/
[Reduce Binary Size]: https://www.influxdata.com/blog/how-reduce-telegraf-binary-size/
