// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Package configtelemetry defines various telemetry level for configuration.
// It enables every component to have access to telemetry level
// to enable metrics only when necessary.
//
// This document provides guidance on which telemetry level to adopt for Collector metrics.
// When adopting a telemetry level, component authors are expected to rely on this guidance to
// justify their choice of telemetry level.
//
// 1. configtelemetry.None
//
// No telemetry data is recorded.
//
// 2. configtelemetry.Basic
//
// Telemetry associated with this level provides essential coverage of the collector telemetry.
// It should only be used for internal collector telemetry generated by the collector core API. Components outside of
// the core API MUST NOT record additional telemetry at this level.
//
// 3. configtelemetry.Normal
//
// Telemetry associated with this level provides complete coverage of the collector telemetry.
// It should be the default for component authors.
//
// Component authors using this telemetry level can use this guidance:
//
//   - The signals associated with this level must control cardinality.
//     It is acceptable at this level for cardinality to scale linearly with the monitored resources.
//
//   - The signals associated with this level must represent a controlled data volume. Examples follow:
//
//     a. A max cardinality (total possible combinations of dimension values) for a given metric of at most 100.
//
//     b. At most 5 spans actively recording simultaneously per active request.
//
// This is the default level recommended when running the Collector.
//
// 4. configtelemetry.Detailed
//
// Telemetry associated with this level provides complete coverage of the collector telemetry.
//
// The signals associated with this level may exhibit high cardinality and/or high dimensionality.
//
// There is no limit on data volume.
package configtelemetry // import "go.opentelemetry.io/collector/config/configtelemetry"
