// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "pdata/internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
)

type EntityRefSlice struct {
	orig  *[]*otlpcommon.EntityRef
	state *State
}

func GetOrigEntityRefSlice(ms EntityRefSlice) *[]*otlpcommon.EntityRef {
	return ms.orig
}

func GetEntityRefSliceState(ms EntityRefSlice) *State {
	return ms.state
}

func NewEntityRefSlice(orig *[]*otlpcommon.EntityRef, state *State) EntityRefSlice {
	return EntityRefSlice{orig: orig, state: state}
}

func CopyOrigEntityRefSlice(dest, src []*otlpcommon.EntityRef) []*otlpcommon.EntityRef {
	if cap(dest) < len(src) {
		dest = make([]*otlpcommon.EntityRef, len(src))
		data := make([]otlpcommon.EntityRef, len(src))
		for i := range src {
			dest[i] = &data[i]
		}
	}
	dest = dest[:len(src)]
	for i := range src {
		CopyOrigEntityRef(dest[i], src[i])
	}
	return dest
}

func GenerateTestEntityRefSlice() EntityRefSlice {
	orig := []*otlpcommon.EntityRef(nil)
	state := StateMutable
	es := NewEntityRefSlice(&orig, &state)
	FillTestEntityRefSlice(es)
	return es
}

func FillTestEntityRefSlice(es EntityRefSlice) {
	*es.orig = make([]*otlpcommon.EntityRef, 7)
	for i := 0; i < 7; i++ {
		(*es.orig)[i] = &otlpcommon.EntityRef{}
		FillTestEntityRef(NewEntityRef((*es.orig)[i], es.state))
	}
}
