// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func CopyOrigExemplarSlice(dest, src []otlpmetrics.Exemplar) []otlpmetrics.Exemplar {
	var newDest []otlpmetrics.Exemplar
	if cap(dest) < len(src) {
		newDest = make([]otlpmetrics.Exemplar, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			dest[i] = otlpmetrics.Exemplar{}
		}
	}
	for i := range src {
		CopyOrigExemplar(&newDest[i], &src[i])
	}
	return newDest
}

func GenerateOrigTestExemplarSlice() []otlpmetrics.Exemplar {
	orig := make([]otlpmetrics.Exemplar, 7)
	for i := 0; i < 7; i++ {
		orig[i] = otlpmetrics.Exemplar{}
		FillOrigTestExemplar(&orig[i])
	}
	return orig
}

// UnmarshalJSONOrigExemplarSlice unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigExemplarSlice(iter *json.Iterator) []otlpmetrics.Exemplar {
	var orig []otlpmetrics.Exemplar
	iter.ReadArrayCB(func(iter *json.Iterator) bool {
		orig = append(orig, otlpmetrics.Exemplar{})
		UnmarshalJSONOrigExemplar(&orig[len(orig)-1], iter)
		return true
	})
	return orig
}
