// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpcollectormetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

type Metrics struct {
	orig  *otlpcollectormetrics.ExportMetricsServiceRequest
	state *State
}

func GetOrigMetrics(ms Metrics) *otlpcollectormetrics.ExportMetricsServiceRequest {
	return ms.orig
}

func GetMetricsState(ms Metrics) *State {
	return ms.state
}

func NewMetrics(orig *otlpcollectormetrics.ExportMetricsServiceRequest, state *State) Metrics {
	return Metrics{orig: orig, state: state}
}

func GenerateTestMetrics() Metrics {
	orig := otlpcollectormetrics.ExportMetricsServiceRequest{}
	FillOrigTestExportMetricsServiceRequest(&orig)
	state := StateMutable
	return NewMetrics(&orig, &state)
}

func CopyOrigExportMetricsServiceRequest(dest, src *otlpcollectormetrics.ExportMetricsServiceRequest) {
	dest.ResourceMetrics = CopyOrigResourceMetricsSlice(dest.ResourceMetrics, src.ResourceMetrics)
}

func FillOrigTestExportMetricsServiceRequest(orig *otlpcollectormetrics.ExportMetricsServiceRequest) {
	orig.ResourceMetrics = GenerateOrigTestResourceMetricsSlice()
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigExportMetricsServiceRequest(orig *otlpcollectormetrics.ExportMetricsServiceRequest, dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.ResourceMetrics) > 0 {
		dest.WriteObjectField("resourceMetrics")
		dest.WriteArrayStart()
		MarshalJSONOrigResourceMetrics(orig.ResourceMetrics[0], dest)
		for i := 1; i < len(orig.ResourceMetrics); i++ {
			dest.WriteMore()
			MarshalJSONOrigResourceMetrics(orig.ResourceMetrics[i], dest)
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigMetrics unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigExportMetricsServiceRequest(orig *otlpcollectormetrics.ExportMetricsServiceRequest, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "resourceMetrics", "resource_metrics":
			orig.ResourceMetrics = UnmarshalJSONOrigResourceMetricsSlice(iter)
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigExportMetricsServiceRequest(orig *otlpcollectormetrics.ExportMetricsServiceRequest) int {
	var n int
	var l int
	_ = l
	for i := range orig.ResourceMetrics {
		l = SizeProtoOrigResourceMetrics(orig.ResourceMetrics[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigExportMetricsServiceRequest(orig *otlpcollectormetrics.ExportMetricsServiceRequest, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := range orig.ResourceMetrics {
		l = MarshalProtoOrigResourceMetrics(orig.ResourceMetrics[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigExportMetricsServiceRequest(orig *otlpcollectormetrics.ExportMetricsServiceRequest, buf []byte) error {
	return orig.Unmarshal(buf)
}
