// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"go.opentelemetry.io/collector/pdata/internal/data"
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func CopyOrigLink(dest, src *otlpprofiles.Link) {
	dest.TraceId = src.TraceId
	dest.SpanId = src.SpanId
}

func FillOrigTestLink(orig *otlpprofiles.Link) {
	orig.TraceId = data.TraceID([16]byte{1, 2, 3, 4, 5, 6, 7, 8, 8, 7, 6, 5, 4, 3, 2, 1})
	orig.SpanId = data.SpanID([8]byte{8, 7, 6, 5, 4, 3, 2, 1})
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigLink(orig *otlpprofiles.Link, dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.TraceId != data.TraceID([16]byte{}) {
		dest.WriteObjectField("traceId")
		MarshalJSONOrigTraceID(&orig.TraceId, dest)
	}
	if orig.SpanId != data.SpanID([8]byte{}) {
		dest.WriteObjectField("spanId")
		MarshalJSONOrigSpanID(&orig.SpanId, dest)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigLink unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigLink(orig *otlpprofiles.Link, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "traceId", "trace_id":
			orig.TraceId.UnmarshalJSONIter(iter)
		case "spanId", "span_id":
			orig.SpanId.UnmarshalJSONIter(iter)
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigLink(orig *otlpprofiles.Link) int {
	var n int
	var l int
	_ = l
	l = SizeProtoOrigTraceID(&orig.TraceId)
	n += 1 + proto.Sov(uint64(l)) + l
	l = SizeProtoOrigSpanID(&orig.SpanId)
	n += 1 + proto.Sov(uint64(l)) + l
	return n
}

func MarshalProtoOrigLink(orig *otlpprofiles.Link, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l

	l = MarshalProtoOrigTraceID(&orig.TraceId, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	l = MarshalProtoOrigSpanID(&orig.SpanId, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x12

	return len(buf) - pos
}

func UnmarshalProtoOrigLink(orig *otlpprofiles.Link, buf []byte) error {
	return orig.Unmarshal(buf)
}
