// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func CopyOrigLocation(dest, src *otlpprofiles.Location) {
	if srcMappingIndex, ok := src.MappingIndex_.(*otlpprofiles.Location_MappingIndex); ok {
		destMappingIndex, ok := dest.MappingIndex_.(*otlpprofiles.Location_MappingIndex)
		if !ok {
			destMappingIndex = &otlpprofiles.Location_MappingIndex{}
			dest.MappingIndex_ = destMappingIndex
		}
		destMappingIndex.MappingIndex = srcMappingIndex.MappingIndex
	} else {
		dest.MappingIndex_ = nil
	}
	dest.Address = src.Address
	dest.Line = CopyOrigLineSlice(dest.Line, src.Line)
	dest.IsFolded = src.IsFolded
	dest.AttributeIndices = CopyOrigInt32Slice(dest.AttributeIndices, src.AttributeIndices)
}

func FillOrigTestLocation(orig *otlpprofiles.Location) {
	orig.MappingIndex_ = &otlpprofiles.Location_MappingIndex{MappingIndex: int32(13)}
	orig.Address = uint64(13)
	orig.Line = GenerateOrigTestLineSlice()
	orig.IsFolded = true
	orig.AttributeIndices = GenerateOrigTestInt32Slice()
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigLocation(orig *otlpprofiles.Location, dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.MappingIndex_ != nil {
		dest.WriteObjectField("mappingIndex")
		dest.WriteInt32(orig.MappingIndex_.(*otlpprofiles.Location_MappingIndex).MappingIndex)
	}
	if orig.Address != uint64(0) {
		dest.WriteObjectField("address")
		dest.WriteUint64(orig.Address)
	}
	if len(orig.Line) > 0 {
		dest.WriteObjectField("line")
		dest.WriteArrayStart()
		MarshalJSONOrigLine(orig.Line[0], dest)
		for i := 1; i < len(orig.Line); i++ {
			dest.WriteMore()
			MarshalJSONOrigLine(orig.Line[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.IsFolded != false {
		dest.WriteObjectField("isFolded")
		dest.WriteBool(orig.IsFolded)
	}
	if len(orig.AttributeIndices) > 0 {
		dest.WriteObjectField("attributeIndices")
		dest.WriteArrayStart()
		dest.WriteInt32(orig.AttributeIndices[0])
		for i := 1; i < len(orig.AttributeIndices); i++ {
			dest.WriteMore()
			dest.WriteInt32(orig.AttributeIndices[i])
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigLocation unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigLocation(orig *otlpprofiles.Location, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "mappingIndex", "mapping_index":
			orig.MappingIndex_ = &otlpprofiles.Location_MappingIndex{MappingIndex: iter.ReadInt32()}
		case "address":
			orig.Address = iter.ReadUint64()
		case "line":
			orig.Line = UnmarshalJSONOrigLineSlice(iter)
		case "isFolded", "is_folded":
			orig.IsFolded = iter.ReadBool()
		case "attributeIndices", "attribute_indices":
			orig.AttributeIndices = UnmarshalJSONOrigInt32Slice(iter)
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigLocation(orig *otlpprofiles.Location) int {
	var n int
	var l int
	_ = l
	if orig.MappingIndex_ != nil {
		n += 1 + proto.Sov(uint64(orig.MappingIndex_.(*otlpprofiles.Location_MappingIndex).MappingIndex))
	}
	if orig.Address != 0 {
		n += 1 + proto.Sov(uint64(orig.Address))
	}
	for i := range orig.Line {
		l = SizeProtoOrigLine(orig.Line[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.IsFolded {
		n += 2
	}
	if len(orig.AttributeIndices) > 0 {
		l = 0
		for _, e := range orig.AttributeIndices {
			l += proto.Sov(uint64(e))
		}
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigLocation(orig *otlpprofiles.Location, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.MappingIndex_ != nil {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.MappingIndex_.(*otlpprofiles.Location_MappingIndex).MappingIndex))
		pos--
		buf[pos] = 0x8

	}
	if orig.Address != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.Address))
		pos--
		buf[pos] = 0x10
	}
	for i := range orig.Line {
		l = MarshalProtoOrigLine(orig.Line[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	if orig.IsFolded {
		pos--
		if orig.IsFolded {
			buf[pos] = 1
		} else {
			buf[pos] = 0
		}
		pos--
		buf[pos] = 0x20
	}
	l = len(orig.AttributeIndices)
	if l > 0 {
		endPos := pos
		for i := l - 1; i >= 0; i-- {
			pos = proto.EncodeVarint(buf, pos, uint64(orig.AttributeIndices[i]))
		}
		pos = proto.EncodeVarint(buf, pos, uint64(endPos-pos))
		pos--
		buf[pos] = 0x2a
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigLocation(orig *otlpprofiles.Location, buf []byte) error {
	return orig.Unmarshal(buf)
}
