// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigProfile(t *testing.T) {
	src := &otlpprofiles.Profile{}
	dest := &otlpprofiles.Profile{}
	CopyOrigProfile(dest, src)
	assert.Equal(t, &otlpprofiles.Profile{}, dest)
	FillOrigTestProfile(src)
	CopyOrigProfile(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigProfileUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpprofiles.Profile{}
	UnmarshalJSONOrigProfile(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpprofiles.Profile{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigProfile(t *testing.T) {
	for name, src := range getEncodingTestValuesProfile() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigProfile(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpprofiles.Profile{}
			UnmarshalJSONOrigProfile(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigProfile(t *testing.T) {
	for name, src := range getEncodingTestValuesProfile() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigProfile(src))
			gotSize := MarshalProtoOrigProfile(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpprofiles.Profile{}
			require.NoError(t, UnmarshalProtoOrigProfile(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesProfile() map[string]*otlpprofiles.Profile {
	return map[string]*otlpprofiles.Profile{
		"empty": {},
		"fill_test": func() *otlpprofiles.Profile {
			src := &otlpprofiles.Profile{}
			FillOrigTestProfile(src)
			return src
		}(),
	}
}
