// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package plogotlp

import (
	"go.opentelemetry.io/collector/pdata/internal"
	otlpcollectorlog "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/logs/v1"
)

// ExportResponse represents the response for gRPC/HTTP client/server.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewExportResponse function to create new instances.
// Important: zero-initialized instance is not valid for use.
type ExportResponse struct {
	orig  *otlpcollectorlog.ExportLogsServiceResponse
	state *internal.State
}

func newExportResponse(orig *otlpcollectorlog.ExportLogsServiceResponse, state *internal.State) ExportResponse {
	return ExportResponse{orig: orig, state: state}
}

// NewExportResponse creates a new empty ExportResponse.
//
// This must be used only in testing code. Users should use "AppendEmpty" when part of a Slice,
// OR directly access the member if this is embedded in another struct.
func NewExportResponse() ExportResponse {
	state := internal.StateMutable
	return newExportResponse(&otlpcollectorlog.ExportLogsServiceResponse{}, &state)
}

// MoveTo moves all properties from the current struct overriding the destination and
// resetting the current instance to its zero value
func (ms ExportResponse) MoveTo(dest ExportResponse) {
	ms.state.AssertMutable()
	dest.state.AssertMutable()
	// If they point to the same data, they are the same, nothing to do.
	if ms.orig == dest.orig {
		return
	}
	*dest.orig = *ms.orig
	*ms.orig = otlpcollectorlog.ExportLogsServiceResponse{}
}

// PartialSuccess returns the partialsuccess associated with this ExportResponse.
func (ms ExportResponse) PartialSuccess() ExportPartialSuccess {
	return newExportPartialSuccess(&ms.orig.PartialSuccess, ms.state)
}

// CopyTo copies all properties from the current struct overriding the destination.
func (ms ExportResponse) CopyTo(dest ExportResponse) {
	dest.state.AssertMutable()
	internal.CopyOrigExportLogsServiceResponse(dest.orig, ms.orig)
}
