// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package entity

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

func TestEntityRef_MoveTo(t *testing.T) {
	ms := generateTestEntityRef()
	dest := NewEntityRef()
	ms.MoveTo(dest)
	assert.Equal(t, NewEntityRef(), ms)
	assert.Equal(t, generateTestEntityRef(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestEntityRef(), dest)
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { ms.MoveTo(newEntityRef(&otlpcommon.EntityRef{}, &sharedState)) })
	assert.Panics(t, func() { newEntityRef(&otlpcommon.EntityRef{}, &sharedState).MoveTo(dest) })
}

func TestEntityRef_CopyTo(t *testing.T) {
	ms := NewEntityRef()
	orig := NewEntityRef()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestEntityRef()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { ms.CopyTo(newEntityRef(&otlpcommon.EntityRef{}, &sharedState)) })
}

func TestEntityRef_SchemaUrl(t *testing.T) {
	ms := NewEntityRef()
	assert.Empty(t, ms.SchemaUrl())
	ms.SetSchemaUrl("test_schemaurl")
	assert.Equal(t, "test_schemaurl", ms.SchemaUrl())
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { newEntityRef(&otlpcommon.EntityRef{}, &sharedState).SetSchemaUrl("test_schemaurl") })
}

func TestEntityRef_Type(t *testing.T) {
	ms := NewEntityRef()
	assert.Empty(t, ms.Type())
	ms.SetType("test_type")
	assert.Equal(t, "test_type", ms.Type())
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { newEntityRef(&otlpcommon.EntityRef{}, &sharedState).SetType("test_type") })
}

func TestEntityRef_IdKeys(t *testing.T) {
	ms := NewEntityRef()
	assert.Equal(t, pcommon.NewStringSlice(), ms.IdKeys())
	ms.getOrig().IdKeys = internal.GenerateOrigTestStringSlice()
	assert.Equal(t, pcommon.StringSlice(internal.GenerateTestStringSlice()), ms.IdKeys())
}

func TestEntityRef_DescriptionKeys(t *testing.T) {
	ms := NewEntityRef()
	assert.Equal(t, pcommon.NewStringSlice(), ms.DescriptionKeys())
	ms.getOrig().DescriptionKeys = internal.GenerateOrigTestStringSlice()
	assert.Equal(t, pcommon.StringSlice(internal.GenerateTestStringSlice()), ms.DescriptionKeys())
}

func generateTestEntityRef() EntityRef {
	return EntityRef(internal.GenerateTestEntityRef())
}
