// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/binary"
	"fmt"
	"math"
	"sync"

	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

var (
	protoPoolExponentialHistogramDataPoint = sync.Pool{
		New: func() any {
			return &otlpmetrics.ExponentialHistogramDataPoint{}
		},
	}
	ProtoPoolExponentialHistogramDataPoint_Sum = sync.Pool{
		New: func() any {
			return &otlpmetrics.ExponentialHistogramDataPoint_Sum{}
		},
	}

	ProtoPoolExponentialHistogramDataPoint_Min = sync.Pool{
		New: func() any {
			return &otlpmetrics.ExponentialHistogramDataPoint_Min{}
		},
	}

	ProtoPoolExponentialHistogramDataPoint_Max = sync.Pool{
		New: func() any {
			return &otlpmetrics.ExponentialHistogramDataPoint_Max{}
		},
	}
)

func NewOrigExponentialHistogramDataPoint() *otlpmetrics.ExponentialHistogramDataPoint {
	if !UseProtoPooling.IsEnabled() {
		return &otlpmetrics.ExponentialHistogramDataPoint{}
	}
	return protoPoolExponentialHistogramDataPoint.Get().(*otlpmetrics.ExponentialHistogramDataPoint)
}

func DeleteOrigExponentialHistogramDataPoint(orig *otlpmetrics.ExponentialHistogramDataPoint, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	for i := range orig.Attributes {
		DeleteOrigKeyValue(&orig.Attributes[i], false)
	}
	switch ov := orig.Sum_.(type) {
	case *otlpmetrics.ExponentialHistogramDataPoint_Sum:
		if UseProtoPooling.IsEnabled() {
			ov.Sum = float64(0)
			ProtoPoolExponentialHistogramDataPoint_Sum.Put(ov)
		}

	}
	DeleteOrigExponentialHistogramDataPoint_Buckets(&orig.Positive, false)
	DeleteOrigExponentialHistogramDataPoint_Buckets(&orig.Negative, false)
	for i := range orig.Exemplars {
		DeleteOrigExemplar(&orig.Exemplars[i], false)
	}
	switch ov := orig.Min_.(type) {
	case *otlpmetrics.ExponentialHistogramDataPoint_Min:
		if UseProtoPooling.IsEnabled() {
			ov.Min = float64(0)
			ProtoPoolExponentialHistogramDataPoint_Min.Put(ov)
		}

	}
	switch ov := orig.Max_.(type) {
	case *otlpmetrics.ExponentialHistogramDataPoint_Max:
		if UseProtoPooling.IsEnabled() {
			ov.Max = float64(0)
			ProtoPoolExponentialHistogramDataPoint_Max.Put(ov)
		}

	}

	orig.Reset()
	if nullable {
		protoPoolExponentialHistogramDataPoint.Put(orig)
	}
}

func CopyOrigExponentialHistogramDataPoint(dest, src *otlpmetrics.ExponentialHistogramDataPoint) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	dest.Attributes = CopyOrigKeyValueSlice(dest.Attributes, src.Attributes)
	dest.StartTimeUnixNano = src.StartTimeUnixNano
	dest.TimeUnixNano = src.TimeUnixNano
	dest.Count = src.Count
	if srcSum, ok := src.Sum_.(*otlpmetrics.ExponentialHistogramDataPoint_Sum); ok {
		destSum, ok := dest.Sum_.(*otlpmetrics.ExponentialHistogramDataPoint_Sum)
		if !ok {
			destSum = &otlpmetrics.ExponentialHistogramDataPoint_Sum{}
			dest.Sum_ = destSum
		}
		destSum.Sum = srcSum.Sum
	} else {
		dest.Sum_ = nil
	}
	dest.Scale = src.Scale
	dest.ZeroCount = src.ZeroCount
	CopyOrigExponentialHistogramDataPoint_Buckets(&dest.Positive, &src.Positive)
	CopyOrigExponentialHistogramDataPoint_Buckets(&dest.Negative, &src.Negative)
	dest.Flags = src.Flags
	dest.Exemplars = CopyOrigExemplarSlice(dest.Exemplars, src.Exemplars)
	if srcMin, ok := src.Min_.(*otlpmetrics.ExponentialHistogramDataPoint_Min); ok {
		destMin, ok := dest.Min_.(*otlpmetrics.ExponentialHistogramDataPoint_Min)
		if !ok {
			destMin = &otlpmetrics.ExponentialHistogramDataPoint_Min{}
			dest.Min_ = destMin
		}
		destMin.Min = srcMin.Min
	} else {
		dest.Min_ = nil
	}
	if srcMax, ok := src.Max_.(*otlpmetrics.ExponentialHistogramDataPoint_Max); ok {
		destMax, ok := dest.Max_.(*otlpmetrics.ExponentialHistogramDataPoint_Max)
		if !ok {
			destMax = &otlpmetrics.ExponentialHistogramDataPoint_Max{}
			dest.Max_ = destMax
		}
		destMax.Max = srcMax.Max
	} else {
		dest.Max_ = nil
	}
	dest.ZeroThreshold = src.ZeroThreshold
}

func GenTestOrigExponentialHistogramDataPoint() *otlpmetrics.ExponentialHistogramDataPoint {
	orig := NewOrigExponentialHistogramDataPoint()
	orig.Attributes = GenerateOrigTestKeyValueSlice()
	orig.StartTimeUnixNano = 1234567890
	orig.TimeUnixNano = 1234567890
	orig.Count = uint64(13)
	orig.Sum_ = &otlpmetrics.ExponentialHistogramDataPoint_Sum{Sum: float64(3.1415926)}
	orig.Scale = int32(13)
	orig.ZeroCount = uint64(13)
	orig.Positive = *GenTestOrigExponentialHistogramDataPoint_Buckets()
	orig.Negative = *GenTestOrigExponentialHistogramDataPoint_Buckets()
	orig.Flags = 1
	orig.Exemplars = GenerateOrigTestExemplarSlice()
	orig.Min_ = &otlpmetrics.ExponentialHistogramDataPoint_Min{Min: float64(3.1415926)}
	orig.Max_ = &otlpmetrics.ExponentialHistogramDataPoint_Max{Max: float64(3.1415926)}
	orig.ZeroThreshold = float64(3.1415926)
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigExponentialHistogramDataPoint(orig *otlpmetrics.ExponentialHistogramDataPoint, dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.Attributes) > 0 {
		dest.WriteObjectField("attributes")
		dest.WriteArrayStart()
		MarshalJSONOrigKeyValue(&orig.Attributes[0], dest)
		for i := 1; i < len(orig.Attributes); i++ {
			dest.WriteMore()
			MarshalJSONOrigKeyValue(&orig.Attributes[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.StartTimeUnixNano != uint64(0) {
		dest.WriteObjectField("startTimeUnixNano")
		dest.WriteUint64(orig.StartTimeUnixNano)
	}
	if orig.TimeUnixNano != uint64(0) {
		dest.WriteObjectField("timeUnixNano")
		dest.WriteUint64(orig.TimeUnixNano)
	}
	if orig.Count != uint64(0) {
		dest.WriteObjectField("count")
		dest.WriteUint64(orig.Count)
	}
	if orig, ok := orig.Sum_.(*otlpmetrics.ExponentialHistogramDataPoint_Sum); ok {
		dest.WriteObjectField("sum")
		dest.WriteFloat64(orig.Sum)
	}
	if orig.Scale != int32(0) {
		dest.WriteObjectField("scale")
		dest.WriteInt32(orig.Scale)
	}
	if orig.ZeroCount != uint64(0) {
		dest.WriteObjectField("zeroCount")
		dest.WriteUint64(orig.ZeroCount)
	}
	dest.WriteObjectField("positive")
	MarshalJSONOrigExponentialHistogramDataPoint_Buckets(&orig.Positive, dest)
	dest.WriteObjectField("negative")
	MarshalJSONOrigExponentialHistogramDataPoint_Buckets(&orig.Negative, dest)
	if orig.Flags != uint32(0) {
		dest.WriteObjectField("flags")
		dest.WriteUint32(orig.Flags)
	}
	if len(orig.Exemplars) > 0 {
		dest.WriteObjectField("exemplars")
		dest.WriteArrayStart()
		MarshalJSONOrigExemplar(&orig.Exemplars[0], dest)
		for i := 1; i < len(orig.Exemplars); i++ {
			dest.WriteMore()
			MarshalJSONOrigExemplar(&orig.Exemplars[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if orig, ok := orig.Min_.(*otlpmetrics.ExponentialHistogramDataPoint_Min); ok {
		dest.WriteObjectField("min")
		dest.WriteFloat64(orig.Min)
	}
	if orig, ok := orig.Max_.(*otlpmetrics.ExponentialHistogramDataPoint_Max); ok {
		dest.WriteObjectField("max")
		dest.WriteFloat64(orig.Max)
	}
	if orig.ZeroThreshold != float64(0) {
		dest.WriteObjectField("zeroThreshold")
		dest.WriteFloat64(orig.ZeroThreshold)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigExponentialHistogramDataPoint unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigExponentialHistogramDataPoint(orig *otlpmetrics.ExponentialHistogramDataPoint, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "attributes":
			for iter.ReadArray() {
				orig.Attributes = append(orig.Attributes, otlpcommon.KeyValue{})
				UnmarshalJSONOrigKeyValue(&orig.Attributes[len(orig.Attributes)-1], iter)
			}

		case "startTimeUnixNano", "start_time_unix_nano":
			orig.StartTimeUnixNano = iter.ReadUint64()
		case "timeUnixNano", "time_unix_nano":
			orig.TimeUnixNano = iter.ReadUint64()
		case "count":
			orig.Count = iter.ReadUint64()
		case "sum":
			{
				var ov *otlpmetrics.ExponentialHistogramDataPoint_Sum
				if !UseProtoPooling.IsEnabled() {
					ov = &otlpmetrics.ExponentialHistogramDataPoint_Sum{}
				} else {
					ov = ProtoPoolExponentialHistogramDataPoint_Sum.Get().(*otlpmetrics.ExponentialHistogramDataPoint_Sum)
				}
				ov.Sum = iter.ReadFloat64()
				orig.Sum_ = ov
			}

		case "scale":
			orig.Scale = iter.ReadInt32()
		case "zeroCount", "zero_count":
			orig.ZeroCount = iter.ReadUint64()
		case "positive":
			UnmarshalJSONOrigExponentialHistogramDataPoint_Buckets(&orig.Positive, iter)
		case "negative":
			UnmarshalJSONOrigExponentialHistogramDataPoint_Buckets(&orig.Negative, iter)
		case "flags":
			orig.Flags = iter.ReadUint32()
		case "exemplars":
			for iter.ReadArray() {
				orig.Exemplars = append(orig.Exemplars, otlpmetrics.Exemplar{})
				UnmarshalJSONOrigExemplar(&orig.Exemplars[len(orig.Exemplars)-1], iter)
			}

		case "min":
			{
				var ov *otlpmetrics.ExponentialHistogramDataPoint_Min
				if !UseProtoPooling.IsEnabled() {
					ov = &otlpmetrics.ExponentialHistogramDataPoint_Min{}
				} else {
					ov = ProtoPoolExponentialHistogramDataPoint_Min.Get().(*otlpmetrics.ExponentialHistogramDataPoint_Min)
				}
				ov.Min = iter.ReadFloat64()
				orig.Min_ = ov
			}

		case "max":
			{
				var ov *otlpmetrics.ExponentialHistogramDataPoint_Max
				if !UseProtoPooling.IsEnabled() {
					ov = &otlpmetrics.ExponentialHistogramDataPoint_Max{}
				} else {
					ov = ProtoPoolExponentialHistogramDataPoint_Max.Get().(*otlpmetrics.ExponentialHistogramDataPoint_Max)
				}
				ov.Max = iter.ReadFloat64()
				orig.Max_ = ov
			}

		case "zeroThreshold", "zero_threshold":
			orig.ZeroThreshold = iter.ReadFloat64()
		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigExponentialHistogramDataPoint(orig *otlpmetrics.ExponentialHistogramDataPoint) int {
	var n int
	var l int
	_ = l
	for i := range orig.Attributes {
		l = SizeProtoOrigKeyValue(&orig.Attributes[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.StartTimeUnixNano != 0 {
		n += 9
	}
	if orig.TimeUnixNano != 0 {
		n += 9
	}
	if orig.Count != 0 {
		n += 9
	}
	if orig, ok := orig.Sum_.(*otlpmetrics.ExponentialHistogramDataPoint_Sum); ok {
		_ = orig
		n += 9
	}
	if orig.Scale != 0 {
		n += 1 + proto.Soz(uint64(orig.Scale))
	}
	if orig.ZeroCount != 0 {
		n += 9
	}
	l = SizeProtoOrigExponentialHistogramDataPoint_Buckets(&orig.Positive)
	n += 1 + proto.Sov(uint64(l)) + l
	l = SizeProtoOrigExponentialHistogramDataPoint_Buckets(&orig.Negative)
	n += 1 + proto.Sov(uint64(l)) + l
	if orig.Flags != 0 {
		n += 1 + proto.Sov(uint64(orig.Flags))
	}
	for i := range orig.Exemplars {
		l = SizeProtoOrigExemplar(&orig.Exemplars[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig, ok := orig.Min_.(*otlpmetrics.ExponentialHistogramDataPoint_Min); ok {
		_ = orig
		n += 9
	}
	if orig, ok := orig.Max_.(*otlpmetrics.ExponentialHistogramDataPoint_Max); ok {
		_ = orig
		n += 9
	}
	if orig.ZeroThreshold != 0 {
		n += 9
	}
	return n
}

func MarshalProtoOrigExponentialHistogramDataPoint(orig *otlpmetrics.ExponentialHistogramDataPoint, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := len(orig.Attributes) - 1; i >= 0; i-- {
		l = MarshalProtoOrigKeyValue(&orig.Attributes[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	if orig.StartTimeUnixNano != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.StartTimeUnixNano))
		pos--
		buf[pos] = 0x11
	}
	if orig.TimeUnixNano != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.TimeUnixNano))
		pos--
		buf[pos] = 0x19
	}
	if orig.Count != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.Count))
		pos--
		buf[pos] = 0x21
	}
	if orig, ok := orig.Sum_.(*otlpmetrics.ExponentialHistogramDataPoint_Sum); ok {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.Sum))
		pos--
		buf[pos] = 0x29
	}
	if orig.Scale != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64((uint32(orig.Scale)<<1)^uint32(orig.Scale>>31)))
		pos--
		buf[pos] = 0x30
	}
	if orig.ZeroCount != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.ZeroCount))
		pos--
		buf[pos] = 0x39
	}

	l = MarshalProtoOrigExponentialHistogramDataPoint_Buckets(&orig.Positive, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x42

	l = MarshalProtoOrigExponentialHistogramDataPoint_Buckets(&orig.Negative, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x4a

	if orig.Flags != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.Flags))
		pos--
		buf[pos] = 0x50
	}
	for i := len(orig.Exemplars) - 1; i >= 0; i-- {
		l = MarshalProtoOrigExemplar(&orig.Exemplars[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x5a
	}
	if orig, ok := orig.Min_.(*otlpmetrics.ExponentialHistogramDataPoint_Min); ok {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.Min))
		pos--
		buf[pos] = 0x61
	}
	if orig, ok := orig.Max_.(*otlpmetrics.ExponentialHistogramDataPoint_Max); ok {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.Max))
		pos--
		buf[pos] = 0x69
	}
	if orig.ZeroThreshold != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.ZeroThreshold))
		pos--
		buf[pos] = 0x71
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigExponentialHistogramDataPoint(orig *otlpmetrics.ExponentialHistogramDataPoint, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Attributes = append(orig.Attributes, otlpcommon.KeyValue{})
			err = UnmarshalProtoOrigKeyValue(&orig.Attributes[len(orig.Attributes)-1], buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeUnixNano", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.StartTimeUnixNano = uint64(num)

		case 3:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.TimeUnixNano = uint64(num)

		case 4:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.Count = uint64(num)

		case 5:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sum", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}
			var ov *otlpmetrics.ExponentialHistogramDataPoint_Sum
			if !UseProtoPooling.IsEnabled() {
				ov = &otlpmetrics.ExponentialHistogramDataPoint_Sum{}
			} else {
				ov = ProtoPoolExponentialHistogramDataPoint_Sum.Get().(*otlpmetrics.ExponentialHistogramDataPoint_Sum)
			}
			ov.Sum = math.Float64frombits(num)
			orig.Sum_ = ov

		case 6:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field Scale", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.Scale = int32(uint32(num>>1) ^ uint32(int32((num&1)<<31)>>31))

		case 7:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field ZeroCount", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.ZeroCount = uint64(num)

		case 8:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Positive", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = UnmarshalProtoOrigExponentialHistogramDataPoint_Buckets(&orig.Positive, buf[startPos:pos])
			if err != nil {
				return err
			}

		case 9:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Negative", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = UnmarshalProtoOrigExponentialHistogramDataPoint_Buckets(&orig.Negative, buf[startPos:pos])
			if err != nil {
				return err
			}

		case 10:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.Flags = uint32(num)

		case 11:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Exemplars", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Exemplars = append(orig.Exemplars, otlpmetrics.Exemplar{})
			err = UnmarshalProtoOrigExemplar(&orig.Exemplars[len(orig.Exemplars)-1], buf[startPos:pos])
			if err != nil {
				return err
			}

		case 12:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field Min", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}
			var ov *otlpmetrics.ExponentialHistogramDataPoint_Min
			if !UseProtoPooling.IsEnabled() {
				ov = &otlpmetrics.ExponentialHistogramDataPoint_Min{}
			} else {
				ov = ProtoPoolExponentialHistogramDataPoint_Min.Get().(*otlpmetrics.ExponentialHistogramDataPoint_Min)
			}
			ov.Min = math.Float64frombits(num)
			orig.Min_ = ov

		case 13:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field Max", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}
			var ov *otlpmetrics.ExponentialHistogramDataPoint_Max
			if !UseProtoPooling.IsEnabled() {
				ov = &otlpmetrics.ExponentialHistogramDataPoint_Max{}
			} else {
				ov = ProtoPoolExponentialHistogramDataPoint_Max.Get().(*otlpmetrics.ExponentialHistogramDataPoint_Max)
			}
			ov.Max = math.Float64frombits(num)
			orig.Max_ = ov

		case 14:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field ZeroThreshold", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.ZeroThreshold = math.Float64frombits(num)
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
