// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"testing"
	"unsafe"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
)

func TestKeyValueAndUnitSlice(t *testing.T) {
	es := NewKeyValueAndUnitSlice()
	assert.Equal(t, 0, es.Len())
	es = newKeyValueAndUnitSlice(&[]*otlpprofiles.KeyValueAndUnit{}, internal.NewState())
	assert.Equal(t, 0, es.Len())

	emptyVal := NewKeyValueAndUnit()
	testVal := generateTestKeyValueAndUnit()
	for i := 0; i < 7; i++ {
		es.AppendEmpty()
		assert.Equal(t, emptyVal, es.At(i))
		(*es.orig)[i] = internal.GenTestOrigKeyValueAndUnit()
		assert.Equal(t, testVal, es.At(i))
	}
	assert.Equal(t, 7, es.Len())
}

func TestKeyValueAndUnitSliceReadOnly(t *testing.T) {
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	es := newKeyValueAndUnitSlice(&[]*otlpprofiles.KeyValueAndUnit{}, sharedState)
	assert.Equal(t, 0, es.Len())
	assert.Panics(t, func() { es.AppendEmpty() })
	assert.Panics(t, func() { es.EnsureCapacity(2) })
	es2 := NewKeyValueAndUnitSlice()
	es.CopyTo(es2)
	assert.Panics(t, func() { es2.CopyTo(es) })
	assert.Panics(t, func() { es.MoveAndAppendTo(es2) })
	assert.Panics(t, func() { es2.MoveAndAppendTo(es) })
}

func TestKeyValueAndUnitSlice_CopyTo(t *testing.T) {
	dest := NewKeyValueAndUnitSlice()
	src := generateTestKeyValueAndUnitSlice()
	src.CopyTo(dest)
	assert.Equal(t, generateTestKeyValueAndUnitSlice(), dest)
	dest.CopyTo(dest)
	assert.Equal(t, generateTestKeyValueAndUnitSlice(), dest)
}

func TestKeyValueAndUnitSlice_EnsureCapacity(t *testing.T) {
	es := generateTestKeyValueAndUnitSlice()

	// Test ensure smaller capacity.
	const ensureSmallLen = 4
	es.EnsureCapacity(ensureSmallLen)
	assert.Less(t, ensureSmallLen, es.Len())
	assert.Equal(t, es.Len(), cap(*es.orig))
	assert.Equal(t, generateTestKeyValueAndUnitSlice(), es)

	// Test ensure larger capacity
	const ensureLargeLen = 9
	es.EnsureCapacity(ensureLargeLen)
	assert.Less(t, generateTestKeyValueAndUnitSlice().Len(), ensureLargeLen)
	assert.Equal(t, ensureLargeLen, cap(*es.orig))
	assert.Equal(t, generateTestKeyValueAndUnitSlice(), es)
}

func TestKeyValueAndUnitSlice_MoveAndAppendTo(t *testing.T) {
	// Test MoveAndAppendTo to empty
	expectedSlice := generateTestKeyValueAndUnitSlice()
	dest := NewKeyValueAndUnitSlice()
	src := generateTestKeyValueAndUnitSlice()
	src.MoveAndAppendTo(dest)
	assert.Equal(t, generateTestKeyValueAndUnitSlice(), dest)
	assert.Equal(t, 0, src.Len())
	assert.Equal(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo empty slice
	src.MoveAndAppendTo(dest)
	assert.Equal(t, generateTestKeyValueAndUnitSlice(), dest)
	assert.Equal(t, 0, src.Len())
	assert.Equal(t, expectedSlice.Len(), dest.Len())

	// Test MoveAndAppendTo not empty slice
	generateTestKeyValueAndUnitSlice().MoveAndAppendTo(dest)
	assert.Equal(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.Equal(t, expectedSlice.At(i), dest.At(i))
		assert.Equal(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}

	dest.MoveAndAppendTo(dest)
	assert.Equal(t, 2*expectedSlice.Len(), dest.Len())
	for i := 0; i < expectedSlice.Len(); i++ {
		assert.Equal(t, expectedSlice.At(i), dest.At(i))
		assert.Equal(t, expectedSlice.At(i), dest.At(i+expectedSlice.Len()))
	}
}

func TestKeyValueAndUnitSlice_RemoveIf(t *testing.T) {
	// Test RemoveIf on empty slice
	emptySlice := NewKeyValueAndUnitSlice()
	emptySlice.RemoveIf(func(el KeyValueAndUnit) bool {
		t.Fail()
		return false
	})

	// Test RemoveIf
	filtered := generateTestKeyValueAndUnitSlice()
	pos := 0
	filtered.RemoveIf(func(el KeyValueAndUnit) bool {
		pos++
		return pos%2 == 1
	})
	assert.Equal(t, 2, filtered.Len())
}

func TestKeyValueAndUnitSlice_RemoveIfAll(t *testing.T) {
	got := generateTestKeyValueAndUnitSlice()
	got.RemoveIf(func(el KeyValueAndUnit) bool {
		return true
	})
	assert.Equal(t, 0, got.Len())
}

func TestKeyValueAndUnitSliceAll(t *testing.T) {
	ms := generateTestKeyValueAndUnitSlice()
	assert.NotEmpty(t, ms.Len())

	var c int
	for i, v := range ms.All() {
		assert.Equal(t, ms.At(i), v, "element should match")
		c++
	}
	assert.Equal(t, ms.Len(), c, "All elements should have been visited")
}

func TestKeyValueAndUnitSlice_Sort(t *testing.T) {
	es := generateTestKeyValueAndUnitSlice()
	es.Sort(func(a, b KeyValueAndUnit) bool {
		return uintptr(unsafe.Pointer(a.orig)) < uintptr(unsafe.Pointer(b.orig))
	})
	for i := 1; i < es.Len(); i++ {
		assert.Less(t, uintptr(unsafe.Pointer(es.At(i-1).orig)), uintptr(unsafe.Pointer(es.At(i).orig)))
	}
	es.Sort(func(a, b KeyValueAndUnit) bool {
		return uintptr(unsafe.Pointer(a.orig)) > uintptr(unsafe.Pointer(b.orig))
	})
	for i := 1; i < es.Len(); i++ {
		assert.Greater(t, uintptr(unsafe.Pointer(es.At(i-1).orig)), uintptr(unsafe.Pointer(es.At(i).orig)))
	}
}

func generateTestKeyValueAndUnitSlice() KeyValueAndUnitSlice {
	ms := NewKeyValueAndUnitSlice()
	*ms.orig = internal.GenerateOrigTestKeyValueAndUnitSlice()
	return ms
}
