// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: opentelemetry/proto/metrics/v1/metrics.proto

package v1

import (
	encoding_binary "encoding/binary"
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"

	go_opentelemetry_io_collector_model_internal_data "go.opentelemetry.io/collector/model/internal/data"
	v11 "go.opentelemetry.io/collector/model/internal/data/protogen/common/v1"
	v1 "go.opentelemetry.io/collector/model/internal/data/protogen/resource/v1"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// AggregationTemporality defines how a metric aggregator reports aggregated
// values. It describes how those values relate to the time interval over
// which they are aggregated.
type AggregationTemporality int32

const (
	// UNSPECIFIED is the default AggregationTemporality, it MUST not be used.
	AggregationTemporality_AGGREGATION_TEMPORALITY_UNSPECIFIED AggregationTemporality = 0
	// DELTA is an AggregationTemporality for a metric aggregator which reports
	// changes since last report time. Successive metrics contain aggregation of
	// values from continuous and non-overlapping intervals.
	//
	// The values for a DELTA metric are based only on the time interval
	// associated with one measurement cycle. There is no dependency on
	// previous measurements like is the case for CUMULATIVE metrics.
	//
	// For example, consider a system measuring the number of requests that
	// it receives and reports the sum of these requests every second as a
	// DELTA metric:
	//
	//   1. The system starts receiving at time=t_0.
	//   2. A request is received, the system measures 1 request.
	//   3. A request is received, the system measures 1 request.
	//   4. A request is received, the system measures 1 request.
	//   5. The 1 second collection cycle ends. A metric is exported for the
	//      number of requests received over the interval of time t_0 to
	//      t_0+1 with a value of 3.
	//   6. A request is received, the system measures 1 request.
	//   7. A request is received, the system measures 1 request.
	//   8. The 1 second collection cycle ends. A metric is exported for the
	//      number of requests received over the interval of time t_0+1 to
	//      t_0+2 with a value of 2.
	AggregationTemporality_AGGREGATION_TEMPORALITY_DELTA AggregationTemporality = 1
	// CUMULATIVE is an AggregationTemporality for a metric aggregator which
	// reports changes since a fixed start time. This means that current values
	// of a CUMULATIVE metric depend on all previous measurements since the
	// start time. Because of this, the sender is required to retain this state
	// in some form. If this state is lost or invalidated, the CUMULATIVE metric
	// values MUST be reset and a new fixed start time following the last
	// reported measurement time sent MUST be used.
	//
	// For example, consider a system measuring the number of requests that
	// it receives and reports the sum of these requests every second as a
	// CUMULATIVE metric:
	//
	//   1. The system starts receiving at time=t_0.
	//   2. A request is received, the system measures 1 request.
	//   3. A request is received, the system measures 1 request.
	//   4. A request is received, the system measures 1 request.
	//   5. The 1 second collection cycle ends. A metric is exported for the
	//      number of requests received over the interval of time t_0 to
	//      t_0+1 with a value of 3.
	//   6. A request is received, the system measures 1 request.
	//   7. A request is received, the system measures 1 request.
	//   8. The 1 second collection cycle ends. A metric is exported for the
	//      number of requests received over the interval of time t_0 to
	//      t_0+2 with a value of 5.
	//   9. The system experiences a fault and loses state.
	//   10. The system recovers and resumes receiving at time=t_1.
	//   11. A request is received, the system measures 1 request.
	//   12. The 1 second collection cycle ends. A metric is exported for the
	//      number of requests received over the interval of time t_1 to
	//      t_0+1 with a value of 1.
	//
	// Note: Even though, when reporting changes since last report time, using
	// CUMULATIVE is valid, it is not recommended. This may cause problems for
	// systems that do not use start_time to determine when the aggregation
	// value was reset (e.g. Prometheus).
	AggregationTemporality_AGGREGATION_TEMPORALITY_CUMULATIVE AggregationTemporality = 2
)

var AggregationTemporality_name = map[int32]string{
	0: "AGGREGATION_TEMPORALITY_UNSPECIFIED",
	1: "AGGREGATION_TEMPORALITY_DELTA",
	2: "AGGREGATION_TEMPORALITY_CUMULATIVE",
}

var AggregationTemporality_value = map[string]int32{
	"AGGREGATION_TEMPORALITY_UNSPECIFIED": 0,
	"AGGREGATION_TEMPORALITY_DELTA":       1,
	"AGGREGATION_TEMPORALITY_CUMULATIVE":  2,
}

func (x AggregationTemporality) String() string {
	return proto.EnumName(AggregationTemporality_name, int32(x))
}

func (AggregationTemporality) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{0}
}

// DataPointFlags is defined as a protobuf 'uint32' type and is to be used as a
// bit-field representing 32 distinct boolean flags.  Each flag defined in this
// enum is a bit-mask.  To test the presence of a single flag in the flags of
// a data point, for example, use an expression like:
//
//   (point.flags & FLAG_NO_RECORDED_VALUE) == FLAG_NO_RECORDED_VALUE
//
type DataPointFlags int32

const (
	DataPointFlags_FLAG_NONE DataPointFlags = 0
	// This DataPoint is valid but has no recorded value.  This value
	// SHOULD be used to reflect explicitly missing data in a series, as
	// for an equivalent to the Prometheus "staleness marker".
	DataPointFlags_FLAG_NO_RECORDED_VALUE DataPointFlags = 1
)

var DataPointFlags_name = map[int32]string{
	0: "FLAG_NONE",
	1: "FLAG_NO_RECORDED_VALUE",
}

var DataPointFlags_value = map[string]int32{
	"FLAG_NONE":              0,
	"FLAG_NO_RECORDED_VALUE": 1,
}

func (x DataPointFlags) String() string {
	return proto.EnumName(DataPointFlags_name, int32(x))
}

func (DataPointFlags) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{1}
}

// MetricsData represents the metrics data that can be stored in a persistent
// storage, OR can be embedded by other protocols that transfer OTLP metrics
// data but do not implement the OTLP protocol.
//
// The main difference between this message and collector protocol is that
// in this message there will not be any "control" or "metadata" specific to
// OTLP protocol.
//
// When new fields are added into this message, the OTLP request MUST be updated
// as well.
type MetricsData struct {
	// An array of ResourceMetrics.
	// For data coming from a single resource this array will typically contain
	// one element. Intermediary nodes that receive data from multiple origins
	// typically batch the data before forwarding further and in that case this
	// array will contain multiple elements.
	ResourceMetrics []*ResourceMetrics `protobuf:"bytes,1,rep,name=resource_metrics,json=resourceMetrics,proto3" json:"resource_metrics,omitempty"`
}

func (m *MetricsData) Reset()         { *m = MetricsData{} }
func (m *MetricsData) String() string { return proto.CompactTextString(m) }
func (*MetricsData) ProtoMessage()    {}
func (*MetricsData) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{0}
}
func (m *MetricsData) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MetricsData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MetricsData.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MetricsData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetricsData.Merge(m, src)
}
func (m *MetricsData) XXX_Size() int {
	return m.Size()
}
func (m *MetricsData) XXX_DiscardUnknown() {
	xxx_messageInfo_MetricsData.DiscardUnknown(m)
}

var xxx_messageInfo_MetricsData proto.InternalMessageInfo

func (m *MetricsData) GetResourceMetrics() []*ResourceMetrics {
	if m != nil {
		return m.ResourceMetrics
	}
	return nil
}

// A collection of InstrumentationLibraryMetrics from a Resource.
type ResourceMetrics struct {
	// The resource for the metrics in this message.
	// If this field is not set then no resource info is known.
	Resource v1.Resource `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource"`
	// A list of metrics that originate from a resource.
	InstrumentationLibraryMetrics []*InstrumentationLibraryMetrics `protobuf:"bytes,2,rep,name=instrumentation_library_metrics,json=instrumentationLibraryMetrics,proto3" json:"instrumentation_library_metrics,omitempty"`
	// This schema_url applies to the data in the "resource" field. It does not apply
	// to the data in the "instrumentation_library_metrics" field which have their own
	// schema_url field.
	SchemaUrl string `protobuf:"bytes,3,opt,name=schema_url,json=schemaUrl,proto3" json:"schema_url,omitempty"`
}

func (m *ResourceMetrics) Reset()         { *m = ResourceMetrics{} }
func (m *ResourceMetrics) String() string { return proto.CompactTextString(m) }
func (*ResourceMetrics) ProtoMessage()    {}
func (*ResourceMetrics) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{1}
}
func (m *ResourceMetrics) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResourceMetrics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResourceMetrics.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResourceMetrics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceMetrics.Merge(m, src)
}
func (m *ResourceMetrics) XXX_Size() int {
	return m.Size()
}
func (m *ResourceMetrics) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceMetrics.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceMetrics proto.InternalMessageInfo

func (m *ResourceMetrics) GetResource() v1.Resource {
	if m != nil {
		return m.Resource
	}
	return v1.Resource{}
}

func (m *ResourceMetrics) GetInstrumentationLibraryMetrics() []*InstrumentationLibraryMetrics {
	if m != nil {
		return m.InstrumentationLibraryMetrics
	}
	return nil
}

func (m *ResourceMetrics) GetSchemaUrl() string {
	if m != nil {
		return m.SchemaUrl
	}
	return ""
}

// A collection of Metrics produced by an InstrumentationLibrary.
type InstrumentationLibraryMetrics struct {
	// The instrumentation library information for the metrics in this message.
	// Semantically when InstrumentationLibrary isn't set, it is equivalent with
	// an empty instrumentation library name (unknown).
	InstrumentationLibrary v11.InstrumentationLibrary `protobuf:"bytes,1,opt,name=instrumentation_library,json=instrumentationLibrary,proto3" json:"instrumentation_library"`
	// A list of metrics that originate from an instrumentation library.
	Metrics []*Metric `protobuf:"bytes,2,rep,name=metrics,proto3" json:"metrics,omitempty"`
	// This schema_url applies to all metrics in the "metrics" field.
	SchemaUrl string `protobuf:"bytes,3,opt,name=schema_url,json=schemaUrl,proto3" json:"schema_url,omitempty"`
}

func (m *InstrumentationLibraryMetrics) Reset()         { *m = InstrumentationLibraryMetrics{} }
func (m *InstrumentationLibraryMetrics) String() string { return proto.CompactTextString(m) }
func (*InstrumentationLibraryMetrics) ProtoMessage()    {}
func (*InstrumentationLibraryMetrics) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{2}
}
func (m *InstrumentationLibraryMetrics) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InstrumentationLibraryMetrics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_InstrumentationLibraryMetrics.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *InstrumentationLibraryMetrics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstrumentationLibraryMetrics.Merge(m, src)
}
func (m *InstrumentationLibraryMetrics) XXX_Size() int {
	return m.Size()
}
func (m *InstrumentationLibraryMetrics) XXX_DiscardUnknown() {
	xxx_messageInfo_InstrumentationLibraryMetrics.DiscardUnknown(m)
}

var xxx_messageInfo_InstrumentationLibraryMetrics proto.InternalMessageInfo

func (m *InstrumentationLibraryMetrics) GetInstrumentationLibrary() v11.InstrumentationLibrary {
	if m != nil {
		return m.InstrumentationLibrary
	}
	return v11.InstrumentationLibrary{}
}

func (m *InstrumentationLibraryMetrics) GetMetrics() []*Metric {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (m *InstrumentationLibraryMetrics) GetSchemaUrl() string {
	if m != nil {
		return m.SchemaUrl
	}
	return ""
}

// Defines a Metric which has one or more timeseries.  The following is a
// brief summary of the Metric data model.  For more details, see:
//
//   https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/metrics/datamodel.md
//
//
// The data model and relation between entities is shown in the
// diagram below. Here, "DataPoint" is the term used to refer to any
// one of the specific data point value types, and "points" is the term used
// to refer to any one of the lists of points contained in the Metric.
//
// - Metric is composed of a metadata and data.
// - Metadata part contains a name, description, unit.
// - Data is one of the possible types (Sum, Gauge, Histogram, Summary).
// - DataPoint contains timestamps, attributes, and one of the possible value type
//   fields.
//
//     Metric
//  +------------+
//  |name        |
//  |description |
//  |unit        |     +------------------------------------+
//  |data        |---> |Gauge, Sum, Histogram, Summary, ... |
//  +------------+     +------------------------------------+
//
//    Data [One of Gauge, Sum, Histogram, Summary, ...]
//  +-----------+
//  |...        |  // Metadata about the Data.
//  |points     |--+
//  +-----------+  |
//                 |      +---------------------------+
//                 |      |DataPoint 1                |
//                 v      |+------+------+   +------+ |
//              +-----+   ||label |label |...|label | |
//              |  1  |-->||value1|value2|...|valueN| |
//              +-----+   |+------+------+   +------+ |
//              |  .  |   |+-----+                    |
//              |  .  |   ||value|                    |
//              |  .  |   |+-----+                    |
//              |  .  |   +---------------------------+
//              |  .  |                   .
//              |  .  |                   .
//              |  .  |                   .
//              |  .  |   +---------------------------+
//              |  .  |   |DataPoint M                |
//              +-----+   |+------+------+   +------+ |
//              |  M  |-->||label |label |...|label | |
//              +-----+   ||value1|value2|...|valueN| |
//                        |+------+------+   +------+ |
//                        |+-----+                    |
//                        ||value|                    |
//                        |+-----+                    |
//                        +---------------------------+
//
// Each distinct type of DataPoint represents the output of a specific
// aggregation function, the result of applying the DataPoint's
// associated function of to one or more measurements.
//
// All DataPoint types have three common fields:
// - Attributes includes key-value pairs associated with the data point
// - TimeUnixNano is required, set to the end time of the aggregation
// - StartTimeUnixNano is optional, but strongly encouraged for DataPoints
//   having an AggregationTemporality field, as discussed below.
//
// Both TimeUnixNano and StartTimeUnixNano values are expressed as
// UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
//
// # TimeUnixNano
//
// This field is required, having consistent interpretation across
// DataPoint types.  TimeUnixNano is the moment corresponding to when
// the data point's aggregate value was captured.
//
// Data points with the 0 value for TimeUnixNano SHOULD be rejected
// by consumers.
//
// # StartTimeUnixNano
//
// StartTimeUnixNano in general allows detecting when a sequence of
// observations is unbroken.  This field indicates to consumers the
// start time for points with cumulative and delta
// AggregationTemporality, and it should be included whenever possible
// to support correct rate calculation.  Although it may be omitted
// when the start time is truly unknown, setting StartTimeUnixNano is
// strongly encouraged.
type Metric struct {
	// name of the metric, including its DNS name prefix. It must be unique.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// description of the metric, which can be used in documentation.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// unit in which the metric value is reported. Follows the format
	// described by http://unitsofmeasure.org/ucum.html.
	Unit string `protobuf:"bytes,3,opt,name=unit,proto3" json:"unit,omitempty"`
	// Data determines the aggregation type (if any) of the metric, what is the
	// reported value type for the data points, as well as the relatationship to
	// the time interval over which they are reported.
	//
	// Types that are valid to be assigned to Data:
	//	*Metric_IntGauge
	//	*Metric_Gauge
	//	*Metric_IntSum
	//	*Metric_Sum
	//	*Metric_IntHistogram
	//	*Metric_Histogram
	//	*Metric_ExponentialHistogram
	//	*Metric_Summary
	Data isMetric_Data `protobuf_oneof:"data"`
}

func (m *Metric) Reset()         { *m = Metric{} }
func (m *Metric) String() string { return proto.CompactTextString(m) }
func (*Metric) ProtoMessage()    {}
func (*Metric) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{3}
}
func (m *Metric) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Metric) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Metric.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Metric) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metric.Merge(m, src)
}
func (m *Metric) XXX_Size() int {
	return m.Size()
}
func (m *Metric) XXX_DiscardUnknown() {
	xxx_messageInfo_Metric.DiscardUnknown(m)
}

var xxx_messageInfo_Metric proto.InternalMessageInfo

type isMetric_Data interface {
	isMetric_Data()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Metric_IntGauge struct {
	IntGauge *IntGauge `protobuf:"bytes,4,opt,name=int_gauge,json=intGauge,proto3,oneof" json:"int_gauge,omitempty"`
}
type Metric_Gauge struct {
	Gauge *Gauge `protobuf:"bytes,5,opt,name=gauge,proto3,oneof" json:"gauge,omitempty"`
}
type Metric_IntSum struct {
	IntSum *IntSum `protobuf:"bytes,6,opt,name=int_sum,json=intSum,proto3,oneof" json:"int_sum,omitempty"`
}
type Metric_Sum struct {
	Sum *Sum `protobuf:"bytes,7,opt,name=sum,proto3,oneof" json:"sum,omitempty"`
}
type Metric_IntHistogram struct {
	IntHistogram *IntHistogram `protobuf:"bytes,8,opt,name=int_histogram,json=intHistogram,proto3,oneof" json:"int_histogram,omitempty"`
}
type Metric_Histogram struct {
	Histogram *Histogram `protobuf:"bytes,9,opt,name=histogram,proto3,oneof" json:"histogram,omitempty"`
}
type Metric_ExponentialHistogram struct {
	ExponentialHistogram *ExponentialHistogram `protobuf:"bytes,10,opt,name=exponential_histogram,json=exponentialHistogram,proto3,oneof" json:"exponential_histogram,omitempty"`
}
type Metric_Summary struct {
	Summary *Summary `protobuf:"bytes,11,opt,name=summary,proto3,oneof" json:"summary,omitempty"`
}

func (*Metric_IntGauge) isMetric_Data()             {}
func (*Metric_Gauge) isMetric_Data()                {}
func (*Metric_IntSum) isMetric_Data()               {}
func (*Metric_Sum) isMetric_Data()                  {}
func (*Metric_IntHistogram) isMetric_Data()         {}
func (*Metric_Histogram) isMetric_Data()            {}
func (*Metric_ExponentialHistogram) isMetric_Data() {}
func (*Metric_Summary) isMetric_Data()              {}

func (m *Metric) GetData() isMetric_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *Metric) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Metric) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Metric) GetUnit() string {
	if m != nil {
		return m.Unit
	}
	return ""
}

// Deprecated: Do not use.
func (m *Metric) GetIntGauge() *IntGauge {
	if x, ok := m.GetData().(*Metric_IntGauge); ok {
		return x.IntGauge
	}
	return nil
}

func (m *Metric) GetGauge() *Gauge {
	if x, ok := m.GetData().(*Metric_Gauge); ok {
		return x.Gauge
	}
	return nil
}

// Deprecated: Do not use.
func (m *Metric) GetIntSum() *IntSum {
	if x, ok := m.GetData().(*Metric_IntSum); ok {
		return x.IntSum
	}
	return nil
}

func (m *Metric) GetSum() *Sum {
	if x, ok := m.GetData().(*Metric_Sum); ok {
		return x.Sum
	}
	return nil
}

// Deprecated: Do not use.
func (m *Metric) GetIntHistogram() *IntHistogram {
	if x, ok := m.GetData().(*Metric_IntHistogram); ok {
		return x.IntHistogram
	}
	return nil
}

func (m *Metric) GetHistogram() *Histogram {
	if x, ok := m.GetData().(*Metric_Histogram); ok {
		return x.Histogram
	}
	return nil
}

func (m *Metric) GetExponentialHistogram() *ExponentialHistogram {
	if x, ok := m.GetData().(*Metric_ExponentialHistogram); ok {
		return x.ExponentialHistogram
	}
	return nil
}

func (m *Metric) GetSummary() *Summary {
	if x, ok := m.GetData().(*Metric_Summary); ok {
		return x.Summary
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Metric) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Metric_IntGauge)(nil),
		(*Metric_Gauge)(nil),
		(*Metric_IntSum)(nil),
		(*Metric_Sum)(nil),
		(*Metric_IntHistogram)(nil),
		(*Metric_Histogram)(nil),
		(*Metric_ExponentialHistogram)(nil),
		(*Metric_Summary)(nil),
	}
}

// Gauge represents the type of a scalar metric that always exports the
// "current value" for every data point. It should be used for an "unknown"
// aggregation.
//
// A Gauge does not support different aggregation temporalities. Given the
// aggregation is unknown, points cannot be combined using the same
// aggregation, regardless of aggregation temporalities. Therefore,
// AggregationTemporality is not included. Consequently, this also means
// "StartTimeUnixNano" is ignored for all data points.
type Gauge struct {
	DataPoints []*NumberDataPoint `protobuf:"bytes,1,rep,name=data_points,json=dataPoints,proto3" json:"data_points,omitempty"`
}

func (m *Gauge) Reset()         { *m = Gauge{} }
func (m *Gauge) String() string { return proto.CompactTextString(m) }
func (*Gauge) ProtoMessage()    {}
func (*Gauge) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{4}
}
func (m *Gauge) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Gauge) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Gauge.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Gauge) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Gauge.Merge(m, src)
}
func (m *Gauge) XXX_Size() int {
	return m.Size()
}
func (m *Gauge) XXX_DiscardUnknown() {
	xxx_messageInfo_Gauge.DiscardUnknown(m)
}

var xxx_messageInfo_Gauge proto.InternalMessageInfo

func (m *Gauge) GetDataPoints() []*NumberDataPoint {
	if m != nil {
		return m.DataPoints
	}
	return nil
}

// Sum represents the type of a scalar metric that is calculated as a sum of all
// reported measurements over a time interval.
type Sum struct {
	DataPoints []*NumberDataPoint `protobuf:"bytes,1,rep,name=data_points,json=dataPoints,proto3" json:"data_points,omitempty"`
	// aggregation_temporality describes if the aggregator reports delta changes
	// since last report time, or cumulative changes since a fixed start time.
	AggregationTemporality AggregationTemporality `protobuf:"varint,2,opt,name=aggregation_temporality,json=aggregationTemporality,proto3,enum=opentelemetry.proto.metrics.v1.AggregationTemporality" json:"aggregation_temporality,omitempty"`
	// If "true" means that the sum is monotonic.
	IsMonotonic bool `protobuf:"varint,3,opt,name=is_monotonic,json=isMonotonic,proto3" json:"is_monotonic,omitempty"`
}

func (m *Sum) Reset()         { *m = Sum{} }
func (m *Sum) String() string { return proto.CompactTextString(m) }
func (*Sum) ProtoMessage()    {}
func (*Sum) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{5}
}
func (m *Sum) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Sum) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Sum.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Sum) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Sum.Merge(m, src)
}
func (m *Sum) XXX_Size() int {
	return m.Size()
}
func (m *Sum) XXX_DiscardUnknown() {
	xxx_messageInfo_Sum.DiscardUnknown(m)
}

var xxx_messageInfo_Sum proto.InternalMessageInfo

func (m *Sum) GetDataPoints() []*NumberDataPoint {
	if m != nil {
		return m.DataPoints
	}
	return nil
}

func (m *Sum) GetAggregationTemporality() AggregationTemporality {
	if m != nil {
		return m.AggregationTemporality
	}
	return AggregationTemporality_AGGREGATION_TEMPORALITY_UNSPECIFIED
}

func (m *Sum) GetIsMonotonic() bool {
	if m != nil {
		return m.IsMonotonic
	}
	return false
}

// Histogram represents the type of a metric that is calculated by aggregating
// as a Histogram of all reported measurements over a time interval.
type Histogram struct {
	DataPoints []*HistogramDataPoint `protobuf:"bytes,1,rep,name=data_points,json=dataPoints,proto3" json:"data_points,omitempty"`
	// aggregation_temporality describes if the aggregator reports delta changes
	// since last report time, or cumulative changes since a fixed start time.
	AggregationTemporality AggregationTemporality `protobuf:"varint,2,opt,name=aggregation_temporality,json=aggregationTemporality,proto3,enum=opentelemetry.proto.metrics.v1.AggregationTemporality" json:"aggregation_temporality,omitempty"`
}

func (m *Histogram) Reset()         { *m = Histogram{} }
func (m *Histogram) String() string { return proto.CompactTextString(m) }
func (*Histogram) ProtoMessage()    {}
func (*Histogram) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{6}
}
func (m *Histogram) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Histogram) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Histogram.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Histogram) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Histogram.Merge(m, src)
}
func (m *Histogram) XXX_Size() int {
	return m.Size()
}
func (m *Histogram) XXX_DiscardUnknown() {
	xxx_messageInfo_Histogram.DiscardUnknown(m)
}

var xxx_messageInfo_Histogram proto.InternalMessageInfo

func (m *Histogram) GetDataPoints() []*HistogramDataPoint {
	if m != nil {
		return m.DataPoints
	}
	return nil
}

func (m *Histogram) GetAggregationTemporality() AggregationTemporality {
	if m != nil {
		return m.AggregationTemporality
	}
	return AggregationTemporality_AGGREGATION_TEMPORALITY_UNSPECIFIED
}

// ExponentialHistogram represents the type of a metric that is calculated by aggregating
// as a ExponentialHistogram of all reported double measurements over a time interval.
type ExponentialHistogram struct {
	DataPoints []*ExponentialHistogramDataPoint `protobuf:"bytes,1,rep,name=data_points,json=dataPoints,proto3" json:"data_points,omitempty"`
	// aggregation_temporality describes if the aggregator reports delta changes
	// since last report time, or cumulative changes since a fixed start time.
	AggregationTemporality AggregationTemporality `protobuf:"varint,2,opt,name=aggregation_temporality,json=aggregationTemporality,proto3,enum=opentelemetry.proto.metrics.v1.AggregationTemporality" json:"aggregation_temporality,omitempty"`
}

func (m *ExponentialHistogram) Reset()         { *m = ExponentialHistogram{} }
func (m *ExponentialHistogram) String() string { return proto.CompactTextString(m) }
func (*ExponentialHistogram) ProtoMessage()    {}
func (*ExponentialHistogram) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{7}
}
func (m *ExponentialHistogram) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExponentialHistogram) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExponentialHistogram.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExponentialHistogram) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExponentialHistogram.Merge(m, src)
}
func (m *ExponentialHistogram) XXX_Size() int {
	return m.Size()
}
func (m *ExponentialHistogram) XXX_DiscardUnknown() {
	xxx_messageInfo_ExponentialHistogram.DiscardUnknown(m)
}

var xxx_messageInfo_ExponentialHistogram proto.InternalMessageInfo

func (m *ExponentialHistogram) GetDataPoints() []*ExponentialHistogramDataPoint {
	if m != nil {
		return m.DataPoints
	}
	return nil
}

func (m *ExponentialHistogram) GetAggregationTemporality() AggregationTemporality {
	if m != nil {
		return m.AggregationTemporality
	}
	return AggregationTemporality_AGGREGATION_TEMPORALITY_UNSPECIFIED
}

// Summary metric data are used to convey quantile summaries,
// a Prometheus (see: https://prometheus.io/docs/concepts/metric_types/#summary)
// and OpenMetrics (see: https://github.com/OpenObservability/OpenMetrics/blob/4dbf6075567ab43296eed941037c12951faafb92/protos/prometheus.proto#L45)
// data type. These data points cannot always be merged in a meaningful way.
// While they can be useful in some applications, histogram data points are
// recommended for new applications.
type Summary struct {
	DataPoints []*SummaryDataPoint `protobuf:"bytes,1,rep,name=data_points,json=dataPoints,proto3" json:"data_points,omitempty"`
}

func (m *Summary) Reset()         { *m = Summary{} }
func (m *Summary) String() string { return proto.CompactTextString(m) }
func (*Summary) ProtoMessage()    {}
func (*Summary) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{8}
}
func (m *Summary) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Summary) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Summary.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Summary) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Summary.Merge(m, src)
}
func (m *Summary) XXX_Size() int {
	return m.Size()
}
func (m *Summary) XXX_DiscardUnknown() {
	xxx_messageInfo_Summary.DiscardUnknown(m)
}

var xxx_messageInfo_Summary proto.InternalMessageInfo

func (m *Summary) GetDataPoints() []*SummaryDataPoint {
	if m != nil {
		return m.DataPoints
	}
	return nil
}

// NumberDataPoint is a single data point in a timeseries that describes the
// time-varying scalar value of a metric.
type NumberDataPoint struct {
	// The set of key/value pairs that uniquely identify the timeseries from
	// where this point belongs. The list may be empty (may contain 0 elements).
	Attributes []v11.KeyValue `protobuf:"bytes,7,rep,name=attributes,proto3" json:"attributes"`
	// Labels is deprecated and will be removed soon.
	// 1. Old senders and receivers that are not aware of this change will
	// continue using the `labels` field.
	// 2. New senders, which are aware of this change MUST send only `attributes`.
	// 3. New receivers, which are aware of this change MUST convert this into
	// `labels` by simply converting all int64 values into float.
	//
	// This field will be removed in ~3 months, on July 1, 2021.
	Labels []v11.StringKeyValue `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels"` // Deprecated: Do not use.
	// StartTimeUnixNano is optional but strongly encouraged, see the
	// the detailed comments above Metric.
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	StartTimeUnixNano uint64 `protobuf:"fixed64,2,opt,name=start_time_unix_nano,json=startTimeUnixNano,proto3" json:"start_time_unix_nano,omitempty"`
	// TimeUnixNano is required, see the detailed comments above Metric.
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	TimeUnixNano uint64 `protobuf:"fixed64,3,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// The value itself.  A point is considered invalid when one of the recognized
	// value fields is not present inside this oneof.
	//
	// Types that are valid to be assigned to Value:
	//	*NumberDataPoint_AsDouble
	//	*NumberDataPoint_AsInt
	Value isNumberDataPoint_Value `protobuf_oneof:"value"`
	// (Optional) List of exemplars collected from
	// measurements that were used to form the data point
	Exemplars []Exemplar `protobuf:"bytes,5,rep,name=exemplars,proto3" json:"exemplars"`
	// Flags that apply to this specific data point.  See DataPointFlags
	// for the available flags and their meaning.
	Flags uint32 `protobuf:"varint,8,opt,name=flags,proto3" json:"flags,omitempty"`
}

func (m *NumberDataPoint) Reset()         { *m = NumberDataPoint{} }
func (m *NumberDataPoint) String() string { return proto.CompactTextString(m) }
func (*NumberDataPoint) ProtoMessage()    {}
func (*NumberDataPoint) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{9}
}
func (m *NumberDataPoint) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NumberDataPoint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NumberDataPoint.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NumberDataPoint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NumberDataPoint.Merge(m, src)
}
func (m *NumberDataPoint) XXX_Size() int {
	return m.Size()
}
func (m *NumberDataPoint) XXX_DiscardUnknown() {
	xxx_messageInfo_NumberDataPoint.DiscardUnknown(m)
}

var xxx_messageInfo_NumberDataPoint proto.InternalMessageInfo

type isNumberDataPoint_Value interface {
	isNumberDataPoint_Value()
	MarshalTo([]byte) (int, error)
	Size() int
}

type NumberDataPoint_AsDouble struct {
	AsDouble float64 `protobuf:"fixed64,4,opt,name=as_double,json=asDouble,proto3,oneof" json:"as_double,omitempty"`
}
type NumberDataPoint_AsInt struct {
	AsInt int64 `protobuf:"fixed64,6,opt,name=as_int,json=asInt,proto3,oneof" json:"as_int,omitempty"`
}

func (*NumberDataPoint_AsDouble) isNumberDataPoint_Value() {}
func (*NumberDataPoint_AsInt) isNumberDataPoint_Value()    {}

func (m *NumberDataPoint) GetValue() isNumberDataPoint_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *NumberDataPoint) GetAttributes() []v11.KeyValue {
	if m != nil {
		return m.Attributes
	}
	return nil
}

// Deprecated: Do not use.
func (m *NumberDataPoint) GetLabels() []v11.StringKeyValue {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *NumberDataPoint) GetStartTimeUnixNano() uint64 {
	if m != nil {
		return m.StartTimeUnixNano
	}
	return 0
}

func (m *NumberDataPoint) GetTimeUnixNano() uint64 {
	if m != nil {
		return m.TimeUnixNano
	}
	return 0
}

func (m *NumberDataPoint) GetAsDouble() float64 {
	if x, ok := m.GetValue().(*NumberDataPoint_AsDouble); ok {
		return x.AsDouble
	}
	return 0
}

func (m *NumberDataPoint) GetAsInt() int64 {
	if x, ok := m.GetValue().(*NumberDataPoint_AsInt); ok {
		return x.AsInt
	}
	return 0
}

func (m *NumberDataPoint) GetExemplars() []Exemplar {
	if m != nil {
		return m.Exemplars
	}
	return nil
}

func (m *NumberDataPoint) GetFlags() uint32 {
	if m != nil {
		return m.Flags
	}
	return 0
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*NumberDataPoint) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*NumberDataPoint_AsDouble)(nil),
		(*NumberDataPoint_AsInt)(nil),
	}
}

// HistogramDataPoint is a single data point in a timeseries that describes the
// time-varying values of a Histogram. A Histogram contains summary statistics
// for a population of values, it may optionally contain the distribution of
// those values across a set of buckets.
//
// If the histogram contains the distribution of values, then both
// "explicit_bounds" and "bucket counts" fields must be defined.
// If the histogram does not contain the distribution of values, then both
// "explicit_bounds" and "bucket_counts" must be omitted and only "count" and
// "sum" are known.
type HistogramDataPoint struct {
	// The set of key/value pairs that uniquely identify the timeseries from
	// where this point belongs. The list may be empty (may contain 0 elements).
	Attributes []v11.KeyValue `protobuf:"bytes,9,rep,name=attributes,proto3" json:"attributes"`
	// Labels is deprecated and will be removed soon.
	// 1. Old senders and receivers that are not aware of this change will
	// continue using the `labels` field.
	// 2. New senders, which are aware of this change MUST send only `attributes`.
	// 3. New receivers, which are aware of this change MUST convert this into
	// `labels` by simply converting all int64 values into float.
	//
	// This field will be removed in ~3 months, on July 1, 2021.
	Labels []v11.StringKeyValue `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels"` // Deprecated: Do not use.
	// StartTimeUnixNano is optional but strongly encouraged, see the
	// the detailed comments above Metric.
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	StartTimeUnixNano uint64 `protobuf:"fixed64,2,opt,name=start_time_unix_nano,json=startTimeUnixNano,proto3" json:"start_time_unix_nano,omitempty"`
	// TimeUnixNano is required, see the detailed comments above Metric.
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	TimeUnixNano uint64 `protobuf:"fixed64,3,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// count is the number of values in the population. Must be non-negative. This
	// value must be equal to the sum of the "count" fields in buckets if a
	// histogram is provided.
	Count uint64 `protobuf:"fixed64,4,opt,name=count,proto3" json:"count,omitempty"`
	// sum of the values in the population. If count is zero then this field
	// must be zero.
	//
	// Note: Sum should only be filled out when measuring non-negative discrete
	// events, and is assumed to be monotonic over the values of these events.
	// Negative events *can* be recorded, but sum should not be filled out when
	// doing so.  This is specifically to enforce compatibility w/ OpenMetrics,
	// see: https://github.com/OpenObservability/OpenMetrics/blob/main/specification/OpenMetrics.md#histogram
	Sum float64 `protobuf:"fixed64,5,opt,name=sum,proto3" json:"sum,omitempty"`
	// bucket_counts is an optional field contains the count values of histogram
	// for each bucket.
	//
	// The sum of the bucket_counts must equal the value in the count field.
	//
	// The number of elements in bucket_counts array must be by one greater than
	// the number of elements in explicit_bounds array.
	BucketCounts []uint64 `protobuf:"fixed64,6,rep,packed,name=bucket_counts,json=bucketCounts,proto3" json:"bucket_counts,omitempty"`
	// explicit_bounds specifies buckets with explicitly defined bounds for values.
	//
	// The boundaries for bucket at index i are:
	//
	// (-infinity, explicit_bounds[i]] for i == 0
	// (explicit_bounds[i-1], explicit_bounds[i]] for 0 < i < size(explicit_bounds)
	// (explicit_bounds[i-1], +infinity) for i == size(explicit_bounds)
	//
	// The values in the explicit_bounds array must be strictly increasing.
	//
	// Histogram buckets are inclusive of their upper boundary, except the last
	// bucket where the boundary is at infinity. This format is intentionally
	// compatible with the OpenMetrics histogram definition.
	ExplicitBounds []float64 `protobuf:"fixed64,7,rep,packed,name=explicit_bounds,json=explicitBounds,proto3" json:"explicit_bounds,omitempty"`
	// (Optional) List of exemplars collected from
	// measurements that were used to form the data point
	Exemplars []Exemplar `protobuf:"bytes,8,rep,name=exemplars,proto3" json:"exemplars"`
	// Flags that apply to this specific data point.  See DataPointFlags
	// for the available flags and their meaning.
	Flags uint32 `protobuf:"varint,10,opt,name=flags,proto3" json:"flags,omitempty"`
}

func (m *HistogramDataPoint) Reset()         { *m = HistogramDataPoint{} }
func (m *HistogramDataPoint) String() string { return proto.CompactTextString(m) }
func (*HistogramDataPoint) ProtoMessage()    {}
func (*HistogramDataPoint) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{10}
}
func (m *HistogramDataPoint) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HistogramDataPoint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HistogramDataPoint.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HistogramDataPoint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HistogramDataPoint.Merge(m, src)
}
func (m *HistogramDataPoint) XXX_Size() int {
	return m.Size()
}
func (m *HistogramDataPoint) XXX_DiscardUnknown() {
	xxx_messageInfo_HistogramDataPoint.DiscardUnknown(m)
}

var xxx_messageInfo_HistogramDataPoint proto.InternalMessageInfo

func (m *HistogramDataPoint) GetAttributes() []v11.KeyValue {
	if m != nil {
		return m.Attributes
	}
	return nil
}

// Deprecated: Do not use.
func (m *HistogramDataPoint) GetLabels() []v11.StringKeyValue {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *HistogramDataPoint) GetStartTimeUnixNano() uint64 {
	if m != nil {
		return m.StartTimeUnixNano
	}
	return 0
}

func (m *HistogramDataPoint) GetTimeUnixNano() uint64 {
	if m != nil {
		return m.TimeUnixNano
	}
	return 0
}

func (m *HistogramDataPoint) GetCount() uint64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *HistogramDataPoint) GetSum() float64 {
	if m != nil {
		return m.Sum
	}
	return 0
}

func (m *HistogramDataPoint) GetBucketCounts() []uint64 {
	if m != nil {
		return m.BucketCounts
	}
	return nil
}

func (m *HistogramDataPoint) GetExplicitBounds() []float64 {
	if m != nil {
		return m.ExplicitBounds
	}
	return nil
}

func (m *HistogramDataPoint) GetExemplars() []Exemplar {
	if m != nil {
		return m.Exemplars
	}
	return nil
}

func (m *HistogramDataPoint) GetFlags() uint32 {
	if m != nil {
		return m.Flags
	}
	return 0
}

// ExponentialHistogramDataPoint is a single data point in a timeseries that describes the
// time-varying values of a ExponentialHistogram of double values. A ExponentialHistogram contains
// summary statistics for a population of values, it may optionally contain the
// distribution of those values across a set of buckets.
//
type ExponentialHistogramDataPoint struct {
	// The set of key/value pairs that uniquely identify the timeseries from
	// where this point belongs. The list may be empty (may contain 0 elements).
	Attributes []v11.KeyValue `protobuf:"bytes,1,rep,name=attributes,proto3" json:"attributes"`
	// StartTimeUnixNano is optional but strongly encouraged, see the
	// the detailed comments above Metric.
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	StartTimeUnixNano uint64 `protobuf:"fixed64,2,opt,name=start_time_unix_nano,json=startTimeUnixNano,proto3" json:"start_time_unix_nano,omitempty"`
	// TimeUnixNano is required, see the detailed comments above Metric.
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	TimeUnixNano uint64 `protobuf:"fixed64,3,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// count is the number of values in the population. Must be
	// non-negative. This value must be equal to the sum of the "bucket_counts"
	// values in the positive and negative Buckets plus the "zero_count" field.
	Count uint64 `protobuf:"fixed64,4,opt,name=count,proto3" json:"count,omitempty"`
	// sum of the values in the population. If count is zero then this field
	// must be zero.
	//
	// Note: Sum should only be filled out when measuring non-negative discrete
	// events, and is assumed to be monotonic over the values of these events.
	// Negative events *can* be recorded, but sum should not be filled out when
	// doing so.  This is specifically to enforce compatibility w/ OpenMetrics,
	// see: https://github.com/OpenObservability/OpenMetrics/blob/main/specification/OpenMetrics.md#histogram
	Sum float64 `protobuf:"fixed64,5,opt,name=sum,proto3" json:"sum,omitempty"`
	// scale describes the resolution of the histogram.  Boundaries are
	// located at powers of the base, where:
	//
	//   base = (2^(2^-scale))
	//
	// The histogram bucket identified by `index`, a signed integer,
	// contains values that are greater than or equal to (base^index) and
	// less than (base^(index+1)).
	//
	// The positive and negative ranges of the histogram are expressed
	// separately.  Negative values are mapped by their absolute value
	// into the negative range using the same scale as the positive range.
	//
	// scale is not restricted by the protocol, as the permissible
	// values depend on the range of the data.
	Scale int32 `protobuf:"zigzag32,6,opt,name=scale,proto3" json:"scale,omitempty"`
	// zero_count is the count of values that are either exactly zero or
	// within the region considered zero by the instrumentation at the
	// tolerated degree of precision.  This bucket stores values that
	// cannot be expressed using the standard exponential formula as
	// well as values that have been rounded to zero.
	//
	// Implementations MAY consider the zero bucket to have probability
	// mass equal to (zero_count / count).
	ZeroCount uint64 `protobuf:"fixed64,7,opt,name=zero_count,json=zeroCount,proto3" json:"zero_count,omitempty"`
	// positive carries the positive range of exponential bucket counts.
	Positive ExponentialHistogramDataPoint_Buckets `protobuf:"bytes,8,opt,name=positive,proto3" json:"positive"`
	// negative carries the negative range of exponential bucket counts.
	Negative ExponentialHistogramDataPoint_Buckets `protobuf:"bytes,9,opt,name=negative,proto3" json:"negative"`
	// Flags that apply to this specific data point.  See DataPointFlags
	// for the available flags and their meaning.
	Flags uint32 `protobuf:"varint,10,opt,name=flags,proto3" json:"flags,omitempty"`
	// (Optional) List of exemplars collected from
	// measurements that were used to form the data point
	Exemplars []Exemplar `protobuf:"bytes,11,rep,name=exemplars,proto3" json:"exemplars"`
}

func (m *ExponentialHistogramDataPoint) Reset()         { *m = ExponentialHistogramDataPoint{} }
func (m *ExponentialHistogramDataPoint) String() string { return proto.CompactTextString(m) }
func (*ExponentialHistogramDataPoint) ProtoMessage()    {}
func (*ExponentialHistogramDataPoint) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{11}
}
func (m *ExponentialHistogramDataPoint) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExponentialHistogramDataPoint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExponentialHistogramDataPoint.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExponentialHistogramDataPoint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExponentialHistogramDataPoint.Merge(m, src)
}
func (m *ExponentialHistogramDataPoint) XXX_Size() int {
	return m.Size()
}
func (m *ExponentialHistogramDataPoint) XXX_DiscardUnknown() {
	xxx_messageInfo_ExponentialHistogramDataPoint.DiscardUnknown(m)
}

var xxx_messageInfo_ExponentialHistogramDataPoint proto.InternalMessageInfo

func (m *ExponentialHistogramDataPoint) GetAttributes() []v11.KeyValue {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *ExponentialHistogramDataPoint) GetStartTimeUnixNano() uint64 {
	if m != nil {
		return m.StartTimeUnixNano
	}
	return 0
}

func (m *ExponentialHistogramDataPoint) GetTimeUnixNano() uint64 {
	if m != nil {
		return m.TimeUnixNano
	}
	return 0
}

func (m *ExponentialHistogramDataPoint) GetCount() uint64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *ExponentialHistogramDataPoint) GetSum() float64 {
	if m != nil {
		return m.Sum
	}
	return 0
}

func (m *ExponentialHistogramDataPoint) GetScale() int32 {
	if m != nil {
		return m.Scale
	}
	return 0
}

func (m *ExponentialHistogramDataPoint) GetZeroCount() uint64 {
	if m != nil {
		return m.ZeroCount
	}
	return 0
}

func (m *ExponentialHistogramDataPoint) GetPositive() ExponentialHistogramDataPoint_Buckets {
	if m != nil {
		return m.Positive
	}
	return ExponentialHistogramDataPoint_Buckets{}
}

func (m *ExponentialHistogramDataPoint) GetNegative() ExponentialHistogramDataPoint_Buckets {
	if m != nil {
		return m.Negative
	}
	return ExponentialHistogramDataPoint_Buckets{}
}

func (m *ExponentialHistogramDataPoint) GetFlags() uint32 {
	if m != nil {
		return m.Flags
	}
	return 0
}

func (m *ExponentialHistogramDataPoint) GetExemplars() []Exemplar {
	if m != nil {
		return m.Exemplars
	}
	return nil
}

// Buckets are a set of bucket counts, encoded in a contiguous array
// of counts.
type ExponentialHistogramDataPoint_Buckets struct {
	// Offset is the bucket index of the first entry in the bucket_counts array.
	//
	// Note: This uses a varint encoding as a simple form of compression.
	Offset int32 `protobuf:"zigzag32,1,opt,name=offset,proto3" json:"offset,omitempty"`
	// Count is an array of counts, where count[i] carries the count
	// of the bucket at index (offset+i).  count[i] is the count of
	// values greater than or equal to base^(offset+i) and less than
	// base^(offset+i+1).
	//
	// Note: By contrast, the explicit HistogramDataPoint uses
	// fixed64.  This field is expected to have many buckets,
	// especially zeros, so uint64 has been selected to ensure
	// varint encoding.
	BucketCounts []uint64 `protobuf:"varint,2,rep,packed,name=bucket_counts,json=bucketCounts,proto3" json:"bucket_counts,omitempty"`
}

func (m *ExponentialHistogramDataPoint_Buckets) Reset()         { *m = ExponentialHistogramDataPoint_Buckets{} }
func (m *ExponentialHistogramDataPoint_Buckets) String() string { return proto.CompactTextString(m) }
func (*ExponentialHistogramDataPoint_Buckets) ProtoMessage()    {}
func (*ExponentialHistogramDataPoint_Buckets) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{11, 0}
}
func (m *ExponentialHistogramDataPoint_Buckets) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExponentialHistogramDataPoint_Buckets) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExponentialHistogramDataPoint_Buckets.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExponentialHistogramDataPoint_Buckets) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExponentialHistogramDataPoint_Buckets.Merge(m, src)
}
func (m *ExponentialHistogramDataPoint_Buckets) XXX_Size() int {
	return m.Size()
}
func (m *ExponentialHistogramDataPoint_Buckets) XXX_DiscardUnknown() {
	xxx_messageInfo_ExponentialHistogramDataPoint_Buckets.DiscardUnknown(m)
}

var xxx_messageInfo_ExponentialHistogramDataPoint_Buckets proto.InternalMessageInfo

func (m *ExponentialHistogramDataPoint_Buckets) GetOffset() int32 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *ExponentialHistogramDataPoint_Buckets) GetBucketCounts() []uint64 {
	if m != nil {
		return m.BucketCounts
	}
	return nil
}

// SummaryDataPoint is a single data point in a timeseries that describes the
// time-varying values of a Summary metric.
type SummaryDataPoint struct {
	// The set of key/value pairs that uniquely identify the timeseries from
	// where this point belongs. The list may be empty (may contain 0 elements).
	Attributes []v11.KeyValue `protobuf:"bytes,7,rep,name=attributes,proto3" json:"attributes"`
	// Labels is deprecated and will be removed soon.
	// 1. Old senders and receivers that are not aware of this change will
	// continue using the `labels` field.
	// 2. New senders, which are aware of this change MUST send only `attributes`.
	// 3. New receivers, which are aware of this change MUST convert this into
	// `labels` by simply converting all int64 values into float.
	//
	// This field will be removed in ~3 months, on July 1, 2021.
	Labels []v11.StringKeyValue `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels"` // Deprecated: Do not use.
	// StartTimeUnixNano is optional but strongly encouraged, see the
	// the detailed comments above Metric.
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	StartTimeUnixNano uint64 `protobuf:"fixed64,2,opt,name=start_time_unix_nano,json=startTimeUnixNano,proto3" json:"start_time_unix_nano,omitempty"`
	// TimeUnixNano is required, see the detailed comments above Metric.
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	TimeUnixNano uint64 `protobuf:"fixed64,3,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// count is the number of values in the population. Must be non-negative.
	Count uint64 `protobuf:"fixed64,4,opt,name=count,proto3" json:"count,omitempty"`
	// sum of the values in the population. If count is zero then this field
	// must be zero.
	//
	// Note: Sum should only be filled out when measuring non-negative discrete
	// events, and is assumed to be monotonic over the values of these events.
	// Negative events *can* be recorded, but sum should not be filled out when
	// doing so.  This is specifically to enforce compatibility w/ OpenMetrics,
	// see: https://github.com/OpenObservability/OpenMetrics/blob/main/specification/OpenMetrics.md#summary
	Sum float64 `protobuf:"fixed64,5,opt,name=sum,proto3" json:"sum,omitempty"`
	// (Optional) list of values at different quantiles of the distribution calculated
	// from the current snapshot. The quantiles must be strictly increasing.
	QuantileValues []*SummaryDataPoint_ValueAtQuantile `protobuf:"bytes,6,rep,name=quantile_values,json=quantileValues,proto3" json:"quantile_values,omitempty"`
	// Flags that apply to this specific data point.  See DataPointFlags
	// for the available flags and their meaning.
	Flags uint32 `protobuf:"varint,8,opt,name=flags,proto3" json:"flags,omitempty"`
}

func (m *SummaryDataPoint) Reset()         { *m = SummaryDataPoint{} }
func (m *SummaryDataPoint) String() string { return proto.CompactTextString(m) }
func (*SummaryDataPoint) ProtoMessage()    {}
func (*SummaryDataPoint) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{12}
}
func (m *SummaryDataPoint) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SummaryDataPoint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SummaryDataPoint.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SummaryDataPoint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SummaryDataPoint.Merge(m, src)
}
func (m *SummaryDataPoint) XXX_Size() int {
	return m.Size()
}
func (m *SummaryDataPoint) XXX_DiscardUnknown() {
	xxx_messageInfo_SummaryDataPoint.DiscardUnknown(m)
}

var xxx_messageInfo_SummaryDataPoint proto.InternalMessageInfo

func (m *SummaryDataPoint) GetAttributes() []v11.KeyValue {
	if m != nil {
		return m.Attributes
	}
	return nil
}

// Deprecated: Do not use.
func (m *SummaryDataPoint) GetLabels() []v11.StringKeyValue {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *SummaryDataPoint) GetStartTimeUnixNano() uint64 {
	if m != nil {
		return m.StartTimeUnixNano
	}
	return 0
}

func (m *SummaryDataPoint) GetTimeUnixNano() uint64 {
	if m != nil {
		return m.TimeUnixNano
	}
	return 0
}

func (m *SummaryDataPoint) GetCount() uint64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *SummaryDataPoint) GetSum() float64 {
	if m != nil {
		return m.Sum
	}
	return 0
}

func (m *SummaryDataPoint) GetQuantileValues() []*SummaryDataPoint_ValueAtQuantile {
	if m != nil {
		return m.QuantileValues
	}
	return nil
}

func (m *SummaryDataPoint) GetFlags() uint32 {
	if m != nil {
		return m.Flags
	}
	return 0
}

// Represents the value at a given quantile of a distribution.
//
// To record Min and Max values following conventions are used:
// - The 1.0 quantile is equivalent to the maximum value observed.
// - The 0.0 quantile is equivalent to the minimum value observed.
//
// See the following issue for more context:
// https://github.com/open-telemetry/opentelemetry-proto/issues/125
type SummaryDataPoint_ValueAtQuantile struct {
	// The quantile of a distribution. Must be in the interval
	// [0.0, 1.0].
	Quantile float64 `protobuf:"fixed64,1,opt,name=quantile,proto3" json:"quantile,omitempty"`
	// The value at the given quantile of a distribution.
	//
	// Quantile values must NOT be negative.
	Value float64 `protobuf:"fixed64,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *SummaryDataPoint_ValueAtQuantile) Reset()         { *m = SummaryDataPoint_ValueAtQuantile{} }
func (m *SummaryDataPoint_ValueAtQuantile) String() string { return proto.CompactTextString(m) }
func (*SummaryDataPoint_ValueAtQuantile) ProtoMessage()    {}
func (*SummaryDataPoint_ValueAtQuantile) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{12, 0}
}
func (m *SummaryDataPoint_ValueAtQuantile) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SummaryDataPoint_ValueAtQuantile) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SummaryDataPoint_ValueAtQuantile.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SummaryDataPoint_ValueAtQuantile) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SummaryDataPoint_ValueAtQuantile.Merge(m, src)
}
func (m *SummaryDataPoint_ValueAtQuantile) XXX_Size() int {
	return m.Size()
}
func (m *SummaryDataPoint_ValueAtQuantile) XXX_DiscardUnknown() {
	xxx_messageInfo_SummaryDataPoint_ValueAtQuantile.DiscardUnknown(m)
}

var xxx_messageInfo_SummaryDataPoint_ValueAtQuantile proto.InternalMessageInfo

func (m *SummaryDataPoint_ValueAtQuantile) GetQuantile() float64 {
	if m != nil {
		return m.Quantile
	}
	return 0
}

func (m *SummaryDataPoint_ValueAtQuantile) GetValue() float64 {
	if m != nil {
		return m.Value
	}
	return 0
}

// A representation of an exemplar, which is a sample input measurement.
// Exemplars also hold information about the environment when the measurement
// was recorded, for example the span and trace ID of the active span when the
// exemplar was recorded.
type Exemplar struct {
	// The set of key/value pairs that were filtered out by the aggregator, but
	// recorded alongside the original measurement. Only key/value pairs that were
	// filtered out by the aggregator should be included
	FilteredAttributes []v11.KeyValue `protobuf:"bytes,7,rep,name=filtered_attributes,json=filteredAttributes,proto3" json:"filtered_attributes"`
	// Labels is deprecated and will be removed soon.
	// 1. Old senders and receivers that are not aware of this change will
	// continue using the `filtered_labels` field.
	// 2. New senders, which are aware of this change MUST send only
	// `filtered_attributes`.
	// 3. New receivers, which are aware of this change MUST convert this into
	// `filtered_labels` by simply converting all int64 values into float.
	//
	// This field will be removed in ~3 months, on July 1, 2021.
	FilteredLabels []v11.StringKeyValue `protobuf:"bytes,1,rep,name=filtered_labels,json=filteredLabels,proto3" json:"filtered_labels"` // Deprecated: Do not use.
	// time_unix_nano is the exact time when this exemplar was recorded
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	TimeUnixNano uint64 `protobuf:"fixed64,2,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// The value of the measurement that was recorded. An exemplar is
	// considered invalid when one of the recognized value fields is not present
	// inside this oneof.
	//
	// Types that are valid to be assigned to Value:
	//	*Exemplar_AsDouble
	//	*Exemplar_AsInt
	Value isExemplar_Value `protobuf_oneof:"value"`
	// (Optional) Span ID of the exemplar trace.
	// span_id may be missing if the measurement is not recorded inside a trace
	// or if the trace is not sampled.
	SpanId go_opentelemetry_io_collector_model_internal_data.SpanID `protobuf:"bytes,4,opt,name=span_id,json=spanId,proto3,customtype=go.opentelemetry.io/collector/model/internal/data.SpanID" json:"span_id"`
	// (Optional) Trace ID of the exemplar trace.
	// trace_id may be missing if the measurement is not recorded inside a trace
	// or if the trace is not sampled.
	TraceId go_opentelemetry_io_collector_model_internal_data.TraceID `protobuf:"bytes,5,opt,name=trace_id,json=traceId,proto3,customtype=go.opentelemetry.io/collector/model/internal/data.TraceID" json:"trace_id"`
}

func (m *Exemplar) Reset()         { *m = Exemplar{} }
func (m *Exemplar) String() string { return proto.CompactTextString(m) }
func (*Exemplar) ProtoMessage()    {}
func (*Exemplar) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{13}
}
func (m *Exemplar) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Exemplar) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Exemplar.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Exemplar) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Exemplar.Merge(m, src)
}
func (m *Exemplar) XXX_Size() int {
	return m.Size()
}
func (m *Exemplar) XXX_DiscardUnknown() {
	xxx_messageInfo_Exemplar.DiscardUnknown(m)
}

var xxx_messageInfo_Exemplar proto.InternalMessageInfo

type isExemplar_Value interface {
	isExemplar_Value()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Exemplar_AsDouble struct {
	AsDouble float64 `protobuf:"fixed64,3,opt,name=as_double,json=asDouble,proto3,oneof" json:"as_double,omitempty"`
}
type Exemplar_AsInt struct {
	AsInt int64 `protobuf:"fixed64,6,opt,name=as_int,json=asInt,proto3,oneof" json:"as_int,omitempty"`
}

func (*Exemplar_AsDouble) isExemplar_Value() {}
func (*Exemplar_AsInt) isExemplar_Value()    {}

func (m *Exemplar) GetValue() isExemplar_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *Exemplar) GetFilteredAttributes() []v11.KeyValue {
	if m != nil {
		return m.FilteredAttributes
	}
	return nil
}

// Deprecated: Do not use.
func (m *Exemplar) GetFilteredLabels() []v11.StringKeyValue {
	if m != nil {
		return m.FilteredLabels
	}
	return nil
}

func (m *Exemplar) GetTimeUnixNano() uint64 {
	if m != nil {
		return m.TimeUnixNano
	}
	return 0
}

func (m *Exemplar) GetAsDouble() float64 {
	if x, ok := m.GetValue().(*Exemplar_AsDouble); ok {
		return x.AsDouble
	}
	return 0
}

func (m *Exemplar) GetAsInt() int64 {
	if x, ok := m.GetValue().(*Exemplar_AsInt); ok {
		return x.AsInt
	}
	return 0
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Exemplar) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Exemplar_AsDouble)(nil),
		(*Exemplar_AsInt)(nil),
	}
}

// IntDataPoint is deprecated. Use integer value in NumberDataPoint.
//
// Deprecated: Do not use.
type IntDataPoint struct {
	// The set of labels that uniquely identify this timeseries.
	Labels []v11.StringKeyValue `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels"`
	// StartTimeUnixNano is optional but strongly encouraged, see the
	// the detailed comments above Metric.
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	StartTimeUnixNano uint64 `protobuf:"fixed64,2,opt,name=start_time_unix_nano,json=startTimeUnixNano,proto3" json:"start_time_unix_nano,omitempty"`
	// TimeUnixNano is required, see the detailed comments above Metric.
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	TimeUnixNano uint64 `protobuf:"fixed64,3,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// value itself.
	Value int64 `protobuf:"fixed64,4,opt,name=value,proto3" json:"value,omitempty"`
	// (Optional) List of exemplars collected from
	// measurements that were used to form the data point
	Exemplars []IntExemplar `protobuf:"bytes,5,rep,name=exemplars,proto3" json:"exemplars"`
}

func (m *IntDataPoint) Reset()         { *m = IntDataPoint{} }
func (m *IntDataPoint) String() string { return proto.CompactTextString(m) }
func (*IntDataPoint) ProtoMessage()    {}
func (*IntDataPoint) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{14}
}
func (m *IntDataPoint) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IntDataPoint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IntDataPoint.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IntDataPoint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IntDataPoint.Merge(m, src)
}
func (m *IntDataPoint) XXX_Size() int {
	return m.Size()
}
func (m *IntDataPoint) XXX_DiscardUnknown() {
	xxx_messageInfo_IntDataPoint.DiscardUnknown(m)
}

var xxx_messageInfo_IntDataPoint proto.InternalMessageInfo

func (m *IntDataPoint) GetLabels() []v11.StringKeyValue {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *IntDataPoint) GetStartTimeUnixNano() uint64 {
	if m != nil {
		return m.StartTimeUnixNano
	}
	return 0
}

func (m *IntDataPoint) GetTimeUnixNano() uint64 {
	if m != nil {
		return m.TimeUnixNano
	}
	return 0
}

func (m *IntDataPoint) GetValue() int64 {
	if m != nil {
		return m.Value
	}
	return 0
}

func (m *IntDataPoint) GetExemplars() []IntExemplar {
	if m != nil {
		return m.Exemplars
	}
	return nil
}

// IntGauge is deprecated.  Use Gauge with an integer value in NumberDataPoint.
//
// Deprecated: Do not use.
type IntGauge struct {
	DataPoints []*IntDataPoint `protobuf:"bytes,1,rep,name=data_points,json=dataPoints,proto3" json:"data_points,omitempty"`
}

func (m *IntGauge) Reset()         { *m = IntGauge{} }
func (m *IntGauge) String() string { return proto.CompactTextString(m) }
func (*IntGauge) ProtoMessage()    {}
func (*IntGauge) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{15}
}
func (m *IntGauge) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IntGauge) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IntGauge.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IntGauge) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IntGauge.Merge(m, src)
}
func (m *IntGauge) XXX_Size() int {
	return m.Size()
}
func (m *IntGauge) XXX_DiscardUnknown() {
	xxx_messageInfo_IntGauge.DiscardUnknown(m)
}

var xxx_messageInfo_IntGauge proto.InternalMessageInfo

func (m *IntGauge) GetDataPoints() []*IntDataPoint {
	if m != nil {
		return m.DataPoints
	}
	return nil
}

// IntSum is deprecated.  Use Sum with an integer value in NumberDataPoint.
//
// Deprecated: Do not use.
type IntSum struct {
	DataPoints []*IntDataPoint `protobuf:"bytes,1,rep,name=data_points,json=dataPoints,proto3" json:"data_points,omitempty"`
	// aggregation_temporality describes if the aggregator reports delta changes
	// since last report time, or cumulative changes since a fixed start time.
	AggregationTemporality AggregationTemporality `protobuf:"varint,2,opt,name=aggregation_temporality,json=aggregationTemporality,proto3,enum=opentelemetry.proto.metrics.v1.AggregationTemporality" json:"aggregation_temporality,omitempty"`
	// If "true" means that the sum is monotonic.
	IsMonotonic bool `protobuf:"varint,3,opt,name=is_monotonic,json=isMonotonic,proto3" json:"is_monotonic,omitempty"`
}

func (m *IntSum) Reset()         { *m = IntSum{} }
func (m *IntSum) String() string { return proto.CompactTextString(m) }
func (*IntSum) ProtoMessage()    {}
func (*IntSum) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{16}
}
func (m *IntSum) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IntSum) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IntSum.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IntSum) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IntSum.Merge(m, src)
}
func (m *IntSum) XXX_Size() int {
	return m.Size()
}
func (m *IntSum) XXX_DiscardUnknown() {
	xxx_messageInfo_IntSum.DiscardUnknown(m)
}

var xxx_messageInfo_IntSum proto.InternalMessageInfo

func (m *IntSum) GetDataPoints() []*IntDataPoint {
	if m != nil {
		return m.DataPoints
	}
	return nil
}

func (m *IntSum) GetAggregationTemporality() AggregationTemporality {
	if m != nil {
		return m.AggregationTemporality
	}
	return AggregationTemporality_AGGREGATION_TEMPORALITY_UNSPECIFIED
}

func (m *IntSum) GetIsMonotonic() bool {
	if m != nil {
		return m.IsMonotonic
	}
	return false
}

// IntHistogramDataPoint is deprecated; use HistogramDataPoint.
//
// Deprecated: Do not use.
type IntHistogramDataPoint struct {
	// The set of labels that uniquely identify this timeseries.
	Labels []v11.StringKeyValue `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels"`
	// StartTimeUnixNano is optional but strongly encouraged, see the
	// the detailed comments above Metric.
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	StartTimeUnixNano uint64 `protobuf:"fixed64,2,opt,name=start_time_unix_nano,json=startTimeUnixNano,proto3" json:"start_time_unix_nano,omitempty"`
	// TimeUnixNano is required, see the detailed comments above Metric.
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	TimeUnixNano uint64 `protobuf:"fixed64,3,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// count is the number of values in the population. Must be non-negative. This
	// value must be equal to the sum of the "count" fields in buckets if a
	// histogram is provided.
	Count uint64 `protobuf:"fixed64,4,opt,name=count,proto3" json:"count,omitempty"`
	// sum of the values in the population. If count is zero then this field
	// must be zero. This value must be equal to the sum of the "sum" fields in
	// buckets if a histogram is provided.
	Sum int64 `protobuf:"fixed64,5,opt,name=sum,proto3" json:"sum,omitempty"`
	// bucket_counts is an optional field contains the count values of histogram
	// for each bucket.
	//
	// The sum of the bucket_counts must equal the value in the count field.
	//
	// The number of elements in bucket_counts array must be by one greater than
	// the number of elements in explicit_bounds array.
	BucketCounts []uint64 `protobuf:"fixed64,6,rep,packed,name=bucket_counts,json=bucketCounts,proto3" json:"bucket_counts,omitempty"`
	// explicit_bounds specifies buckets with explicitly defined bounds for values.
	//
	// The boundaries for bucket at index i are:
	//
	// (-infinity, explicit_bounds[i]] for i == 0
	// (explicit_bounds[i-1], explicit_bounds[i]] for 0 < i < size(explicit_bounds)
	// (explicit_bounds[i-1], +infinity) for i == size(explicit_bounds)
	//
	// The values in the explicit_bounds array must be strictly increasing.
	//
	// Histogram buckets are inclusive of their upper boundary, except the last
	// bucket where the boundary is at infinity. This format is intentionally
	// compatible with the OpenMetrics histogram definition.
	ExplicitBounds []float64 `protobuf:"fixed64,7,rep,packed,name=explicit_bounds,json=explicitBounds,proto3" json:"explicit_bounds,omitempty"`
	// (Optional) List of exemplars collected from
	// measurements that were used to form the data point
	Exemplars []IntExemplar `protobuf:"bytes,8,rep,name=exemplars,proto3" json:"exemplars"`
}

func (m *IntHistogramDataPoint) Reset()         { *m = IntHistogramDataPoint{} }
func (m *IntHistogramDataPoint) String() string { return proto.CompactTextString(m) }
func (*IntHistogramDataPoint) ProtoMessage()    {}
func (*IntHistogramDataPoint) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{17}
}
func (m *IntHistogramDataPoint) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IntHistogramDataPoint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IntHistogramDataPoint.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IntHistogramDataPoint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IntHistogramDataPoint.Merge(m, src)
}
func (m *IntHistogramDataPoint) XXX_Size() int {
	return m.Size()
}
func (m *IntHistogramDataPoint) XXX_DiscardUnknown() {
	xxx_messageInfo_IntHistogramDataPoint.DiscardUnknown(m)
}

var xxx_messageInfo_IntHistogramDataPoint proto.InternalMessageInfo

func (m *IntHistogramDataPoint) GetLabels() []v11.StringKeyValue {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *IntHistogramDataPoint) GetStartTimeUnixNano() uint64 {
	if m != nil {
		return m.StartTimeUnixNano
	}
	return 0
}

func (m *IntHistogramDataPoint) GetTimeUnixNano() uint64 {
	if m != nil {
		return m.TimeUnixNano
	}
	return 0
}

func (m *IntHistogramDataPoint) GetCount() uint64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *IntHistogramDataPoint) GetSum() int64 {
	if m != nil {
		return m.Sum
	}
	return 0
}

func (m *IntHistogramDataPoint) GetBucketCounts() []uint64 {
	if m != nil {
		return m.BucketCounts
	}
	return nil
}

func (m *IntHistogramDataPoint) GetExplicitBounds() []float64 {
	if m != nil {
		return m.ExplicitBounds
	}
	return nil
}

func (m *IntHistogramDataPoint) GetExemplars() []IntExemplar {
	if m != nil {
		return m.Exemplars
	}
	return nil
}

// IntHistogram is deprecated, replaced by Histogram points using double-
// valued exemplars.
//
// Deprecated: Do not use.
type IntHistogram struct {
	DataPoints []*IntHistogramDataPoint `protobuf:"bytes,1,rep,name=data_points,json=dataPoints,proto3" json:"data_points,omitempty"`
	// aggregation_temporality describes if the aggregator reports delta changes
	// since last report time, or cumulative changes since a fixed start time.
	AggregationTemporality AggregationTemporality `protobuf:"varint,2,opt,name=aggregation_temporality,json=aggregationTemporality,proto3,enum=opentelemetry.proto.metrics.v1.AggregationTemporality" json:"aggregation_temporality,omitempty"`
}

func (m *IntHistogram) Reset()         { *m = IntHistogram{} }
func (m *IntHistogram) String() string { return proto.CompactTextString(m) }
func (*IntHistogram) ProtoMessage()    {}
func (*IntHistogram) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{18}
}
func (m *IntHistogram) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IntHistogram) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IntHistogram.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IntHistogram) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IntHistogram.Merge(m, src)
}
func (m *IntHistogram) XXX_Size() int {
	return m.Size()
}
func (m *IntHistogram) XXX_DiscardUnknown() {
	xxx_messageInfo_IntHistogram.DiscardUnknown(m)
}

var xxx_messageInfo_IntHistogram proto.InternalMessageInfo

func (m *IntHistogram) GetDataPoints() []*IntHistogramDataPoint {
	if m != nil {
		return m.DataPoints
	}
	return nil
}

func (m *IntHistogram) GetAggregationTemporality() AggregationTemporality {
	if m != nil {
		return m.AggregationTemporality
	}
	return AggregationTemporality_AGGREGATION_TEMPORALITY_UNSPECIFIED
}

// IntExemplar is deprecated. Use Exemplar with as_int for value
//
// Deprecated: Do not use.
type IntExemplar struct {
	// The set of labels that were filtered out by the aggregator, but recorded
	// alongside the original measurement. Only labels that were filtered out
	// by the aggregator should be included
	FilteredLabels []v11.StringKeyValue `protobuf:"bytes,1,rep,name=filtered_labels,json=filteredLabels,proto3" json:"filtered_labels"`
	// time_unix_nano is the exact time when this exemplar was recorded
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	TimeUnixNano uint64 `protobuf:"fixed64,2,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// Numerical int value of the measurement that was recorded.
	Value int64 `protobuf:"fixed64,3,opt,name=value,proto3" json:"value,omitempty"`
	// (Optional) Span ID of the exemplar trace.
	// span_id may be missing if the measurement is not recorded inside a trace
	// or if the trace is not sampled.
	SpanId go_opentelemetry_io_collector_model_internal_data.SpanID `protobuf:"bytes,4,opt,name=span_id,json=spanId,proto3,customtype=go.opentelemetry.io/collector/model/internal/data.SpanID" json:"span_id"`
	// (Optional) Trace ID of the exemplar trace.
	// trace_id may be missing if the measurement is not recorded inside a trace
	// or if the trace is not sampled.
	TraceId go_opentelemetry_io_collector_model_internal_data.TraceID `protobuf:"bytes,5,opt,name=trace_id,json=traceId,proto3,customtype=go.opentelemetry.io/collector/model/internal/data.TraceID" json:"trace_id"`
}

func (m *IntExemplar) Reset()         { *m = IntExemplar{} }
func (m *IntExemplar) String() string { return proto.CompactTextString(m) }
func (*IntExemplar) ProtoMessage()    {}
func (*IntExemplar) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{19}
}
func (m *IntExemplar) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IntExemplar) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IntExemplar.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IntExemplar) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IntExemplar.Merge(m, src)
}
func (m *IntExemplar) XXX_Size() int {
	return m.Size()
}
func (m *IntExemplar) XXX_DiscardUnknown() {
	xxx_messageInfo_IntExemplar.DiscardUnknown(m)
}

var xxx_messageInfo_IntExemplar proto.InternalMessageInfo

func (m *IntExemplar) GetFilteredLabels() []v11.StringKeyValue {
	if m != nil {
		return m.FilteredLabels
	}
	return nil
}

func (m *IntExemplar) GetTimeUnixNano() uint64 {
	if m != nil {
		return m.TimeUnixNano
	}
	return 0
}

func (m *IntExemplar) GetValue() int64 {
	if m != nil {
		return m.Value
	}
	return 0
}

func init() {
	proto.RegisterEnum("opentelemetry.proto.metrics.v1.AggregationTemporality", AggregationTemporality_name, AggregationTemporality_value)
	proto.RegisterEnum("opentelemetry.proto.metrics.v1.DataPointFlags", DataPointFlags_name, DataPointFlags_value)
	proto.RegisterType((*MetricsData)(nil), "opentelemetry.proto.metrics.v1.MetricsData")
	proto.RegisterType((*ResourceMetrics)(nil), "opentelemetry.proto.metrics.v1.ResourceMetrics")
	proto.RegisterType((*InstrumentationLibraryMetrics)(nil), "opentelemetry.proto.metrics.v1.InstrumentationLibraryMetrics")
	proto.RegisterType((*Metric)(nil), "opentelemetry.proto.metrics.v1.Metric")
	proto.RegisterType((*Gauge)(nil), "opentelemetry.proto.metrics.v1.Gauge")
	proto.RegisterType((*Sum)(nil), "opentelemetry.proto.metrics.v1.Sum")
	proto.RegisterType((*Histogram)(nil), "opentelemetry.proto.metrics.v1.Histogram")
	proto.RegisterType((*ExponentialHistogram)(nil), "opentelemetry.proto.metrics.v1.ExponentialHistogram")
	proto.RegisterType((*Summary)(nil), "opentelemetry.proto.metrics.v1.Summary")
	proto.RegisterType((*NumberDataPoint)(nil), "opentelemetry.proto.metrics.v1.NumberDataPoint")
	proto.RegisterType((*HistogramDataPoint)(nil), "opentelemetry.proto.metrics.v1.HistogramDataPoint")
	proto.RegisterType((*ExponentialHistogramDataPoint)(nil), "opentelemetry.proto.metrics.v1.ExponentialHistogramDataPoint")
	proto.RegisterType((*ExponentialHistogramDataPoint_Buckets)(nil), "opentelemetry.proto.metrics.v1.ExponentialHistogramDataPoint.Buckets")
	proto.RegisterType((*SummaryDataPoint)(nil), "opentelemetry.proto.metrics.v1.SummaryDataPoint")
	proto.RegisterType((*SummaryDataPoint_ValueAtQuantile)(nil), "opentelemetry.proto.metrics.v1.SummaryDataPoint.ValueAtQuantile")
	proto.RegisterType((*Exemplar)(nil), "opentelemetry.proto.metrics.v1.Exemplar")
	proto.RegisterType((*IntDataPoint)(nil), "opentelemetry.proto.metrics.v1.IntDataPoint")
	proto.RegisterType((*IntGauge)(nil), "opentelemetry.proto.metrics.v1.IntGauge")
	proto.RegisterType((*IntSum)(nil), "opentelemetry.proto.metrics.v1.IntSum")
	proto.RegisterType((*IntHistogramDataPoint)(nil), "opentelemetry.proto.metrics.v1.IntHistogramDataPoint")
	proto.RegisterType((*IntHistogram)(nil), "opentelemetry.proto.metrics.v1.IntHistogram")
	proto.RegisterType((*IntExemplar)(nil), "opentelemetry.proto.metrics.v1.IntExemplar")
}

func init() {
	proto.RegisterFile("opentelemetry/proto/metrics/v1/metrics.proto", fileDescriptor_3c3112f9fa006917)
}

var fileDescriptor_3c3112f9fa006917 = []byte{
	// 1652 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe4, 0x59, 0x4b, 0x6f, 0x1b, 0xc9,
	0x11, 0xe6, 0x90, 0xe2, 0xab, 0xa8, 0x07, 0xdd, 0x91, 0x65, 0x42, 0x80, 0x64, 0x99, 0x4e, 0x2c,
	0xc5, 0x71, 0xc8, 0x58, 0x89, 0xf3, 0x84, 0x01, 0x93, 0x22, 0x25, 0x11, 0xa2, 0x1e, 0x1e, 0x51,
	0x0a, 0x6c, 0x38, 0x1e, 0x34, 0xc9, 0x16, 0xdd, 0xf0, 0x3c, 0x98, 0x99, 0x1e, 0x41, 0xca, 0xdd,
	0x39, 0xe5, 0x10, 0xe4, 0x1e, 0x20, 0xf7, 0xfc, 0x85, 0xfc, 0x00, 0x1f, 0x9d, 0x5b, 0x90, 0x05,
	0x8c, 0x85, 0xb5, 0xc0, 0x02, 0xbb, 0x87, 0x3d, 0xed, 0x9e, 0x17, 0xdd, 0x3d, 0x43, 0x52, 0xd4,
	0x48, 0xa4, 0x2c, 0x19, 0x2b, 0xc3, 0xb7, 0xee, 0x9a, 0xaa, 0xaf, 0xeb, 0xd9, 0x55, 0x33, 0x03,
	0xf7, 0xac, 0x36, 0x31, 0x19, 0xd1, 0x89, 0x41, 0x98, 0x7d, 0x98, 0x6f, 0xdb, 0x16, 0xb3, 0xf2,
	0x7c, 0x4d, 0x1b, 0x4e, 0x7e, 0xff, 0xbe, 0xbf, 0xcc, 0x89, 0x07, 0x68, 0xf6, 0x18, 0xb7, 0x24,
	0xe6, 0x7c, 0x96, 0xfd, 0xfb, 0xd3, 0x93, 0x2d, 0xab, 0x65, 0x49, 0x0c, 0xbe, 0x92, 0x0c, 0xd3,
	0x77, 0x83, 0xce, 0x68, 0x58, 0x86, 0x61, 0x99, 0xfc, 0x08, 0xb9, 0xf2, 0x78, 0x73, 0x41, 0xbc,
	0x36, 0x71, 0x2c, 0xd7, 0x6e, 0x10, 0xce, 0xed, 0xaf, 0x25, 0x7f, 0x96, 0x42, 0x6a, 0x5d, 0x9e,
	0x5f, 0xc2, 0x0c, 0xa3, 0xa7, 0x90, 0xf6, 0x19, 0x34, 0x4f, 0xaf, 0x8c, 0x32, 0x17, 0x59, 0x48,
	0x2d, 0xe6, 0x73, 0x67, 0xeb, 0x9e, 0x53, 0x3d, 0x39, 0x0f, 0x4e, 0x9d, 0xb0, 0x8f, 0x13, 0xb2,
	0xaf, 0xc2, 0x30, 0xd1, 0xc7, 0x84, 0xd6, 0x20, 0xe1, 0xb3, 0x65, 0x94, 0x39, 0x65, 0x21, 0xb5,
	0xf8, 0xd3, 0xc0, 0x73, 0x3a, 0x5a, 0xf7, 0x1c, 0x54, 0x1c, 0x79, 0xfd, 0xf6, 0x66, 0x48, 0xed,
	0x00, 0xa0, 0x57, 0x0a, 0xdc, 0xa4, 0xa6, 0xc3, 0x6c, 0xd7, 0x20, 0x26, 0xc3, 0x8c, 0x5a, 0xa6,
	0xa6, 0xd3, 0xba, 0x8d, 0xed, 0xc3, 0x8e, 0x31, 0x61, 0x61, 0xcc, 0xc3, 0x41, 0xc6, 0x54, 0x8e,
	0xc3, 0x54, 0x25, 0x8a, 0x6f, 0xda, 0x0c, 0x3d, 0xeb, 0x31, 0x9a, 0x01, 0x70, 0x1a, 0x2f, 0x88,
	0x81, 0x35, 0xd7, 0xd6, 0x33, 0x91, 0x39, 0x65, 0x21, 0xa9, 0x26, 0x25, 0x65, 0xc7, 0xd6, 0xb3,
	0xdf, 0x29, 0x30, 0x73, 0x26, 0x3e, 0x62, 0x70, 0xe3, 0x14, 0x3b, 0x3c, 0x27, 0x3d, 0x08, 0xd4,
	0xdf, 0x4b, 0x84, 0x53, 0xd5, 0xf7, 0x1c, 0x36, 0x15, 0xac, 0x3d, 0x7a, 0x04, 0xf1, 0xe3, 0x5e,
	0xba, 0x33, 0xc8, 0x4b, 0x52, 0x5f, 0xd5, 0x17, 0x1b, 0x64, 0xf8, 0x7f, 0xa2, 0x10, 0x93, 0x22,
	0x08, 0xc1, 0x88, 0x89, 0x0d, 0x19, 0xf3, 0xa4, 0x2a, 0xd6, 0x68, 0x0e, 0x52, 0x4d, 0xe2, 0x34,
	0x6c, 0xda, 0xe6, 0x5a, 0x65, 0xc2, 0xe2, 0x51, 0x2f, 0x89, 0x4b, 0xb9, 0x26, 0x65, 0x1e, 0xb2,
	0x58, 0xa3, 0x35, 0x48, 0x52, 0x93, 0x69, 0x2d, 0xec, 0xb6, 0x48, 0x66, 0x44, 0x78, 0x67, 0x61,
	0x70, 0x74, 0xd9, 0x0a, 0xe7, 0x2f, 0x86, 0x33, 0xca, 0x6a, 0x48, 0x4d, 0x50, 0x6f, 0x8f, 0x1e,
	0x42, 0x54, 0x02, 0x45, 0x05, 0xd0, 0x4f, 0x06, 0x01, 0x09, 0xa9, 0xd5, 0x90, 0x2a, 0xa5, 0x50,
	0x19, 0xe2, 0x5c, 0x17, 0xc7, 0x35, 0x32, 0x31, 0x01, 0x70, 0x67, 0x08, 0x4d, 0xb6, 0x5d, 0xc3,
	0xd3, 0x23, 0x46, 0xc5, 0x0e, 0xfd, 0x06, 0x22, 0x1c, 0x22, 0x2e, 0x20, 0x6e, 0x0f, 0x82, 0xd8,
	0x76, 0x8d, 0xd5, 0x90, 0xca, 0x25, 0xd0, 0x1f, 0x61, 0x8c, 0x9f, 0xff, 0x82, 0x3a, 0xcc, 0x6a,
	0xd9, 0xd8, 0xc8, 0x24, 0x04, 0xc4, 0xbd, 0x21, 0xb4, 0x58, 0xf5, 0x65, 0x3c, 0x5d, 0x46, 0x69,
	0x0f, 0x0d, 0x55, 0x20, 0xd9, 0x05, 0x4d, 0x9e, 0x51, 0xa7, 0x3d, 0xa0, 0x1d, 0xe9, 0xd5, 0x90,
	0xda, 0x95, 0x46, 0x2f, 0xe1, 0x3a, 0x39, 0x68, 0x5b, 0x26, 0x31, 0x19, 0xc5, 0x7a, 0x8f, 0xae,
	0x20, 0x60, 0x7f, 0x35, 0x08, 0xb6, 0xdc, 0x15, 0xee, 0x3d, 0x61, 0x92, 0x04, 0xd0, 0xd1, 0x12,
	0xc4, 0x1d, 0xd7, 0x30, 0x78, 0xe1, 0xa4, 0x04, 0xfc, 0xfc, 0x10, 0xde, 0xe4, 0xec, 0xab, 0x21,
	0xd5, 0x97, 0x2c, 0xc6, 0x60, 0xa4, 0x89, 0x19, 0xce, 0x3e, 0x81, 0xa8, 0xcc, 0x92, 0x2d, 0x48,
	0x71, 0x82, 0xd6, 0xb6, 0xa8, 0xc9, 0x86, 0xbe, 0x1f, 0x37, 0x5c, 0xa3, 0x4e, 0x6c, 0x7e, 0xcb,
	0x6e, 0x71, 0x39, 0x15, 0x9a, 0xfe, 0xd2, 0xc9, 0x7e, 0xad, 0x40, 0x84, 0x47, 0xfe, 0xd2, 0x91,
	0x91, 0x05, 0x37, 0x70, 0xab, 0x65, 0x93, 0x96, 0xbc, 0x46, 0x18, 0x31, 0xda, 0x96, 0x8d, 0x75,
	0xca, 0x0e, 0x45, 0x81, 0x8d, 0x2f, 0xfe, 0x7a, 0x10, 0x7a, 0xa1, 0x2b, 0x5e, 0xeb, 0x4a, 0xab,
	0x53, 0x38, 0x90, 0x8e, 0x6e, 0xc1, 0x28, 0x75, 0x34, 0xc3, 0x32, 0x2d, 0x66, 0x99, 0xb4, 0x21,
	0x6a, 0x35, 0xa1, 0xa6, 0xa8, 0xb3, 0xee, 0x93, 0xb2, 0xff, 0x55, 0x20, 0xd9, 0x8d, 0xd1, 0x76,
	0x90, 0xcd, 0x8b, 0x43, 0x67, 0xd7, 0xd5, 0x30, 0x3b, 0xfb, 0xa5, 0x02, 0x93, 0x41, 0xa9, 0x89,
	0x9e, 0x07, 0x99, 0xf7, 0xf0, 0x7d, 0xb2, 0xfc, 0x8a, 0x58, 0xfa, 0x0c, 0xe2, 0x5e, 0x91, 0xa0,
	0xc7, 0x41, 0xb6, 0xfd, 0x62, 0xc8, 0x12, 0x0b, 0xae, 0x84, 0x7f, 0x47, 0x60, 0xa2, 0x2f, 0x9f,
	0xd1, 0x3a, 0x00, 0x66, 0xcc, 0xa6, 0x75, 0x97, 0x11, 0x27, 0x13, 0x17, 0xa7, 0xcc, 0x0f, 0xe8,
	0x80, 0x6b, 0xe4, 0x70, 0x17, 0xeb, 0xae, 0x3f, 0x24, 0xf4, 0x00, 0xa0, 0x75, 0x88, 0xe9, 0xb8,
	0x4e, 0x74, 0x5f, 0xe1, 0x9f, 0x0f, 0x80, 0xda, 0x66, 0x36, 0x35, 0x5b, 0x1d, 0xc0, 0x18, 0x07,
	0xcc, 0x28, 0xaa, 0x07, 0x82, 0xf2, 0x30, 0xe9, 0x30, 0x6c, 0x33, 0x8d, 0x51, 0x83, 0x68, 0xae,
	0x49, 0x0f, 0x34, 0x13, 0x9b, 0x96, 0xf0, 0x7e, 0x4c, 0xbd, 0x26, 0x9e, 0xd5, 0xa8, 0x41, 0x76,
	0x4c, 0x7a, 0xb0, 0x81, 0x4d, 0x0b, 0xfd, 0x18, 0xc6, 0xfb, 0x58, 0x23, 0x82, 0x75, 0x94, 0xf5,
	0x72, 0xcd, 0x40, 0x12, 0x3b, 0x5a, 0xd3, 0x72, 0xeb, 0xba, 0xec, 0x6b, 0xa2, 0x53, 0x61, 0xa7,
	0x24, 0x28, 0xe8, 0x06, 0xc4, 0xb0, 0xa3, 0x51, 0x93, 0x89, 0x4e, 0x93, 0xe6, 0x3d, 0x08, 0x3b,
	0x15, 0x93, 0xa1, 0x2a, 0x24, 0xc9, 0x01, 0x31, 0xda, 0x3a, 0xb6, 0x9d, 0x4c, 0x54, 0x18, 0xb8,
	0x30, 0x38, 0xdb, 0xa4, 0x80, 0xe7, 0xac, 0x2e, 0x00, 0x9a, 0x84, 0xe8, 0x9e, 0x8e, 0x5b, 0x8e,
	0xe8, 0x24, 0x63, 0xaa, 0xdc, 0x14, 0xe3, 0x10, 0xdd, 0xe7, 0xbe, 0xc8, 0x1e, 0x45, 0x00, 0x9d,
	0xcc, 0xcf, 0xbe, 0x80, 0x25, 0x3f, 0x8d, 0x80, 0x4d, 0x42, 0xb4, 0x61, 0xb9, 0x26, 0x13, 0xc1,
	0x8a, 0xa9, 0x72, 0x83, 0xd2, 0xb2, 0x97, 0xf3, 0x79, 0x42, 0x91, 0x4d, 0xfa, 0x36, 0x8c, 0xd5,
	0xdd, 0xc6, 0x4b, 0xc2, 0x34, 0xc1, 0xe1, 0x64, 0x62, 0x73, 0x11, 0x0e, 0x26, 0x89, 0x4b, 0x82,
	0x86, 0xe6, 0x61, 0x82, 0x1c, 0xb4, 0x75, 0xda, 0xa0, 0x4c, 0xab, 0x5b, 0xae, 0xd9, 0x94, 0x79,
	0xaf, 0xa8, 0xe3, 0x3e, 0xb9, 0x28, 0xa8, 0xc7, 0xc3, 0x9d, 0xb8, 0xb4, 0x70, 0x43, 0x4f, 0xb8,
	0xb3, 0xff, 0x8a, 0xc2, 0xcc, 0x99, 0x17, 0x52, 0x5f, 0xc0, 0x95, 0x8b, 0x06, 0xfc, 0x07, 0x8e,
	0xd0, 0x24, 0x44, 0x9d, 0x06, 0xd6, 0x89, 0x28, 0xad, 0x6b, 0xaa, 0xdc, 0xf0, 0xe1, 0xf6, 0x2f,
	0xc4, 0xb6, 0x64, 0xd4, 0xc4, 0x70, 0x16, 0x53, 0x93, 0x9c, 0x22, 0x42, 0x86, 0x5a, 0x90, 0x68,
	0x5b, 0x0e, 0x65, 0x74, 0x9f, 0x78, 0x63, 0x57, 0xf9, 0x42, 0x97, 0x7c, 0xae, 0x28, 0xf2, 0xc1,
	0xf1, 0xdf, 0x72, 0x7c, 0x70, 0x7e, 0x90, 0x29, 0xae, 0xe5, 0x7d, 0xe2, 0x8d, 0x62, 0x97, 0x7b,
	0x90, 0x0f, 0x1e, 0x9c, 0x0c, 0xc7, 0x13, 0x2e, 0x75, 0xc1, 0x84, 0x9b, 0x5e, 0x86, 0xb8, 0x77,
	0x3c, 0x9a, 0x82, 0x98, 0xb5, 0xb7, 0xe7, 0x10, 0x26, 0x5e, 0x0a, 0xae, 0xa9, 0xde, 0xee, 0x64,
	0xbd, 0xf0, 0x97, 0x93, 0x91, 0xe3, 0xf5, 0x92, 0xfd, 0x36, 0x02, 0xe9, 0xfe, 0xbe, 0xf2, 0x69,
	0xf6, 0x8d, 0x61, 0x93, 0x9c, 0xc2, 0xc4, 0x9f, 0x5d, 0x6c, 0x32, 0xaa, 0x13, 0x4d, 0x5c, 0xe6,
	0xf2, 0x22, 0x4a, 0x2d, 0x3e, 0x3a, 0x6f, 0xff, 0xce, 0x09, 0xfb, 0x0a, 0xec, 0xb1, 0x07, 0xa7,
	0x8e, 0xfb, 0xc0, 0xe2, 0xc1, 0x29, 0x4d, 0x64, 0x7a, 0x09, 0x26, 0xfa, 0x04, 0xd1, 0x34, 0x24,
	0x7c, 0x51, 0x91, 0x04, 0x8a, 0xda, 0xd9, 0x73, 0x10, 0xa1, 0xa6, 0xf0, 0x8f, 0xa2, 0x7a, 0x0d,
	0xe8, 0xab, 0x08, 0x24, 0xfc, 0xec, 0x42, 0xcf, 0xe1, 0x47, 0x7b, 0x54, 0x67, 0xc4, 0x26, 0x4d,
	0xed, 0xa2, 0x81, 0x47, 0x3e, 0x52, 0xa1, 0x9b, 0x00, 0xcf, 0x61, 0xa2, 0x83, 0x7f, 0x19, 0x99,
	0x30, 0xee, 0xa3, 0x55, 0x65, 0x46, 0x9c, 0x0c, 0x70, 0x78, 0xd0, 0x60, 0x10, 0x19, 0x7e, 0x30,
	0x78, 0x02, 0x71, 0xa7, 0x8d, 0x4d, 0x8d, 0x36, 0x45, 0x6a, 0x8c, 0x16, 0x1f, 0x71, 0x35, 0xfe,
	0xff, 0xf6, 0xe6, 0x6f, 0x5b, 0x56, 0x9f, 0xfe, 0xd4, 0xca, 0x37, 0x2c, 0x5d, 0x27, 0x0d, 0x66,
	0xd9, 0x79, 0xc3, 0x6a, 0x12, 0x3d, 0x4f, 0x4d, 0x46, 0x6c, 0x13, 0xeb, 0x79, 0x3e, 0xab, 0xe5,
	0xb6, 0xdb, 0xd8, 0xac, 0x94, 0xd4, 0x18, 0x07, 0xac, 0x34, 0xd1, 0x33, 0x48, 0x30, 0x1b, 0x37,
	0x08, 0xc7, 0x8e, 0x0a, 0xec, 0x82, 0x87, 0xfd, 0xbb, 0xf3, 0x63, 0xd7, 0x38, 0x52, 0xa5, 0xa4,
	0xc6, 0x05, 0x64, 0xa5, 0xd9, 0x9d, 0x36, 0xfe, 0x19, 0x86, 0xd1, 0x8a, 0xc9, 0xba, 0x05, 0xbe,
	0x76, 0xb1, 0x8a, 0x94, 0x91, 0xfe, 0xf0, 0xf5, 0x28, 0xf3, 0x96, 0x3b, 0x3d, 0xed, 0xe5, 0x2d,
	0xda, 0x3c, 0x39, 0xa5, 0xfd, 0x6c, 0x88, 0xb7, 0xf4, 0x53, 0x2f, 0xd2, 0xdf, 0x87, 0x33, 0x4a,
	0xf6, 0x4f, 0x90, 0xf0, 0xbf, 0x6c, 0xa0, 0xf5, 0xa0, 0xd1, 0x7c, 0x98, 0x0f, 0x01, 0x81, 0x63,
	0xb9, 0x80, 0xff, 0x46, 0x81, 0x98, 0xfc, 0x5e, 0x71, 0xc9, 0xe8, 0x57, 0xf1, 0x25, 0x55, 0x58,
	0xfc, 0xd7, 0x08, 0x5c, 0xef, 0xfd, 0x36, 0xf2, 0xd1, 0x65, 0xde, 0xd9, 0x9d, 0x20, 0xfd, 0x21,
	0x06, 0xd2, 0xcd, 0x93, 0x03, 0xe9, 0xc5, 0x33, 0xfb, 0x33, 0x45, 0x54, 0x7e, 0xf7, 0xad, 0x7a,
	0x37, 0x28, 0x01, 0x1f, 0x9c, 0xe7, 0x3b, 0xd7, 0xd5, 0xc8, 0x44, 0x61, 0xdd, 0x17, 0x61, 0x48,
	0xf5, 0xb8, 0x00, 0x3d, 0xbb, 0xa4, 0x3e, 0x23, 0x5d, 0xf9, 0x7e, 0x5d, 0xa6, 0x73, 0x6d, 0x45,
	0x7a, 0xaf, 0xad, 0x8f, 0xb5, 0x87, 0x70, 0x37, 0xdf, 0xfd, 0x9b, 0x02, 0x53, 0xc1, 0xd1, 0x41,
	0xf3, 0x70, 0xbb, 0xb0, 0xb2, 0xa2, 0x96, 0x57, 0x0a, 0xb5, 0xca, 0xe6, 0x86, 0x56, 0x2b, 0xaf,
	0x6f, 0x6d, 0xaa, 0x85, 0x6a, 0xa5, 0xf6, 0x44, 0xdb, 0xd9, 0xd8, 0xde, 0x2a, 0x2f, 0x55, 0x96,
	0x2b, 0xe5, 0x52, 0x3a, 0x84, 0x6e, 0xc1, 0xcc, 0x69, 0x8c, 0xa5, 0x72, 0xb5, 0x56, 0x48, 0x2b,
	0xe8, 0x0e, 0x64, 0x4f, 0x63, 0x59, 0xda, 0x59, 0xdf, 0xa9, 0x16, 0x6a, 0x95, 0xdd, 0x72, 0x3a,
	0x7c, 0xf7, 0x0f, 0x30, 0xde, 0xc9, 0xc1, 0x65, 0x31, 0x5a, 0x8f, 0x41, 0x72, 0xb9, 0x5a, 0x58,
	0xd1, 0x36, 0x36, 0x37, 0xca, 0xe9, 0x10, 0x9a, 0x86, 0x29, 0x6f, 0xab, 0xa9, 0xe5, 0xa5, 0x4d,
	0xb5, 0x54, 0x2e, 0x69, 0xbb, 0x85, 0xea, 0x4e, 0x39, 0xad, 0x14, 0xff, 0xa1, 0xbc, 0x7e, 0x37,
	0xab, 0xbc, 0x79, 0x37, 0xab, 0x7c, 0xfe, 0x6e, 0x56, 0xf9, 0xfb, 0xd1, 0x6c, 0xe8, 0xcd, 0xd1,
	0x6c, 0xe8, 0x7f, 0x47, 0xb3, 0x21, 0xb8, 0x45, 0xad, 0x01, 0x39, 0x5a, 0x1c, 0xf5, 0x7e, 0x34,
	0x6c, 0xf1, 0x07, 0x5b, 0xca, 0xd3, 0xf2, 0xb9, 0x3d, 0x2c, 0x7f, 0x2c, 0xb5, 0x88, 0xd9, 0xf3,
	0xaf, 0xab, 0x1e, 0x13, 0xc4, 0x5f, 0x7e, 0x1f, 0x00, 0x00, 0xff, 0xff, 0x3b, 0xe0, 0x1c, 0x00,
	0x14, 0x1b, 0x00, 0x00,
}

func (m *MetricsData) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MetricsData) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MetricsData) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ResourceMetrics) > 0 {
		for iNdEx := len(m.ResourceMetrics) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ResourceMetrics[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ResourceMetrics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceMetrics) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResourceMetrics) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.SchemaUrl) > 0 {
		i -= len(m.SchemaUrl)
		copy(dAtA[i:], m.SchemaUrl)
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.SchemaUrl)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.InstrumentationLibraryMetrics) > 0 {
		for iNdEx := len(m.InstrumentationLibraryMetrics) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.InstrumentationLibraryMetrics[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	{
		size, err := m.Resource.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintMetrics(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *InstrumentationLibraryMetrics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstrumentationLibraryMetrics) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InstrumentationLibraryMetrics) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.SchemaUrl) > 0 {
		i -= len(m.SchemaUrl)
		copy(dAtA[i:], m.SchemaUrl)
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.SchemaUrl)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Metrics) > 0 {
		for iNdEx := len(m.Metrics) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Metrics[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	{
		size, err := m.InstrumentationLibrary.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintMetrics(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *Metric) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Metric) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Metric) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Data != nil {
		{
			size := m.Data.Size()
			i -= size
			if _, err := m.Data.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if len(m.Unit) > 0 {
		i -= len(m.Unit)
		copy(dAtA[i:], m.Unit)
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.Unit)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Metric_IntGauge) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Metric_IntGauge) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.IntGauge != nil {
		{
			size, err := m.IntGauge.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMetrics(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	return len(dAtA) - i, nil
}
func (m *Metric_Gauge) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Metric_Gauge) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Gauge != nil {
		{
			size, err := m.Gauge.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMetrics(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	return len(dAtA) - i, nil
}
func (m *Metric_IntSum) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Metric_IntSum) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.IntSum != nil {
		{
			size, err := m.IntSum.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMetrics(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	return len(dAtA) - i, nil
}
func (m *Metric_Sum) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Metric_Sum) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Sum != nil {
		{
			size, err := m.Sum.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMetrics(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	return len(dAtA) - i, nil
}
func (m *Metric_IntHistogram) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Metric_IntHistogram) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.IntHistogram != nil {
		{
			size, err := m.IntHistogram.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMetrics(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	return len(dAtA) - i, nil
}
func (m *Metric_Histogram) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Metric_Histogram) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Histogram != nil {
		{
			size, err := m.Histogram.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMetrics(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	return len(dAtA) - i, nil
}
func (m *Metric_ExponentialHistogram) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Metric_ExponentialHistogram) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ExponentialHistogram != nil {
		{
			size, err := m.ExponentialHistogram.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMetrics(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	return len(dAtA) - i, nil
}
func (m *Metric_Summary) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Metric_Summary) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Summary != nil {
		{
			size, err := m.Summary.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMetrics(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	return len(dAtA) - i, nil
}
func (m *Gauge) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Gauge) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Gauge) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.DataPoints) > 0 {
		for iNdEx := len(m.DataPoints) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.DataPoints[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Sum) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Sum) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Sum) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.IsMonotonic {
		i--
		if m.IsMonotonic {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.AggregationTemporality != 0 {
		i = encodeVarintMetrics(dAtA, i, uint64(m.AggregationTemporality))
		i--
		dAtA[i] = 0x10
	}
	if len(m.DataPoints) > 0 {
		for iNdEx := len(m.DataPoints) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.DataPoints[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Histogram) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Histogram) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Histogram) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AggregationTemporality != 0 {
		i = encodeVarintMetrics(dAtA, i, uint64(m.AggregationTemporality))
		i--
		dAtA[i] = 0x10
	}
	if len(m.DataPoints) > 0 {
		for iNdEx := len(m.DataPoints) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.DataPoints[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ExponentialHistogram) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExponentialHistogram) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExponentialHistogram) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AggregationTemporality != 0 {
		i = encodeVarintMetrics(dAtA, i, uint64(m.AggregationTemporality))
		i--
		dAtA[i] = 0x10
	}
	if len(m.DataPoints) > 0 {
		for iNdEx := len(m.DataPoints) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.DataPoints[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Summary) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Summary) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Summary) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.DataPoints) > 0 {
		for iNdEx := len(m.DataPoints) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.DataPoints[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *NumberDataPoint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NumberDataPoint) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NumberDataPoint) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Flags != 0 {
		i = encodeVarintMetrics(dAtA, i, uint64(m.Flags))
		i--
		dAtA[i] = 0x40
	}
	if len(m.Attributes) > 0 {
		for iNdEx := len(m.Attributes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Attributes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.Value != nil {
		{
			size := m.Value.Size()
			i -= size
			if _, err := m.Value.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if len(m.Exemplars) > 0 {
		for iNdEx := len(m.Exemplars) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Exemplars[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.TimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.TimeUnixNano))
		i--
		dAtA[i] = 0x19
	}
	if m.StartTimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.StartTimeUnixNano))
		i--
		dAtA[i] = 0x11
	}
	if len(m.Labels) > 0 {
		for iNdEx := len(m.Labels) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Labels[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *NumberDataPoint_AsDouble) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NumberDataPoint_AsDouble) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= 8
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.AsDouble))))
	i--
	dAtA[i] = 0x21
	return len(dAtA) - i, nil
}
func (m *NumberDataPoint_AsInt) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NumberDataPoint_AsInt) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= 8
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.AsInt))
	i--
	dAtA[i] = 0x31
	return len(dAtA) - i, nil
}
func (m *HistogramDataPoint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HistogramDataPoint) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HistogramDataPoint) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Flags != 0 {
		i = encodeVarintMetrics(dAtA, i, uint64(m.Flags))
		i--
		dAtA[i] = 0x50
	}
	if len(m.Attributes) > 0 {
		for iNdEx := len(m.Attributes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Attributes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x4a
		}
	}
	if len(m.Exemplars) > 0 {
		for iNdEx := len(m.Exemplars) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Exemplars[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x42
		}
	}
	if len(m.ExplicitBounds) > 0 {
		for iNdEx := len(m.ExplicitBounds) - 1; iNdEx >= 0; iNdEx-- {
			f11 := math.Float64bits(float64(m.ExplicitBounds[iNdEx]))
			i -= 8
			encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(f11))
		}
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.ExplicitBounds)*8))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.BucketCounts) > 0 {
		for iNdEx := len(m.BucketCounts) - 1; iNdEx >= 0; iNdEx-- {
			i -= 8
			encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.BucketCounts[iNdEx]))
		}
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.BucketCounts)*8))
		i--
		dAtA[i] = 0x32
	}
	if m.Sum != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Sum))))
		i--
		dAtA[i] = 0x29
	}
	if m.Count != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.Count))
		i--
		dAtA[i] = 0x21
	}
	if m.TimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.TimeUnixNano))
		i--
		dAtA[i] = 0x19
	}
	if m.StartTimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.StartTimeUnixNano))
		i--
		dAtA[i] = 0x11
	}
	if len(m.Labels) > 0 {
		for iNdEx := len(m.Labels) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Labels[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ExponentialHistogramDataPoint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExponentialHistogramDataPoint) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExponentialHistogramDataPoint) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Exemplars) > 0 {
		for iNdEx := len(m.Exemplars) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Exemplars[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x5a
		}
	}
	if m.Flags != 0 {
		i = encodeVarintMetrics(dAtA, i, uint64(m.Flags))
		i--
		dAtA[i] = 0x50
	}
	{
		size, err := m.Negative.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintMetrics(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x4a
	{
		size, err := m.Positive.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintMetrics(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x42
	if m.ZeroCount != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.ZeroCount))
		i--
		dAtA[i] = 0x39
	}
	if m.Scale != 0 {
		i = encodeVarintMetrics(dAtA, i, uint64((uint32(m.Scale)<<1)^uint32((m.Scale>>31))))
		i--
		dAtA[i] = 0x30
	}
	if m.Sum != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Sum))))
		i--
		dAtA[i] = 0x29
	}
	if m.Count != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.Count))
		i--
		dAtA[i] = 0x21
	}
	if m.TimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.TimeUnixNano))
		i--
		dAtA[i] = 0x19
	}
	if m.StartTimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.StartTimeUnixNano))
		i--
		dAtA[i] = 0x11
	}
	if len(m.Attributes) > 0 {
		for iNdEx := len(m.Attributes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Attributes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ExponentialHistogramDataPoint_Buckets) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExponentialHistogramDataPoint_Buckets) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExponentialHistogramDataPoint_Buckets) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.BucketCounts) > 0 {
		dAtA15 := make([]byte, len(m.BucketCounts)*10)
		var j14 int
		for _, num := range m.BucketCounts {
			for num >= 1<<7 {
				dAtA15[j14] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j14++
			}
			dAtA15[j14] = uint8(num)
			j14++
		}
		i -= j14
		copy(dAtA[i:], dAtA15[:j14])
		i = encodeVarintMetrics(dAtA, i, uint64(j14))
		i--
		dAtA[i] = 0x12
	}
	if m.Offset != 0 {
		i = encodeVarintMetrics(dAtA, i, uint64((uint32(m.Offset)<<1)^uint32((m.Offset>>31))))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *SummaryDataPoint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SummaryDataPoint) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SummaryDataPoint) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Flags != 0 {
		i = encodeVarintMetrics(dAtA, i, uint64(m.Flags))
		i--
		dAtA[i] = 0x40
	}
	if len(m.Attributes) > 0 {
		for iNdEx := len(m.Attributes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Attributes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.QuantileValues) > 0 {
		for iNdEx := len(m.QuantileValues) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.QuantileValues[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if m.Sum != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Sum))))
		i--
		dAtA[i] = 0x29
	}
	if m.Count != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.Count))
		i--
		dAtA[i] = 0x21
	}
	if m.TimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.TimeUnixNano))
		i--
		dAtA[i] = 0x19
	}
	if m.StartTimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.StartTimeUnixNano))
		i--
		dAtA[i] = 0x11
	}
	if len(m.Labels) > 0 {
		for iNdEx := len(m.Labels) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Labels[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *SummaryDataPoint_ValueAtQuantile) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SummaryDataPoint_ValueAtQuantile) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SummaryDataPoint_ValueAtQuantile) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Value != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Value))))
		i--
		dAtA[i] = 0x11
	}
	if m.Quantile != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Quantile))))
		i--
		dAtA[i] = 0x9
	}
	return len(dAtA) - i, nil
}

func (m *Exemplar) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Exemplar) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Exemplar) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.FilteredAttributes) > 0 {
		for iNdEx := len(m.FilteredAttributes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.FilteredAttributes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.Value != nil {
		{
			size := m.Value.Size()
			i -= size
			if _, err := m.Value.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	{
		size := m.TraceId.Size()
		i -= size
		if _, err := m.TraceId.MarshalTo(dAtA[i:]); err != nil {
			return 0, err
		}
		i = encodeVarintMetrics(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x2a
	{
		size := m.SpanId.Size()
		i -= size
		if _, err := m.SpanId.MarshalTo(dAtA[i:]); err != nil {
			return 0, err
		}
		i = encodeVarintMetrics(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x22
	if m.TimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.TimeUnixNano))
		i--
		dAtA[i] = 0x11
	}
	if len(m.FilteredLabels) > 0 {
		for iNdEx := len(m.FilteredLabels) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.FilteredLabels[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Exemplar_AsDouble) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Exemplar_AsDouble) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= 8
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.AsDouble))))
	i--
	dAtA[i] = 0x19
	return len(dAtA) - i, nil
}
func (m *Exemplar_AsInt) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Exemplar_AsInt) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= 8
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.AsInt))
	i--
	dAtA[i] = 0x31
	return len(dAtA) - i, nil
}
func (m *IntDataPoint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IntDataPoint) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IntDataPoint) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Exemplars) > 0 {
		for iNdEx := len(m.Exemplars) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Exemplars[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.Value != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.Value))
		i--
		dAtA[i] = 0x21
	}
	if m.TimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.TimeUnixNano))
		i--
		dAtA[i] = 0x19
	}
	if m.StartTimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.StartTimeUnixNano))
		i--
		dAtA[i] = 0x11
	}
	if len(m.Labels) > 0 {
		for iNdEx := len(m.Labels) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Labels[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *IntGauge) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IntGauge) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IntGauge) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.DataPoints) > 0 {
		for iNdEx := len(m.DataPoints) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.DataPoints[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *IntSum) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IntSum) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IntSum) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.IsMonotonic {
		i--
		if m.IsMonotonic {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.AggregationTemporality != 0 {
		i = encodeVarintMetrics(dAtA, i, uint64(m.AggregationTemporality))
		i--
		dAtA[i] = 0x10
	}
	if len(m.DataPoints) > 0 {
		for iNdEx := len(m.DataPoints) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.DataPoints[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *IntHistogramDataPoint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IntHistogramDataPoint) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IntHistogramDataPoint) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Exemplars) > 0 {
		for iNdEx := len(m.Exemplars) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Exemplars[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x42
		}
	}
	if len(m.ExplicitBounds) > 0 {
		for iNdEx := len(m.ExplicitBounds) - 1; iNdEx >= 0; iNdEx-- {
			f16 := math.Float64bits(float64(m.ExplicitBounds[iNdEx]))
			i -= 8
			encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(f16))
		}
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.ExplicitBounds)*8))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.BucketCounts) > 0 {
		for iNdEx := len(m.BucketCounts) - 1; iNdEx >= 0; iNdEx-- {
			i -= 8
			encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.BucketCounts[iNdEx]))
		}
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.BucketCounts)*8))
		i--
		dAtA[i] = 0x32
	}
	if m.Sum != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.Sum))
		i--
		dAtA[i] = 0x29
	}
	if m.Count != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.Count))
		i--
		dAtA[i] = 0x21
	}
	if m.TimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.TimeUnixNano))
		i--
		dAtA[i] = 0x19
	}
	if m.StartTimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.StartTimeUnixNano))
		i--
		dAtA[i] = 0x11
	}
	if len(m.Labels) > 0 {
		for iNdEx := len(m.Labels) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Labels[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *IntHistogram) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IntHistogram) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IntHistogram) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.AggregationTemporality != 0 {
		i = encodeVarintMetrics(dAtA, i, uint64(m.AggregationTemporality))
		i--
		dAtA[i] = 0x10
	}
	if len(m.DataPoints) > 0 {
		for iNdEx := len(m.DataPoints) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.DataPoints[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *IntExemplar) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IntExemplar) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IntExemplar) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size := m.TraceId.Size()
		i -= size
		if _, err := m.TraceId.MarshalTo(dAtA[i:]); err != nil {
			return 0, err
		}
		i = encodeVarintMetrics(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x2a
	{
		size := m.SpanId.Size()
		i -= size
		if _, err := m.SpanId.MarshalTo(dAtA[i:]); err != nil {
			return 0, err
		}
		i = encodeVarintMetrics(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x22
	if m.Value != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.Value))
		i--
		dAtA[i] = 0x19
	}
	if m.TimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.TimeUnixNano))
		i--
		dAtA[i] = 0x11
	}
	if len(m.FilteredLabels) > 0 {
		for iNdEx := len(m.FilteredLabels) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.FilteredLabels[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintMetrics(dAtA []byte, offset int, v uint64) int {
	offset -= sovMetrics(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *MetricsData) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ResourceMetrics) > 0 {
		for _, e := range m.ResourceMetrics {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	return n
}

func (m *ResourceMetrics) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Resource.Size()
	n += 1 + l + sovMetrics(uint64(l))
	if len(m.InstrumentationLibraryMetrics) > 0 {
		for _, e := range m.InstrumentationLibraryMetrics {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	l = len(m.SchemaUrl)
	if l > 0 {
		n += 1 + l + sovMetrics(uint64(l))
	}
	return n
}

func (m *InstrumentationLibraryMetrics) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.InstrumentationLibrary.Size()
	n += 1 + l + sovMetrics(uint64(l))
	if len(m.Metrics) > 0 {
		for _, e := range m.Metrics {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	l = len(m.SchemaUrl)
	if l > 0 {
		n += 1 + l + sovMetrics(uint64(l))
	}
	return n
}

func (m *Metric) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovMetrics(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovMetrics(uint64(l))
	}
	l = len(m.Unit)
	if l > 0 {
		n += 1 + l + sovMetrics(uint64(l))
	}
	if m.Data != nil {
		n += m.Data.Size()
	}
	return n
}

func (m *Metric_IntGauge) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.IntGauge != nil {
		l = m.IntGauge.Size()
		n += 1 + l + sovMetrics(uint64(l))
	}
	return n
}
func (m *Metric_Gauge) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Gauge != nil {
		l = m.Gauge.Size()
		n += 1 + l + sovMetrics(uint64(l))
	}
	return n
}
func (m *Metric_IntSum) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.IntSum != nil {
		l = m.IntSum.Size()
		n += 1 + l + sovMetrics(uint64(l))
	}
	return n
}
func (m *Metric_Sum) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Sum != nil {
		l = m.Sum.Size()
		n += 1 + l + sovMetrics(uint64(l))
	}
	return n
}
func (m *Metric_IntHistogram) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.IntHistogram != nil {
		l = m.IntHistogram.Size()
		n += 1 + l + sovMetrics(uint64(l))
	}
	return n
}
func (m *Metric_Histogram) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Histogram != nil {
		l = m.Histogram.Size()
		n += 1 + l + sovMetrics(uint64(l))
	}
	return n
}
func (m *Metric_ExponentialHistogram) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ExponentialHistogram != nil {
		l = m.ExponentialHistogram.Size()
		n += 1 + l + sovMetrics(uint64(l))
	}
	return n
}
func (m *Metric_Summary) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Summary != nil {
		l = m.Summary.Size()
		n += 1 + l + sovMetrics(uint64(l))
	}
	return n
}
func (m *Gauge) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.DataPoints) > 0 {
		for _, e := range m.DataPoints {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	return n
}

func (m *Sum) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.DataPoints) > 0 {
		for _, e := range m.DataPoints {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.AggregationTemporality != 0 {
		n += 1 + sovMetrics(uint64(m.AggregationTemporality))
	}
	if m.IsMonotonic {
		n += 2
	}
	return n
}

func (m *Histogram) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.DataPoints) > 0 {
		for _, e := range m.DataPoints {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.AggregationTemporality != 0 {
		n += 1 + sovMetrics(uint64(m.AggregationTemporality))
	}
	return n
}

func (m *ExponentialHistogram) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.DataPoints) > 0 {
		for _, e := range m.DataPoints {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.AggregationTemporality != 0 {
		n += 1 + sovMetrics(uint64(m.AggregationTemporality))
	}
	return n
}

func (m *Summary) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.DataPoints) > 0 {
		for _, e := range m.DataPoints {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	return n
}

func (m *NumberDataPoint) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Labels) > 0 {
		for _, e := range m.Labels {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.StartTimeUnixNano != 0 {
		n += 9
	}
	if m.TimeUnixNano != 0 {
		n += 9
	}
	if m.Value != nil {
		n += m.Value.Size()
	}
	if len(m.Exemplars) > 0 {
		for _, e := range m.Exemplars {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if len(m.Attributes) > 0 {
		for _, e := range m.Attributes {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.Flags != 0 {
		n += 1 + sovMetrics(uint64(m.Flags))
	}
	return n
}

func (m *NumberDataPoint_AsDouble) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 9
	return n
}
func (m *NumberDataPoint_AsInt) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 9
	return n
}
func (m *HistogramDataPoint) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Labels) > 0 {
		for _, e := range m.Labels {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.StartTimeUnixNano != 0 {
		n += 9
	}
	if m.TimeUnixNano != 0 {
		n += 9
	}
	if m.Count != 0 {
		n += 9
	}
	if m.Sum != 0 {
		n += 9
	}
	if len(m.BucketCounts) > 0 {
		n += 1 + sovMetrics(uint64(len(m.BucketCounts)*8)) + len(m.BucketCounts)*8
	}
	if len(m.ExplicitBounds) > 0 {
		n += 1 + sovMetrics(uint64(len(m.ExplicitBounds)*8)) + len(m.ExplicitBounds)*8
	}
	if len(m.Exemplars) > 0 {
		for _, e := range m.Exemplars {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if len(m.Attributes) > 0 {
		for _, e := range m.Attributes {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.Flags != 0 {
		n += 1 + sovMetrics(uint64(m.Flags))
	}
	return n
}

func (m *ExponentialHistogramDataPoint) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Attributes) > 0 {
		for _, e := range m.Attributes {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.StartTimeUnixNano != 0 {
		n += 9
	}
	if m.TimeUnixNano != 0 {
		n += 9
	}
	if m.Count != 0 {
		n += 9
	}
	if m.Sum != 0 {
		n += 9
	}
	if m.Scale != 0 {
		n += 1 + sozMetrics(uint64(m.Scale))
	}
	if m.ZeroCount != 0 {
		n += 9
	}
	l = m.Positive.Size()
	n += 1 + l + sovMetrics(uint64(l))
	l = m.Negative.Size()
	n += 1 + l + sovMetrics(uint64(l))
	if m.Flags != 0 {
		n += 1 + sovMetrics(uint64(m.Flags))
	}
	if len(m.Exemplars) > 0 {
		for _, e := range m.Exemplars {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	return n
}

func (m *ExponentialHistogramDataPoint_Buckets) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Offset != 0 {
		n += 1 + sozMetrics(uint64(m.Offset))
	}
	if len(m.BucketCounts) > 0 {
		l = 0
		for _, e := range m.BucketCounts {
			l += sovMetrics(uint64(e))
		}
		n += 1 + sovMetrics(uint64(l)) + l
	}
	return n
}

func (m *SummaryDataPoint) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Labels) > 0 {
		for _, e := range m.Labels {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.StartTimeUnixNano != 0 {
		n += 9
	}
	if m.TimeUnixNano != 0 {
		n += 9
	}
	if m.Count != 0 {
		n += 9
	}
	if m.Sum != 0 {
		n += 9
	}
	if len(m.QuantileValues) > 0 {
		for _, e := range m.QuantileValues {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if len(m.Attributes) > 0 {
		for _, e := range m.Attributes {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.Flags != 0 {
		n += 1 + sovMetrics(uint64(m.Flags))
	}
	return n
}

func (m *SummaryDataPoint_ValueAtQuantile) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Quantile != 0 {
		n += 9
	}
	if m.Value != 0 {
		n += 9
	}
	return n
}

func (m *Exemplar) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.FilteredLabels) > 0 {
		for _, e := range m.FilteredLabels {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.TimeUnixNano != 0 {
		n += 9
	}
	if m.Value != nil {
		n += m.Value.Size()
	}
	l = m.SpanId.Size()
	n += 1 + l + sovMetrics(uint64(l))
	l = m.TraceId.Size()
	n += 1 + l + sovMetrics(uint64(l))
	if len(m.FilteredAttributes) > 0 {
		for _, e := range m.FilteredAttributes {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	return n
}

func (m *Exemplar_AsDouble) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 9
	return n
}
func (m *Exemplar_AsInt) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 9
	return n
}
func (m *IntDataPoint) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Labels) > 0 {
		for _, e := range m.Labels {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.StartTimeUnixNano != 0 {
		n += 9
	}
	if m.TimeUnixNano != 0 {
		n += 9
	}
	if m.Value != 0 {
		n += 9
	}
	if len(m.Exemplars) > 0 {
		for _, e := range m.Exemplars {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	return n
}

func (m *IntGauge) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.DataPoints) > 0 {
		for _, e := range m.DataPoints {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	return n
}

func (m *IntSum) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.DataPoints) > 0 {
		for _, e := range m.DataPoints {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.AggregationTemporality != 0 {
		n += 1 + sovMetrics(uint64(m.AggregationTemporality))
	}
	if m.IsMonotonic {
		n += 2
	}
	return n
}

func (m *IntHistogramDataPoint) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Labels) > 0 {
		for _, e := range m.Labels {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.StartTimeUnixNano != 0 {
		n += 9
	}
	if m.TimeUnixNano != 0 {
		n += 9
	}
	if m.Count != 0 {
		n += 9
	}
	if m.Sum != 0 {
		n += 9
	}
	if len(m.BucketCounts) > 0 {
		n += 1 + sovMetrics(uint64(len(m.BucketCounts)*8)) + len(m.BucketCounts)*8
	}
	if len(m.ExplicitBounds) > 0 {
		n += 1 + sovMetrics(uint64(len(m.ExplicitBounds)*8)) + len(m.ExplicitBounds)*8
	}
	if len(m.Exemplars) > 0 {
		for _, e := range m.Exemplars {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	return n
}

func (m *IntHistogram) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.DataPoints) > 0 {
		for _, e := range m.DataPoints {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.AggregationTemporality != 0 {
		n += 1 + sovMetrics(uint64(m.AggregationTemporality))
	}
	return n
}

func (m *IntExemplar) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.FilteredLabels) > 0 {
		for _, e := range m.FilteredLabels {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.TimeUnixNano != 0 {
		n += 9
	}
	if m.Value != 0 {
		n += 9
	}
	l = m.SpanId.Size()
	n += 1 + l + sovMetrics(uint64(l))
	l = m.TraceId.Size()
	n += 1 + l + sovMetrics(uint64(l))
	return n
}

func sovMetrics(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozMetrics(x uint64) (n int) {
	return sovMetrics(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *MetricsData) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MetricsData: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MetricsData: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceMetrics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResourceMetrics = append(m.ResourceMetrics, &ResourceMetrics{})
			if err := m.ResourceMetrics[len(m.ResourceMetrics)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResourceMetrics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResourceMetrics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResourceMetrics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resource", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Resource.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InstrumentationLibraryMetrics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.InstrumentationLibraryMetrics = append(m.InstrumentationLibraryMetrics, &InstrumentationLibraryMetrics{})
			if err := m.InstrumentationLibraryMetrics[len(m.InstrumentationLibraryMetrics)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SchemaUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InstrumentationLibraryMetrics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstrumentationLibraryMetrics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstrumentationLibraryMetrics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InstrumentationLibrary", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.InstrumentationLibrary.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metrics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Metrics = append(m.Metrics, &Metric{})
			if err := m.Metrics[len(m.Metrics)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SchemaUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Metric) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Metric: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Metric: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unit", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Unit = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntGauge", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &IntGauge{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &Metric_IntGauge{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gauge", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Gauge{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &Metric_Gauge{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntSum", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &IntSum{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &Metric_IntSum{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sum", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Sum{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &Metric_Sum{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntHistogram", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &IntHistogram{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &Metric_IntHistogram{v}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Histogram", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Histogram{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &Metric_Histogram{v}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExponentialHistogram", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ExponentialHistogram{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &Metric_ExponentialHistogram{v}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Summary", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Summary{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &Metric_Summary{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Gauge) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Gauge: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Gauge: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataPoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DataPoints = append(m.DataPoints, &NumberDataPoint{})
			if err := m.DataPoints[len(m.DataPoints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Sum) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Sum: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Sum: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataPoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DataPoints = append(m.DataPoints, &NumberDataPoint{})
			if err := m.DataPoints[len(m.DataPoints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AggregationTemporality", wireType)
			}
			m.AggregationTemporality = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AggregationTemporality |= AggregationTemporality(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsMonotonic", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsMonotonic = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Histogram) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Histogram: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Histogram: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataPoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DataPoints = append(m.DataPoints, &HistogramDataPoint{})
			if err := m.DataPoints[len(m.DataPoints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AggregationTemporality", wireType)
			}
			m.AggregationTemporality = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AggregationTemporality |= AggregationTemporality(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExponentialHistogram) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExponentialHistogram: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExponentialHistogram: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataPoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DataPoints = append(m.DataPoints, &ExponentialHistogramDataPoint{})
			if err := m.DataPoints[len(m.DataPoints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AggregationTemporality", wireType)
			}
			m.AggregationTemporality = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AggregationTemporality |= AggregationTemporality(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Summary) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Summary: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Summary: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataPoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DataPoints = append(m.DataPoints, &SummaryDataPoint{})
			if err := m.DataPoints[len(m.DataPoints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NumberDataPoint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NumberDataPoint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NumberDataPoint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Labels = append(m.Labels, v11.StringKeyValue{})
			if err := m.Labels[len(m.Labels)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeUnixNano", wireType)
			}
			m.StartTimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.StartTimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			m.TimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.TimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field AsDouble", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Value = &NumberDataPoint_AsDouble{float64(math.Float64frombits(v))}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Exemplars", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Exemplars = append(m.Exemplars, Exemplar{})
			if err := m.Exemplars[len(m.Exemplars)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field AsInt", wireType)
			}
			var v int64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Value = &NumberDataPoint_AsInt{v}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attributes = append(m.Attributes, v11.KeyValue{})
			if err := m.Attributes[len(m.Attributes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			m.Flags = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Flags |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HistogramDataPoint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HistogramDataPoint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HistogramDataPoint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Labels = append(m.Labels, v11.StringKeyValue{})
			if err := m.Labels[len(m.Labels)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeUnixNano", wireType)
			}
			m.StartTimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.StartTimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			m.TimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.TimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			m.Count = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.Count = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 5:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sum", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Sum = float64(math.Float64frombits(v))
		case 6:
			if wireType == 1 {
				var v uint64
				if (iNdEx + 8) > l {
					return io.ErrUnexpectedEOF
				}
				v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
				iNdEx += 8
				m.BucketCounts = append(m.BucketCounts, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMetrics
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthMetrics
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthMetrics
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				elementCount = packedLen / 8
				if elementCount != 0 && len(m.BucketCounts) == 0 {
					m.BucketCounts = make([]uint64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
					iNdEx += 8
					m.BucketCounts = append(m.BucketCounts, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field BucketCounts", wireType)
			}
		case 7:
			if wireType == 1 {
				var v uint64
				if (iNdEx + 8) > l {
					return io.ErrUnexpectedEOF
				}
				v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
				iNdEx += 8
				v2 := float64(math.Float64frombits(v))
				m.ExplicitBounds = append(m.ExplicitBounds, v2)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMetrics
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthMetrics
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthMetrics
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				elementCount = packedLen / 8
				if elementCount != 0 && len(m.ExplicitBounds) == 0 {
					m.ExplicitBounds = make([]float64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
					iNdEx += 8
					v2 := float64(math.Float64frombits(v))
					m.ExplicitBounds = append(m.ExplicitBounds, v2)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ExplicitBounds", wireType)
			}
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Exemplars", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Exemplars = append(m.Exemplars, Exemplar{})
			if err := m.Exemplars[len(m.Exemplars)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attributes = append(m.Attributes, v11.KeyValue{})
			if err := m.Attributes[len(m.Attributes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			m.Flags = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Flags |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExponentialHistogramDataPoint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExponentialHistogramDataPoint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExponentialHistogramDataPoint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attributes = append(m.Attributes, v11.KeyValue{})
			if err := m.Attributes[len(m.Attributes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeUnixNano", wireType)
			}
			m.StartTimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.StartTimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			m.TimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.TimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			m.Count = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.Count = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 5:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sum", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Sum = float64(math.Float64frombits(v))
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scale", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = int32((uint32(v) >> 1) ^ uint32(((v&1)<<31)>>31))
			m.Scale = v
		case 7:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field ZeroCount", wireType)
			}
			m.ZeroCount = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.ZeroCount = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Positive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Positive.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Negative", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Negative.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			m.Flags = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Flags |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Exemplars", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Exemplars = append(m.Exemplars, Exemplar{})
			if err := m.Exemplars[len(m.Exemplars)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExponentialHistogramDataPoint_Buckets) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Buckets: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Buckets: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Offset", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = int32((uint32(v) >> 1) ^ uint32(((v&1)<<31)>>31))
			m.Offset = v
		case 2:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMetrics
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.BucketCounts = append(m.BucketCounts, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMetrics
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthMetrics
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthMetrics
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.BucketCounts) == 0 {
					m.BucketCounts = make([]uint64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMetrics
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.BucketCounts = append(m.BucketCounts, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field BucketCounts", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SummaryDataPoint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SummaryDataPoint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SummaryDataPoint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Labels = append(m.Labels, v11.StringKeyValue{})
			if err := m.Labels[len(m.Labels)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeUnixNano", wireType)
			}
			m.StartTimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.StartTimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			m.TimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.TimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			m.Count = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.Count = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 5:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sum", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Sum = float64(math.Float64frombits(v))
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QuantileValues", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.QuantileValues = append(m.QuantileValues, &SummaryDataPoint_ValueAtQuantile{})
			if err := m.QuantileValues[len(m.QuantileValues)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attributes = append(m.Attributes, v11.KeyValue{})
			if err := m.Attributes[len(m.Attributes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			m.Flags = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Flags |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SummaryDataPoint_ValueAtQuantile) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ValueAtQuantile: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ValueAtQuantile: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Quantile", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Quantile = float64(math.Float64frombits(v))
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Value = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Exemplar) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Exemplar: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Exemplar: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FilteredLabels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FilteredLabels = append(m.FilteredLabels, v11.StringKeyValue{})
			if err := m.FilteredLabels[len(m.FilteredLabels)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			m.TimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.TimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field AsDouble", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Value = &Exemplar_AsDouble{float64(math.Float64frombits(v))}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.SpanId.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TraceId.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field AsInt", wireType)
			}
			var v int64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Value = &Exemplar_AsInt{v}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FilteredAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FilteredAttributes = append(m.FilteredAttributes, v11.KeyValue{})
			if err := m.FilteredAttributes[len(m.FilteredAttributes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IntDataPoint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IntDataPoint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IntDataPoint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Labels = append(m.Labels, v11.StringKeyValue{})
			if err := m.Labels[len(m.Labels)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeUnixNano", wireType)
			}
			m.StartTimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.StartTimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			m.TimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.TimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			m.Value = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Exemplars", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Exemplars = append(m.Exemplars, IntExemplar{})
			if err := m.Exemplars[len(m.Exemplars)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IntGauge) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IntGauge: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IntGauge: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataPoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DataPoints = append(m.DataPoints, &IntDataPoint{})
			if err := m.DataPoints[len(m.DataPoints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IntSum) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IntSum: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IntSum: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataPoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DataPoints = append(m.DataPoints, &IntDataPoint{})
			if err := m.DataPoints[len(m.DataPoints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AggregationTemporality", wireType)
			}
			m.AggregationTemporality = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AggregationTemporality |= AggregationTemporality(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsMonotonic", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsMonotonic = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IntHistogramDataPoint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IntHistogramDataPoint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IntHistogramDataPoint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Labels = append(m.Labels, v11.StringKeyValue{})
			if err := m.Labels[len(m.Labels)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeUnixNano", wireType)
			}
			m.StartTimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.StartTimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			m.TimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.TimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			m.Count = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.Count = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 5:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sum", wireType)
			}
			m.Sum = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.Sum = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 6:
			if wireType == 1 {
				var v uint64
				if (iNdEx + 8) > l {
					return io.ErrUnexpectedEOF
				}
				v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
				iNdEx += 8
				m.BucketCounts = append(m.BucketCounts, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMetrics
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthMetrics
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthMetrics
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				elementCount = packedLen / 8
				if elementCount != 0 && len(m.BucketCounts) == 0 {
					m.BucketCounts = make([]uint64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
					iNdEx += 8
					m.BucketCounts = append(m.BucketCounts, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field BucketCounts", wireType)
			}
		case 7:
			if wireType == 1 {
				var v uint64
				if (iNdEx + 8) > l {
					return io.ErrUnexpectedEOF
				}
				v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
				iNdEx += 8
				v2 := float64(math.Float64frombits(v))
				m.ExplicitBounds = append(m.ExplicitBounds, v2)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMetrics
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthMetrics
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthMetrics
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				elementCount = packedLen / 8
				if elementCount != 0 && len(m.ExplicitBounds) == 0 {
					m.ExplicitBounds = make([]float64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
					iNdEx += 8
					v2 := float64(math.Float64frombits(v))
					m.ExplicitBounds = append(m.ExplicitBounds, v2)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ExplicitBounds", wireType)
			}
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Exemplars", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Exemplars = append(m.Exemplars, IntExemplar{})
			if err := m.Exemplars[len(m.Exemplars)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IntHistogram) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IntHistogram: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IntHistogram: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataPoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DataPoints = append(m.DataPoints, &IntHistogramDataPoint{})
			if err := m.DataPoints[len(m.DataPoints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AggregationTemporality", wireType)
			}
			m.AggregationTemporality = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AggregationTemporality |= AggregationTemporality(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IntExemplar) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IntExemplar: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IntExemplar: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FilteredLabels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FilteredLabels = append(m.FilteredLabels, v11.StringKeyValue{})
			if err := m.FilteredLabels[len(m.FilteredLabels)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			m.TimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.TimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			m.Value = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.SpanId.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceId", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TraceId.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMetrics(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthMetrics
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupMetrics
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthMetrics
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthMetrics        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMetrics          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupMetrics = fmt.Errorf("proto: unexpected end of group")
)
