/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.hierarchy;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.tool.Job;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class View
extends ElectricObject {
    private static final int TEXTVIEW = 1;
    private static final int MULTIPAGEVIEW = 2;
    private static final int PERMANENTVIEW = 4;
    private String fullName;
    private String abbreviation;
    private int order;
    private int type;
    private static List views = new ArrayList();
    private static HashMap viewNames = new HashMap();
    private static int overallOrder = 16;
    public static final View SCHEMATIC = View.makeInstance("schematic", "sch", 4, 0);
    public static final View ICON = View.makeInstance("icon", "ic", 4, 1);
    public static final View LAYOUT = View.makeInstance("layout", "lay", 4, 2);
    public static final View LAYOUTSKEL = View.makeInstance("layout.skeleton", "lay.sk", 4, 3);
    public static final View LAYOUTCOMP = View.makeInstance("layout.compensated", "lay.comp", 4, 4);
    public static final View VHDL = View.makeInstance("VHDL", "vhdl", 5, 5);
    public static final View VERILOG = View.makeInstance("Verilog", "ver", 5, 6);
    public static final View DOC = View.makeInstance("documentation", "doc", 5, 7);
    public static final View DOCWAVE = View.makeInstance("documentation.waveform", "doc.wave", 4, 8);
    public static final View NETLIST = View.makeInstance("netlist", "net", 5, 9);
    public static final View NETLISTNETLISP = View.makeInstance("netlist.netlisp", "net.netlisp", 5, 10);
    public static final View NETLISTRSIM = View.makeInstance("netlist.rsim", "net.rsim", 5, 11);
    public static final View NETLISTSILOS = View.makeInstance("netlist.silos", "net.silos", 5, 12);
    public static final View NETLISTQUISC = View.makeInstance("netlist.quisc", "net.quisc", 5, 13);
    public static final View NETLISTALS = View.makeInstance("netlist.als", "net.als", 5, 14);
    public static final View UNKNOWN = View.makeInstance("unknown", "", 4, 15);

    public static View newInstance(String fullName, String abbreviation) {
        Job.checkChanging();
        View view = View.makeInstance(fullName, abbreviation, 0, overallOrder++);
        Undo.newObject(view);
        return view;
    }

    public static View newTextInstance(String fullName, String abbreviation) {
        Job.checkChanging();
        View view = View.makeInstance(fullName, abbreviation, 1, overallOrder++);
        Undo.newObject(view);
        return view;
    }

    public static View newMultiPageSchematicInstance(int page) {
        Job.checkChanging();
        View view = View.makeInstance("schematic-page-" + page, "p" + page, 2, overallOrder++);
        Undo.newObject(view);
        return view;
    }

    public void kill() {
        if (this.isPermanentView()) {
            return;
        }
        Iterator it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            Iterator cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = (Cell)cIt.next();
                if (cell.getView() != this) continue;
                System.out.println("Cannot delete view " + this.getFullName() + " because it is in use (for example, cell " + cell.describe() + ")");
                return;
            }
        }
        Job.checkChanging();
        Undo.killObject(this);
        viewNames.remove(this.fullName);
        viewNames.remove(this.abbreviation);
        views.remove(this);
    }

    private View() {
    }

    private static View makeInstance(String fullName, String abbreviation, int type, int order) {
        if (viewNames.get(abbreviation) != null) {
            System.out.println("multiple views with same name: " + abbreviation);
            return null;
        }
        if (viewNames.get(fullName) != null) {
            System.out.println("multiple views with same name: " + fullName);
            return null;
        }
        if (fullName.toLowerCase().startsWith("schematic-page-")) {
            type |= 2;
        }
        View v = new View();
        v.fullName = fullName;
        v.abbreviation = abbreviation;
        v.type = type;
        v.order = order;
        viewNames.put(fullName, v);
        viewNames.put(abbreviation, v);
        views.add(v);
        return v;
    }

    public static View findView(String name) {
        return (View)viewNames.get(name);
    }

    public static View findMultiPageSchematicView(int page) {
        String viewName = "schematic-page-" + page;
        return View.findView(viewName);
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isTextView() {
        return (this.type & 1) != 0;
    }

    public boolean isMultiPageView() {
        return (this.type & 2) != 0;
    }

    public boolean isPermanentView() {
        return (this.type & 4) != 0;
    }

    public static Iterator getViews() {
        return views.iterator();
    }

    public static int getNumViews() {
        return views.size();
    }

    public static List getOrderedViews() {
        ArrayList sortedList = new ArrayList();
        Iterator it = View.getViews();
        while (it.hasNext()) {
            sortedList.add(it.next());
        }
        Collections.sort(sortedList, new ViewByOrder());
        return sortedList;
    }

    public String toString() {
        return "View " + this.fullName;
    }

    private static class ViewByOrder
    implements Comparator {
        private ViewByOrder() {
        }

        public int compare(Object o1, Object o2) {
            View v1 = (View)o1;
            View v2 = (View)o2;
            return v1.getOrder() - v2.getOrder();
        }
    }
}

