/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.CMOS;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.MoCMOS;
import com.sun.electric.technology.technologies.MoCMOSOld;
import com.sun.electric.technology.technologies.MoCMOSSub;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.technology.technologies.nMOS;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;

public class Technology
extends ElectricObject {
    private static final int NONELECTRICAL = 1;
    private static final int NODIRECTIONALARCS = 2;
    private static final int NONEGATEDARCS = 4;
    private static final int NONSTANDARD = 8;
    private static final int STATICTECHNOLOGY = 16;
    private static final int NOPRIMTECHNOLOGY = 32;
    private static Preferences prefs = null;
    private static List technologies = new ArrayList();
    private static Technology curTech = null;
    private static Technology curLayoutTech = null;
    private static int techNumber = 0;
    private String techName;
    private String techShortName;
    private String techDesc;
    private int userBits = 0;
    private int techIndex;
    private double scale = 1.0;
    private boolean scaleRelevant = true;
    private int transparentLayers;
    private Pref[] transparentColorPrefs;
    private Color[] colorMap;
    private List layers = new ArrayList();
    private int layerIndex = 0;
    private List nodes = new ArrayList();
    private List arcs = new ArrayList();
    private List ports = new ArrayList();
    private double minResistance;
    private double minCapacitance;
    private boolean parasiticOverridesGathered = false;
    private String[] spiceHeaderLevel1;
    private String[] spiceHeaderLevel2;
    private String[] spiceHeaderLevel3;
    private Pref prefScale;
    private Pref prefMinResistance;
    private Pref prefMinCapacitance;
    private static final String[] extraTechnologies = new String[]{"tsmc90.TSMC90"};
    private static final NodeLayer[] nullPrimLayers = new NodeLayer[0];
    static /* synthetic */ Class class$java$lang$Integer;

    protected Technology() {
        this.techIndex = techNumber++;
        if (prefs == null) {
            prefs = Preferences.userNodeForPackage(this.getClass());
        }
        technologies.add(this);
    }

    public static void initAllTechnologies() {
        Artwork.tech.setup();
        CMOS.tech.setup();
        MoCMOS.tech.setup();
        MoCMOSOld.tech.setup();
        MoCMOSSub.tech.setup();
        nMOS.tech.setup();
        Schematics.tech.setup();
        Generic.tech.setup();
        for (int i = 0; i < extraTechnologies.length; ++i) {
            try {
                Class<?> extraTechClass = Class.forName("com.sun.electric.plugins." + extraTechnologies[i]);
                extraTechClass.getMethod("setItUp", null).invoke(null, null);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        MoCMOS.tech.setCurrent();
        Generic.tech.makeUnivList();
    }

    protected void setup() {
        this.init();
        Iterator it = this.getLayers();
        block0: while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            int extras = layer.getFunctionExtras();
            if ((extras & 0x1000) == 0) continue;
            Layer.Function fun = layer.getFunction();
            Iterator oIt = this.getLayers();
            while (oIt.hasNext()) {
                Layer oLayer = (Layer)oIt.next();
                int oExtras = oLayer.getFunctionExtras();
                Layer.Function oFun = oLayer.getFunction();
                if (oFun != fun || oExtras != (extras & 0xFFFFEFFF)) continue;
                layer.setNonPseudoLayer(oLayer);
                continue block0;
            }
        }
    }

    public void init() {
    }

    public static Technology getCurrent() {
        return curTech;
    }

    public void setCurrent() {
        curTech = this;
        if (this != Generic.tech && this != Schematics.tech && this != Artwork.tech) {
            curLayoutTech = this;
        }
    }

    public static int getNumTechnologies() {
        return technologies.size();
    }

    public static Technology findTechnology(String name) {
        for (int i = 0; i < technologies.size(); ++i) {
            Technology t = (Technology)technologies.get(i);
            if (!t.techName.equalsIgnoreCase(name)) continue;
            return t;
        }
        return null;
    }

    public static Iterator getTechnologies() {
        return technologies.iterator();
    }

    public static List getTechnologiesSortedByName() {
        ArrayList sortedList = new ArrayList();
        Iterator it = Technology.getTechnologies();
        while (it.hasNext()) {
            sortedList.add(it.next());
        }
        Collections.sort(sortedList, new TechnologyCaseInsensitive());
        return sortedList;
    }

    public Iterator getLayers() {
        return this.layers.iterator();
    }

    public Layer getLayer(int index) {
        return (Layer)this.layers.get(index);
    }

    public int getNumLayers() {
        return this.layers.size();
    }

    public Layer findLayer(String layerName) {
        Iterator it = this.getLayers();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            if (!layer.getName().equalsIgnoreCase(layerName)) continue;
            return layer;
        }
        return null;
    }

    public void addLayer(Layer layer) {
        layer.setIndex(this.layerIndex++);
        this.layers.add(layer);
    }

    public boolean sameLayer(Layer layer1, Layer layer2) {
        return layer1 == layer2;
    }

    public List getLayersSortedByHeight() {
        ArrayList layerList = new ArrayList();
        Iterator it = this.getLayers();
        while (it.hasNext()) {
            layerList.add(it.next());
        }
        Collections.sort(layerList, new LayerHeight());
        return layerList;
    }

    public PrimitiveArc findArcProto(String name) {
        for (int i = 0; i < this.arcs.size(); ++i) {
            PrimitiveArc ap = (PrimitiveArc)this.arcs.get(i);
            if (!ap.getName().equalsIgnoreCase(name)) continue;
            return ap;
        }
        return null;
    }

    public Iterator getArcs() {
        return this.arcs.iterator();
    }

    public int getNumArcs() {
        return this.arcs.size();
    }

    public void addArcProto(PrimitiveArc ap) {
        this.arcs.add(ap);
    }

    protected void setNoDirectionalArcs() {
        this.userBits |= 2;
    }

    public boolean isNoDirectionalArcs() {
        return (this.userBits & 2) != 0;
    }

    protected void setNoNegatedArcs() {
        this.userBits |= 4;
    }

    public boolean isNoNegatedArcs() {
        return (this.userBits & 4) != 0;
    }

    public Poly[] getShapeOfArc(ArcInst ai) {
        return this.getShapeOfArc(ai, null, null);
    }

    public Poly[] getShapeOfArc(ArcInst ai, EditWindow wnd) {
        return this.getShapeOfArc(ai, wnd, null);
    }

    public Poly[] getShapeOfArc(ArcInst ai, EditWindow wnd, Layer layerOverride) {
        PrimitiveArc ap = (PrimitiveArc)ai.getProto();
        Technology tech = ap.getTechnology();
        ArcLayer[] primLayers = ap.getLayers();
        boolean addArrow = false;
        if (!tech.isNoDirectionalArcs() && ai.isDirectional() && !ai.isSkipHead()) {
            addArrow = true;
        }
        int numDisplayable = ai.numDisplayableVariables(true);
        if (wnd == null) {
            numDisplayable = 0;
        }
        int maxPolys = primLayers.length + numDisplayable;
        if (addArrow) {
            ++maxPolys;
        }
        Poly[] polys = new Poly[maxPolys];
        int polyNum = 0;
        Layer lastLayer = null;
        for (int i = 0; i < primLayers.length; ++i) {
            ArcLayer primLayer = primLayers[i];
            polys[polyNum] = ai.makePoly(ai.getLength(), ai.getWidth() - primLayer.getOffset(), primLayer.getStyle());
            if (polys[polyNum] == null) {
                return null;
            }
            if (layerOverride != null) {
                polys[polyNum].setLayer(layerOverride);
            } else {
                lastLayer = primLayer.getLayer();
                polys[polyNum].setLayer(lastLayer);
            }
            ++polyNum;
        }
        if (addArrow) {
            Point2D headLoc = ai.getHead().getLocation();
            Point2D tailLoc = ai.getTail().getLocation();
            double headX = headLoc.getX();
            double headY = headLoc.getY();
            double tailX = tailLoc.getX();
            double tailY = tailLoc.getY();
            int angle = ai.getAngle();
            if (ai.isReverseEnds()) {
                double swap = headX;
                headX = tailX;
                tailX = swap;
                swap = headY;
                headY = tailY;
                tailY = swap;
            } else {
                angle += 1800;
            }
            Point2D[] points = new Point2D.Double[4];
            if (!ai.isSkipHead()) {
                int angleOfArrow = 300;
                int backAngle1 = angle - angleOfArrow;
                int backAngle2 = angle + angleOfArrow;
                points[0] = new Point2D.Double(headX, headY);
                points[1] = new Point2D.Double(headX + DBMath.cos(backAngle1), headY + DBMath.sin(backAngle1));
                points[2] = points[0];
                points[3] = new Point2D.Double(headX + DBMath.cos(backAngle2), headY + DBMath.sin(backAngle2));
            }
            polys[polyNum] = new Poly(points);
            polys[polyNum].setStyle(Poly.Type.VECTORS);
            polys[polyNum].setLayer(lastLayer);
            ++polyNum;
        }
        if (numDisplayable > 0) {
            Rectangle2D rect = ai.getBounds();
            ai.addDisplayableVariables(rect, polys, polyNum, wnd, true);
        }
        return polys;
    }

    public PrimitiveArc convertOldArcName(String name) {
        return null;
    }

    public PrimitiveNode findNodeProto(String name) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            PrimitiveNode pn = (PrimitiveNode)this.nodes.get(i);
            if (!pn.getName().equalsIgnoreCase(name)) continue;
            return pn;
        }
        return null;
    }

    public Iterator getNodes() {
        return this.nodes.iterator();
    }

    public int getNumNodes() {
        return this.nodes.size();
    }

    public void addNodeProto(PrimitiveNode np) {
        this.nodes.add(np);
    }

    public Iterator getPorts() {
        return this.ports.iterator();
    }

    public int getNumPorts() {
        return this.ports.size();
    }

    public void addPortProto(PrimitivePort pp) {
        this.ports.add(pp);
    }

    public NodeProto.Function getPrimitiveFunction(NodeInst ni) {
        return ni.getProto().getFunction();
    }

    public Dimension2D getTransistorSize(NodeInst ni, VarContext context) {
        PrimitiveNode np = (PrimitiveNode)ni.getProto();
        SizeOffset so = ni.getSizeOffset();
        double width = ni.getXSize() - so.getLowXOffset() - so.getHighXOffset();
        double height = ni.getYSize() - so.getLowYOffset() - so.getHighYOffset();
        Dimension2D.Double dim = new Dimension2D.Double(width, height);
        return dim;
    }

    public PortInst getTransistorGatePort(NodeInst ni) {
        return ni.getPortInst(0);
    }

    public PortInst getTransistorSourcePort(NodeInst ni) {
        return ni.getPortInst(1);
    }

    public PortInst getTransistorDrainPort(NodeInst ni) {
        if (ni.getProto().getTechnology() == Schematics.tech) {
            return ni.getPortInst(2);
        }
        return ni.getPortInst(3);
    }

    public PortInst getTransistorBiasPort(NodeInst ni) {
        if (ni.getNumPortInsts() < 4) {
            return null;
        }
        if (ni.getProto().getTechnology() != Schematics.tech) {
            return null;
        }
        return ni.getPortInst(3);
    }

    public void setPrimitiveFunction(NodeInst ni, NodeProto.Function function) {
    }

    public void setNoPrimitiveNodes() {
        this.userBits |= 0x20;
    }

    public boolean isNoPrimitiveNodes() {
        return (this.userBits & 0x20) != 0;
    }

    public void setDefaultOutline(NodeInst ni) {
    }

    public SizeOffset getNodeInstSizeOffset(NodeInst ni) {
        NodeProto np = ni.getProto();
        return np.getProtoSizeOffset();
    }

    public Poly[] getShapeOfNode(NodeInst ni) {
        return this.getShapeOfNode(ni, null, false, false);
    }

    public Poly[] getShapeOfNode(NodeInst ni, EditWindow wnd) {
        return this.getShapeOfNode(ni, wnd, false, false);
    }

    public Poly[] getShapeOfNode(NodeInst ni, EditWindow wnd, boolean electrical, boolean reasonable) {
        NodeLayer[] eLayers;
        NodeProto prototype = ni.getProto();
        if (!(prototype instanceof PrimitiveNode)) {
            return null;
        }
        PrimitiveNode np = (PrimitiveNode)prototype;
        NodeLayer[] primLayers = np.getLayers();
        if (electrical && (eLayers = np.getElectricalLayers()) != null) {
            primLayers = eLayers;
        }
        if (ni.isWiped()) {
            primLayers = nullPrimLayers;
        } else if (np.isWipeOn1or2() && ni.pinUseCount()) {
            primLayers = nullPrimLayers;
        }
        return this.getShapeOfNode(ni, wnd, electrical, reasonable, primLayers, null);
    }

    public Poly[] getShapeOfNode(NodeInst ni, EditWindow wnd, boolean electrical, boolean reasonable, NodeLayer[] primLayers, Layer layerOverride) {
        int i;
        Point2D[] outline;
        PrimitiveNode np = (PrimitiveNode)ni.getProto();
        int specialType = np.getSpecialType();
        if (specialType != 1 && np.isHoldsOutline() && (outline = ni.getTrace()) != null) {
            int numPolys = 1;
            if (wnd != null) {
                numPolys += ni.numDisplayableVariables(true);
            }
            Poly[] polys = new Poly[numPolys];
            Point2D[] pointList = new Point2D.Double[outline.length];
            for (int i2 = 0; i2 < outline.length; ++i2) {
                pointList[i2] = new Point2D.Double(ni.getTrueCenterX() + outline[i2].getX(), ni.getTrueCenterY() + outline[i2].getY());
            }
            polys[0] = new Poly(pointList);
            NodeLayer primLayer = primLayers[0];
            polys[0].setStyle(primLayer.getStyle());
            if (layerOverride != null) {
                polys[0].setLayer(layerOverride);
            } else {
                polys[0].setLayer(primLayer.getLayer());
            }
            Rectangle2D rect = ni.getBounds();
            if (wnd != null) {
                ni.addDisplayableVariables(rect, polys, 1, wnd, true);
            }
            return polys;
        }
        int numBasicLayers = primLayers.length;
        int numExtraLayers = 0;
        MultiCutData mcd = null;
        SerpentineTrans std = null;
        if (specialType == 3) {
            mcd = new MultiCutData(ni, np.getSpecialValues());
            numExtraLayers = reasonable ? mcd.cutsReasonable : mcd.cutsTotal;
            --numBasicLayers;
        } else if (specialType == 1 && (std = new SerpentineTrans(ni)).layersTotal > 0) {
            numExtraLayers = std.layersTotal;
            numBasicLayers = 0;
        }
        int numNegatingBubbles = 0;
        Iterator it = ni.getConnections();
        while (it.hasNext()) {
            Connection con = (Connection)it.next();
            if (!con.isNegated()) continue;
            ++numNegatingBubbles;
        }
        int numPolys = numBasicLayers + numExtraLayers + numNegatingBubbles;
        if (wnd != null) {
            numPolys += ni.numDisplayableVariables(true);
        }
        Poly[] polys = new Poly[numPolys];
        int fillPoly = 0;
        for (i = 0; i < numBasicLayers; ++i) {
            double xCenter = ni.getTrueCenterX();
            double yCenter = ni.getTrueCenterY();
            double xSize = ni.getXSize();
            double ySize = ni.getYSize();
            NodeLayer primLayer = primLayers[i];
            int representation = primLayer.getRepresentation();
            if (representation == 1 || representation == 2) {
                EdgeH leftEdge = primLayer.getLeftEdge();
                EdgeH rightEdge = primLayer.getRightEdge();
                EdgeV topEdge = primLayer.getTopEdge();
                EdgeV bottomEdge = primLayer.getBottomEdge();
                double portLowX = xCenter + leftEdge.getMultiplier() * xSize + leftEdge.getAdder();
                double portHighX = xCenter + rightEdge.getMultiplier() * xSize + rightEdge.getAdder();
                double portLowY = yCenter + bottomEdge.getMultiplier() * ySize + bottomEdge.getAdder();
                double portHighY = yCenter + topEdge.getMultiplier() * ySize + topEdge.getAdder();
                Point2D[] pointList = Poly.makePoints(portLowX, portHighX, portLowY, portHighY);
                polys[fillPoly] = new Poly(pointList);
            } else if (representation == 0) {
                TechPoint[] points = primLayer.getPoints();
                Point2D[] pointList = new Point2D.Double[points.length];
                for (int j = 0; j < points.length; ++j) {
                    EdgeH xFactor = points[j].getX();
                    EdgeV yFactor = points[j].getY();
                    double x = 0.0;
                    double y = 0.0;
                    if (xFactor != null && yFactor != null) {
                        x = xCenter + xFactor.getMultiplier() * xSize + xFactor.getAdder();
                        y = yCenter + yFactor.getMultiplier() * ySize + yFactor.getAdder();
                    }
                    pointList[j] = new Point2D.Double(x, y);
                }
                polys[fillPoly] = new Poly(pointList);
            }
            Poly.Type style = primLayer.getStyle();
            if (style.isText()) {
                polys[fillPoly].setString(primLayer.getMessage());
                polys[fillPoly].setTextDescriptor(primLayer.getDescriptor());
            }
            polys[i].setStyle(style);
            if (layerOverride != null) {
                polys[i].setLayer(layerOverride);
            } else {
                polys[fillPoly].setLayer(primLayer.getLayer());
            }
            if (electrical) {
                int portIndex = primLayer.getPortNum();
                PortProto port = null;
                if (portIndex >= 0) {
                    port = np.getPort(portIndex);
                }
                polys[fillPoly].setPort(port);
            }
            ++fillPoly;
        }
        if (mcd != null) {
            NodeLayer primLayer = primLayers[numBasicLayers];
            Poly.Type style = primLayer.getStyle();
            PortProto port = null;
            if (electrical) {
                port = np.getPort(0);
            }
            for (int i3 = 0; i3 < numExtraLayers; ++i3) {
                polys[fillPoly] = mcd.fillCutPoly(ni, i3);
                polys[fillPoly].setStyle(style);
                polys[fillPoly].setLayer(primLayer.getLayer());
                polys[fillPoly].setPort(port);
                ++fillPoly;
            }
        }
        if (numNegatingBubbles > 0) {
            double bubbleRadius = Schematics.getNegatingBubbleSize() / 2.0;
            Iterator it2 = ni.getConnections();
            while (it2.hasNext()) {
                Connection con = (Connection)it2.next();
                if (!con.isNegated()) continue;
                AffineTransform trans = ni.rotateIn();
                Point2D.Double portLocation = new Point2D.Double(con.getLocation().getX(), con.getLocation().getY());
                trans.transform(portLocation, portLocation);
                double x = ((Point2D)portLocation).getX();
                double y = ((Point2D)portLocation).getY();
                PrimitivePort pp = (PrimitivePort)con.getPortInst().getPortProto();
                int angle = pp.getAngle() * 10;
                double dX = DBMath.cos(angle) * bubbleRadius;
                double dY = DBMath.sin(angle) * bubbleRadius;
                Point2D[] points = new Point2D[]{new Point2D.Double(x + dX, y + dY), new Point2D.Double(x, y)};
                polys[fillPoly] = new Poly(points);
                polys[fillPoly].setStyle(Poly.Type.CIRCLE);
                polys[fillPoly].setLayer(Schematics.tech.node_lay);
                ++fillPoly;
            }
        }
        if (std != null) {
            for (i = 0; i < numExtraLayers; ++i) {
                polys[fillPoly] = std.fillTransPoly(i);
                ++fillPoly;
            }
        }
        if (wnd != null) {
            Rectangle2D rect = ni.getBounds();
            ni.addDisplayableVariables(rect, polys, fillPoly, wnd, true);
        }
        return polys;
    }

    public PrimitiveNode convertOldNodeName(String name) {
        return null;
    }

    public Poly getShapeOfPort(NodeInst ni, PrimitivePort pp) {
        return this.getShapeOfPort(ni, pp, null);
    }

    public Poly getShapeOfPort(NodeInst ni, PrimitivePort pp, Point2D selectPt) {
        Point2D[] outline;
        SerpentineTrans std;
        PrimitiveNode np = (PrimitiveNode)ni.getProto();
        if (np.getSpecialType() == 1 && (std = new SerpentineTrans(ni)).hasValidData()) {
            return std.fillTransPort(pp);
        }
        if (np.isHoldsOutline() && (outline = ni.getTrace()) != null) {
            double cX = ni.getTrueCenterX();
            double cY = ni.getTrueCenterY();
            Point2D[] pointList = new Point2D.Double[outline.length];
            for (int i = 0; i < outline.length; ++i) {
                pointList[i] = new Point2D.Double(cX + outline[i].getX(), cY + outline[i].getY());
            }
            Poly portPoly = new Poly(pointList);
            if (ni.getFunction() == NodeProto.Function.NODE) {
                portPoly.setStyle(Poly.Type.FILLED);
            } else {
                portPoly.setStyle(Poly.Type.OPENED);
            }
            portPoly.setTextDescriptor(pp.getTextDescriptor());
            return portPoly;
        }
        double portLowX = ni.getTrueCenterX() + pp.getLeft().getMultiplier() * ni.getXSize() + pp.getLeft().getAdder();
        double portHighX = ni.getTrueCenterX() + pp.getRight().getMultiplier() * ni.getXSize() + pp.getRight().getAdder();
        double portLowY = ni.getTrueCenterY() + pp.getBottom().getMultiplier() * ni.getYSize() + pp.getBottom().getAdder();
        double portHighY = ni.getTrueCenterY() + pp.getTop().getMultiplier() * ni.getYSize() + pp.getTop().getAdder();
        double portX = (portLowX + portHighX) / 2.0;
        double portY = (portLowY + portHighY) / 2.0;
        Poly portPoly = new Poly(portX, portY, portHighX - portLowX, portHighY - portLowY);
        portPoly.setStyle(Poly.Type.FILLED);
        portPoly.setTextDescriptor(pp.getTextDescriptor());
        return portPoly;
    }

    public PrimitivePort convertOldPortName(String portName, PrimitiveNode np) {
        PrimitivePort pp;
        int len = portName.length() - 4;
        if (len > 0 && portName.substring(len).equals("-bot") && (pp = (PrimitivePort)np.findPortProto(portName + "tom")) != null) {
            return pp;
        }
        return null;
    }

    private Pref getParasiticPref(String what, Pref pref, double factory) {
        if (pref == null) {
            pref = Pref.makeDoublePref("Mininum" + what + "IN" + this.getTechName(), prefs, factory);
            pref.attachToObject(this, "Tools/Spice tab", this.getTechShortName() + " Min. " + what);
        }
        return pref;
    }

    public static Preferences getTechnologyPreferences() {
        return prefs;
    }

    public double getMinResistance() {
        this.prefMinResistance = this.getParasiticPref("Resistance", this.prefMinResistance, this.minResistance);
        return this.prefMinResistance.getDouble();
    }

    public void setMinResistance(double minResistance) {
        this.prefMinResistance = this.getParasiticPref("Resistance", this.prefMinResistance, this.minResistance);
        this.prefMinResistance.setDouble(minResistance);
    }

    public double getMinCapacitance() {
        this.prefMinCapacitance = this.getParasiticPref("Capacitance", this.prefMinCapacitance, this.minCapacitance);
        return this.prefMinCapacitance.getDouble();
    }

    public void setMinCapacitance(double minCapacitance) {
        this.prefMinCapacitance = this.getParasiticPref("Capacitance", this.prefMinCapacitance, this.minCapacitance);
        this.prefMinCapacitance.setDouble(minCapacitance);
    }

    public void setFactoryParasitics(double minResistance, double minCapacitance) {
        this.minResistance = minResistance;
        this.prefMinResistance = this.getParasiticPref("Resistance", this.prefMinResistance, this.minResistance);
        this.minCapacitance = minCapacitance;
        this.prefMinCapacitance = this.getParasiticPref("Capacitance", this.prefMinCapacitance, this.minCapacitance);
    }

    public String[] getSpiceHeaderLevel1() {
        return this.spiceHeaderLevel1;
    }

    public void setSpiceHeaderLevel1(String[] lines) {
        this.spiceHeaderLevel1 = lines;
    }

    public String[] getSpiceHeaderLevel2() {
        return this.spiceHeaderLevel2;
    }

    public void setSpiceHeaderLevel2(String[] lines) {
        this.spiceHeaderLevel2 = lines;
    }

    public String[] getSpiceHeaderLevel3() {
        return this.spiceHeaderLevel3;
    }

    public void setSpiceHeaderLevel3(String[] lines) {
        this.spiceHeaderLevel3 = lines;
    }

    protected void setNonElectrical() {
        this.userBits |= 1;
    }

    public boolean isNonElectrical() {
        return (this.userBits & 1) != 0;
    }

    protected void setNonStandard() {
        this.userBits |= 8;
    }

    public boolean isNonStandard() {
        return (this.userBits & 8) != 0;
    }

    protected void setStaticTechnology() {
        this.userBits |= 8;
    }

    public boolean isStaticTechnology() {
        return (this.userBits & 8) != 0;
    }

    public String getTechName() {
        return this.techName;
    }

    protected void setTechName(String techName) {
        this.techName = techName;
    }

    public String getTechShortName() {
        return this.techShortName;
    }

    protected void setTechShortName(String techShortName) {
        this.techShortName = techShortName;
    }

    public String getTechDesc() {
        return this.techDesc;
    }

    public void setTechDesc(String techDesc) {
        this.techDesc = techDesc;
    }

    public double getScale() {
        return this.prefScale.getDouble();
    }

    public String getScaleVariableName() {
        return "ScaleFOR" + this.getTechName();
    }

    protected void setFactoryScale(double factory, boolean scaleRelevant) {
        this.scaleRelevant = scaleRelevant;
        this.prefScale = Pref.makeDoublePref(this.getScaleVariableName(), prefs, factory);
        Pref.Meaning meaning = this.prefScale.attachToObject(this, "Technology/Scale tab", this.getTechShortName() + " scale");
        meaning.setValidOption(this.isScaleRelevant());
    }

    public void setScale(double scale) {
        if (scale == 0.0) {
            return;
        }
        this.prefScale.setDouble(scale);
    }

    public boolean isScaleRelevant() {
        return this.scaleRelevant;
    }

    protected void setFactoryTransparentLayers(Color[] layers) {
        this.transparentLayers = layers.length;
        this.transparentColorPrefs = new Pref[this.transparentLayers];
        for (int i = 0; i < layers.length; ++i) {
            this.transparentColorPrefs[i] = Pref.makeIntPref("TransparentLayer" + (i + 1) + "For" + this.techName, prefs, layers[i].getRGB());
            layers[i] = new Color(this.transparentColorPrefs[i].getInt());
        }
        this.setColorMapFromLayers(layers);
    }

    public int getNumTransparentLayers() {
        return this.transparentLayers;
    }

    public void setColorMap(Color[] map) {
        this.colorMap = map;
    }

    public void setColorMapFromLayers(Color[] layers) {
        if (this.transparentColorPrefs != null) {
            for (int i = 0; i < layers.length; ++i) {
                Pref pref = this.transparentColorPrefs[i];
                pref.setInt(layers[i].getRGB());
            }
        }
        int numEntries = 1 << this.transparentLayers;
        Color[] map = new Color[numEntries];
        for (int i = 0; i < numEntries; ++i) {
            int r = 0;
            int g = 0;
            int b = 0;
            int overlapCount = 0;
            for (int j = 0; j < this.transparentLayers; ++j) {
                if ((i & 1 << j) == 0) continue;
                ++overlapCount;
                r += layers[j].getRed();
                g += layers[j].getGreen();
                b += layers[j].getBlue();
            }
            if (overlapCount == 0) {
                b = 200;
                g = 200;
                r = 200;
            } else {
                r /= overlapCount;
                g /= overlapCount;
                b /= overlapCount;
            }
            map[i] = new Color(r, g, b);
        }
        this.setColorMap(map);
    }

    public DRC.Rules getFactoryDesignRules() {
        return null;
    }

    public Color[] getColorMap() {
        return this.colorMap;
    }

    public int getIndex() {
        return this.techIndex;
    }

    private static boolean validTechnology(String techName) {
        if (Technology.findTechnology(techName) != null) {
            System.out.println("ERROR: Multiple technologies named " + techName);
            return false;
        }
        return true;
    }

    public static Technology whatTechnology(NodeProto cell) {
        Technology tech = Technology.whatTechnology(cell, null, 0, 0, null, 0, 0);
        return tech;
    }

    public static Technology whatTechnology(NodeProto cellOrPrim, NodeProto[] nodeProtoList, int startNodeProto, int endNodeProto, ArcProto[] arcProtoList, int startArcProto, int endArcProto) {
        int i;
        if (cellOrPrim instanceof PrimitiveNode) {
            return ((PrimitiveNode)cellOrPrim).getTechnology();
        }
        Cell cell = (Cell)cellOrPrim;
        int maxTech = 0;
        Iterator it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = (Technology)it.next();
            if (tech.getIndex() <= maxTech) continue;
            maxTech = tech.getIndex();
        }
        int[] useCount = new int[++maxTech];
        for (i = 0; i < maxTech; ++i) {
            useCount[i] = 0;
        }
        if (nodeProtoList != null) {
            for (i = startNodeProto; i < endNodeProto; ++i) {
                Cell subCell;
                NodeProto np = nodeProtoList[i];
                if (np == null) continue;
                Technology nodeTech = np.getTechnology();
                if (np instanceof Cell && (subCell = (Cell)np).getView() == View.ICON) {
                    nodeTech = Schematics.tech;
                }
                if (nodeTech == null) continue;
                int n = nodeTech.getIndex();
                useCount[n] = useCount[n] + 1;
            }
        } else {
            Iterator it2 = cell.getNodes();
            while (it2.hasNext()) {
                Cell subCell;
                NodeInst ni = (NodeInst)it2.next();
                NodeProto np = ni.getProto();
                Technology nodeTech = np.getTechnology();
                if (np instanceof Cell && (subCell = (Cell)np).getView() == View.ICON) {
                    nodeTech = Schematics.tech;
                }
                if (nodeTech == null) continue;
                int n = nodeTech.getIndex();
                useCount[n] = useCount[n] + 1;
            }
        }
        if (arcProtoList != null) {
            for (int i2 = startArcProto; i2 < endArcProto; ++i2) {
                ArcProto ap = arcProtoList[i2];
                if (ap == null) continue;
                int n = ap.getTechnology().getIndex();
                useCount[n] = useCount[n] + 1;
            }
        } else {
            Iterator it3 = cell.getArcs();
            while (it3.hasNext()) {
                ArcInst ai = (ArcInst)it3.next();
                ArcProto ap = ai.getProto();
                int n = ap.getTechnology().getIndex();
                useCount[n] = useCount[n] + 1;
            }
        }
        int best = 0;
        Technology bestTech = null;
        int bestLayout = 0;
        Technology bestLayoutTech = null;
        Iterator it4 = Technology.getTechnologies();
        while (it4.hasNext()) {
            Technology tech = (Technology)it4.next();
            if (tech == Generic.tech) continue;
            if (useCount[tech.getIndex()] > best) {
                best = useCount[tech.getIndex()];
                bestTech = tech;
            }
            if (tech == Schematics.tech || tech == Artwork.tech || useCount[tech.getIndex()] <= bestLayout) continue;
            bestLayout = useCount[tech.getIndex()];
            bestLayoutTech = tech;
        }
        Technology retTech = null;
        if (cell.getView() == View.ICON) {
            if (useCount[Artwork.tech.getIndex()] > 0) {
                return Artwork.tech;
            }
            if (bestTech == null) {
                return Artwork.tech;
            }
            retTech = Artwork.tech;
        } else if (cell.getView() == View.SCHEMATIC || cell.getView().isMultiPageView()) {
            if (useCount[Schematics.tech.getIndex()] > 0) {
                return Schematics.tech;
            }
            if (bestTech == null) {
                return Schematics.tech;
            }
            retTech = Schematics.tech;
        } else {
            retTech = curLayoutTech;
        }
        if (bestLayoutTech != null) {
            retTech = bestLayoutTech;
        } else if (bestTech != null) {
            retTech = bestTech;
        }
        return retTech;
    }

    public String toString() {
        return "Technology " + this.techName;
    }

    private static class SerpentineTrans {
        private NodeInst theNode;
        private PrimitiveNode theProto;
        private int layersTotal;
        private int numSegments;
        private double extraScale;
        private NodeLayer[] primLayers;
        private Point2D[] points;
        private static final int LEFTANGLE = 900;
        private static final int RIGHTANGLE = 2700;

        public SerpentineTrans(NodeInst ni) {
            this.theNode = ni;
            this.layersTotal = 0;
            this.points = ni.getTrace();
            if (this.points != null && this.points.length < 2) {
                this.points = null;
            }
            if (this.points != null) {
                this.theProto = (PrimitiveNode)ni.getProto();
                this.primLayers = this.theProto.getLayers();
                int count = this.primLayers.length;
                this.numSegments = this.points.length - 1;
                this.layersTotal = count * this.numSegments;
                this.extraScale = 0.0;
                Variable varw = ni.getVar("transistor_width", class$java$lang$Integer == null ? (class$java$lang$Integer = Technology.class$("java.lang.Integer")) : class$java$lang$Integer);
                if (varw != null) {
                    Object obj = varw.getObject();
                    this.extraScale = (Integer)obj / 120 / 2;
                }
            }
        }

        public boolean hasValidData() {
            return this.points != null;
        }

        private Poly fillTransPoly(int box) {
            Point2D otherPt;
            int otherang;
            int ang;
            int segment = box % this.numSegments;
            int element = box / this.numSegments;
            double lwid = this.primLayers[element].getSerpentineLWidth();
            double rwid = this.primLayers[element].getSerpentineRWidth();
            double extendt = this.primLayers[element].getSerpentineExtentT();
            double extendb = this.primLayers[element].getSerpentineExtentB();
            lwid += this.extraScale;
            rwid += this.extraScale;
            double xoff = this.theNode.getTrueCenterX();
            double yoff = this.theNode.getTrueCenterY();
            int thissg = segment;
            int next = segment + 1;
            Point2D thisPt = this.points[thissg];
            Point2D nextPt = this.points[next];
            int angle = DBMath.figureAngle(thisPt, nextPt);
            if (thissg == 0) {
                ang = angle + 1800;
                thisPt = DBMath.addPoints(thisPt, DBMath.cos(ang) * extendt, DBMath.sin(ang) * extendt);
            }
            if (next == this.numSegments) {
                nextPt = DBMath.addPoints(nextPt, DBMath.cos(angle) * extendb, DBMath.sin(angle) * extendb);
            }
            ang = angle + 900;
            double sin = DBMath.sin(ang) * lwid;
            double cos = DBMath.cos(ang) * lwid;
            Point2D thisL = DBMath.addPoints(thisPt, cos, sin);
            Point2D nextL = DBMath.addPoints(nextPt, cos, sin);
            ang = angle + 2700;
            sin = DBMath.sin(ang) * rwid;
            cos = DBMath.cos(ang) * rwid;
            Point2D thisR = DBMath.addPoints(thisPt, cos, sin);
            Point2D nextR = DBMath.addPoints(nextPt, cos, sin);
            if (thissg != 0 && (otherang = DBMath.figureAngle(otherPt = this.points[thissg - 1], thisPt)) != angle) {
                ang = otherang + 900;
                thisL = DBMath.intersect(DBMath.addPoints(thisPt, DBMath.cos(ang) * lwid, DBMath.sin(ang) * lwid), otherang, thisL, angle);
                ang = otherang + 2700;
                thisR = DBMath.intersect(DBMath.addPoints(thisPt, DBMath.cos(ang) * rwid, DBMath.sin(ang) * rwid), otherang, thisR, angle);
            }
            if (next != this.numSegments && (otherang = DBMath.figureAngle(nextPt, otherPt = this.points[next + 1])) != angle) {
                ang = otherang + 900;
                Point2D newPtL = DBMath.addPoints(nextPt, DBMath.cos(ang) * lwid, DBMath.sin(ang) * lwid);
                nextL = DBMath.intersect(newPtL, otherang, nextL, angle);
                ang = otherang + 2700;
                Point2D newPtR = DBMath.addPoints(nextPt, DBMath.cos(ang) * rwid, DBMath.sin(ang) * rwid);
                nextR = DBMath.intersect(newPtR, otherang, nextR, angle);
            }
            Point2D[] points = new Point2D.Double[]{DBMath.addPoints(thisL, xoff, yoff), DBMath.addPoints(thisR, xoff, yoff), DBMath.addPoints(nextR, xoff, yoff), DBMath.addPoints(nextL, xoff, yoff)};
            Poly retPoly = new Poly(points);
            NodeLayer primLayer = this.primLayers[element];
            retPoly.setStyle(primLayer.getStyle());
            retPoly.setLayer(primLayer.getLayer());
            return retPoly;
        }

        private Poly fillTransPort(PortProto pp) {
            Point2D.Double nextPt;
            Point2D.Double thisPt;
            PortProto lpp;
            double[] specialValues = this.theProto.getSpecialValues();
            double diffInset = specialValues[1];
            double diffExtend = specialValues[2];
            double defWid = specialValues[3] + this.extraScale;
            double polyInset = specialValues[4];
            double polyExtend = specialValues[5];
            double xOff = this.theNode.getTrueCenterX();
            double yOff = this.theNode.getTrueCenterY();
            int total = this.points.length;
            AffineTransform trans = this.theNode.rotateOut();
            int which = 0;
            Iterator it = this.theProto.getPorts();
            while (it.hasNext() && (lpp = (PortProto)it.next()) != pp) {
                ++which;
            }
            if (which == 0) {
                thisPt = new Point2D.Double(this.points[0].getX(), this.points[0].getY());
                nextPt = new Point2D.Double(this.points[1].getX(), this.points[1].getY());
                int angle = DBMath.figureAngle(thisPt, nextPt);
                int ang = (angle + 1800) % 3600;
                ((Point2D)thisPt).setLocation(((Point2D)thisPt).getX() + DBMath.cos(ang) * polyExtend + xOff, ((Point2D)thisPt).getY() + DBMath.sin(ang) * polyExtend + yOff);
                ang = (angle + 900) % 3600;
                Point2D.Double end1 = new Point2D.Double(((Point2D)thisPt).getX() + DBMath.cos(ang) * (defWid / 2.0 - polyInset), ((Point2D)thisPt).getY() + DBMath.sin(ang) * (defWid / 2.0 - polyInset));
                ang = (angle + 2700) % 3600;
                Point2D.Double end2 = new Point2D.Double(((Point2D)thisPt).getX() + DBMath.cos(ang) * (defWid / 2.0 - polyInset), ((Point2D)thisPt).getY() + DBMath.sin(ang) * (defWid / 2.0 - polyInset));
                Point2D[] portPoints = new Point2D.Double[]{end1, end2};
                trans.transform(portPoints, 0, portPoints, 0, 2);
                Poly retPoly = new Poly(portPoints);
                retPoly.setStyle(Poly.Type.OPENED);
                return retPoly;
            }
            if (which == 2) {
                thisPt = new Point2D.Double(this.points[total - 1].getX(), this.points[total - 1].getY());
                nextPt = new Point2D.Double(this.points[total - 2].getX(), this.points[total - 2].getY());
                int angle = DBMath.figureAngle(thisPt, nextPt);
                int ang = (angle + 1800) % 3600;
                ((Point2D)thisPt).setLocation(((Point2D)thisPt).getX() + DBMath.cos(ang) * polyExtend + xOff, ((Point2D)thisPt).getY() + DBMath.sin(ang) * polyExtend + yOff);
                ang = (angle + 900) % 3600;
                Point2D.Double end1 = new Point2D.Double(((Point2D)thisPt).getX() + DBMath.cos(ang) * (defWid / 2.0 - polyInset), ((Point2D)thisPt).getY() + DBMath.sin(ang) * (defWid / 2.0 - polyInset));
                ang = (angle + 2700) % 3600;
                Point2D.Double end2 = new Point2D.Double(((Point2D)thisPt).getX() + DBMath.cos(ang) * (defWid / 2.0 - polyInset), ((Point2D)thisPt).getY() + DBMath.sin(ang) * (defWid / 2.0 - polyInset));
                Point2D[] portPoints = new Point2D.Double[]{end1, end2};
                trans.transform(portPoints, 0, portPoints, 0, 2);
                Poly retPoly = new Poly(portPoints);
                retPoly.setStyle(Poly.Type.OPENED);
                return retPoly;
            }
            if (which == 3) {
                diffExtend = -diffExtend;
                defWid = -defWid;
            }
            if (which == 4) {
                defWid = 0.0;
                diffExtend = 0.0;
            }
            Point2D[] portPoints = new Point2D.Double[total];
            Point2D.Double lastPoint = null;
            int lastAngle = 0;
            for (int nextIndex = 1; nextIndex < total; ++nextIndex) {
                int thisIndex = nextIndex - 1;
                Point2D thisPt2 = new Point2D.Double(this.points[thisIndex].getX() + xOff, this.points[thisIndex].getY() + yOff);
                Point2D.Double nextPt2 = new Point2D.Double(this.points[nextIndex].getX() + xOff, this.points[nextIndex].getY() + yOff);
                int angle = DBMath.figureAngle(thisPt2, nextPt2);
                if (thisIndex == 0) {
                    ((Point2D)thisPt2).setLocation(((Point2D)thisPt2).getX() + DBMath.cos(angle) * diffInset, ((Point2D)thisPt2).getY() + DBMath.sin(angle) * diffInset);
                }
                if (nextIndex == total - 1) {
                    int backAng = (angle + 1800) % 3600;
                    ((Point2D)nextPt2).setLocation(((Point2D)nextPt2).getX() + DBMath.cos(backAng) * diffInset, ((Point2D)nextPt2).getY() + DBMath.sin(backAng) * diffInset);
                }
                int ang = (angle + 900) % 3600;
                double sine = DBMath.sin(ang);
                double cosine = DBMath.cos(ang);
                ((Point2D)thisPt2).setLocation(((Point2D)thisPt2).getX() + cosine * (defWid / 2.0 + diffExtend), ((Point2D)thisPt2).getY() + sine * (defWid / 2.0 + diffExtend));
                ((Point2D)nextPt2).setLocation(((Point2D)nextPt2).getX() + cosine * (defWid / 2.0 + diffExtend), ((Point2D)nextPt2).getY() + sine * (defWid / 2.0 + diffExtend));
                if (thisIndex != 0) {
                    thisPt2 = DBMath.intersect(lastPoint, lastAngle, thisPt2, angle);
                }
                portPoints[thisIndex] = thisPt2;
                lastPoint = thisPt2;
                lastAngle = angle;
                if (nextIndex != total - 1) continue;
                portPoints[nextIndex] = nextPt2;
            }
            trans.transform(portPoints, 0, portPoints, 0, total);
            Poly retPoly = new Poly(portPoints);
            retPoly.setStyle(Poly.Type.OPENED);
            return retPoly;
        }
    }

    public static class MultiCutData {
        private double cutSizeX;
        private double cutSizeY;
        private double cutSep;
        private double cutIndent;
        private int cutsX;
        private int cutsY;
        private int cutsTotal;
        private int cutsReasonable;
        private double cutBaseX;
        private double cutBaseY;
        private double cutTopEdge;
        private double cutLeftEdge;
        private double cutRightEdge;

        public MultiCutData(NodeInst ni, double[] specialValues) {
            this.cutSizeX = specialValues[0];
            this.cutSizeY = specialValues[1];
            this.cutIndent = specialValues[2];
            this.cutSep = specialValues[3];
            PrimitiveNode np = (PrimitiveNode)ni.getProto();
            SizeOffset so = ni.getSizeOffset();
            double cutLX = so.getLowXOffset();
            double cutHX = so.getHighXOffset();
            double cutLY = so.getLowYOffset();
            double cutHY = so.getHighYOffset();
            double cutAreaWidth = ni.getXSize() - cutLX - cutHX;
            double cutAreaHeight = ni.getYSize() - cutLY - cutHY;
            this.cutsX = (int)(cutAreaWidth - this.cutIndent * 2.0 + this.cutSep) / (int)(this.cutSizeX + this.cutSep);
            this.cutsY = (int)(cutAreaHeight - this.cutIndent * 2.0 + this.cutSep) / (int)(this.cutSizeY + this.cutSep);
            if (this.cutsX <= 0) {
                this.cutsX = 1;
            }
            if (this.cutsY <= 0) {
                this.cutsY = 1;
            }
            this.cutsReasonable = this.cutsTotal = this.cutsX * this.cutsY;
            if (this.cutsTotal != 1) {
                this.cutBaseX = (cutAreaWidth - this.cutIndent * 2.0 - this.cutSizeX * (double)this.cutsX - this.cutSep * (double)(this.cutsX - 1)) / 2.0 + (cutLX + this.cutIndent + this.cutSizeX / 2.0) + ni.getAnchorCenterX() - ni.getXSize() / 2.0;
                this.cutBaseY = (cutAreaHeight - this.cutIndent * 2.0 - this.cutSizeY * (double)this.cutsY - this.cutSep * (double)(this.cutsY - 1)) / 2.0 + (cutLY + this.cutIndent + this.cutSizeY / 2.0) + ni.getAnchorCenterY() - ni.getYSize() / 2.0;
                if (this.cutsX > 2 && this.cutsY > 2) {
                    this.cutsReasonable = this.cutsX * 2 + (this.cutsY - 2) * 2;
                    this.cutTopEdge = this.cutsX * 2;
                    this.cutLeftEdge = this.cutsX * 2 + this.cutsY - 2;
                    this.cutRightEdge = this.cutsX * 2 + (this.cutsY - 2) * 2;
                }
            }
        }

        public int numCuts() {
            return this.cutsTotal;
        }

        private Poly fillCutPoly(NodeInst ni, int cut) {
            if (this.cutsX > 2 && this.cutsY > 2 && cut >= this.cutsX) {
                if ((double)cut < this.cutTopEdge) {
                    cut += this.cutsX * (this.cutsY - 2);
                } else if ((double)cut < this.cutLeftEdge) {
                    cut = (int)(((double)cut - this.cutTopEdge) * (double)this.cutsX + (double)this.cutsX);
                } else if ((double)cut < this.cutRightEdge) {
                    cut = (int)(((double)cut - this.cutLeftEdge) * (double)this.cutsX + (double)(this.cutsX * 2) - 1.0);
                } else {
                    int cutx = (cut -= (int)this.cutRightEdge) % (this.cutsX - 2);
                    int cuty = cut / (this.cutsX - 2);
                    cut = cuty * this.cutsX + cutx + this.cutsX + 1;
                }
            }
            double cX = this.cutsX == 1 ? ni.getTrueCenterX() : this.cutBaseX + (double)(cut % this.cutsX) * (this.cutSizeX + this.cutSep);
            double cY = this.cutsY == 1 ? ni.getTrueCenterY() : this.cutBaseY + (double)(cut / this.cutsX) * (this.cutSizeY + this.cutSep);
            return new Poly(cX, cY, this.cutSizeX, this.cutSizeY);
        }
    }

    private static class LayerHeight
    implements Comparator {
        private LayerHeight() {
        }

        public int compare(Object o1, Object o2) {
            Layer l1 = (Layer)o1;
            Layer l2 = (Layer)o2;
            int h1 = l1.getFunction().getHeight();
            int h2 = l2.getFunction().getHeight();
            return h1 - h2;
        }
    }

    private static class TechnologyCaseInsensitive
    implements Comparator {
        private TechnologyCaseInsensitive() {
        }

        public int compare(Object o1, Object o2) {
            Technology c1 = (Technology)o1;
            Technology c2 = (Technology)o2;
            String s1 = c1.getTechName();
            String s2 = c2.getTechName();
            return s1.compareToIgnoreCase(s2);
        }
    }

    public static class NodeLayer {
        private Layer layer;
        private int portNum;
        private Poly.Type style;
        private int representation;
        private TechPoint[] points;
        private String message;
        private TextDescriptor descriptor;
        private double lWidth;
        private double rWidth;
        private double extentT;
        private double extendB;
        public static final int POINTS = 0;
        public static final int BOX = 1;
        public static final int MINBOX = 2;

        public NodeLayer(Layer layer, int portNum, Poly.Type style, int representation, TechPoint[] points) {
            this.layer = layer;
            this.portNum = portNum;
            this.style = style;
            this.representation = representation;
            this.points = points;
            this.extendB = 0.0;
            this.extentT = 0.0;
            this.rWidth = 0.0;
            this.lWidth = 0.0;
        }

        public NodeLayer(Layer layer, int portNum, Poly.Type style, int representation, TechPoint[] points, double lWidth, double rWidth, double extentT, double extendB) {
            this.layer = layer;
            this.portNum = portNum;
            this.style = style;
            this.representation = representation;
            this.points = points;
            this.lWidth = lWidth;
            this.rWidth = rWidth;
            this.extentT = extentT;
            this.extendB = extendB;
        }

        public Layer getLayer() {
            return this.layer;
        }

        public int getPortNum() {
            return this.portNum;
        }

        public Poly.Type getStyle() {
            return this.style;
        }

        public int getRepresentation() {
            return this.representation;
        }

        public TechPoint[] getPoints() {
            return this.points;
        }

        public EdgeH getLeftEdge() {
            return this.points[0].getX();
        }

        public EdgeV getBottomEdge() {
            return this.points[0].getY();
        }

        public EdgeH getRightEdge() {
            return this.points[1].getX();
        }

        public EdgeV getTopEdge() {
            return this.points[1].getY();
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public TextDescriptor getDescriptor() {
            return this.descriptor;
        }

        public void setDescriptor(TextDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public double getSerpentineLWidth() {
            return this.lWidth;
        }

        public void setSerpentineLWidth(double lWidth) {
            this.lWidth = lWidth;
        }

        public double getSerpentineRWidth() {
            return this.rWidth;
        }

        public void setSerpentineRWidth(double rWidth) {
            this.rWidth = rWidth;
        }

        public double getSerpentineExtentT() {
            return this.extentT;
        }

        public void setSerpentineExtentT(double extentT) {
            this.extentT = extentT;
        }

        public double getSerpentineExtentB() {
            return this.extendB;
        }

        public void setSerpentineExtentB(double extendB) {
            this.extendB = extendB;
        }
    }

    public static class TechPoint {
        private EdgeH x;
        private EdgeV y;

        public TechPoint(EdgeH x, EdgeV y) {
            this.x = x;
            this.y = y;
        }

        public TechPoint duplicate() {
            TechPoint newTP = new TechPoint(new EdgeH(this.x.getMultiplier(), this.x.getAdder()), new EdgeV(this.y.getMultiplier(), this.y.getAdder()));
            return newTP;
        }

        public static TechPoint[] makeCenterBox() {
            return new TechPoint[]{new TechPoint(EdgeH.fromCenter(0.0), EdgeV.fromCenter(0.0)), new TechPoint(EdgeH.fromCenter(0.0), EdgeV.fromCenter(0.0))};
        }

        public static TechPoint[] makeFullBox() {
            return TechPoint.makeIndented(0.0);
        }

        public static TechPoint[] makeIndented(double amount) {
            return new TechPoint[]{new TechPoint(EdgeH.fromLeft(amount), EdgeV.fromBottom(amount)), new TechPoint(EdgeH.fromRight(amount), EdgeV.fromTop(amount))};
        }

        public EdgeH getX() {
            return this.x;
        }

        public EdgeV getY() {
            return this.y;
        }
    }

    public static class ArcLayer {
        private Layer layer;
        private double offset;
        private Poly.Type style;

        public ArcLayer(Layer layer, double offset, Poly.Type style) {
            this.layer = layer;
            this.offset = offset;
            this.style = style;
        }

        public Layer getLayer() {
            return this.layer;
        }

        public double getOffset() {
            return this.offset;
        }

        public void setOffset(double offset) {
            this.offset = offset;
        }

        public Poly.Type getStyle() {
            return this.style;
        }
    }
}

