/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.output.Geometry;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.User;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CIF
extends Geometry {
    private double minAllowedResolution = 0.0;
    private int crcChecksum;
    private int[] crcTab = new int[256];
    private boolean crcPrevIsCharSep;
    private int crcNumChars;
    private static final int[] crcRow = new int[]{79764919, 159529838, 319059676, 638119352, 1276238704, -1742489888, 881225847, 1762451694};
    private byte space = (byte)32;
    private int cellNumber = 100;
    private HashMap cellNumbers = new HashMap();
    private double scaleFactor = Technology.getCurrent().getScale() / 10.0;
    private ErrorLogger errorLogger;

    public static void writeCIFFile(Cell cell, VarContext context, String filePath) {
        CIF out = new CIF();
        if (out.openTextOutputStream(filePath)) {
            return;
        }
        CIFVisitor visitor = out.makeCIFVisitor(CIF.getMaxHierDepth(cell));
        if (out.writeCell(cell, context, visitor)) {
            return;
        }
        if (out.closeTextOutputStream()) {
            return;
        }
        System.out.println(filePath + " written");
        if (out.errorLogger.numErrors() != 0) {
            System.out.println(out.errorLogger.numErrors() + " CIF RESOLUTION ERRORS FOUND");
        }
        out.errorLogger.termLogging(true);
    }

    CIF() {
        if (IOTool.isCIFOutCheckResolution()) {
            this.minAllowedResolution = IOTool.getCIFOutResolution();
        }
        this.errorLogger = ErrorLogger.newInstance("CIF resolution");
    }

    protected void start() {
        if (User.isIncludeDateAndVersionInOutput()) {
            this.writeLine("( Electric VLSI Design System, version " + Version.getVersion() + " );");
            Date now = new Date();
            this.writeLine("( written on " + TextUtils.formatDate(now) + " );");
        } else {
            this.writeLine("( Electric VLSI Design System );");
        }
        this.emitCopyright("( ", " );");
        int i = 0;
        while (i < this.crcTab.length) {
            this.crcTab[i] = 0;
            for (int j = 0; j < 8; ++j) {
                if ((1 << j & i) == 0) continue;
                this.crcTab[i] = this.crcTab[i] ^ crcRow[j];
            }
            int n = i++;
            this.crcTab[n] = this.crcTab[n] & 0xFFFFFFFF;
        }
        this.crcNumChars = 1;
        this.crcPrevIsCharSep = true;
        this.crcChecksum = this.crcTab[32];
    }

    protected void done() {
        if (IOTool.isCIFOutInstantiatesTopLevel()) {
            this.writeLine("C " + this.cellNumber + ";");
        }
        this.writeLine("E");
    }

    protected void writeCellGeom(Geometry.CellGeom cellGeom) {
        ++this.cellNumber;
        this.writeLine("DS " + this.cellNumber + " 1 1;");
        this.writeLine("9 " + (cellGeom.nonUniqueName ? cellGeom.cell.getLibrary().getName() + ":" : "") + cellGeom.cell.noLibDescribe() + ";");
        this.cellNumbers.put(cellGeom.cell, new Integer(this.cellNumber));
        Set layers = cellGeom.polyMap.keySet();
        Iterator it = layers.iterator();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            if (this.writeLayer(layer)) continue;
            List polyList = (List)cellGeom.polyMap.get(layer);
            Iterator polyIt = polyList.iterator();
            while (polyIt.hasNext()) {
                Poly poly = (Poly)polyIt.next();
                this.writePoly(poly, cellGeom.cell);
            }
        }
        Iterator noIt = cellGeom.cell.getNodes();
        while (noIt.hasNext()) {
            NodeInst ni = (NodeInst)noIt.next();
            if (!(ni.getProto() instanceof Cell)) continue;
            this.writeNodable(ni);
        }
        this.writeLine("DF;");
    }

    protected boolean mergeGeom(int hierLevelsFromBottom) {
        return IOTool.isCIFOutMergesBoxes();
    }

    protected boolean writeLayer(Layer layer) {
        String layName = layer.getCIFLayer();
        if (layName == null) {
            return true;
        }
        this.writeLine("L " + layName + ";");
        return false;
    }

    protected void writePoly(Poly poly, Cell cell) {
        Point2D[] points = poly.getPoints();
        this.checkResolution(poly, cell);
        if (poly.getStyle() == Poly.Type.DISC) {
            double r = points[0].distance(points[1]);
            if (r <= 0.0) {
                return;
            }
            int radius = this.scale(r);
            int x = this.scale(points[0].getX());
            int y = this.scale(points[0].getY());
            String line = " R " + radius + " " + x + " " + y + ";";
            this.writeLine(line);
        } else {
            Rectangle2D bounds = poly.getBounds2D();
            if (bounds.getHeight() <= 0.0 || bounds.getWidth() <= 0.0) {
                return;
            }
            Rectangle2D box = poly.getBox();
            if (box != null) {
                int width = this.scale(box.getWidth());
                int height = this.scale(box.getHeight());
                int x = this.scale(box.getCenterX());
                int y = this.scale(box.getCenterY());
                String line = " B " + width + " " + height + " " + x + " " + y + ";";
                this.writeLine(line);
                return;
            }
            StringBuffer line = new StringBuffer(" P");
            for (int i = 0; i < points.length; ++i) {
                int x = this.scale(points[i].getX());
                int y = this.scale(points[i].getY());
                line.append(" " + x + " " + y);
            }
            line.append(";");
            this.writeLine(line.toString());
        }
    }

    protected void writeNodable(NodeInst ni) {
        Cell cell = (Cell)ni.getProto();
        if (!ni.isExpanded() && IOTool.isCIFOutMimicsDisplay()) {
            Rectangle2D bounds = ni.getBounds();
            Poly poly = new Poly(bounds.getCenterX(), bounds.getCenterY(), ni.getXSize(), ni.getYSize());
            AffineTransform localPureTrans = ni.rotateOutAboutTrueCenter();
            poly.transform(localPureTrans);
            Point2D[] points = poly.getPoints();
            String line = "0V";
            for (int i = 0; i < 4; ++i) {
                line = line + " " + this.scale(points[i].getX()) + " " + this.scale(points[i].getY());
            }
            line = line + " " + this.scale(points[0].getX()) + " " + this.scale(points[0].getY());
            this.writeLine(line + ";");
            this.writeLine("2C \"" + cell.describe() + "\" T " + this.scale(bounds.getCenterX()) + " " + this.scale(bounds.getCenterY()) + ";");
            return;
        }
        int cellNum = (Integer)this.cellNumbers.get(cell);
        int rotx = (int)(DBMath.cos(ni.getAngle()) * 100.0);
        int roty = (int)(DBMath.sin(ni.getAngle()) * 100.0);
        String line = "C " + cellNum + " R " + rotx + " " + roty;
        if (ni.isMirroredAboutXAxis()) {
            line = line + " M Y";
        }
        if (ni.isMirroredAboutYAxis()) {
            line = line + " M X";
        }
        line = line + " T " + this.scale(ni.getAnchorCenterX()) + " " + this.scale(ni.getAnchorCenterY());
        this.writeLine(line + ";");
    }

    protected void writeLine(String line) {
        line = line + '\n';
        this.printWriter.print(line);
    }

    protected int scale(double n) {
        return (int)(this.scaleFactor * n);
    }

    protected void checkResolution(Poly poly, Cell cell) {
        if (this.minAllowedResolution == 0.0) {
            return;
        }
        ArrayList<Point2D> badpoints = new ArrayList<Point2D>();
        Point2D[] points = poly.getPoints();
        for (int i = 0; i < points.length; ++i) {
            if (points[i].getX() % this.minAllowedResolution == 0.0 && points[i].getY() % this.minAllowedResolution == 0.0) continue;
            badpoints.add(points[i]);
        }
        if (badpoints.size() > 0) {
            Layer layer = poly.getLayer();
            ErrorLogger.ErrorLog err = null;
            err = layer == null ? this.errorLogger.logError("Unknown layer", cell, layer.getIndex()) : this.errorLogger.logError("Resolution < " + this.minAllowedResolution + " on layer " + layer.getName(), cell, layer.getIndex());
            err.addPoly(poly, false, cell);
        }
    }

    private CIFVisitor makeCIFVisitor(int maxDepth) {
        CIFVisitor visitor = new CIFVisitor((Geometry)this, maxDepth);
        return visitor;
    }

    private class CIFVisitor
    extends Geometry.Visitor {
        CIFVisitor(Geometry outGeom, int maxHierDepth) {
            super(CIF.this, outGeom, maxHierDepth);
        }

        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            NodeInst ni = (NodeInst)no;
            NodeProto np = ni.getProto();
            if (np instanceof Cell && !ni.isExpanded() && IOTool.isCIFOutMimicsDisplay()) {
                return false;
            }
            return super.visitNodeInst(no, info);
        }
    }
}

