/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.JNetwork;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.io.output.Output;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public abstract class Topology
extends Output {
    protected Cell topCell;
    private HashMap cellTopos;
    private HashMap cellNameMap;

    Topology() {
    }

    public boolean writeCell(Cell cell, VarContext context) {
        this.writeCell(cell, context, new Visitor(this));
        return false;
    }

    public boolean writeCell(Cell cell, VarContext context, Visitor visitor) {
        this.topCell = cell;
        this.cellTopos = new HashMap();
        this.makeCellNameMap();
        this.start();
        HierarchyEnumerator.enumerateCell(cell, context, null, visitor);
        this.done();
        return false;
    }

    protected abstract void start();

    protected abstract void done();

    protected abstract void writeCellTopology(Cell var1, CellNetInfo var2, VarContext var3);

    protected abstract String getSafeNetName(String var1);

    protected abstract String getSafeCellName(String var1);

    protected abstract String getPowerName();

    protected abstract String getGroundName();

    protected abstract String getGlobalName(Global var1);

    protected abstract boolean isNetworksUseExportedNames();

    protected boolean skipCellAndSubcells(Cell cell) {
        return false;
    }

    protected boolean canParameterizeNames() {
        return false;
    }

    protected int maxNameLength() {
        return 0;
    }

    protected abstract Netlist getNetlistForCell(Cell var1);

    protected CellNetInfo getCellNetInfo(String cellName) {
        CellNetInfo cni = (CellNetInfo)this.cellTopos.get(cellName);
        return cni;
    }

    private CellNetInfo getNetworkInformation(Cell cell, boolean quiet, String paramName, boolean useExportedName) {
        CellNetInfo cni = this.doGetNetworks(cell, quiet, paramName, useExportedName);
        return cni;
    }

    private CellNetInfo doGetNetworks(Cell cell, boolean quiet, String paramName, boolean useExportedName) {
        CellSignal cs;
        JNetwork subNet;
        CellNetInfo cni = new CellNetInfo();
        cni.paramName = paramName;
        cni.netList = this.getNetlistForCell(cell);
        Global.Set globals = cni.netList.getGlobals();
        int globalSize = globals.size();
        cni.cellSignals = new HashMap();
        int nullNameCount = 1;
        Iterator it = cni.netList.getNetworks();
        while (it.hasNext()) {
            JNetwork net = (JNetwork)it.next();
            CellSignal cs2 = new CellSignal();
            cs2.pp = null;
            cs2.descending = !Network.isBusAscending();
            cs2.power = false;
            cs2.ground = false;
            cs2.net = net;
            int netIndex = net.getNetIndex();
            cs2.globalSignal = null;
            for (int j = 0; j < globalSize; ++j) {
                Global global = globals.get(j);
                if (cni.netList.getNetIndex(global) != netIndex) continue;
                cs2.globalSignal = global;
                break;
            }
            if (cs2.globalSignal != null) {
                cs2.name = this.getGlobalName(cs2.globalSignal);
            } else if (net.hasNames()) {
                String name = null;
                name = useExportedName && net.getExportedNames().hasNext() ? (String)net.getExportedNames().next() : (String)net.getNames().next();
                cs2.name = name;
            } else {
                cs2.name = net.describe();
                if (cs2.name.equals("")) {
                    cs2.name = "UNCONNECTED" + nullNameCount++;
                }
            }
            cni.cellSignals.put(net, cs2);
        }
        it = cell.getPorts();
        while (it.hasNext()) {
            String firstName;
            int openSquare;
            int i;
            Export pp = (Export)it.next();
            int portWidth = cni.netList.getBusWidth(pp);
            for (int i2 = 0; i2 < portWidth; ++i2) {
                JNetwork net = cni.netList.getNetwork(pp, i2);
                CellSignal cs3 = (CellSignal)cni.cellSignals.get(net);
                cs3.pp = pp;
                cs3.ppIndex = i2;
            }
            if (portWidth <= 1) continue;
            boolean upDir = false;
            boolean downDir = false;
            boolean randomDir = false;
            int last = 0;
            for (i = 0; i < portWidth && (subNet = cni.netList.getNetwork(pp, i)).hasNames() && (openSquare = (firstName = (String)subNet.getNames().next()).indexOf(91)) >= 0 && Character.isDigit(firstName.charAt(openSquare + 1)); ++i) {
                int index = TextUtils.atoi(firstName.substring(openSquare + 1));
                if (i != 0) {
                    if (index == last - 1) {
                        downDir = true;
                    } else if (index == last + 1) {
                        upDir = true;
                    } else {
                        randomDir = true;
                    }
                }
                last = index;
            }
            if (randomDir || upDir && downDir || !upDir && !downDir) continue;
            for (i = 0; i < portWidth; ++i) {
                subNet = cni.netList.getNetwork(pp, i);
                CellSignal cs4 = (CellSignal)cni.cellSignals.get(subNet);
                cs4.descending = downDir;
            }
        }
        cni.pwrNet = (cni.gndNet = null);
        boolean multiPwr = false;
        boolean multiGnd = false;
        Iterator eIt = cell.getPorts();
        while (eIt.hasNext()) {
            Export pp = (Export)eIt.next();
            int portWidth = cni.netList.getBusWidth(pp);
            if (portWidth > 1) continue;
            JNetwork subNet2 = cni.netList.getNetwork(pp, 0);
            if (pp.isPower()) {
                if (cni.pwrNet != null && cni.pwrNet != subNet2 && !multiPwr) {
                    if (!quiet) {
                        System.out.println("Warning: multiple power networks in cell " + cell.describe());
                    }
                    multiPwr = true;
                }
                cni.pwrNet = subNet2;
            }
            if (!pp.isGround()) continue;
            if (cni.gndNet != null && cni.gndNet != subNet2 && !multiGnd) {
                if (!quiet) {
                    System.out.println("Warning: multiple ground networks in cell " + cell.describe());
                }
                multiGnd = true;
            }
            cni.gndNet = subNet2;
        }
        Iterator it2 = cni.netList.getNetworks();
        while (it2.hasNext()) {
            JNetwork net = (JNetwork)it2.next();
            CellSignal cs5 = (CellSignal)cni.cellSignals.get(net);
            if (cs5.globalSignal == null) continue;
            if (cs5.globalSignal == Global.power) {
                if (cni.pwrNet != null && cni.pwrNet != net && !multiPwr) {
                    if (!quiet) {
                        System.out.println("Warning: multiple power networks in cell " + cell.describe());
                    }
                    multiPwr = true;
                }
                cni.pwrNet = net;
            }
            if (cs5.globalSignal != Global.ground) continue;
            if (cni.gndNet != null && cni.gndNet != net && !multiGnd) {
                if (!quiet) {
                    System.out.println("Warning: multiple ground networks in cell " + cell.describe());
                }
                multiGnd = true;
            }
            cni.gndNet = net;
        }
        it2 = cell.getNodes();
        while (it2.hasNext()) {
            NodeInst ni = (NodeInst)it2.next();
            NodeProto.Function fun = ni.getFunction();
            if (fun != NodeProto.Function.CONPOWER && fun != NodeProto.Function.CONGROUND) continue;
            Iterator cIt = ni.getConnections();
            while (cIt.hasNext()) {
                Connection con = (Connection)cIt.next();
                ArcInst ai = con.getArc();
                subNet = cni.netList.getNetwork(ai, 0);
                if (fun == NodeProto.Function.CONPOWER) {
                    if (cni.pwrNet != null && cni.pwrNet != subNet && !multiPwr) {
                        if (!quiet) {
                            System.out.println("Warning: multiple power networks in cell " + cell.describe());
                        }
                        multiPwr = true;
                    }
                    cni.pwrNet = subNet;
                    continue;
                }
                if (cni.gndNet != null && cni.gndNet != subNet && !multiGnd) {
                    if (!quiet) {
                        System.out.println("Warning: multiple ground networks in cell " + cell.describe());
                    }
                    multiGnd = true;
                }
                cni.gndNet = subNet;
            }
        }
        if (cni.pwrNet != null) {
            cs = (CellSignal)cni.cellSignals.get(cni.pwrNet);
            cs.name = this.getPowerName();
            cs.power = true;
        }
        if (cni.gndNet != null) {
            cs = (CellSignal)cni.cellSignals.get(cni.gndNet);
            cs.name = this.getGroundName();
            cs.ground = true;
        }
        it2 = cni.netList.getNetworks();
        while (it2.hasNext()) {
            JNetwork net = (JNetwork)it2.next();
            CellSignal cs6 = (CellSignal)cni.cellSignals.get(net);
            if (cs6.pp == null) continue;
            int widestFound = -1;
            Export widestPp = null;
            Iterator eIt2 = cell.getPorts();
            while (eIt2.hasNext()) {
                Export pp = (Export)eIt2.next();
                int portWidth = cni.netList.getBusWidth(pp);
                boolean found = false;
                for (int j = 0; j < portWidth; ++j) {
                    JNetwork subNet3 = cni.netList.getNetwork(pp, j);
                    if (subNet3 != net) continue;
                    found = true;
                }
                if (!found || portWidth <= widestFound) continue;
                widestFound = portWidth;
                widestPp = pp;
            }
            if (widestPp == null) continue;
            cs6.pp = widestPp;
        }
        ArrayList cellSignalArray = new ArrayList();
        Iterator it3 = cni.cellSignals.values().iterator();
        while (it3.hasNext()) {
            cellSignalArray.add(it3.next());
        }
        Collections.sort(cellSignalArray, new SortNetsByName());
        cni.cellAggretateSignals = new ArrayList();
        int total = cellSignalArray.size();
        boolean emptyName = true;
        for (int i = 0; i < total; ++i) {
            CellSignal cs7 = (CellSignal)cellSignalArray.get(i);
            CellAggregateSignal cas = new CellAggregateSignal();
            cas.name = Topology.unIndexedName(cs7.name);
            cas.pp = cs7.pp;
            cas.ppIndex = cs7.ppIndex;
            cas.supply = cs7.power | cs7.ground;
            cas.descending = cs7.descending;
            cas.flags = 0;
            cs7.aggregateSignal = cas;
            if (cs7.name.equals(cas.name)) {
                cas.low = 1;
                cas.high = 0;
                CellAggregateSignal.access$2602(cas, new CellSignal[1]);
                ((CellAggregateSignal)cas).signals[0] = cs7;
            } else {
                int index;
                String endName;
                String ept;
                CellSignal csEnd;
                cas.high = (cas.low = TextUtils.atoi(cs7.name.substring(cas.name.length() + 1)));
                int start = i;
                int j = i + 1;
                while (j < total && (csEnd = (CellSignal)cellSignalArray.get(j)).descending == cs7.descending && csEnd.pp == cs7.pp && csEnd.globalSignal == cs7.globalSignal && !(ept = Topology.unIndexedName(endName = csEnd.name)).equals(endName) && (index = TextUtils.atoi(endName.substring(ept.length() + 1))) == cas.high + 1) {
                    if (index > cas.high) {
                        cas.high = index;
                    }
                    i = j++;
                    csEnd.aggregateSignal = cas;
                }
                CellAggregateSignal.access$2602(cas, new CellSignal[i - start + 1]);
                for (j = start; j <= i; ++j) {
                    ((CellAggregateSignal)cas).signals[j - start] = csEnd = (CellSignal)cellSignalArray.get(j);
                }
            }
            cni.cellAggretateSignals.add(cas);
        }
        Iterator it4 = cni.cellAggretateSignals.iterator();
        while (it4.hasNext()) {
            CellAggregateSignal cas = (CellAggregateSignal)it4.next();
            cas.name = this.getSafeNetName(cas.name);
        }
        int numNameList = cni.cellAggretateSignals.size();
        block18: for (int i = 1; i < numNameList; ++i) {
            CellAggregateSignal cas = (CellAggregateSignal)cni.cellAggretateSignals.get(i);
            for (int k = 0; k < 1000; ++k) {
                String ninName = cas.name;
                if (k > 0) {
                    ninName = ninName + "_" + k;
                }
                boolean found = false;
                for (int j = 0; j < i; ++j) {
                    CellAggregateSignal oCas = (CellAggregateSignal)cni.cellAggretateSignals.get(j);
                    if (ninName.equals(oCas.name)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                if (k <= 0) continue block18;
                cas.name = ninName;
                continue block18;
            }
        }
        Iterator it5 = cni.cellAggretateSignals.iterator();
        while (it5.hasNext()) {
            CellAggregateSignal cas = (CellAggregateSignal)it5.next();
            if (cas.low > cas.high) {
                CellSignal cs8 = cas.signals[0];
                cs8.name = cas.name;
                continue;
            }
            for (int k = cas.low; k <= cas.high; ++k) {
                CellSignal cs9 = cas.signals[k - cas.low];
                cs9.name = cas.name + "[" + k + "]";
            }
        }
        return cni;
    }

    protected static String unIndexedName(String name) {
        char theChr;
        int i;
        int len = name.length();
        if (len == 0) {
            return name;
        }
        if (name.charAt(len - 1) != ']') {
            return name;
        }
        for (i = len - 2; i > 0 && (theChr = name.charAt(i)) != '[' && (theChr == ':' || theChr == ',' || Character.isDigit(theChr)); --i) {
        }
        if (name.charAt(i) != '[') {
            return name;
        }
        return name.substring(0, i);
    }

    protected String parameterizedName(Nodable no, VarContext context) {
        int limit;
        Cell cell = (Cell)no.getProto();
        String uniqueCellName = this.getUniqueCellName(cell);
        if (this.canParameterizeNames() && no.getProto() instanceof Cell) {
            HashMap<Variable.Key, Variable> paramValues = new HashMap<Variable.Key, Variable>();
            Iterator it = no.getVariables();
            while (it.hasNext()) {
                Variable var = (Variable)it.next();
                if (!var.getTextDescriptor().isParam()) continue;
                paramValues.put(var.getKey(), var);
            }
            it = paramValues.keySet().iterator();
            while (it.hasNext()) {
                Variable.Key key = (Variable.Key)it.next();
                Variable var = no.getVar(key.getName());
                Object eval = context.evalVar(var, no);
                if (eval == null) continue;
                uniqueCellName = uniqueCellName + "-" + var.getTrueName() + "-" + eval.toString();
            }
        }
        if ((limit = this.maxNameLength()) > 0 && uniqueCellName.length() > limit) {
            int ckSum = 0;
            for (int i = 0; i < uniqueCellName.length(); ++i) {
                ckSum += uniqueCellName.charAt(i);
            }
            uniqueCellName = uniqueCellName.substring(0, limit - 10) + "-TRUNC" + (ckSum %= 9999);
        }
        return this.getSafeCellName(uniqueCellName);
    }

    private String getUniqueCellName(Cell cell) {
        String name = (String)this.cellNameMap.get(cell);
        return name;
    }

    private void makeCellNameMap() {
        this.cellNameMap = new HashMap();
        Iterator lIt = Library.getLibraries();
        while (lIt.hasNext()) {
            Library lib = (Library)lIt.next();
            if (lib.isHidden()) continue;
            Iterator cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = (Cell)cIt.next();
                boolean duplicate = false;
                Iterator oLIt = Library.getLibraries();
                while (oLIt.hasNext()) {
                    Library oLib = (Library)oLIt.next();
                    if (oLib.isHidden() || oLib == lib) continue;
                    Iterator oCIt = oLib.getCells();
                    while (oCIt.hasNext()) {
                        Cell oCell = (Cell)oCIt.next();
                        if (!cell.getName().equalsIgnoreCase(oCell.getName())) continue;
                        duplicate = true;
                        break;
                    }
                    if (!duplicate) continue;
                    break;
                }
                if (duplicate) {
                    this.cellNameMap.put(cell, cell.getLibrary().getName() + "__" + cell.getName());
                    continue;
                }
                this.cellNameMap.put(cell, cell.getName());
            }
        }
    }

    private static class SortNetsByName
    implements Comparator {
        private SortNetsByName() {
        }

        public int compare(Object o1, Object o2) {
            PortProto.Characteristic ch2;
            PortProto.Characteristic ch1;
            CellSignal cs1 = (CellSignal)o1;
            CellSignal cs2 = (CellSignal)o2;
            if (cs1.pp == null != (cs2.pp == null)) {
                return cs1.pp == null ? 1 : -1;
            }
            if (cs1.pp != null && cs2.pp != null && (ch1 = cs1.pp.getCharacteristic()) != (ch2 = cs2.pp.getCharacteristic())) {
                return ch1.getOrder() - ch2.getOrder();
            }
            if (cs1.descending != cs2.descending) {
                return cs1.descending ? 1 : -1;
            }
            return TextUtils.nameSameNumeric(cs1.name, cs2.name);
        }
    }

    protected static class CellNetInfo {
        private String paramName;
        private HashMap cellSignals;
        private List cellAggretateSignals;
        private JNetwork pwrNet;
        private JNetwork gndNet;
        private Netlist netList;

        protected CellNetInfo() {
        }

        protected CellSignal getCellSignal(JNetwork net) {
            return (CellSignal)this.cellSignals.get(net);
        }

        protected Iterator getCellSignals() {
            return this.cellSignals.values().iterator();
        }

        protected Iterator getCellAggregateSignals() {
            return this.cellAggretateSignals.iterator();
        }

        protected String getParameterizedName() {
            return this.paramName;
        }

        protected JNetwork getPowerNet() {
            return this.pwrNet;
        }

        protected JNetwork getGroundNet() {
            return this.gndNet;
        }

        protected Netlist getNetList() {
            return this.netList;
        }
    }

    protected static class CellAggregateSignal {
        private String name;
        private Export pp;
        private int ppIndex;
        private int low;
        private int high;
        private boolean supply;
        private boolean descending;
        private CellSignal[] signals;
        private int flags;

        protected CellAggregateSignal() {
        }

        protected String getName() {
            return this.name;
        }

        protected boolean isDescending() {
            return this.descending;
        }

        protected boolean isSupply() {
            return this.supply;
        }

        protected Export getExport() {
            return this.pp;
        }

        protected int getExportIndex() {
            return this.ppIndex;
        }

        protected int getLowIndex() {
            return this.low;
        }

        protected int getHighIndex() {
            return this.high;
        }

        protected int getFlags() {
            return this.flags;
        }

        protected void setFlags(int flags) {
            this.flags = flags;
        }

        protected boolean isGlobal() {
            int numGlobal = 0;
            for (int i = 0; i < this.signals.length; ++i) {
                CellSignal cs = this.signals[i];
                if (!cs.isGlobal()) continue;
                ++numGlobal;
            }
            return numGlobal > 0 && numGlobal == this.signals.length;
        }

        static /* synthetic */ CellSignal[] access$2602(CellAggregateSignal x0, CellSignal[] x1) {
            x0.signals = x1;
            return x1;
        }
    }

    protected static class CellSignal {
        private String name;
        private JNetwork net;
        private CellAggregateSignal aggregateSignal;
        private Export pp;
        private int ppIndex;
        private boolean descending;
        private boolean power;
        private boolean ground;
        private Global globalSignal;

        protected CellSignal() {
        }

        protected String getName() {
            return this.name;
        }

        protected JNetwork getNetwork() {
            return this.net;
        }

        protected Export getExport() {
            return this.pp;
        }

        protected int getExportIndex() {
            return this.ppIndex;
        }

        protected CellAggregateSignal getAggregateSignal() {
            return this.aggregateSignal;
        }

        protected boolean isDescending() {
            return this.descending;
        }

        protected boolean isGlobal() {
            return this.globalSignal != null;
        }

        protected boolean isPower() {
            return this.power;
        }

        protected boolean isGround() {
            return this.ground;
        }

        protected boolean isExported() {
            return this.pp != null;
        }
    }

    public class Visitor
    extends HierarchyEnumerator.Visitor {
        private Topology outGeom;

        public Visitor(Topology outGeom) {
            this.outGeom = outGeom;
        }

        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            return !Topology.this.skipCellAndSubcells(info.getCell());
        }

        public void exitCell(HierarchyEnumerator.CellInfo info) {
            Cell cell = info.getCell();
            CellNetInfo cni = null;
            if (info.isRootCell()) {
                cni = Topology.this.getNetworkInformation(cell, false, cell.getName(), Topology.this.isNetworksUseExportedNames());
            } else {
                MyCellInfo mci = (MyCellInfo)info;
                mci = (MyCellInfo)mci.getParentInfo();
                cni = Topology.this.getCellNetInfo(mci.currentInstanceParametizedName);
            }
            this.outGeom.writeCellTopology(cell, cni, info.getContext());
        }

        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            NodeProto np = no.getProto();
            if (np instanceof PrimitiveNode) {
                return false;
            }
            MyCellInfo mci = (MyCellInfo)info;
            VarContext context = info.getContext();
            mci.currentInstanceParametizedName = Topology.this.parameterizedName(no, context);
            if (Topology.this.cellTopos.containsKey(mci.currentInstanceParametizedName)) {
                return false;
            }
            Cell cell = (Cell)np;
            Netlist netList = Topology.this.getNetlistForCell(cell);
            CellNetInfo cni = Topology.this.getNetworkInformation(cell, false, mci.currentInstanceParametizedName, Topology.this.isNetworksUseExportedNames());
            Topology.this.cellTopos.put(mci.currentInstanceParametizedName, cni);
            return true;
        }

        public HierarchyEnumerator.CellInfo newCellInfo() {
            return new MyCellInfo();
        }
    }

    public class MyCellInfo
    extends HierarchyEnumerator.CellInfo {
        String currentInstanceParametizedName;
    }
}

