/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.CellUsage;
import com.sun.electric.tool.ncc.NccEngine;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.processing.HierarchyInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class NccBottomUp {
    private CellUsage getCellUsage(Cell root) {
        CellUsage visitor = new CellUsage();
        HierarchyEnumerator.enumerateCell(root, null, null, visitor);
        return visitor;
    }

    private boolean compareTwo(Cell schematic, Cell layout, HierarchyInfo hierInfo, NccOptions options) {
        if (NccUtils.hasSkipAnnotation(schematic)) {
            return true;
        }
        if (NccUtils.hasSkipAnnotation(layout)) {
            return true;
        }
        System.out.println("Comparing: " + NccUtils.fullName(schematic) + " with: " + NccUtils.fullName(layout));
        return NccEngine.compare(schematic, null, layout, null, hierInfo, options);
    }

    private Cell selectAndRemoveReferenceCell(List cells) {
        Iterator it = cells.iterator();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            if (cell.getView() != View.SCHEMATIC) continue;
            it.remove();
            return cell;
        }
        it = cells.iterator();
        Cell refCell = (Cell)it.next();
        it.remove();
        return refCell;
    }

    private boolean compareCellsInGroup(List cellsInGroup, String groupName, HierarchyInfo hierInfo, NccOptions options) {
        if (cellsInGroup.size() < 2) {
            return true;
        }
        Cell refCell = this.selectAndRemoveReferenceCell(cellsInGroup);
        if (hierInfo != null) {
            hierInfo.nextSubcircuit(groupName);
        }
        boolean match = true;
        Iterator it = cellsInGroup.iterator();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            match &= this.compareTwo(refCell, cell, hierInfo, options);
        }
        return match;
    }

    private List getUsedCellsInGroup(Cell cell, CellUsage use1, CellUsage use2) {
        Cell onlyCell;
        NccCellAnnotations ann = NccCellAnnotations.getAnnotations(cell);
        Cell.CellGroup group = cell.getCellGroup();
        if (ann != null && ann.getGroupToJoin() != null && ann.getGroupToJoin() != group) {
            return new ArrayList();
        }
        HashSet<Cell> cellsInGroup = new HashSet<Cell>();
        cellsInGroup.addAll(use1.getGroupAdditions(group));
        cellsInGroup.addAll(use2.getGroupAdditions(group));
        Iterator gi = group.getCells();
        while (gi.hasNext()) {
            Cell c = (Cell)gi.next();
            if (!use1.cellIsUsed(c) && !use2.cellIsUsed(c)) continue;
            cellsInGroup.add(c);
        }
        LayoutLib.error(cellsInGroup.size() == 0, "Cell not in its own group?");
        ArrayList<Cell> cellsInGroupList = new ArrayList<Cell>();
        cellsInGroupList.addAll(cellsInGroup);
        if (cellsInGroup.size() == 1 && use1.cellIsUsed(onlyCell = (Cell)cellsInGroup.iterator().next()) && use2.cellIsUsed(onlyCell)) {
            cellsInGroupList.add(onlyCell);
        }
        return cellsInGroupList;
    }

    private boolean compareCellGroups(CellUsage use1, CellUsage use2, boolean hierarchical, NccOptions options) {
        boolean match = true;
        HierarchyInfo hierInfo = hierarchical ? new HierarchyInfo() : null;
        Iterator it = use1.cellsInReverseTopologicalOrder();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            List cellsInGroup = this.getUsedCellsInGroup(cell, use1, use2);
            String grpNm = cell.getLibrary().getName() + ":" + cell.getName();
            match &= this.compareCellsInGroup(cellsInGroup, grpNm, hierInfo, options);
            String cellNm = cell.getName();
            if (cellNm.equals("mem_core_36") || cellNm.equals("mem_core_45")) {
                match = true;
            }
            if (match || !options.haltAfterFirstMismatch) continue;
            System.out.println("Halting multiple cell NCC after finding first mismatch");
            return false;
        }
        return match;
    }

    private boolean compareCells(Cell c1, Cell c2, boolean hierarchical, NccOptions options) {
        CellUsage use1 = this.getCellUsage(c1);
        CellUsage use2 = this.getCellUsage(c2);
        return this.compareCellGroups(use1, use2, hierarchical, options);
    }

    public static boolean compare(Cell c1, Cell c2, boolean hierarchical, NccOptions options) {
        options.checkSizes = false;
        NccBottomUp ncch = new NccBottomUp();
        return ncch.compareCells(c1, c2, hierarchical, options);
    }
}

