/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.jemNets.NccNetlist;
import com.sun.electric.tool.ncc.processing.ExportChecker;
import com.sun.electric.tool.ncc.processing.HashCodePartitioning;
import com.sun.electric.tool.ncc.processing.HierarchyInfo;
import com.sun.electric.tool.ncc.processing.LocalPartitioning;
import com.sun.electric.tool.ncc.processing.SerialParallelMerge;
import com.sun.electric.tool.ncc.strategy.StratCheck;
import com.sun.electric.tool.ncc.strategy.StratCheckSizes;
import com.sun.electric.tool.ncc.strategy.StratCount;
import com.sun.electric.tool.ncc.strategy.StratDebug;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NccEngine {
    private NccGlobals globals;

    private List buildNccNetlists(List cells, List contexts, List netlists, HierarchyInfo hierInfo) {
        this.globals.error(cells.size() != contexts.size() || contexts.size() != netlists.size(), "number of cells, contexts, and netlists must be the same");
        ArrayList<NccNetlist> nccLists = new ArrayList<NccNetlist>();
        Iterator itCell = cells.iterator();
        Iterator itCon = contexts.iterator();
        Iterator itNet = netlists.iterator();
        while (itCell.hasNext()) {
            Cell cell = (Cell)itCell.next();
            VarContext context = (VarContext)itCon.next();
            Netlist netlist = (Netlist)itNet.next();
            NccNetlist nccList = new NccNetlist(cell, context, netlist, hierInfo, this.globals);
            nccLists.add(nccList);
        }
        return nccLists;
    }

    private boolean designsMatch(HierarchyInfo hierInfo) {
        boolean OK;
        if (this.globals.getRoot() == null) {
            this.globals.println("empty cell");
            return true;
        }
        ExportChecker expCheck = new ExportChecker(this.globals);
        boolean expNamesOK = expCheck.matchByName();
        expCheck.saveInfoNeededToMakeMeASubcircuit(hierInfo);
        EquivRecord root = this.globals.getRoot();
        StratCheck.doYourJob(root, this.globals);
        StratCount.doYourJob(root, this.globals);
        SerialParallelMerge.doYourJob(this.globals);
        StratCheck.doYourJob(root, this.globals);
        StratCount.doYourJob(root, this.globals);
        boolean localOK = LocalPartitioning.doYourJob(this.globals);
        if (!localOK) {
            return false;
        }
        boolean topoOK = HashCodePartitioning.doYourJob(this.globals);
        boolean expTopoOK = expCheck.ensureExportsWithMatchingNamesAreOnEquivalentNets();
        boolean sizesOK = StratCheckSizes.doYourJob(this.globals);
        boolean bl = OK = localOK && expNamesOK && topoOK && expTopoOK && sizesOK;
        if (!topoOK) {
            StratDebug.doYourJob(this.globals);
        }
        return OK;
    }

    private boolean areEquivalent(List cells, List contexts, List netlists, HierarchyInfo hierInfo, NccOptions options) {
        this.globals = new NccGlobals(options);
        this.globals.println("********************************************************************************");
        List nccNetlists = this.buildNccNetlists(cells, contexts, netlists, hierInfo);
        this.globals.setInitialNetlists(nccNetlists);
        boolean match = this.designsMatch(hierInfo);
        this.globals.println("********************************************************************************");
        return match;
    }

    public static boolean compare(List cells, List contexts, List netlists, HierarchyInfo hierCompInfo, NccOptions options) {
        NccEngine ncc = new NccEngine();
        return ncc.areEquivalent(cells, contexts, netlists, hierCompInfo, options);
    }

    public static boolean compare(Cell cell1, VarContext context1, Cell cell2, VarContext context2, HierarchyInfo hierInfo, NccOptions options) {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        cells.add(cell1);
        cells.add(cell2);
        ArrayList<VarContext> contexts = new ArrayList<VarContext>();
        contexts.add(context1);
        contexts.add(context2);
        ArrayList<Netlist> netlists = new ArrayList<Netlist>();
        netlists.add(cell1.getNetlist(true));
        netlists.add(cell2.getNetlist(true));
        return NccEngine.compare(cells, contexts, netlists, hierInfo, options);
    }
}

