/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.strategy;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import com.sun.electric.tool.ncc.trees.NetObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class StratDebug2
extends Strategy {
    private StratDebug2(NccGlobals globals) {
        super(globals);
        NccOptions options = globals.getOptions();
        boolean savedVerbose = options.verbose;
        options.verbose = true;
        globals.println("begin search for RK stuff");
        this.doFor(globals.getRoot());
        globals.println("end search for RK stuff");
        options.verbose = savedVerbose;
    }

    private boolean hasRKstuff(Circuit ckt) {
        Iterator it = ckt.getNetObjs();
        while (it.hasNext()) {
            NetObject no = (NetObject)it.next();
            String name = no.getName();
            if (name.indexOf("/rks_") != -1) {
                return true;
            }
            if (name.indexOf("/rkl_") == -1) continue;
            return true;
        }
        return false;
    }

    private boolean hasRKstuff(EquivRecord er) {
        Iterator it = er.getCircuits();
        while (it.hasNext()) {
            Circuit ckt = (Circuit)it.next();
            if (!this.hasRKstuff(ckt)) continue;
            return true;
        }
        return false;
    }

    public LeafList doFor(EquivRecord er) {
        if (er.isLeaf()) {
            if (this.hasRKstuff(er)) {
                this.globals.println(er.nameString());
                List reasons = er.getPartitionReasonsFromRootToMe();
                Iterator it = reasons.iterator();
                while (it.hasNext()) {
                    this.globals.println("   " + it.next());
                }
                super.doFor(er);
            }
        } else {
            super.doFor(er);
        }
        return new LeafList();
    }

    public HashMap doFor(Circuit c) {
        this.globals.println(" " + c.nameString());
        return super.doFor(c);
    }

    public Integer doFor(NetObject n) {
        this.globals.println("  " + n.toString());
        return CODE_NO_CHANGE;
    }

    public static void doYourJob(NccGlobals globals) {
        new StratDebug2(globals);
    }
}

