/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.strategy;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import com.sun.electric.tool.ncc.trees.NetObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StratPreanalysisReport
extends Strategy {
    private static final NetObject.Type PART = NetObject.Type.PART;
    private static final NetObject.Type PORT = NetObject.Type.PORT;
    List mismatched = new ArrayList();

    private StratPreanalysisReport(NccGlobals globals) {
        super(globals);
    }

    private boolean doYourJob2(NccGlobals globals) {
        this.doFor(globals.getRoot());
        this.summary();
        return this.mismatched.size() == 0;
    }

    private void prln(String s) {
        this.globals.println(s);
    }

    private void printCircuitContents(Circuit ckt, int cktNdx, String t) {
        String cktName = this.globals.getRootCellNames()[cktNdx];
        int numNetObjs = ckt.numNetObjs();
        this.prln("  In " + cktName + " " + numNetObjs + " " + t + " have these characteristics: ");
        Iterator it = ckt.getNetObjs();
        while (it.hasNext()) {
            NetObject o = (NetObject)it.next();
            this.prln("    " + o.toString());
        }
    }

    private void printMismatchedRecord(EquivRecord r) {
        String t = r.getNetObjType() == PART ? "parts" : "wires";
        this.prln("The " + t + " in this set share the following characteristics:");
        List reasons = r.getPartitionReasonsFromRootToMe();
        Iterator it = reasons.iterator();
        while (it.hasNext()) {
            this.prln("    " + it.next());
        }
        int cktNdx = 0;
        Iterator it2 = r.getCircuits();
        while (it2.hasNext()) {
            Circuit ckt = (Circuit)it2.next();
            this.printCircuitContents(ckt, cktNdx, t);
            ++cktNdx;
        }
    }

    private void summary() {
        NccOptions options = this.globals.getOptions();
        boolean savedVerbose = options.verbose;
        options.verbose = true;
        if (this.mismatched.size() != 0) {
            this.globals.println("\nMismatches found during local processing:\n");
        }
        Iterator it = this.mismatched.iterator();
        while (it.hasNext()) {
            EquivRecord r = (EquivRecord)it.next();
            this.printMismatchedRecord(r);
        }
        options.verbose = savedVerbose;
    }

    public LeafList doFor(EquivRecord g) {
        if (g.isLeaf()) {
            if (g.isMismatched() && g.getNetObjType() != PORT) {
                this.mismatched.add(g);
            }
            return new LeafList();
        }
        return super.doFor(g);
    }

    public static boolean doYourJob(NccGlobals globals) {
        StratPreanalysisReport wp = new StratPreanalysisReport(globals);
        return wp.doYourJob2(globals);
    }
}

