/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.trees;

import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.jemNets.Port;
import com.sun.electric.tool.ncc.jemNets.Wire;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import com.sun.electric.tool.ncc.trees.NetObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Circuit {
    private EquivRecord myParent;
    private Set content = new HashSet();

    private Circuit() {
    }

    public static Circuit please(List netObjs) {
        Circuit ckt = new Circuit();
        Iterator it = netObjs.iterator();
        while (it.hasNext()) {
            ckt.adopt((NetObject)it.next());
        }
        return ckt;
    }

    public Iterator getNetObjs() {
        return this.content.iterator();
    }

    public int numNetObjs() {
        return this.content.size();
    }

    public void adopt(NetObject n) {
        this.content.add(n);
        n.setParent(this);
    }

    public void remove(NetObject n) {
        this.content.remove(n);
    }

    public static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    public void checkMe(EquivRecord parent) {
        Circuit.error(this.getParent() != parent, "wrong parent");
    }

    public Map getExportMap() {
        HashMap<String, Wire> out = new HashMap<String, Wire>();
        Iterator it = this.getNetObjs();
        while (it.hasNext()) {
            NetObject n = (NetObject)it.next();
            Circuit.error(!(n instanceof Wire), "getExportMap expects only Wires");
            Wire w = (Wire)n;
            Port p = w.getPort();
            if (p == null) continue;
            Iterator ni = p.getExportNames();
            while (ni.hasNext()) {
                String exportNm = (String)ni.next();
                Circuit.error(out.containsKey(exportNm), "different wires have the same export name?");
                out.put(exportNm, w);
            }
        }
        return out;
    }

    public String nameString() {
        return "Circuit code=" + this.getCode() + " size=" + this.numNetObjs();
    }

    public int getCode() {
        return this.myParent != null ? this.myParent.getCode() : 0;
    }

    public EquivRecord getParent() {
        return this.myParent;
    }

    public void setParent(EquivRecord p) {
        this.myParent = p;
    }

    public HashMap apply(Strategy js) {
        HashMap<Integer, ArrayList<NetObject>> codeToNetObjs = new HashMap<Integer, ArrayList<NetObject>>();
        Iterator it = this.getNetObjs();
        while (it.hasNext()) {
            NetObject no = (NetObject)it.next();
            Integer code = js.doFor(no);
            Circuit.error(code == null, "null is no longer a legal code");
            ArrayList<NetObject> ns = (ArrayList<NetObject>)codeToNetObjs.get(code);
            if (ns == null) {
                ns = new ArrayList<NetObject>();
                codeToNetObjs.put(code, ns);
            }
            ns.add(no);
        }
        return codeToNetObjs;
    }

    public static void printTheMap(Map m, NccGlobals globals) {
        globals.println("printing a Circuit map of size= " + m.size());
        if (m.size() == 0) {
            return;
        }
        Iterator it = m.keySet().iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            Object oo = m.get(s);
            if (oo == null) {
                globals.println(s + " maps to null");
                continue;
            }
            Wire w = (Wire)oo;
            globals.println(s + " maps to " + w.nameString());
        }
    }
}

