/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.TextAttributesPanel;
import com.sun.electric.tool.user.dialogs.TextInfoPanel;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class GetInfoText
extends EDialog
implements HighlightListener,
DatabaseChangeListener {
    private static GetInfoText theDialog = null;
    private Highlight shownText;
    private String initialText;
    private Variable var;
    private TextDescriptor td;
    private ElectricObject owner;
    private JButton apply;
    private JButton cancel;
    private JLabel evaluation;
    private JLabel header;
    private JButton ok;
    private JTextComponent theText;
    private JPanel buttonsPanel;
    private TextInfoPanel textPanel;
    private TextAttributesPanel attrPanel;
    private JCheckBox multiLine;

    public static void showDialog() {
        if (theDialog == null) {
            if (TopLevel.isMDIMode()) {
                TopLevel jf = TopLevel.getCurrentJFrame();
                theDialog = new GetInfoText((Frame)jf, false);
            } else {
                theDialog = new GetInfoText(null, false);
            }
        }
        theDialog.loadTextInfo();
        if (!theDialog.isVisible()) {
            theDialog.pack();
        }
        theDialog.setVisible(true);
    }

    public void highlightChanged() {
        if (!this.isVisible()) {
            return;
        }
        this.loadTextInfo();
    }

    public void databaseEndChangeBatch(Undo.ChangeBatch batch) {
        if (!this.isVisible()) {
            return;
        }
        boolean reload = false;
        Iterator it = batch.getChanges();
        while (it.hasNext()) {
            Undo.Change change = (Undo.Change)it.next();
            ElectricObject obj = change.getObject();
            if (obj != this.owner) continue;
            reload = true;
            break;
        }
        if (reload) {
            this.loadTextInfo();
        }
    }

    public void databaseChanged(Undo.Change change) {
    }

    private void loadTextInfo() {
        Highlight textHighlight = null;
        int textCount = 0;
        Iterator it = Highlight.getHighlights();
        while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            if (h.getType() != Highlight.Type.TEXT || h.getVar() == null && h.getElectricObject() instanceof Export) continue;
            textHighlight = h;
            ++textCount;
        }
        if (textCount > 1) {
            textHighlight = null;
        }
        boolean enabled = textHighlight != null;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component c = this.getComponent(i);
            c.setEnabled(enabled);
        }
        if (!enabled) {
            this.header.setText("No Text Selected");
            this.evaluation.setText(" ");
            this.theText.setText("");
            this.theText.setEnabled(false);
            this.shownText = null;
            this.textPanel.setTextDescriptor(null, null, null);
            this.attrPanel.setVariable(null, null, null, null);
            this.ok.setEnabled(false);
            this.apply.setEnabled(false);
            this.multiLine.setEnabled(false);
            return;
        }
        this.ok.setEnabled(true);
        this.apply.setEnabled(true);
        String description = "Unknown text";
        this.initialText = "";
        this.td = null;
        this.owner = textHighlight.getElectricObject();
        NodeInst ni = null;
        if (this.owner instanceof NodeInst) {
            ni = (NodeInst)this.owner;
        }
        this.var = textHighlight.getVar();
        if (this.var != null) {
            this.td = this.var.getTextDescriptor();
            Object obj = this.var.getObject();
            if (obj instanceof Object[]) {
                Object[] theArray = (Object[])obj;
                this.initialText = "";
                for (int i = 0; i < theArray.length; ++i) {
                    if (i != 0) {
                        this.initialText = this.initialText + "\n";
                    }
                    this.initialText = this.initialText + theArray[i];
                }
            } else {
                this.initialText = this.var.getPureValue(-1, -1);
            }
            description = this.var.getFullDescription(this.owner);
        } else if (textHighlight.getName() != null) {
            if (this.owner instanceof Geometric) {
                Geometric geom = (Geometric)this.owner;
                this.td = geom.getNameTextDescriptor();
                description = geom instanceof NodeInst ? "Name of node " + ((NodeInst)geom).getProto().describe() : "Name of arc " + ((ArcInst)geom).getProto().describe();
                this.initialText = geom.getName();
            }
        } else if (this.owner instanceof NodeInst) {
            description = "Name of cell instance " + ni.describe();
            this.td = ni.getProtoTextDescriptor();
            this.initialText = ni.getProto().describe();
        }
        this.shownText = textHighlight;
        this.header.setText(description);
        this.theText.setText(this.initialText);
        this.theText.setEditable(true);
        if (this.initialText.indexOf(10) != -1) {
            if (this.var == null && this.shownText != null && this.shownText.getName() != null) {
                this.multiLine.setEnabled(false);
                this.multiLine.setSelected(false);
            } else {
                this.multiLine.setEnabled(true);
                this.multiLine.setSelected(true);
            }
        } else {
            if (this.var == null && this.shownText != null && this.shownText.getName() != null) {
                this.multiLine.setEnabled(false);
            } else {
                this.multiLine.setEnabled(true);
            }
            this.multiLine.setSelected(false);
        }
        this.evaluation.setText(" ");
        if (this.var != null && this.var.isCode()) {
            this.evaluation.setText("Evaluation: " + this.var.describe(-1, -1));
        }
        this.textPanel.setTextDescriptor(this.td, null, this.owner);
        this.attrPanel.setVariable(this.var, this.td, null, this.owner);
        this.changeTextComponent(this.initialText, this.multiLine.isSelected());
    }

    private GetInfoText(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        this.setLocation(100, 50);
        Highlight.addHighlightListener(this);
        Undo.addDatabaseChangeListener(this);
        this.loadTextInfo();
    }

    protected void escapePressed() {
        this.cancelActionPerformed(null);
    }

    private void initComponents() {
        this.cancel = new JButton();
        this.ok = new JButton();
        this.header = new JLabel();
        this.apply = new JButton();
        this.evaluation = new JLabel();
        this.theText = new JTextField();
        this.textPanel = new TextInfoPanel();
        this.attrPanel = new TextAttributesPanel();
        this.buttonsPanel = new JPanel();
        this.multiLine = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.getRootPane().setDefaultButton(this.ok);
        this.setTitle("Text Properties");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GetInfoText.this.closeDialog(evt);
            }
        });
        this.header.setText("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.header, gridBagConstraints);
        this.changeTextComponent("", false);
        this.multiLine.setText("Multi-Line Text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.multiLine, gridBagConstraints);
        this.multiLine.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GetInfoText.this.multiLineStateChanged();
            }
        });
        this.evaluation.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.evaluation, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.textPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.attrPanel, gridBagConstraints);
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoText.this.cancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.apply.setText("Apply");
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoText.this.applyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.apply, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoText.this.okActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.pack();
    }

    private void multiLineStateChanged() {
        this.changeTextComponent(this.theText.getText(), this.multiLine.isSelected());
    }

    private void changeTextComponent(String currentText, boolean multipleLines) {
        boolean enabled;
        boolean bl = enabled = this.shownText != null;
        if (!enabled) {
            return;
        }
        this.getContentPane().remove(this.theText);
        if (currentText == null) {
            currentText = "";
        }
        if (multipleLines) {
            int size;
            this.theText = new JTextArea();
            String[] text = currentText.split("\\n");
            if (text.length > (size = 1)) {
                size = text.length;
            }
            ((JTextArea)this.theText).setRows(size);
            ((JTextArea)this.theText).setBorder(BorderFactory.createBevelBorder(1));
            this.theText.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                }

                public void keyTyped(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                    JTextArea area = (JTextArea)GetInfoText.this.theText;
                    area.setRows(area.getLineCount());
                    GetInfoText.this.pack();
                }
            });
        } else {
            this.theText = new JTextField();
            JTextField field = (JTextField)this.theText;
            if (currentText.matches(".*?\\n.*")) {
                currentText = currentText.substring(0, currentText.indexOf(10));
            }
        }
        this.theText.setText(currentText);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.theText, gridBagConstraints);
        this.pack();
        this.theText.requestFocus();
    }

    private String getDelimtedText(JTextComponent c) {
        String currentText = c.getText();
        if (c instanceof JTextArea) {
            JTextArea area = (JTextArea)c;
            StringBuffer text = new StringBuffer();
            boolean first = true;
            for (int i = 0; i < area.getLineCount(); ++i) {
                try {
                    if (!first) {
                        text.append("\n");
                    }
                    int startPos = area.getLineStartOffset(i);
                    int endPos = area.getLineEndOffset(i);
                    text.append(currentText.substring(startPos, endPos));
                    System.out.println("Line " + i + " is: " + currentText.substring(startPos, endPos));
                    first = false;
                    continue;
                }
                catch (BadLocationException e) {
                    e.printStackTrace(System.out);
                }
            }
            currentText = text.toString();
        }
        return currentText;
    }

    private void applyActionPerformed(ActionEvent evt) {
        if (this.shownText == null) {
            return;
        }
        this.textPanel.applyChanges();
        this.attrPanel.applyChanges();
        boolean changed = false;
        String currentText = this.theText.getText();
        if (!currentText.equals(this.initialText)) {
            changed = true;
        }
        if (changed) {
            String str;
            int i;
            String[] textArray = currentText.split("\\n");
            ArrayList<String> textList = new ArrayList<String>();
            for (i = 0; i < textArray.length; ++i) {
                str = textArray[i];
                if ((str = str.trim()).equals("")) continue;
                textList.add(str);
            }
            textArray = new String[textList.size()];
            for (i = 0; i < textList.size(); ++i) {
                textArray[i] = str = (String)textList.get(i);
            }
            if (textArray.length > 0) {
                ChangeText job = new ChangeText(this.shownText, this.var, this.shownText.getName(), this.owner, textArray);
                this.initialText = currentText;
            }
        }
    }

    private void okActionPerformed(ActionEvent evt) {
        this.applyActionPerformed(evt);
        this.closeDialog(null);
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
    }

    protected static class ChangeText
    extends Job {
        Highlight shownText;
        Variable var;
        Name name;
        ElectricObject owner;
        String[] newText;

        protected ChangeText(Highlight shownText, Variable var, Name name, ElectricObject owner, String[] newText) {
            super("Modify Text", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.shownText = shownText;
            this.var = var;
            this.name = name;
            this.owner = owner;
            this.newText = newText;
            this.startJob();
        }

        public boolean doIt() {
            if (this.var != null) {
                Variable newVar = null;
                newVar = this.newText.length > 1 ? this.owner.updateVar(this.var.getKey(), (Object)this.newText) : this.owner.updateVar(this.var.getKey(), (Object)this.newText[0]);
                if (newVar != null) {
                    this.shownText.setVar(newVar);
                }
            } else if (this.name != null && this.owner != null) {
                ((Geometric)this.owner).setName(this.newText[0]);
            }
            return true;
        }
    }
}

