/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;

public class Progress {
    private JProgressBar progressBar;
    private JTextArea taskOutput;
    private JFrame jf;
    private JInternalFrame jif;

    public Progress(String title) {
        if (TopLevel.isMDIMode()) {
            this.jif = new JInternalFrame(title);
            this.jif.setSize(300, 80);
            this.jif.setLocation(300, 300);
        } else {
            this.jf = new JFrame(title);
            this.jf.setSize(300, 80);
            this.jf.setLocation(300, 300);
        }
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.taskOutput = new JTextArea();
        this.taskOutput.setMargin(new Insets(5, 5, 5, 5));
        this.taskOutput.setEditable(false);
        this.taskOutput.setCursor(null);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.progressBar, "Center");
        panel.add((Component)this.taskOutput, "South");
        if (TopLevel.isMDIMode()) {
            this.jif.getContentPane().add(panel);
            this.jif.show();
            TopLevel.addToDesktop(this.jif);
            this.jif.moveToFront();
        } else {
            this.jf.getContentPane().add(panel);
            this.jf.show();
        }
    }

    public void close() {
        if (TopLevel.isMDIMode()) {
            this.jif.dispose();
        } else {
            this.jf.dispose();
        }
    }

    public void setProgress(int progress) {
        if (progress < 0) {
            progress = 0;
        }
        if (progress > 100) {
            progress = 100;
        }
        this.progressBar.setValue(progress);
    }

    public int getProgress() {
        return this.progressBar.getValue();
    }

    public void setNote(String note) {
        this.taskOutput.setText(note);
    }

    public String getNote() {
        return this.taskOutput.getText();
    }
}

