/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.constraint.Layout;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.FlagSet;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class Spread
extends EDialog {
    private JButton cancel;
    private ButtonGroup direction;
    private JLabel jLabel1;
    private JButton ok;
    private JTextField spreadAmount;
    private JRadioButton spreadDown;
    private JRadioButton spreadLeft;
    private JRadioButton spreadRight;
    private JRadioButton spreadUp;

    public static void showSpreadDialog() {
        NodeInst ni = (NodeInst)Highlight.getOneElectricObject(NodeInst.class);
        if (ni == null) {
            return;
        }
        Spread dialog = new Spread((Frame)TopLevel.getCurrentJFrame(), true);
        dialog.setVisible(true);
    }

    public Spread(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        this.spreadUp.setSelected(true);
    }

    protected void escapePressed() {
        this.cancel(null);
    }

    private void initComponents() {
        this.direction = new ButtonGroup();
        this.cancel = new JButton();
        this.ok = new JButton();
        this.jLabel1 = new JLabel();
        this.spreadAmount = new JTextField();
        this.spreadUp = new JRadioButton();
        this.spreadDown = new JRadioButton();
        this.spreadLeft = new JRadioButton();
        this.spreadRight = new JRadioButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Spread About Highlighted");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Spread.this.closeDialog(evt);
            }
        });
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Spread.this.cancel(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Spread.this.ok(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.jLabel1.setText("Distance to spread:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.spreadAmount.setColumns(8);
        this.spreadAmount.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.spreadAmount, gridBagConstraints);
        this.spreadUp.setText("Spread up");
        this.direction.add(this.spreadUp);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.spreadUp, gridBagConstraints);
        this.spreadDown.setText("Spread down");
        this.direction.add(this.spreadDown);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.spreadDown, gridBagConstraints);
        this.spreadLeft.setText("Spread left");
        this.direction.add(this.spreadLeft);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.spreadLeft, gridBagConstraints);
        this.spreadRight.setText("Spread right");
        this.direction.add(this.spreadRight);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.spreadRight, gridBagConstraints);
        this.pack();
    }

    private void cancel(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void ok(ActionEvent evt) {
        SpreadJob job = new SpreadJob(this);
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class SpreadJob
    extends Job {
        Spread dialog;

        protected SpreadJob(Spread dialog) {
            super("Spread Circuitry", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.dialog = dialog;
            this.startJob();
        }

        public boolean doIt() {
            double yC1;
            double xC1;
            int direction = 0;
            if (this.dialog.spreadUp.isSelected()) {
                direction = 117;
            } else if (this.dialog.spreadDown.isSelected()) {
                direction = 100;
            } else if (this.dialog.spreadLeft.isSelected()) {
                direction = 108;
            } else if (this.dialog.spreadRight.isSelected()) {
                direction = 114;
            }
            double amount = TextUtils.atof(this.dialog.spreadAmount.getText());
            NodeInst ni = (NodeInst)Highlight.getOneElectricObject(class$com$sun$electric$database$topology$NodeInst == null ? (class$com$sun$electric$database$topology$NodeInst = Spread.class$("com.sun.electric.database.topology.NodeInst")) : class$com$sun$electric$database$topology$NodeInst);
            if (ni == null) {
                return false;
            }
            Cell cell = ni.getParent();
            if (CircuitChanges.cantEdit(cell, null, true)) {
                return false;
            }
            SizeOffset so = ni.getSizeOffset();
            double sLx = ni.getTrueCenterX() - ni.getXSize() / 2.0 + so.getLowXOffset();
            double sHx = ni.getTrueCenterX() + ni.getXSize() / 2.0 - so.getHighXOffset();
            double sLy = ni.getTrueCenterY() - ni.getYSize() / 2.0 + so.getLowYOffset();
            double sHy = ni.getTrueCenterY() + ni.getYSize() / 2.0 - so.getHighYOffset();
            FlagSet fs = Geometric.getFlagSet(1);
            Iterator it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst oNi = (NodeInst)it.next();
                oNi.clearBit(fs);
            }
            it = cell.getArcs();
            while (it.hasNext()) {
                ArcInst oAi = (ArcInst)it.next();
                oAi.clearBit(fs);
            }
            boolean mustBeHor = true;
            if (direction == 108 || direction == 114) {
                mustBeHor = false;
            }
            SpreadJob.manhattanTravel(ni, mustBeHor, fs);
            Iterator it2 = cell.getNodes();
            while (it2.hasNext()) {
                NodeInst oNi = (NodeInst)it2.next();
                SizeOffset oSo = oNi.getSizeOffset();
                if (direction == 108 || direction == 114) {
                    if (oNi.getTrueCenterX() - oNi.getXSize() / 2.0 + oSo.getLowXOffset() < sLx && oNi.getTrueCenterX() + oNi.getXSize() / 2.0 - oSo.getHighXOffset() > sHx) {
                        oNi.setBit(fs);
                    }
                    if (oNi.getTrueCenterX() != (sLx + sHx) / 2.0) continue;
                    oNi.setBit(fs);
                    continue;
                }
                if (oNi.getTrueCenterY() - oNi.getYSize() / 2.0 + oSo.getLowYOffset() < sLy && oNi.getTrueCenterY() + oNi.getYSize() / 2.0 - oSo.getHighYOffset() > sHy) {
                    oNi.setBit(fs);
                }
                if (oNi.getTrueCenterY() != (sLy + sHy) / 2.0) continue;
                oNi.setBit(fs);
            }
            it2 = cell.getArcs();
            while (it2.hasNext()) {
                ArcInst ai = (ArcInst)it2.next();
                NodeInst no1 = ai.getTail().getPortInst().getNodeInst();
                NodeInst no2 = ai.getHead().getPortInst().getNodeInst();
                xC1 = no1.getTrueCenterX();
                yC1 = no1.getTrueCenterY();
                double xC2 = no2.getTrueCenterX();
                double yC2 = no2.getTrueCenterY();
                if (no2.isBit(fs)) {
                    NodeInst swapNi = no1;
                    no1 = no2;
                    no2 = swapNi;
                    double swap = xC1;
                    xC1 = xC2;
                    xC2 = swap;
                    swap = yC1;
                    yC1 = yC2;
                    yC2 = swap;
                }
                if (no2.isBit(fs)) continue;
                boolean i = true;
                if (no1.isBit(fs)) {
                    switch (direction) {
                        case 108: {
                            if (!(xC2 <= sLx)) break;
                            i = false;
                            break;
                        }
                        case 114: {
                            if (!(xC2 >= sHx)) break;
                            i = false;
                            break;
                        }
                        case 117: {
                            if (!(yC2 >= sHy)) break;
                            i = false;
                            break;
                        }
                        case 100: {
                            if (!(yC2 <= sLy)) break;
                            i = false;
                        }
                    }
                } else {
                    switch (direction) {
                        case 108: {
                            if (xC1 > sLx && xC2 <= sLx) {
                                i = false;
                                break;
                            }
                            if (!(xC2 > sLx) || !(xC1 <= sLx)) break;
                            i = false;
                            break;
                        }
                        case 114: {
                            if (xC1 < sHx && xC2 >= sHx) {
                                i = false;
                                break;
                            }
                            if (!(xC2 < sHx) || !(xC1 >= sHx)) break;
                            i = false;
                            break;
                        }
                        case 117: {
                            if (yC1 > sHy && yC2 <= sHy) {
                                i = false;
                                break;
                            }
                            if (!(yC2 > sHy) || !(yC1 <= sHy)) break;
                            i = false;
                            break;
                        }
                        case 100: {
                            if (yC1 < sLy && yC2 >= sLy) {
                                i = false;
                                break;
                            }
                            if (!(yC2 < sLy) || !(yC1 >= sLy)) break;
                            i = false;
                        }
                    }
                }
                if (i) continue;
                ai.setBit(fs);
            }
            boolean moved = false;
            boolean again = true;
            block28: while (again) {
                again = false;
                Iterator it3 = cell.getNodes();
                while (it3.hasNext()) {
                    NodeInst oNi = (NodeInst)it3.next();
                    if (oNi.isBit(fs)) continue;
                    xC1 = oNi.getTrueCenterX();
                    yC1 = oNi.getTrueCenterY();
                    boolean doIt = false;
                    switch (direction) {
                        case 108: {
                            if (!(xC1 < sLx)) break;
                            doIt = true;
                            break;
                        }
                        case 114: {
                            if (!(xC1 > sHx)) break;
                            doIt = true;
                            break;
                        }
                        case 117: {
                            if (!(yC1 > sHy)) break;
                            doIt = true;
                            break;
                        }
                        case 100: {
                            if (!(yC1 < sLy)) break;
                            doIt = true;
                        }
                    }
                    if (!doIt) continue;
                    Iterator aIt = cell.getArcs();
                    while (aIt.hasNext()) {
                        ArcInst ai = (ArcInst)aIt.next();
                        if (ai.isBit(fs)) {
                            Layout.setTempRigid(ai, false);
                            continue;
                        }
                        Layout.setTempRigid(ai, true);
                    }
                    SpreadJob.netTravel(oNi, fs);
                    switch (direction) {
                        case 108: {
                            oNi.modifyInstance(-amount, 0.0, 0.0, 0.0, 0);
                            break;
                        }
                        case 114: {
                            oNi.modifyInstance(amount, 0.0, 0.0, 0.0, 0);
                            break;
                        }
                        case 117: {
                            oNi.modifyInstance(0.0, amount, 0.0, 0.0, 0);
                            break;
                        }
                        case 100: {
                            oNi.modifyInstance(0.0, -amount, 0.0, 0.0, 0);
                        }
                    }
                    moved = true;
                    again = true;
                    continue block28;
                }
            }
            fs.freeFlagSet();
            if (!moved) {
                System.out.println("Nothing changed");
            }
            return true;
        }

        private static void netTravel(NodeInst ni, FlagSet fs) {
            if (ni.isBit(fs)) {
                return;
            }
            ni.setBit(fs);
            Iterator it = ni.getConnections();
            while (it.hasNext()) {
                Connection con = (Connection)it.next();
                ArcInst ai = con.getArc();
                if (ai.isBit(fs)) continue;
                SpreadJob.netTravel(ai.getHead().getPortInst().getNodeInst(), fs);
                SpreadJob.netTravel(ai.getTail().getPortInst().getNodeInst(), fs);
            }
        }

        private static void manhattanTravel(NodeInst ni, boolean hor, FlagSet fs) {
            ni.setBit(fs);
            Iterator it = ni.getConnections();
            while (it.hasNext()) {
                Connection con = (Connection)it.next();
                ArcInst ai = con.getArc();
                int angle = ai.getAngle();
                if (hor ? angle != 0 && angle != 1800 : angle != 900 && angle != 2700) continue;
                NodeInst other = null;
                other = ai.getHead() == con ? ai.getTail().getPortInst().getNodeInst() : ai.getHead().getPortInst().getNodeInst();
                if (other.isBit(fs)) continue;
                SpreadJob.manhattanTravel(other, hor, fs);
            }
        }
    }
}

