/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.menus.EditMenu;
import com.sun.electric.tool.user.ui.ClickZoomWireListener;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ToolBar;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

class OutlineListener
implements MouseMotionListener,
MouseListener,
MouseWheelListener,
KeyListener {
    public static OutlineListener theOne = new OutlineListener();
    private double oldX;
    private double oldY;
    private boolean doingMotionDrag;
    private int point;
    private NodeInst outlineNode;
    private Highlight high;

    private OutlineListener() {
    }

    public void setNode(NodeInst ni) {
        this.high = Highlight.getOneHighlight();
        this.point = 0;
        EditWindow wnd = EditWindow.getCurrent();
        this.outlineNode = ni;
        Point2D[] origPoints = this.outlineNode.getTrace();
        if (origPoints == null && ni.getFunction() == NodeProto.Function.NODE) {
            InitializePoints job = new InitializePoints(this, ni);
            return;
        }
        this.high.setPoint(0);
        if (wnd != null) {
            wnd.repaintContents(null);
        }
    }

    public void mousePressed(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        EditWindow wnd = (EditWindow)evt.getSource();
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        if (evt.getClickCount() == 2 && Highlight.getNumHighlights() >= 1) {
            EditMenu.getInfoCommand();
            return;
        }
        if (ClickZoomWireListener.isRightMouse(evt)) {
            if (CircuitChanges.cantEdit(cell, null, true)) {
                return;
            }
            AffineTransform trans = this.outlineNode.rotateOutAboutTrueCenter();
            Point2D[] origPoints = this.outlineNode.getTrace();
            if (origPoints == null) {
                Point2D[] newPoints = new Point2D[]{new Point2D.Double(this.outlineNode.getAnchorCenterX(), this.outlineNode.getAnchorCenterY())};
                EditWindow.gridAlign(newPoints[0]);
                this.setNewPoints(newPoints, 0);
                this.point = 0;
                this.oldX = newPoints[this.point].getX();
                this.oldY = newPoints[this.point].getY();
            } else if (origPoints.length == 1) {
                Point2D[] newPoints = new Point2D[2];
                newPoints[0] = new Point2D.Double(this.outlineNode.getAnchorCenterX() + origPoints[0].getX(), this.outlineNode.getAnchorCenterY() + origPoints[0].getY());
                trans.transform(newPoints[0], newPoints[0]);
                EditWindow.gridAlign(newPoints[0]);
                newPoints[1] = new Point2D.Double(newPoints[0].getX() + 2.0, newPoints[0].getY() + 2.0);
                EditWindow.gridAlign(newPoints[1]);
                this.setNewPoints(newPoints, 1);
                this.point = 1;
                this.oldX = newPoints[this.point].getX();
                this.oldY = newPoints[this.point].getY();
            } else {
                Point2D[] newPoints = new Point2D[origPoints.length + 1];
                int j = 0;
                for (int i = 0; i < origPoints.length; ++i) {
                    newPoints[j++] = new Point2D.Double(this.outlineNode.getAnchorCenterX() + origPoints[i].getX(), this.outlineNode.getAnchorCenterY() + origPoints[i].getY());
                    if (i != this.point) continue;
                    if (i + 1 >= origPoints.length) {
                        if (this.outlineNode.traceWraps()) {
                            newPoints[j] = new Point2D.Double(this.outlineNode.getAnchorCenterX() + (origPoints[i].getX() + origPoints[0].getX()) / 2.0, this.outlineNode.getAnchorCenterY() + (origPoints[i].getY() + origPoints[0].getY()) / 2.0);
                            EditWindow.gridAlign(newPoints[j]);
                            ++j;
                            continue;
                        }
                        newPoints[j] = new Point2D.Double(this.outlineNode.getAnchorCenterX() + origPoints[i].getX() * 2.0 + origPoints[i - 1].getX(), this.outlineNode.getAnchorCenterY() + origPoints[i].getY() * 2.0 + origPoints[i - 1].getY());
                        EditWindow.gridAlign(newPoints[j]);
                        ++j;
                        continue;
                    }
                    newPoints[j] = new Point2D.Double(this.outlineNode.getAnchorCenterX() + (origPoints[i].getX() + origPoints[i + 1].getX()) / 2.0, this.outlineNode.getAnchorCenterY() + (origPoints[i].getY() + origPoints[i + 1].getY()) / 2.0);
                    EditWindow.gridAlign(newPoints[j]);
                    ++j;
                }
                trans.transform(newPoints, 0, newPoints, 0, newPoints.length);
                this.setNewPoints(newPoints, this.point + 1);
                this.oldX = newPoints[this.point + 1].getX();
                this.oldY = newPoints[this.point + 1].getY();
            }
            this.doingMotionDrag = true;
            wnd.repaint();
            return;
        }
        Point2D pt = wnd.screenToDatabase(x, y);
        int numFound = Highlight.findObject(pt, wnd, true, false, false, false, true, false, false);
        this.doingMotionDrag = false;
        if (numFound != 0) {
            this.high = Highlight.getOneHighlight();
            this.outlineNode = (NodeInst)Highlight.getOneElectricObject(NodeInst.class);
            if (this.high != null && this.outlineNode != null) {
                this.point = this.high.getPoint();
                Point2D[] origPoints = this.outlineNode.getTrace();
                if (origPoints != null) {
                    this.doingMotionDrag = true;
                    this.oldX = this.outlineNode.getAnchorCenterX() + origPoints[this.point].getX();
                    this.oldY = this.outlineNode.getAnchorCenterY() + origPoints[this.point].getY();
                }
            }
        }
        wnd.repaint();
    }

    public void mouseReleased(MouseEvent evt) {
        EditWindow wnd = (EditWindow)evt.getSource();
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        if (this.doingMotionDrag) {
            this.doingMotionDrag = false;
            if (CircuitChanges.cantEdit(cell, null, true)) {
                return;
            }
            int newX = evt.getX();
            int newY = evt.getY();
            Point2D curPt = wnd.screenToDatabase(newX, newY);
            EditWindow.gridAlign(curPt);
            Highlight.setHighlightOffset(0, 0);
            this.moveSelectedPoint(curPt.getX() - this.oldX, curPt.getY() - this.oldY);
            wnd.repaintContents(null);
        }
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseMoved(MouseEvent evt) {
    }

    public void mouseDragged(MouseEvent evt) {
        EditWindow wnd = (EditWindow)evt.getSource();
        int newX = evt.getX();
        int newY = evt.getY();
        Point2D curPt = wnd.screenToDatabase(newX, newY);
        EditWindow.gridAlign(curPt);
        Point pt = wnd.databaseToScreen(curPt.getX(), curPt.getY());
        Point gridPt = wnd.databaseToScreen(this.oldX, this.oldY);
        if (this.doingMotionDrag) {
            Highlight.setHighlightOffset(pt.x - gridPt.x, pt.y - gridPt.y);
            wnd.repaint();
            return;
        }
        wnd.repaint();
    }

    public void mouseWheelMoved(MouseWheelEvent evt) {
        int clicks = evt.getWheelRotation();
        System.out.println("Mouse wheel rolled by " + clicks);
    }

    public void keyPressed(KeyEvent evt) {
        int chr = evt.getKeyCode();
        EditWindow wnd = (EditWindow)evt.getSource();
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        if (chr == 127 || chr == 8) {
            Point2D[] origPoints = this.outlineNode.getTrace();
            if (origPoints.length <= 2) {
                System.out.println("Cannot delete the last point on an outline");
                return;
            }
            AffineTransform trans = this.outlineNode.rotateOutAboutTrueCenter();
            Point2D[] newPoints = new Point2D[origPoints.length - 1];
            int pt = this.point;
            int j = 0;
            for (int i = 0; i < origPoints.length; ++i) {
                if (i == pt) continue;
                newPoints[j] = new Point2D.Double(this.outlineNode.getAnchorCenterX() + origPoints[i].getX(), this.outlineNode.getAnchorCenterY() + origPoints[i].getY());
                trans.transform(newPoints[j], newPoints[j]);
                ++j;
            }
            if (pt > 0) {
                --pt;
            }
            this.setNewPoints(newPoints, pt);
        } else if (chr == 37) {
            double arrowDistance = ToolBar.getArrowDistance();
            this.moveSelectedPoint(-arrowDistance, 0.0);
        } else if (chr == 39) {
            double arrowDistance = ToolBar.getArrowDistance();
            this.moveSelectedPoint(arrowDistance, 0.0);
        } else if (chr == 38) {
            double arrowDistance = ToolBar.getArrowDistance();
            this.moveSelectedPoint(0.0, arrowDistance);
        } else if (chr == 40) {
            double arrowDistance = ToolBar.getArrowDistance();
            this.moveSelectedPoint(0.0, -arrowDistance);
        } else if (chr == 46) {
            int nextPoint = this.point + 1;
            Point2D[] origPoints = this.outlineNode.getTrace();
            if (nextPoint >= origPoints.length) {
                nextPoint = 0;
            }
            this.point = nextPoint;
            this.high.setPoint(this.point);
            wnd.repaint();
        } else if (chr == 44) {
            Point2D[] origPoints = this.outlineNode.getTrace();
            int prevPoint = this.point - 1;
            if (prevPoint < 0) {
                prevPoint = origPoints.length - 1;
            }
            this.point = prevPoint;
            this.high.setPoint(this.point);
            wnd.repaint();
        }
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
    }

    private void moveSelectedPoint(double dx, double dy) {
        Point2D[] origPoints = this.outlineNode.getTrace();
        if (origPoints == null) {
            return;
        }
        Point2D[] newPoints = new Point2D[origPoints.length];
        for (int i = 0; i < origPoints.length; ++i) {
            newPoints[i] = new Point2D.Double(this.outlineNode.getAnchorCenterX() + origPoints[i].getX(), this.outlineNode.getAnchorCenterY() + origPoints[i].getY());
        }
        AffineTransform trans = this.outlineNode.rotateOutAboutTrueCenter();
        trans.transform(newPoints, 0, newPoints, 0, newPoints.length);
        newPoints[this.point].setLocation(newPoints[this.point].getX() + dx, newPoints[this.point].getY() + dy);
        this.setNewPoints(newPoints, this.point);
    }

    private void setNewPoints(Point2D[] newPoints, int newPoint) {
        SetPoints job = new SetPoints(this, newPoints, newPoint);
    }

    private static class SetPoints
    extends Job {
        OutlineListener listener;
        Point2D[] newPoints;
        int newPoint;

        protected SetPoints(OutlineListener listener, Point2D[] newPoints, int newPoint) {
            super("Change Outline Points", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.listener = listener;
            this.newPoints = newPoints;
            this.newPoint = newPoint;
            this.startJob();
        }

        public boolean doIt() {
            double lY;
            double lX;
            NodeInst ni = this.listener.outlineNode;
            double hX = lX = this.newPoints[0].getX();
            double hY = lY = this.newPoints[0].getY();
            for (int i = 1; i < this.newPoints.length; ++i) {
                double y;
                double x = this.newPoints[i].getX();
                if (x < lX) {
                    lX = x;
                }
                if (x > hX) {
                    hX = x;
                }
                if ((y = this.newPoints[i].getY()) < lY) {
                    lY = y;
                }
                if (!(y > hY)) continue;
                hY = y;
            }
            double newCX = (lX + hX) / 2.0;
            double newCY = (lY + hY) / 2.0;
            double newSX = hX - lX;
            double newSY = hY - lY;
            for (int i = 0; i < this.newPoints.length; ++i) {
                this.newPoints[i].setLocation(this.newPoints[i].getX() - newCX, this.newPoints[i].getY() - newCY);
            }
            ni.newVar(NodeInst.TRACE, (Object)this.newPoints);
            ni.modifyInstance(newCX - ni.getAnchorCenterX(), newCY - ni.getAnchorCenterY(), newSX - ni.getXSize(), newSY - ni.getYSize(), -ni.getAngle());
            this.listener.high.setPoint(this.listener.point = this.newPoint);
            return true;
        }
    }

    private static class InitializePoints
    extends Job {
        OutlineListener listener;
        NodeInst ni;

        protected InitializePoints(OutlineListener listener, NodeInst ni) {
            super("Initialize Outline Points", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.listener = listener;
            this.ni = ni;
            this.startJob();
        }

        public boolean doIt() {
            Point2D[] points = new Point2D[4];
            double halfWid = this.ni.getXSize() / 2.0;
            double halfHei = this.ni.getYSize() / 2.0;
            points[0] = new Point2D.Double(-halfWid, -halfHei);
            points[1] = new Point2D.Double(-halfWid, halfHei);
            points[2] = new Point2D.Double(halfWid, halfHei);
            points[3] = new Point2D.Double(halfWid, -halfHei);
            this.ni.newVar(NodeInst.TRACE, (Object)points);
            this.listener.high.setPoint(0);
            EditWindow wnd = EditWindow.getCurrent();
            if (wnd != null) {
                wnd.repaintContents(null);
            }
            return true;
        }
    }
}

