/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.menus.MenuBar;
import com.sun.electric.tool.user.menus.MenuCommands;
import com.sun.electric.tool.user.ui.MessagesWindow;
import com.sun.electric.tool.user.ui.PaletteFrame;
import com.sun.electric.tool.user.ui.StatusBar;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

public class TopLevel
extends JFrame {
    private static boolean mdi;
    private static JDesktopPane desktop;
    private static TopLevel topLevel;
    private StatusBar sb = null;
    private WindowFrame wf = null;
    private static Dimension scrnSize;
    private static OS os;
    private static PaletteFrame palette;
    private static MessagesWindow messages;
    private static Cursor cursor;
    private MenuBar menuBar;
    private ToolBar toolBar;
    private static Pref cacheWindowLoc;

    public TopLevel(String name, Rectangle bound, WindowFrame frame, GraphicsConfiguration gc) {
        super(name, gc);
        this.setLocation(bound.x, bound.y);
        this.setSize(bound.width, bound.height);
        this.getContentPane().setLayout(new BorderLayout());
        this.setVisible(true);
        this.setIconImage(Resources.getResource(this.getClass(), "IconElectric.gif").getImage());
        this.menuBar = MenuCommands.createMenuBar();
        this.setJMenuBar(this.menuBar);
        this.toolBar = ToolBar.createToolBar();
        this.getContentPane().add((Component)this.toolBar, "North");
        this.sb = new StatusBar(frame);
        this.getContentPane().add((Component)this.sb, "South");
        if (TopLevel.isMDIMode()) {
            this.addWindowListener(new WindowsEvents());
            this.setDefaultCloseOperation(0);
            this.addComponentListener(new ReshapeComponentAdapter());
        } else {
            this.setDefaultCloseOperation(0);
        }
        cursor = Cursor.getPredefinedCursor(0);
        try {
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
            this.enableEvents(64L);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
        }
    }

    public static void Initialize() {
        messages = new MessagesWindow();
        palette = PaletteFrame.newInstance();
    }

    public static void OSInitialize(boolean mdiMode) {
        scrnSize = Toolkit.getDefaultToolkit().getScreenSize();
        mdi = false;
        try {
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.startsWith("windows")) {
                os = OS.WINDOWS;
                mdi = mdiMode;
                TopLevel.scrnSize.height -= 30;
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            } else if (osName.startsWith("linux") || osName.startsWith("solaris") || osName.startsWith("sunos")) {
                os = OS.UNIX;
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            } else if (osName.startsWith("mac")) {
                os = OS.MACINTOSH;
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.MacLookAndFeel");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (TopLevel.isMDIMode()) {
            String loc = cacheWindowLoc.getString();
            Rectangle bound = TopLevel.parseBound(loc);
            if (bound == null) {
                bound = new Rectangle(scrnSize);
            }
            topLevel = new TopLevel("Electric", bound, null, null);
            desktop = new JDesktopPane();
            topLevel.getContentPane().add((Component)desktop, "Center");
        }
    }

    private static Rectangle parseBound(String loc) {
        int lowX = TextUtils.atoi(loc);
        int commaPos = loc.indexOf(44);
        if (commaPos < 0) {
            return null;
        }
        int lowY = TextUtils.atoi(loc.substring(commaPos + 1));
        int spacePos = loc.indexOf(32);
        if (spacePos < 0) {
            return null;
        }
        int width = TextUtils.atoi(loc.substring(spacePos + 1));
        int xPos = loc.indexOf(120);
        if (xPos < 0) {
            return null;
        }
        int height = TextUtils.atoi(loc.substring(xPos + 1));
        return new Rectangle(lowX, lowY, width, height);
    }

    public static OS getOperatingSystem() {
        return os;
    }

    public static boolean isMDIMode() {
        return mdi;
    }

    public static PaletteFrame getPaletteFrame() {
        return palette;
    }

    public static MessagesWindow getMessagesWindow() {
        return messages;
    }

    public StatusBar getStatusBar() {
        return this.sb;
    }

    public ToolBar getToolBar() {
        return this.toolBar;
    }

    public MenuBar getTheMenuBar() {
        return this.menuBar;
    }

    public static Dimension getScreenSize() {
        if (TopLevel.isMDIMode()) {
            Rectangle bounds = topLevel.getBounds();
            Rectangle dBounds = desktop.getBounds();
            if (dBounds.width != 0 && dBounds.height != 0) {
                return new Dimension(dBounds.width, dBounds.height);
            }
            return new Dimension(bounds.width - 8, bounds.height - 96);
        }
        return new Dimension(scrnSize);
    }

    public static void addToDesktop(JInternalFrame jif) {
        desktop.add(jif);
    }

    public static Cursor getCurrentCursor() {
        return cursor;
    }

    public static void setCurrentCursor(Cursor cursor) {
        TopLevel.cursor = cursor;
        TopLevel jf = TopLevel.getCurrentJFrame();
        jf.setCursor(cursor);
        palette.setCursor(cursor);
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = (WindowFrame)it.next();
            wf.setCursor(cursor);
        }
    }

    public static TopLevel getCurrentJFrame() {
        if (TopLevel.isMDIMode()) {
            return topLevel;
        }
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return null;
        }
        return wf.getFrame();
    }

    public void setWindowFrame(WindowFrame wf) {
        this.wf = wf;
    }

    public void finished() {
        this.setJMenuBar(null);
        this.getContentPane().remove(this.toolBar);
        this.toolBar.finished();
        this.toolBar = null;
        this.getContentPane().remove(this.sb);
        this.sb.finished();
        this.sb = null;
        this.wf = null;
        super.dispose();
    }

    public static void printError(boolean print, String msg) {
        if (print) {
            Throwable t = new Throwable(msg);
            System.out.println(t.toString());
            t.printStackTrace(System.out);
        }
    }

    static {
        desktop = null;
        topLevel = null;
        cacheWindowLoc = Pref.makeStringPref("WindowLocation", User.tool.prefs, "");
    }

    private static class WindowsEvents
    extends WindowAdapter {
        WindowsEvents() {
        }

        public void windowClosing(WindowEvent evt) {
            FileMenu.quitCommand();
        }
    }

    private static class ReshapeComponentAdapter
    extends ComponentAdapter {
        private ReshapeComponentAdapter() {
        }

        public void componentMoved(ComponentEvent e) {
            this.saveLocation(e);
        }

        public void componentResized(ComponentEvent e) {
            this.saveLocation(e);
        }

        private void saveLocation(ComponentEvent e) {
            TopLevel frame = (TopLevel)e.getSource();
            Rectangle bounds = frame.getBounds();
            cacheWindowLoc.setString(bounds.getMinX() + "," + bounds.getMinY() + " " + bounds.getWidth() + "x" + bounds.getHeight());
        }
    }

    public static class OS {
        private final String name;
        public static final OS WINDOWS = new OS("Windows");
        public static final OS UNIX = new OS("UNIX");
        public static final OS MACINTOSH = new OS("Macintosh");

        private OS(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

