/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.extract;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.extract.ExtractedPBucket;
import com.sun.electric.tool.extract.ParasiticTool;
import com.sun.electric.tool.extract.TransistorPBucket;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class NetPBucket
implements ExtractedPBucket {
    private GeometryHandler capMerge;
    private GeometryHandler resGeom;
    private HashMap<Layer, List<String>> resNameMap;
    private HashMap<Layer, List<PolyBase>> resSubGeom;
    private List<ExtractedPBucket> transistorsList;
    private String net;

    public NetPBucket(String net) {
        this.net = net;
        this.capMerge = GeometryHandler.createGeometryHandler(GeometryHandler.GHMode.ALGO_SWEEP, 1);
        this.resGeom = GeometryHandler.createGeometryHandler(GeometryHandler.GHMode.ALGO_SWEEP, 1);
        this.resNameMap = new HashMap(1);
        this.resSubGeom = new HashMap(1);
    }

    public void addTransistor(ExtractedPBucket transBucket) {
        if (!(transBucket instanceof TransistorPBucket)) {
            return;
        }
        if (this.transistorsList == null) {
            this.transistorsList = new ArrayList<ExtractedPBucket>();
        }
        this.transistorsList.add(transBucket);
    }

    public void modifyResistance(Layer layer, PolyBase poly, String[] subNets, boolean add) {
        List<Object> list;
        if (add) {
            this.resGeom.add(layer, poly);
        } else {
            list = this.resSubGeom.get(layer);
            if (list == null) {
                list = new ArrayList<PolyBase>(1);
                this.resSubGeom.put(layer, list);
            }
            list.add(poly);
        }
        list = this.resNameMap.get(layer);
        if (list == null) {
            list = new ArrayList<PolyBase>(2);
            this.resNameMap.put(layer, list);
        }
        for (int i = 0; i < subNets.length; ++i) {
            if (list.contains(subNets[i])) {
                list.remove(subNets[i]);
                continue;
            }
            list.add(subNets[i]);
        }
    }

    public void addCapacitance(Layer layer, Poly poly) {
        this.capMerge.add(layer, poly);
    }

    @Override
    public String getInfo(Technology tech) {
        if (this.net.equalsIgnoreCase("gnd") && !tech.isGroundNetIncluded()) {
            return null;
        }
        StringBuffer parasitic = new StringBuffer();
        boolean first = true;
        double scale = tech.getScale();
        for (Layer layer : this.resGeom.getKeySet()) {
            Collection<PolyBase> c = this.resGeom.getObjects(layer, false, true);
            List<String> nameList = this.resNameMap.get(layer);
            if (nameList == null || nameList.size() != 2) continue;
            double value = 0.0;
            for (PolyBase poly : c) {
                double max;
                double min;
                double h;
                Rectangle2D rect = poly.getBounds2D();
                double w = rect.getWidth();
                if (DBMath.areEquals(w, h = rect.getHeight())) {
                    value += 1.0;
                    continue;
                }
                if (w < h) {
                    min = w;
                    max = h;
                } else {
                    min = h;
                    max = w;
                }
                double l = max - min;
                value += l / min;
            }
            value *= layer.getResistance();
            if (!first) {
                parasitic.append("\n");
            }
            first = false;
            if (!(value > tech.getMinResistance())) continue;
            parasitic.append("r " + nameList.get(0) + " " + nameList.get(1) + " " + value);
        }
        double areaV = 0.0;
        double perimV = 0.0;
        for (Layer layer : this.capMerge.getKeySet()) {
            if (layer.isDiffusionLayer()) continue;
            Collection<PolyBase> c = this.capMerge.getObjects(layer, false, true);
            double area = 0.0;
            double perim = 0.0;
            for (PolyBase poly : c) {
                area += poly.getArea();
                perim += poly.getPerimeter();
            }
            areaV += area * layer.getCapacitance();
            perimV += perim * layer.getEdgeCapacitance();
        }
        double value = (areaV *= ParasiticTool.getAreaScale(scale)) + (perimV *= ParasiticTool.getPerimScale(scale));
        if (value > tech.getMinCapacitance()) {
            if (!first) {
                parasitic.append("\n");
            }
            parasitic.append("C " + this.net + " gnd " + TextUtils.formatDouble(value, 2));
        }
        return parasitic.toString();
    }

    public void postProcess(boolean merge) {
        if (this.capMerge != null) {
            this.capMerge.postProcess(true);
            if (this.transistorsList != null && this.transistorsList.size() > 0) {
                double area = 0.0;
                double perim = 0.0;
                for (Layer layer : this.capMerge.getKeySet()) {
                    if (!layer.isDiffusionLayer()) continue;
                    Collection<PolyBase> c = this.capMerge.getObjects(layer, false, true);
                    for (PolyBase poly : c) {
                        area += poly.getArea();
                        perim += poly.getPerimeter();
                    }
                }
                area /= (double)this.transistorsList.size();
                perim /= (double)this.transistorsList.size();
                for (int i = 0; i < this.transistorsList.size(); ++i) {
                    TransistorPBucket bucket = (TransistorPBucket)this.transistorsList.get(i);
                    bucket.addDifussionInformation(this.net, area, perim);
                }
            }
        }
        if (this.resGeom != null) {
            this.resGeom.subtractAll(this.resSubGeom);
            this.resGeom.postProcess(false);
        }
    }
}

