/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.TechTypeMoCMOS;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;

public abstract class TechType
implements Serializable {
    private static final Variable.Key ATTR_X = Variable.newKey("ATTR_X");
    private static final Variable.Key ATTR_S = Variable.newKey("ATTR_S");
    private static final Variable.Key ATTR_SN = Variable.newKey("ATTR_SN");
    private static final Variable.Key ATTR_SP = Variable.newKey("ATTR_SP");
    private final Technology generic = Technology.findTechnology("generic");
    private final Technology technology;
    private final TechTypeEnum techEnum;
    private final PrimitiveNode essentialBounds = this.generic.findNodeProto("Essential-Bounds");
    private final PrimitiveNode facetCenter = this.generic.findNodeProto("Facet-Center");
    private final int nbLay;
    private final ArcProto[] layers;
    private final PrimitiveNode[] vias;
    private final HashMap<ArcPair, PrimitiveNode> viaMap = new HashMap();
    private final ArcProto pdiff;
    private final ArcProto ndiff;
    private final ArcProto p1;
    private final ArcProto m1;
    private final ArcProto m2;
    private final ArcProto m3;
    private final ArcProto m4;
    private final ArcProto m5;
    private final ArcProto m6;
    private final ArcProto m7;
    private final ArcProto m8;
    private final ArcProto m9;
    private final ArcProto ndiff18;
    private final ArcProto pdiff18;
    private final ArcProto ndiff25;
    private final ArcProto pdiff25;
    private final ArcProto ndiff33;
    private final ArcProto pdiff33;
    private final PrimitiveNode ndpin;
    private final PrimitiveNode pdpin;
    private final PrimitiveNode p1pin;
    private final PrimitiveNode m1pin;
    private final PrimitiveNode m2pin;
    private final PrimitiveNode m3pin;
    private final PrimitiveNode m4pin;
    private final PrimitiveNode m5pin;
    private final PrimitiveNode m6pin;
    private final PrimitiveNode m7pin;
    private final PrimitiveNode m8pin;
    private final PrimitiveNode m9pin;
    private final PrimitiveNode nwm1;
    private final PrimitiveNode pwm1;
    private final PrimitiveNode nwm1Y;
    private final PrimitiveNode pwm1Y;
    private final PrimitiveNode ndm1;
    private final PrimitiveNode pdm1;
    private final PrimitiveNode p1m1;
    private final PrimitiveNode m1m2;
    private final PrimitiveNode m2m3;
    private final PrimitiveNode m3m4;
    private final PrimitiveNode m4m5;
    private final PrimitiveNode m5m6;
    private final PrimitiveNode m6m7;
    private final PrimitiveNode m7m8;
    private final PrimitiveNode m8m9;
    private final PrimitiveNode nmos;
    private final PrimitiveNode pmos;
    private final PrimitiveNode nmos18;
    private final PrimitiveNode pmos18;
    private final PrimitiveNode nmos25;
    private final PrimitiveNode pmos25;
    private final PrimitiveNode nmos33;
    private final PrimitiveNode pmos33;
    private final PrimitiveNode nmos18contact;
    private final PrimitiveNode pmos18contact;
    private final PrimitiveNode nmos25contact;
    private final PrimitiveNode pmos25contact;
    private final PrimitiveNode nmos33contact;
    private final PrimitiveNode pmos33contact;
    private final PrimitiveNode nwell;
    private final PrimitiveNode pwell;
    private final PrimitiveNode m1Node;
    private final PrimitiveNode m2Node;
    private final PrimitiveNode m3Node;
    private final PrimitiveNode m4Node;
    private final PrimitiveNode m5Node;
    private final PrimitiveNode m6Node;
    private final PrimitiveNode m7Node;
    private final PrimitiveNode m8Node;
    private final PrimitiveNode m9Node;
    private final PrimitiveNode p1Node;
    private final PrimitiveNode pdNode;
    private final PrimitiveNode ndNode;
    private final PrimitiveNode pselNode;
    private final PrimitiveNode nselNode;
    private final PrimitiveNode od18;
    private final PrimitiveNode od25;
    private final PrimitiveNode od33;
    private final PrimitiveNode vth;
    private final PrimitiveNode vtl;
    protected double gateLength;
    protected double offsetLShapePolyContact;
    protected double offsetTShapePolyContact;
    protected double selectSpace;
    protected double selectSurroundDiffInTrans;
    protected double selectSurroundDiffAlongGateInTrans;
    protected double selectSurround;
    protected double wellSurroundDiff;
    protected double gateExtendPastMOS;
    protected double p1Width;
    protected double p1ToP1Space;
    protected double gateToGateSpace;
    protected double gateToDiffContSpace;
    protected double gateToDiffContSpaceDogBone;
    protected double selectSurroundDiffInActiveContact;
    protected double m1MinArea;
    protected double diffCont_m1Width;
    protected double diffContIncr;

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    private ArcProto getLayer(int n) {
        return n > this.layers.length - 1 ? null : this.layers[n];
    }

    private PrimitiveNode getVia(int n) {
        return n > this.vias.length - 1 ? null : this.vias[n];
    }

    private PrimitiveNode findNode(PrimitiveNode.Function type, ArcProto[] arcs, Technology tech) {
        Iterator<PrimitiveNode> it = tech.getNodes();
        while (it.hasNext()) {
            PrimitiveNode pn = it.next();
            boolean found = true;
            if (pn.getFunction() != type) continue;
            for (int j = 0; j < arcs.length; ++j) {
                if (pn.connectsTo(arcs[j]) != null) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return pn;
        }
        return null;
    }

    private PrimitiveNode findPin(ArcProto arc) {
        return arc == null ? null : arc.findPinProto();
    }

    private void putViaMap(ArcProto arc1, ArcProto arc2, PrimitiveNode via) {
        if (arc1 == null || arc2 == null || via == null) {
            return;
        }
        ArcPair ap = new ArcPair(arc1, arc2);
        TechType.error(this.viaMap.containsKey(ap), "two contacts for same pair of arcs?");
        this.viaMap.put(ap, via);
    }

    private void initViaMap() {
        this.putViaMap(this.m1, this.m2, this.m1m2);
        this.putViaMap(this.m2, this.m3, this.m2m3);
        this.putViaMap(this.m3, this.m4, this.m3m4);
        this.putViaMap(this.m4, this.m5, this.m4m5);
        this.putViaMap(this.m5, this.m6, this.m5m6);
        this.putViaMap(this.m6, this.m7, this.m6m7);
        this.putViaMap(this.m7, this.m8, this.m7m8);
        this.putViaMap(this.m8, this.m9, this.m8m9);
        this.putViaMap(this.ndiff, this.m1, this.ndm1);
        this.putViaMap(this.pdiff, this.m1, this.pdm1);
        this.putViaMap(this.p1, this.m1, this.p1m1);
    }

    protected TechType(Technology techy, TechTypeEnum techEnum, String[] layerNms) {
        int i;
        TechType.error(techy == null, "Null technology in TechType constructor");
        this.nbLay = layerNms.length;
        this.technology = techy;
        this.techEnum = techEnum;
        this.layers = new ArcProto[this.nbLay];
        for (i = 0; i < this.nbLay; ++i) {
            this.layers[i] = techy.findArcProto(layerNms[i]);
            TechType.error(this.layers[i] == null, "No such layer: " + layerNms[i] + " in technology " + techy.getTechName());
        }
        this.p1 = this.getLayer(0);
        this.m1 = this.getLayer(1);
        this.m2 = this.getLayer(2);
        this.m3 = this.getLayer(3);
        this.m4 = this.getLayer(4);
        this.m5 = this.getLayer(5);
        this.m6 = this.getLayer(6);
        this.m7 = this.getLayer(7);
        this.m8 = this.getLayer(8);
        this.m9 = this.getLayer(9);
        this.pdiff = techy.findArcProto("P-Active");
        this.ndiff = techy.findArcProto("N-Active");
        this.ndiff18 = techy.findArcProto("thick-OD18-N-Active");
        this.pdiff18 = techy.findArcProto("thick-OD18-P-Active");
        this.ndiff25 = techy.findArcProto("thick-OD25-N-Active");
        this.pdiff25 = techy.findArcProto("thick-OD25-P-Active");
        this.ndiff33 = techy.findArcProto("thick-OD33-N-Active");
        this.pdiff33 = techy.findArcProto("thick-OD33-P-Active");
        this.m1Node = techy.findNodeProto("Metal-1-Node");
        this.m2Node = techy.findNodeProto("Metal-2-Node");
        this.m3Node = techy.findNodeProto("Metal-3-Node");
        this.m4Node = techy.findNodeProto("Metal-4-Node");
        this.m5Node = techy.findNodeProto("Metal-5-Node");
        this.m6Node = techy.findNodeProto("Metal-6-Node");
        this.m7Node = techy.findNodeProto("Metal-7-Node");
        this.m8Node = techy.findNodeProto("Metal-8-Node");
        this.m9Node = techy.findNodeProto("Metal-9-Node");
        this.p1Node = techy.findNodeProto("Polysilicon-1-Node");
        this.pdNode = techy.findNodeProto("P-Active-Node");
        this.ndNode = techy.findNodeProto("N-Active-Node");
        this.nselNode = techy.findNodeProto("N-Select-Node");
        this.pselNode = techy.findNodeProto("P-Select-Node");
        this.pdpin = this.findPin(this.pdiff);
        this.ndpin = this.findPin(this.ndiff);
        this.p1pin = this.findPin(this.p1);
        this.m1pin = this.findPin(this.m1);
        this.m2pin = this.findPin(this.m2);
        this.m3pin = this.findPin(this.m3);
        this.m4pin = this.findPin(this.m4);
        this.m5pin = this.findPin(this.m5);
        this.m6pin = this.findPin(this.m6);
        this.m7pin = this.findPin(this.m7);
        this.m8pin = this.findPin(this.m8);
        this.m9pin = this.findPin(this.m9);
        this.vias = new PrimitiveNode[this.nbLay - 1];
        for (i = 0; i < this.nbLay - 1; ++i) {
            this.vias[i] = this.findNode(PrimitiveNode.Function.CONTACT, new ArcProto[]{this.layers[i], this.layers[i + 1]}, techy);
            TechType.error(this.vias[i] == null, "No via for layer: " + layerNms[i]);
        }
        this.p1m1 = this.getVia(0);
        this.m1m2 = this.getVia(1);
        this.m2m3 = this.getVia(2);
        this.m3m4 = this.getVia(3);
        this.m4m5 = this.getVia(4);
        this.m5m6 = this.getVia(5);
        this.m6m7 = this.getVia(6);
        this.m7m8 = this.getVia(7);
        this.m8m9 = this.getVia(8);
        this.ndm1 = techy.findNodeProto("Metal-1-N-Active-Con");
        this.pdm1 = techy.findNodeProto("Metal-1-P-Active-Con");
        this.nwm1 = techy.findNodeProto("Metal-1-N-Well-Con");
        this.pwm1 = techy.findNodeProto("Metal-1-P-Well-Con");
        this.nwm1Y = techy.findNodeProto("Y-Metal-1-N-Well-Con");
        this.pwm1Y = techy.findNodeProto("Y-Metal-1-P-Well-Con");
        this.nmos18contact = techy.findNodeProto("thick-OD18-Metal-1-N-Active-Con");
        this.pmos18contact = techy.findNodeProto("thick-OD18-Metal-1-P-Active-Con");
        this.nmos25contact = techy.findNodeProto("thick-OD25-Metal-1-N-Active-Con");
        this.pmos25contact = techy.findNodeProto("thick-OD25-Metal-1-P-Active-Con");
        this.nmos33contact = techy.findNodeProto("thick-OD33-Metal-1-N-Active-Con");
        this.pmos33contact = techy.findNodeProto("thick-OD33-Metal-1-P-Active-Con");
        this.initViaMap();
        this.nmos = techy.findNodeProto("N-Transistor");
        this.pmos = techy.findNodeProto("P-Transistor");
        this.nmos18 = techy.findNodeProto("OD18-N-Transistor");
        this.pmos18 = techy.findNodeProto("OD18-P-Transistor");
        this.nmos25 = techy.findNodeProto("OD25-N-Transistor");
        this.pmos25 = techy.findNodeProto("OD25-P-Transistor");
        this.nmos33 = techy.findNodeProto("OD33-N-Transistor");
        this.pmos33 = techy.findNodeProto("OD33-P-Transistor");
        this.od18 = techy.findNodeProto("OD18-Node");
        this.od25 = techy.findNodeProto("OD25-Node");
        this.od33 = techy.findNodeProto("OD33-Node");
        this.vth = techy.findNodeProto("VTH-Node");
        this.vtl = techy.findNodeProto("VTL-Node");
        this.nwell = techy.findNodeProto("N-Well-Node");
        this.pwell = techy.findNodeProto("P-Well-Node");
    }

    private static TechType getTechTypeTSMC180(TechTypeEnum techEnum) {
        TechType tsmc180;
        block2: {
            tsmc180 = null;
            try {
                Class<?> tsmc180Class = Class.forName("com.sun.electric.plugins.tsmc.TechTypeTSMC180");
                Constructor<?> techConstr = tsmc180Class.getConstructor(TechTypeEnum.class);
                tsmc180 = (TechType)techConstr.newInstance(new Object[]{techEnum});
            }
            catch (Exception e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return tsmc180;
    }

    private static TechType getTechTypeCMOS90(TechTypeEnum techEnum) {
        TechType cmos90;
        block2: {
            cmos90 = null;
            try {
                Class<?> cmos90Class = Class.forName("com.sun.electric.plugins.tsmc.TechTypeCMOS90");
                Constructor<?> techConstr = cmos90Class.getConstructor(TechTypeEnum.class);
                cmos90 = (TechType)techConstr.newInstance(new Object[]{techEnum});
            }
            catch (Exception e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return cmos90;
    }

    public abstract int getNumMetals();

    public Technology getTechnology() {
        return this.technology;
    }

    public TechTypeEnum getEnum() {
        return this.techEnum;
    }

    public ArcProto pdiff() {
        return this.pdiff;
    }

    public ArcProto ndiff() {
        return this.ndiff;
    }

    public ArcProto p1() {
        return this.p1;
    }

    public ArcProto m1() {
        return this.m1;
    }

    public ArcProto m2() {
        return this.m2;
    }

    public ArcProto m3() {
        return this.m3;
    }

    public ArcProto m4() {
        return this.m4;
    }

    public ArcProto m5() {
        return this.m5;
    }

    public ArcProto m6() {
        return this.m6;
    }

    public ArcProto m7() {
        return this.m7;
    }

    public ArcProto m8() {
        return this.m8;
    }

    public ArcProto m9() {
        return this.m9;
    }

    public ArcProto ndiff18() {
        return this.ndiff18;
    }

    public ArcProto pdiff18() {
        return this.pdiff18;
    }

    public ArcProto ndiff25() {
        return this.ndiff25;
    }

    public ArcProto pdiff25() {
        return this.pdiff25;
    }

    public ArcProto ndiff33() {
        return this.ndiff33;
    }

    public ArcProto pdiff33() {
        return this.pdiff33;
    }

    public PrimitiveNode ndpin() {
        return this.ndpin;
    }

    public PrimitiveNode pdpin() {
        return this.pdpin;
    }

    public PrimitiveNode p1pin() {
        return this.p1pin;
    }

    public PrimitiveNode m1pin() {
        return this.m1pin;
    }

    public PrimitiveNode m2pin() {
        return this.m2pin;
    }

    public PrimitiveNode m3pin() {
        return this.m3pin;
    }

    public PrimitiveNode m4pin() {
        return this.m4pin;
    }

    public PrimitiveNode m5pin() {
        return this.m5pin;
    }

    public PrimitiveNode m6pin() {
        return this.m6pin;
    }

    public PrimitiveNode m7pin() {
        return this.m7pin;
    }

    public PrimitiveNode m8pin() {
        return this.m8pin;
    }

    public PrimitiveNode m9pin() {
        return this.m9pin;
    }

    public PrimitiveNode nwm1() {
        return this.nwm1;
    }

    public PrimitiveNode pwm1() {
        return this.pwm1;
    }

    public PrimitiveNode nwm1Y() {
        return this.nwm1Y;
    }

    public PrimitiveNode pwm1Y() {
        return this.pwm1Y;
    }

    public PrimitiveNode ndm1() {
        return this.ndm1;
    }

    public PrimitiveNode pdm1() {
        return this.pdm1;
    }

    public PrimitiveNode p1m1() {
        return this.p1m1;
    }

    public PrimitiveNode m1m2() {
        return this.m1m2;
    }

    public PrimitiveNode m2m3() {
        return this.m2m3;
    }

    public PrimitiveNode m3m4() {
        return this.m3m4;
    }

    public PrimitiveNode m4m5() {
        return this.m4m5;
    }

    public PrimitiveNode m5m6() {
        return this.m5m6;
    }

    public PrimitiveNode m6m7() {
        return this.m6m7;
    }

    public PrimitiveNode m7m8() {
        return this.m7m8;
    }

    public PrimitiveNode m8m9() {
        return this.m8m9;
    }

    public PrimitiveNode nmos() {
        return this.nmos;
    }

    public PrimitiveNode pmos() {
        return this.pmos;
    }

    public PrimitiveNode nmos18() {
        return this.nmos18;
    }

    public PrimitiveNode pmos18() {
        return this.pmos18;
    }

    public PrimitiveNode nmos25() {
        return this.nmos25;
    }

    public PrimitiveNode pmos25() {
        return this.pmos25;
    }

    public PrimitiveNode nmos33() {
        return this.nmos33;
    }

    public PrimitiveNode pmos33() {
        return this.pmos33;
    }

    public PrimitiveNode nmos18contact() {
        return this.nmos18contact;
    }

    public PrimitiveNode pmos18contact() {
        return this.pmos18contact;
    }

    public PrimitiveNode nmos25contact() {
        return this.nmos25contact;
    }

    public PrimitiveNode pmos25contact() {
        return this.pmos25contact;
    }

    public PrimitiveNode nmos33contact() {
        return this.nmos33contact;
    }

    public PrimitiveNode pmos33contact() {
        return this.pmos33contact;
    }

    public PrimitiveNode nwell() {
        return this.nwell;
    }

    public PrimitiveNode pwell() {
        return this.pwell;
    }

    public PrimitiveNode m1Node() {
        return this.m1Node;
    }

    public PrimitiveNode m2Node() {
        return this.m2Node;
    }

    public PrimitiveNode m3Node() {
        return this.m3Node;
    }

    public PrimitiveNode m4Node() {
        return this.m4Node;
    }

    public PrimitiveNode m5Node() {
        return this.m5Node;
    }

    public PrimitiveNode m6Node() {
        return this.m6Node;
    }

    public PrimitiveNode m7Node() {
        return this.m7Node;
    }

    public PrimitiveNode m8Node() {
        return this.m8Node;
    }

    public PrimitiveNode m9Node() {
        return this.m9Node;
    }

    public PrimitiveNode p1Node() {
        return this.p1Node;
    }

    public PrimitiveNode pdNode() {
        return this.pdNode;
    }

    public PrimitiveNode ndNode() {
        return this.ndNode;
    }

    public PrimitiveNode pselNode() {
        return this.pselNode;
    }

    public PrimitiveNode nselNode() {
        return this.nselNode;
    }

    public PrimitiveNode od18() {
        return this.od18;
    }

    public PrimitiveNode od25() {
        return this.od25;
    }

    public PrimitiveNode od33() {
        return this.od33;
    }

    public PrimitiveNode vth() {
        return this.vth;
    }

    public PrimitiveNode vtl() {
        return this.vtl;
    }

    public PrimitiveNode essentialBounds() {
        return this.essentialBounds;
    }

    public PrimitiveNode facetCenter() {
        return this.facetCenter;
    }

    public PrimitiveNode getViaFor(ArcProto a1, ArcProto a2) {
        return this.viaMap.get(new ArcPair(a1, a2));
    }

    public int layerHeight(ArcProto p) {
        for (int i = 0; i < this.nbLay; ++i) {
            if (this.layers[i] != p) continue;
            return i;
        }
        TechType.error(true, "Can't find layer: " + p);
        return -1;
    }

    public ArcProto closestLayer(PortProto port, ArcProto layer) {
        int h = this.layerHeight(layer);
        for (int dist = 0; dist < this.nbLay; ++dist) {
            ArcProto lay;
            int lookUp = h + dist;
            int lookDn = h - dist;
            if (lookUp < this.nbLay && port.connectsTo(lay = this.layerAtHeight(lookUp))) {
                return lay;
            }
            if (lookDn < 0 || !port.connectsTo(lay = this.layerAtHeight(lookDn))) continue;
            return lay;
        }
        TechType.error(true, "port can't connect to any layer?!!");
        return null;
    }

    public ArcProto highestLayer(PortProto port) {
        for (int h = this.layers.length - 1; h >= 0; --h) {
            if (!port.connectsTo(this.layers[h])) continue;
            return this.layers[h];
        }
        TechType.error(true, "port can't connect to any layer?!!");
        return null;
    }

    public ArcProto layerAtHeight(int layHeight) {
        return this.layers[layHeight];
    }

    public PrimitiveNode viaAbove(int layHeight) {
        return this.vias[layHeight];
    }

    public PrimitiveNode viaBelow(int layHeight) {
        return this.vias[layHeight - 1];
    }

    public abstract double roundToGrid(double var1);

    public abstract MosInst newNmosInst(double var1, double var3, double var5, double var7, Cell var9);

    public abstract MosInst newPmosInst(double var1, double var3, double var5, double var7, Cell var9);

    public abstract String name();

    public abstract double reservedToLambda(int var1, double var2);

    public double getWellWidth() {
        return this.nwm1.getMinSizeRule().getWidth();
    }

    public double getWellSurroundDiff() {
        return this.wellSurroundDiff;
    }

    public double getGateExtendPastMOS() {
        return this.gateExtendPastMOS;
    }

    public double getP1Width() {
        return this.p1Width;
    }

    public double getP1ToP1Space() {
        return this.p1ToP1Space;
    }

    public double getGateToGateSpace() {
        return this.gateToGateSpace;
    }

    public double getGateToDiffContSpace() {
        return this.gateToDiffContSpace;
    }

    public double getGateToDiffContSpaceDogBone() {
        return this.gateToDiffContSpaceDogBone;
    }

    public double getDiffContWidth() {
        SizeOffset so = this.ndm1().getProtoSizeOffset();
        return this.ndm1().getMinSizeRule().getHeight() - so.getHighYOffset() - so.getLowYOffset();
    }

    public double getP1M1Width() {
        SizeOffset so = this.p1m1().getProtoSizeOffset();
        return this.p1m1().getMinSizeRule().getHeight() - so.getHighYOffset() - so.getLowYOffset();
    }

    public double getGateLength() {
        return this.gateLength;
    }

    public double selectSurroundDiffInActiveContact() {
        return this.selectSurroundDiffInActiveContact;
    }

    public double selectSurroundDiffAlongGateInTrans() {
        return this.selectSurroundDiffAlongGateInTrans;
    }

    public double getPolyLShapeOffset() {
        return this.offsetLShapePolyContact;
    }

    public double getPolyTShapeOffset() {
        return this.offsetTShapePolyContact;
    }

    public double getSelectSpacingRule() {
        return this.selectSpace;
    }

    public double getSelectSurroundDiffInTrans() {
        return this.selectSurroundDiffInTrans;
    }

    public double getSelectSurroundOverPoly() {
        return this.selectSurround;
    }

    public double getM1MinArea() {
        return this.m1MinArea;
    }

    public double getDiffCont_m1Width() {
        return this.diffCont_m1Width;
    }

    public double getDiffContIncr() {
        return this.diffContIncr;
    }

    public Variable.Key getAttrX() {
        return ATTR_X;
    }

    public Variable.Key getAttrS() {
        return ATTR_S;
    }

    public Variable.Key getAttrSP() {
        return ATTR_SP;
    }

    public Variable.Key getAttrSN() {
        return ATTR_SN;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TechTypeEnum
    extends Enum<TechTypeEnum> {
        public static final /* enum */ TechTypeEnum MOCMOS = new TechTypeEnum();
        public static final /* enum */ TechTypeEnum TSMC180 = new TechTypeEnum();
        public static final /* enum */ TechTypeEnum CMOS90 = new TechTypeEnum();
        private TechType type;
        private static final /* synthetic */ TechTypeEnum[] $VALUES;

        public static final TechTypeEnum[] values() {
            return (TechTypeEnum[])$VALUES.clone();
        }

        public static TechTypeEnum valueOf(String name) {
            return Enum.valueOf(TechTypeEnum.class, name);
        }

        public TechType getTechType() {
            if (this.type == null) {
                if (this == MOCMOS) {
                    this.type = new TechTypeMoCMOS(this);
                } else if (this == TSMC180) {
                    this.type = TechType.getTechTypeTSMC180(this);
                } else if (this == CMOS90) {
                    this.type = TechType.getTechTypeCMOS90(this);
                } else {
                    System.out.println("Invalid TechTypeEnum");
                    assert (false);
                }
            }
            return this.type;
        }

        static {
            $VALUES = new TechTypeEnum[]{MOCMOS, TSMC180, CMOS90};
        }
    }

    public static class MosInst {
        private final NodeInst mos;
        private final String leftDiff;
        private final String rightDiff;
        private final String topPoly;
        private final String botPoly;

        private static void error(boolean pred, String msg) {
            LayoutLib.error(pred, msg);
        }

        private MosInst(char np, double x, double y, double xSize, double ySize, double angle, String leftDiff, String rightDiff, String topPoly, String botPoly, TechType tech, Cell parent) {
            PrimitiveNode npr = np == 'n' ? tech.nmos() : tech.pmos();
            this.leftDiff = leftDiff;
            this.rightDiff = rightDiff;
            this.topPoly = topPoly;
            this.botPoly = botPoly;
            this.mos = LayoutLib.newNodeInst(npr, x, y, xSize, ySize, angle, parent);
        }

        private PortInst getPort(String portNm) {
            PortInst pi = this.mos.findPortInst(portNm);
            MosInst.error(pi == null, "MosInst can't find port!");
            return pi;
        }

        public PortInst leftDiff() {
            return this.getPort(this.leftDiff);
        }

        public PortInst rightDiff() {
            return this.getPort(this.rightDiff);
        }

        public PortInst topPoly() {
            return this.getPort(this.topPoly);
        }

        public PortInst botPoly() {
            return this.getPort(this.botPoly);
        }

        public static class MosInstH
        extends MosInst {
            public MosInstH(char np, double x, double y, double w, double l, TechType tech, Cell parent) {
                super(np, x, y, w, l, 90.0, np + "-trans-diff-top", np + "-trans-diff-bottom", np + "-trans-poly-right", np + "-trans-poly-left", tech, parent);
            }
        }

        public static class MosInstV
        extends MosInst {
            public MosInstV(char np, double x, double y, double w, double l, TechType tech, Cell parent) {
                super(np, x, y, l, w, 0.0, "diff-left", "diff-right", "poly-top", "poly-bottom", tech, parent);
            }
        }
    }

    private static class ArcPair
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private ArcProto arc1;
        private ArcProto arc2;

        public ArcPair(ArcProto a1, ArcProto a2) {
            this.arc1 = a1;
            this.arc2 = a2;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ArcPair)) {
                return false;
            }
            ArcPair ap = (ArcPair)o;
            if (ap.arc1 == this.arc1 && ap.arc2 == this.arc2) {
                return true;
            }
            return ap.arc1 == this.arc2 && ap.arc2 == this.arc1;
        }

        public int hashCode() {
            return this.arc1.hashCode() * this.arc2.hashCode();
        }
    }
}

