/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry.bool;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class DeltaMerge {
    private static final Segment segLast = new Segment();
    private Segment segPool;
    private Segment chain;
    private int[] inpA = new int[1];
    private int inpC;
    private int[] outA = new int[1];
    private int outC;
    private int pointsSize;
    private long[] points = new long[1];
    private int curPoint;
    private int x;

    public DeltaMerge() {
        this.chain = new Segment();
        this.chain.next = DeltaMerge.segLast;
        this.chain.y = Integer.MIN_VALUE;
    }

    public int loop(DataOutputStream out) throws IOException {
        Arrays.sort(this.points, 0, this.pointsSize);
        this.curPoint = 0;
        int totalOutPoints = 0;
        while (this.getLine()) {
            this.scanLine();
            totalOutPoints += this.outC;
            this.printOut(out);
            this.printSegments();
        }
        out.writeBoolean(false);
        return totalOutPoints;
    }

    public void put(int lx, int ly, int hx, int hy) {
        this.put(lx, ly, true);
        this.put(lx, hy, false);
        this.put(hx, ly, false);
        this.put(hx, hy, true);
    }

    public void put(int x2, int y, boolean positive) {
        if (this.pointsSize >= this.points.length) {
            long[] newPoints = new long[this.points.length * 2];
            System.arraycopy(this.points, 0, newPoints, 0, this.points.length);
            this.points = newPoints;
        }
        if (y < -1073741824 || y > 0x3FFFFFFF) {
            throw new IllegalArgumentException();
        }
        long p = (long)x2 << 32 | (long)(y + 0x40000000 << 1) & 0xFFFFFFFEL;
        if (positive) {
            p |= 1L;
        }
        this.points[this.pointsSize++] = p;
    }

    public int size() {
        return this.pointsSize;
    }

    public void clear() {
        this.points = new long[1];
        this.pointsSize = 0;
    }

    private void printOut(DataOutputStream out) throws IOException {
        if (this.outC == 0) {
            return;
        }
        out.writeBoolean(true);
        out.writeInt(this.x);
        out.writeInt(this.outC);
        for (int i = 0; i < this.outC; ++i) {
            int outVal = this.outA[i];
            int y = outVal >> 1;
            boolean df = (outVal & 1) != 0;
            out.writeInt(outVal);
        }
    }

    private boolean getLine() {
        this.resetInp();
        if (this.curPoint >= this.pointsSize) {
            return false;
        }
        long p = this.points[this.curPoint++];
        this.x = (int)(p >> 32);
        while (true) {
            int y = Integer.MIN_VALUE + (int)(p & 0xFFFFFFFFFFFFFFFFL) >> 1;
            int sign2 = (p & 1L) != 0L ? 1 : -1;
            this.putPointInp(y, sign2);
            if (this.curPoint >= this.pointsSize || this.x != (int)((p = this.points[this.curPoint]) >> 32)) break;
            ++this.curPoint;
        }
        return true;
    }

    private void printSegments() {
        Segment cp = this.chain;
        while (cp.next != segLast) {
            assert (cp.y < cp.next.y);
            assert (cp.val >= 0);
            cp = cp.next;
        }
    }

    private void checkSegments() {
        assert (this.chain.y == Integer.MIN_VALUE);
        assert (this.chain.val == 0);
        Segment cp = this.chain;
        while (cp.next != segLast) {
            assert (cp.y < cp.next.y);
            assert (cp.val >= 0);
            cp = cp.next;
        }
        assert (segLast.y == Integer.MAX_VALUE);
        assert (segLast.val == 0);
    }

    private void scanLine() {
        assert (this.inpC > 0);
        int inpStep = 0;
        int outStep = 0;
        Segment cp = this.chain;
        this.resetOut();
        int inpPos = 0;
        while (inpPos < this.inpC) {
            int newOutStep;
            int newO;
            int oldO;
            Segment p;
            int df;
            int inpVal = this.inpA[inpPos++];
            int y = inpVal >> 1;
            assert (cp.y < y);
            int n = df = (inpVal & 1) != 0 ? 1 : -1;
            while (inpPos < this.inpC && this.inpA[inpPos] >> 1 == y) {
                if ((this.inpA[inpPos++] & 1) != 0) {
                    ++df;
                    continue;
                }
                --df;
            }
            if (df == 0) continue;
            if (inpStep == 0) {
                while (cp.next.y < y) {
                    cp = cp.next;
                }
            } else {
                while (cp.next.y < y) {
                    p = cp.next;
                    oldO = p.val == 0 ? 0 : 1;
                    p.val += inpStep;
                    newO = p.val == 0 ? 0 : 1;
                    newOutStep = newO - oldO;
                    if (newOutStep != outStep) {
                        this.putPointOut(p.y, newOutStep - outStep);
                        outStep = newOutStep;
                    }
                    cp = p;
                }
            }
            assert (cp.y < y && y <= cp.next.y);
            if (cp.next.y > y) {
                p = this.newSegment(cp.next);
                p.y = y;
                p.val = cp.val - inpStep;
                cp.next = p;
            } else {
                p = cp.next;
            }
            inpStep += df;
            assert (p.y == y);
            oldO = p.val == 0 ? 0 : 1;
            p.val += inpStep;
            newO = p.val == 0 ? 0 : 1;
            newOutStep = newO - oldO;
            if (newOutStep != outStep) {
                this.putPointOut(y, newOutStep - outStep);
                outStep = newOutStep;
            }
            if (cp.val == p.val) {
                cp.next = p.next;
                this.dispSegment(p);
            } else {
                cp = p;
            }
            assert (cp.y <= y);
        }
        assert (inpStep == 0);
    }

    private void resetInp() {
        this.inpC = 0;
    }

    private void putPointInp(int y, int val) {
        if (this.inpC >= this.inpA.length) {
            int[] newInpA = new int[this.inpA.length * 2];
            System.arraycopy(this.inpA, 0, newInpA, 0, this.inpA.length);
            this.inpA = newInpA;
        }
        this.inpA[this.inpC++] = y << 1 | (val > 0 ? 1 : 0);
    }

    private void resetOut() {
        this.outC = 0;
    }

    private void putPointOut(int y, int val) {
        if (this.outC >= this.outA.length) {
            int[] newOutA = new int[this.outA.length * 2];
            System.arraycopy(this.outA, 0, newOutA, 0, this.outA.length);
            this.outA = newOutA;
        }
        if (val == 1) {
            this.outA[this.outC++] = y << 1 | 1;
        } else if (val == -1) {
            this.outA[this.outC++] = y << 1;
        } else if (val == 2) {
            this.outA[this.outC++] = y << 1 | 1;
            this.putPointOut(y, 1);
        } else if (val == -2) {
            this.outA[this.outC++] = y << 1;
            this.putPointOut(y, -1);
        } else {
            throw new AssertionError();
        }
    }

    private Segment newSegment(Segment next2) {
        Segment result2;
        if (this.segPool == null) {
            result2 = new Segment();
        } else {
            result2 = this.segPool;
            this.segPool = this.segPool.next;
        }
        result2.next = next2;
        return result2;
    }

    private void dispSegment(Segment p) {
        p.next = this.segPool;
        this.segPool = p;
    }

    static {
        segLast.y = Integer.MAX_VALUE;
    }

    private static class Segment {
        private Segment next;
        private int y;
        private int val;

        private Segment() {
        }
    }
}

