/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.forceDirected2;

import com.sun.electric.tool.Job;
import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.forceDirected2.AdditionalNodeData;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.staged.FinalizeWorker;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.staged.PlacementDTO;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.staged.StartUpStage;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.staged.StartUpStageWorker;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.util.CheckboardingField;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.util.CheckboardingPattern;
import com.sun.electric.tool.placement.forceDirected2.metrics.BBMetric;
import com.sun.electric.tool.placement.forceDirected2.utils.GlobalVars;
import com.sun.electric.tool.placement.forceDirected2.utils.PlacementProperties;
import com.sun.electric.tool.placement.forceDirected2.utils.concurrent.Stage;
import com.sun.electric.tool.placement.forceDirected2.utils.concurrent.StageWorker;
import com.sun.electric.tool.placement.forceDirected2.utils.output.DebugMessageHandler;
import com.sun.electric.util.math.GenMath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PlacementForceDirectedStaged
extends PlacementFrame {
    private static final String ALGORITHM_NAME = "Force-Directed-2";
    protected static Map<PlacementFrame.PlacementNode, Map<PlacementFrame.PlacementNode, GenMath.MutableInteger>> connectivityMap;
    private static volatile int globalCounter;
    private static CheckboardingPattern pattern;
    private static int movementCounter;
    private static Map<PlacementFrame.PlacementNode, AdditionalNodeData> nodeData;
    public PlacementFrame.PlacementParameter maxThreadsParam = new PlacementFrame.PlacementParameter((PlacementFrame)this, "threads", "Number of threads:", 4);
    public PlacementFrame.PlacementParameter maxRuntimeParam = new PlacementFrame.PlacementParameter((PlacementFrame)this, "runtime", "Runtime (seconds):", 240);

    public static int getGlobalCounter() {
        return globalCounter;
    }

    public static synchronized int getMovementCounter() {
        return movementCounter;
    }

    public static Map<PlacementFrame.PlacementNode, AdditionalNodeData> getNodeData() {
        return nodeData;
    }

    public static synchronized void incMovementCounter() {
        ++movementCounter;
    }

    public static void setCheckboardingPattern(CheckboardingPattern pattern) {
        PlacementForceDirectedStaged.pattern = pattern;
    }

    public static synchronized void setMovementCounter(int value2) {
        movementCounter = value2;
    }

    @Override
    public String getAlgorithmName() {
        return ALGORITHM_NAME;
    }

    public synchronized void incGlobalCounter() {
        ++globalCounter;
    }

    @Override
    public void setParamterValues(int threads, int runtime) {
        GlobalVars.numOfThreads = new Integer(threads);
        GlobalVars.timeout = new Integer(runtime);
        this.numOfThreads = threads;
        this.runtime = runtime;
    }

    @Override
    public void runPlacement(List<PlacementFrame.PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks, String cellName, Job job) {
        this.setParamterValues(this.maxThreadsParam.getIntValue(), this.maxRuntimeParam.getIntValue());
        nodeData = new HashMap<PlacementFrame.PlacementNode, AdditionalNodeData>();
        globalCounter = 0;
        movementCounter = 0;
        for (PlacementFrame.PlacementNode node : nodesToPlace) {
            AdditionalNodeData dataSet = new AdditionalNodeData(null);
            nodeData.put(node, dataSet);
        }
        GlobalVars.numOfNodes = new Integer(nodesToPlace.size());
        System.out.println("Algorithm: " + this.getAlgorithmName());
        long start = System.currentTimeMillis();
        int nThreads = PlacementProperties.getInstance().getNumOfThreads();
        ArrayList<StageWorker> startUp = new ArrayList<StageWorker>();
        startUp.add(new StartUpStageWorker(nodesToPlace, allNetworks));
        StartUpStage startUpStage = new StartUpStage(startUp);
        startUpStage.start();
        try {
            startUpStage.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        CheckboardingField[][] fields = pattern.getAll();
        ArrayList<StageWorker> finalizeWorker = new ArrayList<StageWorker>();
        for (int i = 0; i < nThreads; ++i) {
            finalizeWorker.add(new FinalizeWorker(fields[0].length));
        }
        Stage finalizeStage = new Stage(finalizeWorker);
        finalizeStage.start();
        for (int i = 0; i < fields[0].length; ++i) {
            PlacementDTO dto = new PlacementDTO(fields, i);
            finalizeStage.getInput(null).add(dto);
        }
        try {
            finalizeStage.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        long end = System.currentTimeMillis();
        System.out.println("finished: " + (end - start) + " ms.");
        System.out.println("round timhe: " + (double)(end - start) / GlobalVars.rounds.doubleValue() + " ms.");
        DebugMessageHandler.printOnStdOut();
        BBMetric bmetric = new BBMetric(nodesToPlace, allNetworks);
        System.out.println(bmetric.toString());
    }

    static {
        globalCounter = 0;
        movementCounter = 0;
    }
}

