/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.Infrastructure;

class LogicSettableArray {
    private boolean[] outputState;

    LogicSettableArray(int numOutputs) {
        this.outputState = new boolean[numOutputs];
        for (int gpio = 0; gpio < numOutputs; ++gpio) {
            this.outputState[gpio] = true;
        }
    }

    void setLogicState(int index, boolean newLevel) {
        this.checkIndex(index);
        this.outputState[index] = newLevel;
    }

    boolean isLogicStateHigh(int index) {
        this.checkIndex(index);
        return this.outputState[index];
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.outputState.length) {
            Infrastructure.fatal("Index " + index + " not in allowed range 0.." + (this.outputState.length - 1));
        }
    }

    public boolean[] getLogicStates() {
        return this.outputState;
    }

    public void setLogicStates(boolean[] outputState) {
        this.outputState = outputState;
    }
}

