/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.redisplay;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.tool.user.redisplay.ERaster;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.GenMath;
import com.sun.electric.util.math.Orientation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class AbstractLayerDrawing {
    final Dimension sz;
    double scale;
    double originX;
    double originY;
    private double scale_;
    private float factorX;
    private float factorY;
    int clipLX;
    int clipHX;
    int clipLY;
    int clipHY;
    ERectangle drawLimitBounds;
    final Point tempPt1 = new Point();
    final Point tempPt2 = new Point();
    final Point tempPt3 = new Point();
    final Point tempPt4 = new Point();
    final FixpRectangle tempFixpRect = FixpRectangle.fromFixpDiagonal(0L, 0L, 0L, 0L);
    private boolean[] arcOctTable = new boolean[9];
    private Point arcCenter;
    private int arcRadius;
    private ERaster arcRaster;
    private boolean arcThick;

    public AbstractLayerDrawing(Dimension sz) {
        this.sz = new Dimension(sz);
        this.setClip(null);
    }

    void initOrigin(double scale, int originX, int originY) {
        this.scale = scale;
        this.scale_ = (float)(scale / 400.0);
        this.originX = originX;
        this.originY = originY;
        this.factorX = (float)((double)(-originX) / this.scale_);
        this.factorY = (float)((double)originY / this.scale_);
    }

    void initOrigin(double scale, Point2D offset) {
        this.scale = scale;
        this.scale_ = (float)(scale / 400.0);
        this.originX = (double)(this.sz.width / 2) - offset.getX() * scale;
        this.originY = (double)(this.sz.height / 2) + offset.getY() * scale;
        this.factorX = (float)(offset.getX() * 400.0 - (double)(this.sz.width / 2) / this.scale_);
        this.factorY = (float)(offset.getY() * 400.0 + (double)(this.sz.height / 2) / this.scale_);
    }

    Rectangle setClip(ERectangle drawLimitBounds) {
        Rectangle renderBounds = null;
        ERectangle screenDb = ERectangle.fromLambda(-this.originX / this.scale, (this.originY - (double)this.sz.height) / this.scale, (double)this.sz.width / this.scale, (double)this.sz.height / this.scale);
        if (drawLimitBounds != null) {
            this.drawLimitBounds = (ERectangle)screenDb.createIntersection(drawLimitBounds);
            renderBounds = this.databaseToScreen(drawLimitBounds);
            this.setClip(Math.max(renderBounds.x, 0), Math.min(renderBounds.x + renderBounds.width, this.sz.width) - 1, Math.max(renderBounds.y, 0), Math.min(renderBounds.y + renderBounds.height, this.sz.height) - 1);
        } else {
            this.drawLimitBounds = screenDb;
            this.setClip(0, this.sz.width - 1, 0, this.sz.height - 1);
        }
        return renderBounds;
    }

    private void setClip(int clipLX, int clipHX, int clipLY, int clipHY) {
        this.clipLX = clipLX;
        this.clipHX = clipHX;
        this.clipLY = clipLY;
        this.clipHY = clipHY;
    }

    FixpRectangle getSearchBounds(int oX, int oY, Orientation orient) {
        long fpX = (long)oX << 20;
        long fpY = (long)oY << 20;
        this.tempFixpRect.setFixp(this.drawLimitBounds.getFixpMinX() - fpX, this.drawLimitBounds.getFixpMinY() - fpY, this.drawLimitBounds.getFixpMaxX() - fpX, this.drawLimitBounds.getFixpMaxY() - fpY);
        orient.rectangleBounds(this.tempFixpRect, EPoint.ORIGIN, this.tempFixpRect);
        return this.tempFixpRect;
    }

    public void drawBox(int gridLX, int gridLY, int gridHX, int gridHY, ERaster raster) {
        block26: {
            EGraphics.Outline o;
            int lY;
            int hX;
            int hY;
            int lX;
            block25: {
                this.gridToScreen(gridLX, gridLY, this.tempPt1);
                this.gridToScreen(gridHX, gridHY, this.tempPt2);
                lX = this.tempPt1.x;
                hY = this.tempPt1.y;
                hX = this.tempPt2.x;
                lY = this.tempPt2.y;
                if (lX < this.clipLX) {
                    lX = this.clipLX;
                }
                if (hX > this.clipHX) {
                    hX = this.clipHX;
                }
                if (lY < this.clipLY) {
                    lY = this.clipLY;
                }
                if (hY > this.clipHY) {
                    hY = this.clipHY;
                }
                if (lX > hX || lY > hY) {
                    return;
                }
                o = raster.getOutline();
                if (lY == hY) {
                    if (lX == hX) {
                        if (o == null) {
                            raster.fillPoint(lX, lY);
                        } else {
                            raster.drawPoint(lX, lY);
                        }
                    } else if (o == null) {
                        raster.fillHorLine(lY, lX, hX);
                    } else {
                        raster.drawHorLine(lY, lX, hX);
                    }
                    return;
                }
                if (lX == hX) {
                    if (o == null) {
                        raster.fillVerLine(lX, lY, hY);
                    } else {
                        raster.drawVerLine(lX, lY, hY);
                    }
                    return;
                }
                raster.fillBox(lX, hX, lY, hY);
                if (o == null) {
                    return;
                }
                if (!o.isSolidPattern()) break block25;
                raster.drawVerLine(lX, lY, hY);
                raster.drawHorLine(hY, lX, hX);
                raster.drawVerLine(hX, lY, hY);
                raster.drawHorLine(lY, lX, hX);
                if (o.getThickness() == 1) break block26;
                for (int i = 1; i < o.getThickness(); ++i) {
                    if (lX + i <= this.clipHX) {
                        raster.drawVerLine(lX + i, lY, hY);
                    }
                    if (hY - i >= this.clipLX) {
                        raster.drawHorLine(hY - i, lX, hX);
                    }
                    if (hX - i >= this.clipLY) {
                        raster.drawVerLine(hX - i, lY, hY);
                    }
                    if (lY + i > this.clipHY) continue;
                    raster.drawHorLine(lY + i, lX, hX);
                }
                break block26;
            }
            int pattern = o.getPattern();
            int len = o.getLen();
            AbstractLayerDrawing.drawVerOutline(lX, lY, hY, pattern, len, raster);
            AbstractLayerDrawing.drawHorOutline(hY, lX, hX, pattern, len, raster);
            AbstractLayerDrawing.drawVerOutline(hX, lY, hY, pattern, len, raster);
            AbstractLayerDrawing.drawHorOutline(lY, lX, hX, pattern, len, raster);
            if (o.getThickness() != 1) {
                for (int i = 1; i < o.getThickness(); ++i) {
                    if (lX + i <= this.clipHX) {
                        AbstractLayerDrawing.drawVerOutline(lX + i, lY, hY, pattern, len, raster);
                    }
                    if (hY - i >= this.clipLX) {
                        AbstractLayerDrawing.drawHorOutline(hY - i, lX, hX, pattern, len, raster);
                    }
                    if (hX - i >= this.clipLY) {
                        AbstractLayerDrawing.drawVerOutline(hX - i, lY, hY, pattern, len, raster);
                    }
                    if (lY + i > this.clipHY) continue;
                    AbstractLayerDrawing.drawHorOutline(lY + i, lX, hX, pattern, len, raster);
                }
            }
        }
    }

    private static void drawHorOutline(int y, int lX, int hX, int pattern, int len, ERaster raster) {
        int i = 0;
        for (int x2 = lX; x2 <= hX; ++x2) {
            if ((pattern & 1 << i) != 0) {
                raster.drawPoint(x2, y);
            }
            if (++i != len) continue;
            i = 0;
        }
    }

    private static void drawVerOutline(int x2, int lY, int hY, int pattern, int len, ERaster raster) {
        int i = 0;
        for (int y = lY; y <= hY; ++y) {
            if ((pattern & 1 << i) != 0) {
                raster.drawPoint(x2, y);
            }
            if (++i != len) continue;
            i = 0;
        }
    }

    public void drawLine(int gridX1, int gridY1, int gridX2, int gridY2, int texture, ERaster raster) {
        this.gridToScreen(gridX1, gridY1, this.tempPt1);
        this.gridToScreen(gridX2, gridY2, this.tempPt2);
        this.drawLine(this.tempPt1, this.tempPt2, texture, raster);
    }

    private void drawLine(Point pt1, Point pt2, int texture, ERaster raster) {
        if (GenMath.clipLine(pt1, pt2, 0, this.sz.width - 1, 0, this.sz.height - 1)) {
            return;
        }
        switch (texture) {
            case 0: {
                this.drawSolidLine(pt1.x, pt1.y, pt2.x, pt2.y, raster);
                break;
            }
            case 1: {
                this.drawPatLine(pt1.x, pt1.y, pt2.x, pt2.y, 136, 8, raster);
                break;
            }
            case 2: {
                this.drawPatLine(pt1.x, pt1.y, pt2.x, pt2.y, 231, 8, raster);
                break;
            }
            case 3: {
                this.drawThickLine(pt1.x, pt1.y, pt2.x, pt2.y, raster);
            }
        }
    }

    public void drawCross(int gridX, int gridY, int size2, ERaster raster) {
        int hY;
        int lY;
        int hX;
        int lX;
        this.gridToScreen(gridX, gridY, this.tempPt1);
        int cX = this.tempPt1.x;
        int cY = this.tempPt1.y;
        if (this.clipLY <= cY && cY <= this.clipHY && (lX = Math.max(this.clipLX, cX - size2)) <= (hX = Math.min(this.clipHX, cX + size2))) {
            raster.drawHorLine(cY, lX, hX);
        }
        if (this.clipLX <= cX && cX <= this.clipHX && (lY = Math.max(this.clipLY, cY - size2)) <= (hY = Math.min(this.clipHY, cY + size2))) {
            raster.drawVerLine(cX, lY, hY);
        }
    }

    private void drawSolidLine(int x1, int y1, int x2, int y2, ERaster raster) {
        int dy;
        int dx = Math.abs(x2 - x1);
        if (dx > (dy = Math.abs(y2 - y1))) {
            int yend;
            int xend;
            int y;
            int x3;
            int incr2;
            int incr1 = 2 * dy;
            int d = incr2 = 2 * (dy - dx);
            if (x1 > x2) {
                x3 = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x3 = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int yincr = yend < y ? -1 : 1;
            raster.drawPoint(x3, y);
            while (x3 < xend) {
                ++x3;
                if (d < 0) {
                    d += incr1;
                } else {
                    y += yincr;
                    d += incr2;
                }
                raster.drawPoint(x3, y);
            }
        } else {
            int yend;
            int xend;
            int y;
            int x4;
            int incr2;
            int incr1 = 2 * dx;
            int d = incr2 = 2 * (dx - dy);
            if (y1 > y2) {
                x4 = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x4 = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int xincr = xend < x4 ? -1 : 1;
            raster.drawPoint(x4, y);
            while (y < yend) {
                ++y;
                if (d < 0) {
                    d += incr1;
                } else {
                    x4 += xincr;
                    d += incr2;
                }
                raster.drawPoint(x4, y);
            }
        }
    }

    private void drawOutline(int x1, int y1, int x2, int y2, int pattern, int len, ERaster raster) {
        this.tempPt3.x = x1;
        this.tempPt3.y = y1;
        this.tempPt4.x = x2;
        this.tempPt4.y = y2;
        if (GenMath.clipLine(this.tempPt3, this.tempPt4, 0, this.sz.width - 1, 0, this.sz.height - 1)) {
            return;
        }
        this.drawPatLine(this.tempPt3.x, this.tempPt3.y, this.tempPt4.x, this.tempPt4.y, pattern, len, raster);
    }

    private void drawPatLine(int x1, int y1, int x2, int y2, int pattern, int len, ERaster raster) {
        int dy;
        int i = 0;
        int dx = Math.abs(x2 - x1);
        if (dx > (dy = Math.abs(y2 - y1))) {
            int yend;
            int xend;
            int y;
            int x3;
            int incr2;
            int incr1 = 2 * dy;
            int d = incr2 = 2 * (dy - dx);
            if (x1 > x2) {
                x3 = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x3 = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int yincr = yend < y ? -1 : 1;
            raster.drawPoint(x3, y);
            while (x3 < xend) {
                ++x3;
                if (d < 0) {
                    d += incr1;
                } else {
                    y += yincr;
                    d += incr2;
                }
                if (++i == len) {
                    i = 0;
                }
                if ((pattern & 1 << i) == 0) continue;
                raster.drawPoint(x3, y);
            }
        } else {
            int yend;
            int xend;
            int y;
            int x4;
            int incr2;
            int incr1 = 2 * dx;
            int d = incr2 = 2 * (dx - dy);
            if (y1 > y2) {
                x4 = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x4 = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int xincr = xend < x4 ? -1 : 1;
            raster.drawPoint(x4, y);
            while (y < yend) {
                ++y;
                if (d < 0) {
                    d += incr1;
                } else {
                    x4 += xincr;
                    d += incr2;
                }
                if (++i == len) {
                    i = 0;
                }
                if ((pattern & 1 << i) == 0) continue;
                raster.drawPoint(x4, y);
            }
        }
    }

    private void drawThickLine(int x1, int y1, int x2, int y2, ERaster raster) {
        int dy;
        int dx = Math.abs(x2 - x1);
        if (dx > (dy = Math.abs(y2 - y1))) {
            int yend;
            int xend;
            int y;
            int x3;
            int incr2;
            int incr1 = 2 * dy;
            int d = incr2 = 2 * (dy - dx);
            if (x1 > x2) {
                x3 = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x3 = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int yincr = yend < y ? -1 : 1;
            this.drawThickPoint(x3, y, raster);
            while (x3 < xend) {
                ++x3;
                if (d < 0) {
                    d += incr1;
                } else {
                    y += yincr;
                    d += incr2;
                }
                this.drawThickPoint(x3, y, raster);
            }
        } else {
            int yend;
            int xend;
            int y;
            int x4;
            int incr2;
            int incr1 = 2 * dx;
            int d = incr2 = 2 * (dx - dy);
            if (y1 > y2) {
                x4 = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x4 = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int xincr = xend < x4 ? -1 : 1;
            this.drawThickPoint(x4, y, raster);
            while (y < yend) {
                ++y;
                if (d < 0) {
                    d += incr1;
                } else {
                    x4 += xincr;
                    d += incr2;
                }
                this.drawThickPoint(x4, y, raster);
            }
        }
    }

    void drawPolygon(int gridOX, int gridOY, Point[] gridPoints, ERaster raster) {
        int i;
        Point[] intPoints = new Point[gridPoints.length];
        for (int i2 = 0; i2 < gridPoints.length; ++i2) {
            intPoints[i2] = new Point();
            this.gridToScreen(gridPoints[i2].x + gridOX, gridPoints[i2].y + gridOY, intPoints[i2]);
        }
        Point[] points = GenMath.clipPoly(intPoints, this.clipLX, this.clipHX, this.clipLY, this.clipHY);
        PolySeg edgelist = null;
        PolySeg[] polySegs = new PolySeg[points.length];
        for (i = 0; i < points.length; ++i) {
            polySegs[i] = new PolySeg();
            if (i == 0) {
                polySegs[i].fx = points[points.length - 1].x;
                polySegs[i].fy = points[points.length - 1].y;
            } else {
                polySegs[i].fx = points[i - 1].x;
                polySegs[i].fy = points[i - 1].y;
            }
            polySegs[i].tx = points[i].x;
            polySegs[i].ty = points[i].y;
        }
        block2: for (i = 0; i < points.length; ++i) {
            int j = polySegs[i].ty - polySegs[i].fy;
            if (j > 0) {
                polySegs[i].direction = 1;
            } else if (j < 0) {
                polySegs[i].direction = -1;
            } else {
                polySegs[i].direction = 0;
            }
            if (j == 0) {
                polySegs[i].increment = 0;
            } else {
                polySegs[i].increment = polySegs[i].tx - polySegs[i].fx;
                if (polySegs[i].increment != 0) {
                    polySegs[i].increment = (polySegs[i].increment * 65536 - j + 1) / j;
                }
            }
            polySegs[i].tx <<= 16;
            polySegs[i].fx <<= 16;
            if (polySegs[i].fy > polySegs[i].ty) {
                j = polySegs[i].tx;
                polySegs[i].tx = polySegs[i].fx;
                polySegs[i].fx = j;
                j = polySegs[i].ty;
                polySegs[i].ty = polySegs[i].fy;
                polySegs[i].fy = j;
            }
            if (edgelist == null) {
                edgelist = polySegs[i];
                polySegs[i].nextedge = null;
                continue;
            }
            if (edgelist.fy > polySegs[i].fy) {
                polySegs[i].nextedge = edgelist;
                edgelist = polySegs[i];
                continue;
            }
            PolySeg a = edgelist;
            while (a != null) {
                if (a.nextedge == null || a.nextedge.fy > polySegs[i].fy) {
                    polySegs[i].nextedge = a.nextedge;
                    a.nextedge = polySegs[i];
                    continue block2;
                }
                a = a.nextedge;
            }
        }
        int ycur = 0;
        PolySeg active = null;
        while (active != null || edgelist != null) {
            if (active == null) {
                active = edgelist;
                active.nextactive = null;
                edgelist = edgelist.nextedge;
                ycur = active.fy;
            }
            block5: while (edgelist != null && edgelist.fy <= ycur) {
                if (active.fx > edgelist.fx || active.fx == edgelist.fx && active.increment > edgelist.increment) {
                    edgelist.nextactive = active;
                    active = edgelist;
                    edgelist = edgelist.nextedge;
                    continue;
                }
                PolySeg a = active;
                while (a != null) {
                    if (a.nextactive == null || a.nextactive.fx > edgelist.fx || a.nextactive.fx == edgelist.fx && a.nextactive.increment > edgelist.increment) {
                        edgelist.nextactive = a.nextactive;
                        a.nextactive = edgelist;
                        edgelist = edgelist.nextedge;
                        continue block5;
                    }
                    a = a.nextactive;
                }
            }
            int wrap2 = 0;
            PolySeg left = active;
            PolySeg edge = active;
            while (edge != null) {
                if ((wrap2 += edge.direction) == 0) {
                    int j = left.fx + 32768 >> 16;
                    int k = edge.fx + 32768 >> 16;
                    raster.fillHorLine(ycur, j, k);
                    left = edge.nextactive;
                }
                edge = edge.nextactive;
            }
            ++ycur;
            PolySeg lastedge = null;
            PolySeg edge2 = active;
            while (edge2 != null) {
                if (ycur >= edge2.ty) {
                    if (lastedge == null) {
                        active = edge2.nextactive;
                    } else {
                        lastedge.nextactive = edge2.nextactive;
                    }
                } else {
                    edge2.fx += edge2.increment;
                    lastedge = edge2;
                }
                edge2 = edge2.nextactive;
            }
        }
        EGraphics.Outline o = raster.getOutline();
        if (o == null) {
            return;
        }
        for (int i3 = 0; i3 < points.length; ++i3) {
            int last2 = i3 - 1;
            if (last2 < 0) {
                last2 = points.length - 1;
            }
            int fX = points[last2].x;
            int fY = points[last2].y;
            int tX = points[i3].x;
            int tY = points[i3].y;
            this.drawOutline(fX, fY, tX, tY, o.getPattern(), o.getLen(), raster);
            if (o.getThickness() == 1) continue;
            int ang = GenMath.figureAngle(new Point2D.Double(fX, fY), new Point2D.Double(tX, tY));
            double sin = DBMath.sin(ang + 900);
            double cos = DBMath.cos(ang + 900);
            for (int t = 1; t < o.getThickness(); ++t) {
                int dX = (int)(cos * (double)t + 0.5);
                int dY = (int)(sin * (double)t + 0.5);
                this.drawOutline(fX + dX, fY + dY, tX + dX, tY + dY, o.getPattern(), o.getLen(), raster);
            }
        }
    }

    void drawCircle(int gridCenterX, int gridCenterY, int gridEdgeX, int gridEdgeY, ERaster raster) {
        this.gridToScreen(gridCenterX, gridCenterY, this.tempPt1);
        this.gridToScreen(gridEdgeX, gridEdgeY, this.tempPt2);
        this.drawCircle(this.tempPt1, this.tempPt2, raster);
    }

    private void drawCircle(Point center, Point edge, ERaster raster) {
        int x2;
        int radius = (int)center.distance(edge);
        int left = center.x - radius;
        int right = center.x + radius + 1;
        int top = center.y - radius;
        int bottom = center.y + radius + 1;
        int y = radius;
        int d = 3 - 2 * radius;
        if (left >= 0 && right < this.sz.width && top >= 0 && bottom < this.sz.height) {
            for (x2 = 0; x2 <= y; ++x2) {
                raster.drawPoint(center.x + x2, center.y + y);
                raster.drawPoint(center.x - x2, center.y + y);
                raster.drawPoint(center.x + x2, center.y - y);
                raster.drawPoint(center.x - x2, center.y - y);
                raster.drawPoint(center.x + y, center.y + x2);
                raster.drawPoint(center.x - y, center.y + x2);
                raster.drawPoint(center.x + y, center.y - x2);
                raster.drawPoint(center.x - y, center.y - x2);
                if (d < 0) {
                    d += 4 * x2 + 6;
                    continue;
                }
                d += 4 * (x2 - y) + 10;
                --y;
            }
        } else {
            while (x2 <= y) {
                int thisx;
                int thisy = center.y + y;
                if (thisy >= 0 && thisy < this.sz.height) {
                    thisx = center.x + x2;
                    if (thisx >= 0 && thisx < this.sz.width) {
                        raster.drawPoint(thisx, thisy);
                    }
                    if ((thisx = center.x - x2) >= 0 && thisx < this.sz.width) {
                        raster.drawPoint(thisx, thisy);
                    }
                }
                if ((thisy = center.y - y) >= 0 && thisy < this.sz.height) {
                    thisx = center.x + x2;
                    if (thisx >= 0 && thisx < this.sz.width) {
                        raster.drawPoint(thisx, thisy);
                    }
                    if ((thisx = center.x - x2) >= 0 && thisx < this.sz.width) {
                        raster.drawPoint(thisx, thisy);
                    }
                }
                if ((thisy = center.y + x2) >= 0 && thisy < this.sz.height) {
                    thisx = center.x + y;
                    if (thisx >= 0 && thisx < this.sz.width) {
                        raster.drawPoint(thisx, thisy);
                    }
                    if ((thisx = center.x - y) >= 0 && thisx < this.sz.width) {
                        raster.drawPoint(thisx, thisy);
                    }
                }
                if ((thisy = center.y - x2) >= 0 && thisy < this.sz.height) {
                    thisx = center.x + y;
                    if (thisx >= 0 && thisx < this.sz.width) {
                        raster.drawPoint(thisx, thisy);
                    }
                    if ((thisx = center.x - y) >= 0 && thisx < this.sz.width) {
                        raster.drawPoint(thisx, thisy);
                    }
                }
                if (d < 0) {
                    d += 4 * x2 + 6;
                } else {
                    d += 4 * (x2 - y) + 10;
                    --y;
                }
                ++x2;
            }
        }
    }

    void drawThickCircle(int gridCenterX, int gridCenterY, int gridEdgeX, int gridEdgeY, ERaster raster) {
        this.gridToScreen(gridCenterX, gridCenterY, this.tempPt1);
        this.gridToScreen(gridEdgeX, gridEdgeY, this.tempPt2);
        this.drawThickCircle(this.tempPt1, this.tempPt2, raster);
    }

    private void drawThickCircle(Point center, Point edge, ERaster raster) {
        int radius = (int)center.distance(edge);
        int y = radius;
        int d = 3 - 2 * radius;
        for (int x2 = 0; x2 <= y; ++x2) {
            int thisx;
            int thisy = center.y + y;
            if (thisy >= 0 && thisy < this.sz.height) {
                thisx = center.x + x2;
                if (thisx >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, raster);
                }
                if ((thisx = center.x - x2) >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, raster);
                }
            }
            if ((thisy = center.y - y) >= 0 && thisy < this.sz.height) {
                thisx = center.x + x2;
                if (thisx >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, raster);
                }
                if ((thisx = center.x - x2) >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, raster);
                }
            }
            if ((thisy = center.y + x2) >= 0 && thisy < this.sz.height) {
                thisx = center.x + y;
                if (thisx >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, raster);
                }
                if ((thisx = center.x - y) >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, raster);
                }
            }
            if ((thisy = center.y - x2) >= 0 && thisy < this.sz.height) {
                thisx = center.x + y;
                if (thisx >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, raster);
                }
                if ((thisx = center.x - y) >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, raster);
                }
            }
            if (d < 0) {
                d += 4 * x2 + 6;
                continue;
            }
            d += 4 * (x2 - y) + 10;
            --y;
        }
    }

    private void drawDiscRow(int thisy, int startx, int endx, ERaster raster) {
        if (thisy < this.clipLY || thisy > this.clipHY) {
            return;
        }
        if (startx < this.clipLX) {
            startx = this.clipLX;
        }
        if (endx > this.clipHX) {
            endx = this.clipHX;
        }
        if (startx > endx) {
            return;
        }
        raster.fillHorLine(thisy, startx, endx);
    }

    void drawDisc(int gridCenterX, int gridCenterY, int gridEdgeX, int gridEdgeY, ERaster raster) {
        this.gridToScreen(gridCenterX, gridCenterY, this.tempPt1);
        this.gridToScreen(gridEdgeX, gridEdgeY, this.tempPt2);
        this.drawDisc(this.tempPt1, this.tempPt2, raster);
    }

    public void drawOval(int gridCenterX, int gridCenterY, int pixelRadius, ERaster raster) {
        this.gridToScreen(gridCenterX, gridCenterY, this.tempPt1);
        this.drawDisc(this.tempPt1, pixelRadius, raster);
    }

    private void drawDisc(Point center, Point edge, ERaster raster) {
        int radius = (int)center.distance(edge);
        EGraphics.Outline o = raster.getOutline();
        if (o != null) {
            this.drawCircle(center, edge, raster);
        }
        this.drawDisc(center, radius, raster);
    }

    private void drawDisc(Point center, int radius, ERaster raster) {
        int left = center.x - radius;
        int right = center.x + radius + 1;
        int top = center.y - radius;
        int bottom = center.y + radius + 1;
        if (radius == 1) {
            if (left < 0) {
                left = 0;
            }
            if (right >= this.sz.width) {
                right = this.sz.width - 1;
            }
            for (int y = top; y < bottom; ++y) {
                if (y < 0 || y >= this.sz.height) continue;
                for (int x2 = left; x2 < right; ++x2) {
                    raster.drawPoint(x2, y);
                }
            }
            return;
        }
        int y = radius;
        int d = 3 - 2 * radius;
        for (int x3 = 0; x3 <= y; ++x3) {
            this.drawDiscRow(center.y + y, center.x - x3, center.x + x3, raster);
            this.drawDiscRow(center.y - y, center.x - x3, center.x + x3, raster);
            this.drawDiscRow(center.y + x3, center.x - y, center.x + y, raster);
            this.drawDiscRow(center.y - x3, center.x - y, center.x + y, raster);
            if (d < 0) {
                d += 4 * x3 + 6;
                continue;
            }
            d += 4 * (x3 - y) + 10;
            --y;
        }
    }

    private int arcFindOctant(int x2, int y) {
        if (x2 > 0) {
            if (y >= 0) {
                if (y >= x2) {
                    return 7;
                }
                return 8;
            }
            if (x2 >= -y) {
                return 1;
            }
            return 2;
        }
        if (y > 0) {
            if (y > -x2) {
                return 6;
            }
            return 5;
        }
        if (y > x2) {
            return 4;
        }
        return 3;
    }

    private Point arcXformOctant(int x2, int y, int oct) {
        switch (oct) {
            case 1: {
                return new Point(-y, x2);
            }
            case 2: {
                return new Point(x2, -y);
            }
            case 3: {
                return new Point(-x2, -y);
            }
            case 4: {
                return new Point(-y, -x2);
            }
            case 5: {
                return new Point(y, -x2);
            }
            case 6: {
                return new Point(-x2, y);
            }
            case 7: {
                return new Point(x2, y);
            }
            case 8: {
                return new Point(y, x2);
            }
        }
        return null;
    }

    private void arcDoPixel(int x2, int y) {
        if (x2 < this.clipLX || x2 > this.clipHX || y < this.clipLY || y > this.clipHY) {
            return;
        }
        if (this.arcThick) {
            this.drawThickPoint(x2, y, this.arcRaster);
        } else {
            this.arcRaster.drawPoint(x2, y);
        }
    }

    private void arcOutXform(int x2, int y) {
        if (this.arcOctTable[1]) {
            this.arcDoPixel(y + this.arcCenter.x, -x2 + this.arcCenter.y);
        }
        if (this.arcOctTable[2]) {
            this.arcDoPixel(x2 + this.arcCenter.x, -y + this.arcCenter.y);
        }
        if (this.arcOctTable[3]) {
            this.arcDoPixel(-x2 + this.arcCenter.x, -y + this.arcCenter.y);
        }
        if (this.arcOctTable[4]) {
            this.arcDoPixel(-y + this.arcCenter.x, -x2 + this.arcCenter.y);
        }
        if (this.arcOctTable[5]) {
            this.arcDoPixel(-y + this.arcCenter.x, x2 + this.arcCenter.y);
        }
        if (this.arcOctTable[6]) {
            this.arcDoPixel(-x2 + this.arcCenter.x, y + this.arcCenter.y);
        }
        if (this.arcOctTable[7]) {
            this.arcDoPixel(x2 + this.arcCenter.x, y + this.arcCenter.y);
        }
        if (this.arcOctTable[8]) {
            this.arcDoPixel(y + this.arcCenter.x, x2 + this.arcCenter.y);
        }
    }

    private void arcBresCW(Point pt, Point pt1) {
        int d = 3 - 2 * pt.y + 4 * pt.x;
        while (pt.x < pt1.x && pt.y > pt1.y) {
            this.arcOutXform(pt.x, pt.y);
            if (d < 0) {
                d += 4 * pt.x + 6;
            } else {
                d += 4 * (pt.x - pt.y) + 10;
                --pt.y;
            }
            ++pt.x;
        }
        while (pt.x < pt1.x) {
            this.arcOutXform(pt.x, pt.y);
            ++pt.x;
        }
        while (pt.y > pt1.y) {
            this.arcOutXform(pt.x, pt.y);
            --pt.y;
        }
        this.arcOutXform(pt1.x, pt1.y);
    }

    private void arcBresMidCW(Point pt) {
        int d = 3 - 2 * pt.y + 4 * pt.x;
        while (pt.x < pt.y) {
            this.arcOutXform(pt.x, pt.y);
            if (d < 0) {
                d += 4 * pt.x + 6;
            } else {
                d += 4 * (pt.x - pt.y) + 10;
                --pt.y;
            }
            ++pt.x;
        }
        if (pt.x == pt.y) {
            this.arcOutXform(pt.x, pt.y);
        }
    }

    private void arcBresMidCCW(Point pt) {
        int d = 3 + 2 * pt.y - 4 * pt.x;
        while (pt.x > 0) {
            this.arcOutXform(pt.x, pt.y);
            if (d > 0) {
                d += 6 - 4 * pt.x;
            } else {
                d += 4 * (pt.y - pt.x) + 10;
                ++pt.y;
            }
            --pt.x;
        }
        this.arcOutXform(0, this.arcRadius);
    }

    private void arcBresCCW(Point pt, Point pt1) {
        int d = 3 + 2 * pt.y + 4 * pt.x;
        while (pt.x > pt1.x && pt.y < pt1.y) {
            this.arcOutXform(pt.x, pt.y);
            if (d > 0) {
                d += 6 - 4 * pt.x;
            } else {
                d += 4 * (pt.y - pt.x) + 10;
                ++pt.y;
            }
            --pt.x;
        }
        while (pt.x > pt1.x) {
            this.arcOutXform(pt.x, pt.y);
            --pt.x;
        }
        while (pt.y < pt1.y) {
            this.arcOutXform(pt.x, pt.y);
            ++pt.y;
        }
        this.arcOutXform(pt1.x, pt1.y);
    }

    void drawCircleArc(int gridCenterX, int gridCenterY, int gridX1, int gridY1, int gridX2, int gridY2, boolean thick, ERaster raster) {
        this.gridToScreen(gridCenterX, gridCenterY, this.tempPt1);
        this.gridToScreen(gridX1, gridY1, this.tempPt2);
        this.gridToScreen(gridX2, gridY2, this.tempPt3);
        this.drawCircleArc(this.tempPt1, this.tempPt2, this.tempPt3, thick, raster);
    }

    private void drawCircleArc(Point center, Point p1, Point p2, boolean thick, ERaster raster) {
        if (p1.x == p2.x && p1.y == p2.y) {
            return;
        }
        this.arcRaster = raster;
        this.arcCenter = center;
        int pa_x = p2.x - this.arcCenter.x;
        int pa_y = p2.y - this.arcCenter.y;
        int pb_x = p1.x - this.arcCenter.x;
        int pb_y = p1.y - this.arcCenter.y;
        this.arcRadius = (int)this.arcCenter.distance(p2);
        int alternate = (int)this.arcCenter.distance(p1);
        int start_oct = this.arcFindOctant(pa_x, pa_y);
        int end_oct = this.arcFindOctant(pb_x, pb_y);
        this.arcThick = thick;
        if (this.arcRadius != alternate) {
            int diff2 = this.arcRadius - alternate;
            switch (end_oct) {
                case 6: 
                case 7: {
                    pb_y += diff2;
                    break;
                }
                case 1: 
                case 8: {
                    pb_x += diff2;
                    break;
                }
                case 2: 
                case 3: {
                    pb_y -= diff2;
                    break;
                }
                case 4: 
                case 5: {
                    pb_x -= diff2;
                }
            }
        }
        for (int i = 1; i < 9; ++i) {
            this.arcOctTable[i] = false;
        }
        if (start_oct == end_oct) {
            this.arcOctTable[start_oct] = true;
            Point pa = this.arcXformOctant(pa_x, pa_y, start_oct);
            Point pb = this.arcXformOctant(pb_x, pb_y, start_oct);
            if ((start_oct & 1) != 0) {
                this.arcBresCW(pa, pb);
            } else {
                this.arcBresCCW(pa, pb);
            }
            this.arcOctTable[start_oct] = false;
        } else {
            this.arcOctTable[start_oct] = true;
            Point pt = this.arcXformOctant(pa_x, pa_y, start_oct);
            if ((start_oct & 1) != 0) {
                this.arcBresMidCW(pt);
            } else {
                this.arcBresMidCCW(pt);
            }
            this.arcOctTable[start_oct] = false;
            this.arcOctTable[end_oct] = true;
            pt = this.arcXformOctant(pb_x, pb_y, end_oct);
            if ((end_oct & 1) != 0) {
                this.arcBresMidCCW(pt);
            } else {
                this.arcBresMidCW(pt);
            }
            this.arcOctTable[end_oct] = false;
            if (this.MODP(start_oct + 1) != end_oct) {
                if (this.MODP(start_oct + 1) == this.MODM(end_oct - 1)) {
                    this.arcOctTable[this.MODP((int)(start_oct + 1))] = true;
                } else {
                    int i = this.MODP(start_oct + 1);
                    while (i != end_oct) {
                        this.arcOctTable[i] = true;
                        i = this.MODP(i + 1);
                    }
                }
                this.arcBresMidCW(new Point(0, this.arcRadius));
            }
        }
    }

    private int MODM(int x2) {
        return x2 < 1 ? x2 + 8 : x2;
    }

    private int MODP(int x2) {
        return x2 > 8 ? x2 - 8 : x2;
    }

    void drawThickPoint(int x2, int y, ERaster raster) {
        raster.drawPoint(x2, y);
        if (x2 > this.clipLX) {
            raster.drawPoint(x2 - 1, y);
        }
        if (x2 < this.clipHX) {
            raster.drawPoint(x2 + 1, y);
        }
        if (y > this.clipLY) {
            raster.drawPoint(x2, y - 1);
        }
        if (y < this.sz.height - 1) {
            raster.drawPoint(x2, y + 1);
        }
    }

    public void databaseToScreen(double dbX, double dbY, Point result2) {
        double scrX = this.originX + dbX * this.scale;
        double scrY = this.originY - dbY * this.scale;
        result2.x = (int)(scrX >= 0.0 ? scrX + 0.5 : scrX - 0.5);
        result2.y = (int)(scrY >= 0.0 ? scrY + 0.5 : scrY - 0.5);
    }

    void gridToScreen(int dbX, int dbY, Point result2) {
        double scrX = (double)((float)dbX - this.factorX) * this.scale_;
        double scrY = (double)(this.factorY - (float)dbY) * this.scale_;
        result2.x = (int)(scrX >= 0.0 ? scrX + 0.5 : scrX - 0.5);
        result2.y = (int)(scrY >= 0.0 ? scrY + 0.5 : scrY - 0.5);
    }

    void screenToGrid(int scrX, int scrY, Point result2) {
        double dbX = (double)scrX / this.scale_ + (double)this.factorX;
        double dbY = (double)this.factorY - (double)scrY / this.scale_;
        result2.x = (int)(dbX >= 0.0 ? dbX + 0.5 : dbX - 0.5);
        result2.y = (int)(dbY >= 0.0 ? dbY + 0.5 : dbY - 0.5);
    }

    void screenToDatabase(int x2, int y, Point2D result2) {
        result2.setLocation(((double)x2 - this.originX) / this.scale, (this.originY - (double)y) / this.scale);
    }

    Rectangle databaseToScreen(Rectangle2D db) {
        int swap;
        Point llPt = this.tempPt1;
        Point urPt = this.tempPt2;
        this.databaseToScreen(db.getMinX(), db.getMinY(), llPt);
        this.databaseToScreen(db.getMaxX(), db.getMaxY(), urPt);
        int screenLX = llPt.x;
        int screenHX = urPt.x;
        int screenLY = llPt.y;
        int screenHY = urPt.y;
        if (screenHX < screenLX) {
            swap = screenHX;
            screenHX = screenLX;
            screenLX = swap;
        }
        if (screenHY < screenLY) {
            swap = screenHY;
            screenHY = screenLY;
            screenLY = swap;
        }
        return new Rectangle(screenLX, screenLY, screenHX - screenLX + 1, screenHY - screenLY + 1);
    }

    private static class PolySeg {
        private int fx;
        private int fy;
        private int tx;
        private int ty;
        private int direction;
        private int increment;
        private PolySeg nextedge;
        private PolySeg nextactive;

        private PolySeg() {
        }
    }
}

