/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.topology;

import com.sun.electric.database.geometry.EPoint;
import java.util.ArrayList;
import java.util.List;

public class SteinerTree {
    private List<SteinerTreePortPair> pairs = new ArrayList<SteinerTreePortPair>();

    public SteinerTree(List<SteinerTreePort> portList) {
        if (portList.size() < 2) {
            return;
        }
        ArrayList<SteinerTreePort> seen = new ArrayList<SteinerTreePort>();
        seen.add(portList.get(0));
        ArrayList<SteinerTreePort> remaining = new ArrayList<SteinerTreePort>();
        for (int i = 1; i < portList.size(); ++i) {
            remaining.add(portList.get(i));
        }
        while (remaining.size() > 0) {
            double bestDist = Double.MAX_VALUE;
            SteinerTreePort bestRem = null;
            SteinerTreePort bestSeen = null;
            for (SteinerTreePort piRem : remaining) {
                for (SteinerTreePort piSeen : seen) {
                    double dist = piRem.getCenter().distance(piSeen.getCenter());
                    if (!(dist < bestDist)) continue;
                    bestDist = dist;
                    bestRem = piRem;
                    bestSeen = piSeen;
                }
            }
            if (bestRem == null) continue;
            SteinerTreePortPair pp = this.makeTreeBranch(bestRem, bestSeen);
            this.pairs.add(pp);
            remaining.remove(bestRem);
            seen.add(bestRem);
        }
    }

    public SteinerTreePortPair makeTreeBranch(SteinerTreePort p1, SteinerTreePort p2) {
        return new SteinerTreePortPair(p1, p2);
    }

    public List<SteinerTreePortPair> getTreeBranches() {
        return this.pairs;
    }

    public static class SteinerTreePortPair {
        private SteinerTreePort p1;
        private SteinerTreePort p2;

        public SteinerTreePortPair(SteinerTreePort p1, SteinerTreePort p2) {
            this.p1 = p1;
            this.p2 = p2;
        }

        public SteinerTreePort getPort1() {
            return this.p1;
        }

        public SteinerTreePort getPort2() {
            return this.p2;
        }
    }

    public static interface SteinerTreePort {
        public EPoint getCenter();
    }
}

