/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.general;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.placement.PlacementAdapter;
import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;

public class RowCol
extends PlacementFrame {
    protected List<ProxyNode> nodesToPlace;
    protected Map<PlacementFrame.PlacementNode, ProxyNode> proxyMap;
    protected boolean columnPlacement;
    protected int numStacks;
    protected List<ProxyNode>[] stackContents;
    protected double[] stackSizes;
    protected double[] stackCoords;
    protected boolean[] stacksBusy;
    protected boolean makeStacksEven;
    protected boolean flipAlternateColsRows;
    private Random randNum = new Random();

    @Override
    public String getAlgorithmName() {
        return "?";
    }

    @Override
    public void runPlacement(List<PlacementFrame.PlacementNode> placementNodes, List<PlacementFrame.PlacementNetwork> allNetworks, List<PlacementAdapter.PlacementExport> exportsToPlace, String cellName, Job job) {
        this.makeStacksEven = this.getBooleanParam("makeStacksEven");
        this.flipAlternateColsRows = this.getBooleanParam("flipColRow");
        TreeSet<Double> widths = new TreeSet<Double>();
        TreeSet<Double> heights = new TreeSet<Double>();
        Boolean useColumns = RowCol.isColumnPlacement(placementNodes, widths, heights, false);
        if (useColumns == null) {
            System.out.println("Not all cells have a common width or height: do not know how to place.  Sorry.");
            if (widths.size() < heights.size()) {
                System.out.print("  (Did find " + widths.size() + " common widths:");
                for (Double d : widths) {
                    System.out.print(" " + d);
                }
                System.out.println(")");
            } else {
                System.out.print("  (Did find " + heights.size() + " common heights:");
                for (Double d : heights) {
                    System.out.print(" " + d);
                }
                System.out.println(")");
            }
            this.setFailure(true);
            return;
        }
        this.columnPlacement = useColumns;
        this.nodesToPlace = new ArrayList<ProxyNode>(placementNodes.size());
        this.proxyMap = new HashMap<PlacementFrame.PlacementNode, ProxyNode>();
        for (PlacementFrame.PlacementNode p : placementNodes) {
            ProxyNode proxy = new ProxyNode(p);
            this.nodesToPlace.add(proxy);
            this.proxyMap.put(p, proxy);
        }
        this.initLayout();
        boolean complete = this.runRowColPlacement(placementNodes, allNetworks);
        if (complete && this.makeStacksEven) {
            System.out.println("  Making the stacks have even height");
            this.evenAllStacks(allNetworks);
        }
        for (PlacementFrame.PlacementNode pn : placementNodes) {
            ProxyNode p = this.proxyMap.get(pn);
            pn.setPlacement(p.getPlacementX(), p.getPlacementY());
            pn.setOrientation(p.getPlacementOrientation());
        }
    }

    protected boolean runRowColPlacement(List<PlacementFrame.PlacementNode> placementNodes, List<PlacementFrame.PlacementNetwork> allNetworks) {
        return true;
    }

    boolean getBooleanParam(String name) {
        List<PlacementFrame.PlacementParameter> params = this.getParameters();
        for (PlacementFrame.PlacementParameter pp : params) {
            if (!pp.getParameterName().equals(name)) continue;
            return pp.getBooleanValue();
        }
        return false;
    }

    private void initLayout() {
        int i;
        double totalSize = 0.0;
        double maxGirth = 0.0;
        for (ProxyNode plNode : this.nodesToPlace) {
            totalSize += plNode.getCellSize();
            maxGirth = Math.max(maxGirth, plNode.getCellGirth());
        }
        double avgCellSize = totalSize / (double)this.nodesToPlace.size();
        double avgStackSize = Math.sqrt(totalSize * maxGirth);
        this.numStacks = (int)Math.round(totalSize / avgStackSize);
        int numPerStack = (int)Math.ceil((double)this.nodesToPlace.size() / (double)this.numStacks);
        this.stackCoords = new double[this.numStacks];
        this.stackContents = new List[this.numStacks];
        this.stackSizes = new double[this.numStacks];
        this.stacksBusy = new boolean[this.numStacks];
        for (int i2 = 0; i2 < this.numStacks; ++i2) {
            this.stackContents[i2] = new ArrayList<ProxyNode>();
            this.stackSizes[i2] = 0.0;
            this.stacksBusy[i2] = false;
        }
        double girthPos = -maxGirth;
        double stackPos = 0.0;
        int stackIndex = -1;
        for (i = 0; i < this.nodesToPlace.size(); ++i) {
            if (i % numPerStack == 0) {
                stackPos = 0.0;
                this.stackCoords[++stackIndex] = girthPos += maxGirth;
            }
            ProxyNode plNode = this.nodesToPlace.get(i);
            Orientation o = this.getOrientation(stackIndex);
            if (this.columnPlacement) {
                plNode.setPlacement(girthPos, stackPos, stackIndex, o, true);
            } else {
                plNode.setPlacement(stackPos, girthPos, stackIndex, o, true);
            }
            stackPos += avgCellSize;
            List<ProxyNode> pnList = this.stackContents[stackIndex];
            int n = stackIndex;
            this.stackSizes[n] = this.stackSizes[n] + plNode.getCellSize();
            pnList.add(plNode);
        }
        for (i = 0; i < this.numStacks; ++i) {
            List<ProxyNode> pnList = this.stackContents[i];
            Collections.sort(pnList);
            this.evenStack(i);
        }
    }

    public static Boolean isColumnPlacement(List<PlacementFrame.PlacementNode> placementNodes, Set<Double> widths, Set<Double> heights, boolean quiet) {
        Double commonWid = new Double(-1.0);
        Double commonHei = new Double(-1.0);
        for (PlacementFrame.PlacementNode p : placementNodes) {
            PlacementAdapter.PlacementNode papn = (PlacementAdapter.PlacementNode)p;
            if (papn.getOriginal() == null) {
                System.out.println("Original node of '" + papn + "' not found in column placement");
                continue;
            }
            if (!papn.getOriginal().isCellInstance()) continue;
            if (widths != null) {
                widths.add(new Double(p.getWidth()));
            }
            if (heights != null) {
                heights.add(new Double(p.getHeight()));
            }
            if (commonWid != null) {
                if (commonWid < 0.0) {
                    commonWid = new Double(p.getWidth());
                }
                if (commonWid.doubleValue() != p.getWidth()) {
                    commonWid = null;
                }
            }
            if (commonHei == null) continue;
            if (commonHei < 0.0) {
                commonHei = new Double(p.getHeight());
            }
            if (commonHei.doubleValue() == p.getHeight()) continue;
            commonHei = null;
        }
        if (commonWid == null && commonHei == null) {
            return null;
        }
        Boolean useColumns = Boolean.FALSE;
        if (commonWid != null && commonHei == null) {
            useColumns = Boolean.TRUE;
            if (!quiet) {
                System.out.println("  Doing placement in columns");
            }
        } else if (commonWid == null && commonHei != null) {
            if (!quiet) {
                System.out.println("  Doing placement in rows");
            }
        } else if (!quiet) {
            System.out.println("  All cells have same size: presuming row-based placement");
        }
        return useColumns;
    }

    private void evenAllStacks(List<PlacementFrame.PlacementNetwork> allNetworks) {
        double bestGain;
        boolean[] stackConsidered = new boolean[this.numStacks];
        block0: do {
            int tallestStack;
            double initialLength = this.netLength(allNetworks);
            int bestOtherStack = -1;
            int placeInOtherStack = -1;
            bestGain = 0.0;
            ProxyNode nodeToMove = null;
            for (int i = 0; i < this.numStacks; ++i) {
                stackConsidered[i] = false;
            }
            do {
                tallestStack = -1;
                for (int i = 0; i < this.numStacks; ++i) {
                    if (stackConsidered[i] || tallestStack >= 0 && !(this.stackSizes[i] > this.stackSizes[tallestStack])) continue;
                    tallestStack = i;
                }
                if (tallestStack < 0) continue block0;
                stackConsidered[tallestStack] = true;
                for (ProxyNode pn : this.stackContents[tallestStack]) {
                    double size2 = pn.getCellSize();
                    for (int i = 0; i < this.numStacks; ++i) {
                        if (i == tallestStack || this.stackSizes[i] + size2 > this.stackSizes[tallestStack] - size2) continue;
                        for (int j = 0; j < this.stackContents[i].size(); ++j) {
                            this.proposeMove(pn, tallestStack, i, j);
                            double proposedLength = 0.0;
                            for (PlacementFrame.PlacementNetwork net : allNetworks) {
                                proposedLength += this.netLength(net, tallestStack, i);
                            }
                            double gain = initialLength - proposedLength;
                            if (!(gain > bestGain)) continue;
                            bestOtherStack = i;
                            placeInOtherStack = j;
                            bestGain = gain;
                            nodeToMove = pn;
                        }
                    }
                }
            } while (!(bestGain > 0.0));
            this.proposeMove(nodeToMove, tallestStack, bestOtherStack, placeInOtherStack);
            this.implementMove(nodeToMove, tallestStack, bestOtherStack, placeInOtherStack);
        } while (bestGain != 0.0);
    }

    private Orientation getOrientation(int index) {
        Orientation o = Orientation.IDENT;
        if (this.flipAlternateColsRows && index % 2 != 0) {
            if (this.columnPlacement) {
                return Orientation.X;
            }
            return Orientation.Y;
        }
        return o;
    }

    protected void implementMove(ProxyNode node, int oldIndex, int newIndex, int newPlaceInStack) {
        this.remove(node);
        node.setPlacement(node.getProposedX(), node.getProposedY(), node.getProposedIndex(), this.getOrientation(node.getProposedIndex()), true);
        this.put(node, newIndex, newPlaceInStack);
        this.evenStack(oldIndex);
        if (newIndex != oldIndex) {
            this.evenStack(newIndex);
        }
    }

    protected void proposeMove(ProxyNode node, int oldIndex, int newIndex, int newPlaceInStack) {
        Orientation newOrient = this.getOrientation(newIndex);
        if (oldIndex != newIndex) {
            double bottom = 0.0;
            List<ProxyNode> pnList = this.stackContents[oldIndex];
            for (ProxyNode pn : pnList) {
                if (pn == node) continue;
                double x2 = pn.getPlacementX();
                double y = pn.getPlacementY();
                double size2 = pn.getCellSize();
                if (this.columnPlacement) {
                    y = bottom + size2 / 2.0;
                } else {
                    x2 = bottom + size2 / 2.0;
                }
                bottom += size2;
                pn.setProposed(x2, y, pn.getColumnRowIndex(), pn.getPlacementOrientation());
            }
            bottom = 0.0;
            boolean notInserted = true;
            List<ProxyNode> newList = this.stackContents[newIndex];
            for (int i = 0; i < newList.size(); ++i) {
                ProxyNode pn = newList.get(i);
                Orientation o = pn.getPlacementOrientation();
                double x3 = pn.getPlacementX();
                double y = pn.getPlacementY();
                if (notInserted && i == newPlaceInStack) {
                    if (this.columnPlacement) {
                        x3 = this.stackCoords[newIndex];
                    } else {
                        y = this.stackCoords[newIndex];
                    }
                    pn = node;
                    o = newOrient;
                    --i;
                    notInserted = false;
                }
                double size3 = pn.getCellSize();
                if (this.columnPlacement) {
                    y = bottom + size3 / 2.0;
                } else {
                    x3 = bottom + size3 / 2.0;
                }
                bottom += size3;
                pn.setProposed(x3, y, newIndex, o);
            }
            if (notInserted) {
                double size4 = node.getCellSize();
                if (this.columnPlacement) {
                    node.setProposed(this.stackCoords[newIndex], bottom + size4 / 2.0, newIndex, newOrient);
                } else {
                    node.setProposed(bottom + size4 / 2.0, this.stackCoords[newIndex], newIndex, newOrient);
                }
            }
        } else {
            double bottom = 0.0;
            boolean notInserted = true;
            int movedNodes = 0;
            for (int i = 0; i < this.stackContents[newIndex].size(); ++i) {
                ProxyNode pn = this.stackContents[newIndex].get(i);
                if (pn == node) continue;
                if (notInserted && movedNodes == newPlaceInStack) {
                    pn = node;
                    --i;
                    notInserted = false;
                }
                double x4 = pn.getPlacementX();
                double y = pn.getPlacementY();
                double size5 = pn.getCellSize();
                if (this.columnPlacement) {
                    y = bottom + size5 / 2.0;
                } else {
                    x4 = bottom + size5 / 2.0;
                }
                bottom += size5;
                pn.setProposed(x4, y, newIndex, pn.getPlacementOrientation());
                ++movedNodes;
            }
            if (notInserted) {
                double size6 = node.getCellSize();
                if (this.columnPlacement) {
                    node.setProposed(node.getPlacementX(), bottom + size6 / 2.0, newIndex, newOrient);
                } else {
                    node.setProposed(bottom + size6 / 2.0, node.getPlacementY(), newIndex, newOrient);
                }
            }
        }
    }

    protected synchronized int lockRandomStack() {
        int index = this.randNum.nextInt(this.numStacks);
        for (int i = 0; i < this.numStacks; ++i) {
            if (!this.stacksBusy[index]) {
                this.stacksBusy[index] = true;
                return index;
            }
            index = (index + 1) % this.numStacks;
        }
        return -1;
    }

    protected void releaseStack(int index) {
        this.stacksBusy[index] = false;
    }

    private double netLength(List<PlacementFrame.PlacementNetwork> networks) {
        double length = 0.0;
        for (PlacementFrame.PlacementNetwork net : networks) {
            length += this.netLength(net, -1, -1);
        }
        return length;
    }

    protected double netLength(PlacementFrame.PlacementNetwork net, int workingIndex1, int workingIndex2) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        for (PlacementFrame.PlacementPort port : net.getPortsOnNet()) {
            Orientation o;
            double currY;
            double currX;
            ProxyNode pn = this.proxyMap.get(port.getPlacementNode());
            if (pn.getColumnRowIndex() == workingIndex1 || pn.getColumnRowIndex() == workingIndex2) {
                currX = pn.getProposedX();
                currY = pn.getProposedY();
                o = pn.getProposedOrientation();
            } else {
                currX = pn.getPlacementX();
                currY = pn.getPlacementY();
                o = pn.getPlacementOrientation();
            }
            currX = o == Orientation.X ? (currX -= port.getOffX()) : (currX += port.getOffX());
            currY = o == Orientation.Y ? (currY -= port.getOffY()) : (currY += port.getOffY());
            if (currX < minX) {
                minX = currX;
            }
            if (currX > maxX) {
                maxX = currX;
            }
            if (currY < minY) {
                minY = currY;
            }
            if (!(currY > maxY)) continue;
            maxY = currY;
        }
        return maxX - minX + (maxY - minY);
    }

    protected ProxyNode getRandomNode(int index) {
        List<ProxyNode> pnList = this.stackContents[index];
        return pnList.get(this.randNum.nextInt(pnList.size()));
    }

    private void put(ProxyNode node, int index, int position) {
        List<ProxyNode> pnList = this.stackContents[index];
        pnList.add(position, node);
        int n = index;
        this.stackSizes[n] = this.stackSizes[n] + node.getCellSize();
    }

    private void remove(ProxyNode node) {
        int index = node.getColumnRowIndex();
        List<ProxyNode> pnList = this.stackContents[index];
        if (!pnList.remove(node)) {
            System.out.println("ERROR: could not remove node from stack " + index);
        }
        int n = index;
        this.stackSizes[n] = this.stackSizes[n] - node.getCellSize();
    }

    private void evenStack(int index) {
        double bottom = 0.0;
        List<ProxyNode> pnList = this.stackContents[index];
        for (ProxyNode pn : pnList) {
            double x2 = pn.getPlacementX();
            double y = pn.getPlacementY();
            double size2 = pn.getCellSize();
            if (this.columnPlacement) {
                y = bottom + size2 / 2.0;
            } else {
                x2 = bottom + size2 / 2.0;
            }
            bottom += size2;
            pn.setPlacement(x2, y, index, pn.getPlacementOrientation(), true);
        }
    }

    class ProxyNode
    implements Comparable<ProxyNode> {
        private double x;
        private double y;
        private double newX;
        private double newY;
        private int index;
        private int proposedIndex;
        private Orientation orientation;
        private Orientation proposedOrientation;
        private double width = 0.0;
        private double height = 0.0;
        private List<PlacementFrame.PlacementNetwork> nets = new ArrayList<PlacementFrame.PlacementNetwork>();

        public ProxyNode(PlacementFrame.PlacementNode node) {
            this.x = node.getPlacementX();
            this.y = node.getPlacementY();
            NodeProto np = ((PlacementAdapter.PlacementNode)node).getType();
            Rectangle2D spacing = null;
            if (np instanceof Cell) {
                spacing = ((Cell)np).findEssentialBounds();
            }
            if (spacing == null) {
                this.width = node.getWidth();
                this.height = node.getHeight();
            } else {
                this.width = spacing.getWidth();
                this.height = spacing.getHeight();
            }
            for (PlacementFrame.PlacementPort p : node.getPorts()) {
                if (this.nets.contains(p.getPlacementNetwork()) || p.getPlacementNetwork() == null) continue;
                this.nets.add(p.getPlacementNetwork());
            }
            this.orientation = node.getPlacementOrientation();
        }

        public void setProposed(double x2, double y, int ind, Orientation o) {
            this.newX = x2;
            this.newY = y;
            this.proposedIndex = ind;
            this.proposedOrientation = o;
        }

        public double getProposedX() {
            return this.newX;
        }

        public double getProposedY() {
            return this.newY;
        }

        public int getProposedIndex() {
            return this.proposedIndex;
        }

        public Orientation getProposedOrientation() {
            return this.proposedOrientation;
        }

        public void setPlacement(double x2, double y, int ind, Orientation o, boolean check2) {
            if (check2) {
                Orientation oReq;
                double req = RowCol.this.stackCoords[ind];
                if (RowCol.this.columnPlacement) {
                    if (x2 != req) {
                        System.out.println("Moving node from (" + this.x + "[" + this.index + "]," + this.y + ") to (" + x2 + "[" + ind + "]," + y + ") BUT STACK " + ind + " IS AT " + req);
                    }
                } else if (y != req) {
                    System.out.println("Moving node from (" + this.x + "," + this.y + "[" + this.index + "]) to (" + x2 + "," + y + "[" + ind + "]) BUT STACK " + ind + " IS AT " + req);
                }
                if (o != (oReq = RowCol.this.getOrientation(ind))) {
                    System.out.println("Rotating node from (" + this.x + "," + this.y + ")[S=" + this.index + " O=" + this.orientation.toString() + "] to (" + x2 + "," + y + ")[S=" + ind + " O=" + o.toString() + "] BUT O SHOULD BE '" + oReq.toString() + "'");
                }
            }
            this.x = x2;
            this.y = y;
            this.index = ind;
            this.orientation = o;
        }

        public int getColumnRowIndex() {
            return this.index;
        }

        public List<PlacementFrame.PlacementNetwork> getNets() {
            return this.nets;
        }

        public double getPlacementX() {
            return this.x;
        }

        public double getPlacementY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public double getCellSize() {
            if (RowCol.this.columnPlacement) {
                return this.height;
            }
            return this.width;
        }

        public double getCellGirth() {
            if (RowCol.this.columnPlacement) {
                return this.width;
            }
            return this.height;
        }

        public Orientation getPlacementOrientation() {
            return this.orientation;
        }

        @Override
        public int compareTo(ProxyNode o) {
            if (RowCol.this.columnPlacement) {
                double y2;
                double y1 = this.getPlacementY();
                if (y1 < (y2 = o.getPlacementY())) {
                    return 1;
                }
                if (y1 > y2) {
                    return -1;
                }
            } else {
                double x2;
                double x1 = this.getPlacementX();
                if (x1 < (x2 = o.getPlacementX())) {
                    return 1;
                }
                if (x1 > x2) {
                    return -1;
                }
            }
            return 0;
        }
    }
}

