/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.swing;

import gnu.jemacs.buffer.Buffer;
import gnu.jemacs.buffer.CancelledException;
import gnu.jemacs.buffer.EFrame;
import gnu.jemacs.swing.SwingMenu;
import gnu.jemacs.swing.SwingWindow;
import gnu.lists.LList;
import java.util.Enumeration;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SwingFrame
extends EFrame {
    JFrame jframe;
    JMenuBar menuBar;
    JPanel contents;

    public SwingFrame() {
    }

    public SwingFrame(Buffer buffer) {
        this(new SwingWindow(buffer, true));
    }

    public SwingFrame(SwingWindow window) {
        super(window);
        this.contents = window.wrap();
        this.jframe = new JFrame(SwingFrame.defaultName());
        this.jframe.getContentPane().add(this.contents);
        this.jframe.setSize(600, 400);
        this.jframe.setVisible(true);
        this.jframe.setTitle("JEmacs");
        this.menuBar = new JMenuBar();
        this.jframe.setJMenuBar(this.menuBar);
    }

    @Override
    public boolean isLive() {
        return this.contents != null;
    }

    @Override
    public void validate() {
        this.jframe.validate();
    }

    @Override
    public void delete() {
        super.delete();
        this.contents = null;
        this.jframe.dispose();
    }

    @Override
    public String ask(String prompt) {
        String result = JOptionPane.showInputDialog(this.jframe, (Object)prompt);
        if (result == null) {
            throw new CancelledException();
        }
        return result;
    }

    @Override
    public void setMenuBar(LList menu) {
        this.menuBar.removeAll();
        Enumeration e = menu.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            Object item = e.nextElement();
            if (item == null) {
                this.menuBar.add(Box.createHorizontalGlue());
            } else {
                this.menuBar.add(new SwingMenu((LList)item));
            }
            ++i;
        }
        this.menuBar.updateUI();
    }

    @Override
    public String toString() {
        StringBuffer sbuf = new StringBuffer(100);
        sbuf.append("#<frame #");
        sbuf.append(this.id);
        if (this.jframe != null) {
            sbuf.append(" size: ");
            sbuf.append(this.jframe.getSize());
            sbuf.append(" preferred: ");
            sbuf.append(this.jframe.getPreferredSize());
        }
        sbuf.append('>');
        return sbuf.toString();
    }
}

