/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.bytecode.ClassType;
import gnu.expr.PrimProcedure;
import gnu.jemacs.buffer.Buffer;
import gnu.jemacs.buffer.EKeymap;
import gnu.jemacs.buffer.EWindow;
import gnu.jemacs.buffer.Marker;
import gnu.jemacs.buffer.Mode;
import gnu.jemacs.buffer.ProcessInsertCommand;
import gnu.jemacs.buffer.Signal;
import gnu.lists.CharSeq;
import gnu.mapping.Procedure;
import gnu.mapping.WrappedException;
import java.io.IOException;
import java.io.Writer;

public class ProcessMode
extends Mode {
    protected Writer toInferior;
    protected Marker processMark;
    protected boolean lineMode = false;
    static Procedure enterAction = new PrimProcedure(ClassType.make("gnu.jemacs.buffer.ProcessMode").getDeclaredMethod("enterAction", 0));
    public static EKeymap modeMap = new EKeymap("process");

    public Marker getProcessMark() {
        return this.processMark;
    }

    public static void enterAction() {
        Buffer buffer = Buffer.getCurrent();
        ProcessMode processMode = ProcessMode.getProcessMode(buffer);
        processMode.enter();
    }

    public void enter() {
        try {
            if (this.lineMode) {
                this.buffer.insert('\n', 1, null);
                int n = this.buffer.getDot();
                int n2 = this.processMark.getOffset();
                this.buffer.writeTo(n2, n - n2, this.toInferior);
                this.processMark.setDot(n);
            } else {
                this.toInferior.write(13);
            }
            this.toInferior.flush();
        }
        catch (Exception exception) {
            throw new WrappedException(exception);
        }
    }

    public static ProcessMode getProcessMode(Buffer buffer) {
        Mode mode = buffer.modes;
        while (true) {
            if (mode == null) {
                Signal.error("not in process mode");
            }
            if (mode instanceof ProcessMode) {
                return (ProcessMode)mode;
            }
            mode = mode.next;
        }
    }

    public void writeToInferior(CharSeq charSeq) throws IOException {
        charSeq.writeTo(this.toInferior);
        this.toInferior.flush();
    }

    public void selfInsert() {
        EWindow eWindow = EWindow.getSelected();
        this.insert((char)eWindow.pendingKeys[eWindow.pendingLength], 1);
    }

    public void insert(char c, int n) {
        if (!this.lineMode) {
            try {
                while (--n >= 0) {
                    this.toInferior.write(c);
                }
                this.toInferior.flush();
            }
            catch (Exception exception) {
                throw new WrappedException(exception);
            }
        } else {
            this.buffer.insert(c, n);
        }
    }

    static {
        modeMap.defineKey("\n", (Object)enterAction);
        modeMap.defineKey("\r", (Object)enterAction);
        modeMap.defineKey("return", (Object)enterAction);
        ProcessInsertCommand processInsertCommand = new ProcessInsertCommand();
        modeMap.set(32, 126, processInsertCommand);
        modeMap.set(128, 255, processInsertCommand);
    }
}

