/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.ConstantConstraint;
import gnu.mapping.Constraint;
import gnu.mapping.Environment;
import gnu.mapping.Location;
import gnu.mapping.Procedure;
import gnu.mapping.TrivialConstraint;
import gnu.mapping.UnboundConstraint;
import gnu.mapping.UnboundSymbol;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.PrintWriter;

public class Symbol
extends Location
implements Externalizable {
    Object value;
    Constraint constraint;
    public static final String UNBOUND = new String("(unbound)");
    static final String FUNCTION = new String("(function).");
    public static final Symbol hashDELETED = new Symbol(new String("<Deleted>"));

    public final String getNamespaceURI() {
        Environment environment = this.getEnvironment();
        return environment == null ? null : environment.getName();
    }

    public final String getLocalName() {
        return this.getName();
    }

    public static Symbol make(Object object2, String string) {
        if (string != null) {
            string = string.intern();
        }
        if (object2 == null) {
            return new Symbol(string);
        }
        Environment environment = object2 instanceof String ? Environment.getInstance((String)object2) : (Environment)object2;
        return environment.getSymbol(string);
    }

    public final Object get() {
        return this.constraint.get(this);
    }

    public final Object get(Object object2) {
        return this.constraint.get(this, object2);
    }

    public Procedure getProcedure() {
        try {
            return this.constraint.getProcedure(this);
        }
        catch (UnboundSymbol unboundSymbol) {
            Object object2 = this.getFunctionValue(UNBOUND);
            if (object2 != UNBOUND) {
                return (Procedure)object2;
            }
            throw unboundSymbol;
        }
    }

    public final void defineValue(Object object2) {
        Environment environment = this.constraint.getEnvironment(this);
        if (environment == null || environment.locked) {
            this.set(object2);
        } else {
            this.constraint = TrivialConstraint.getInstance(this);
            this.value = object2;
        }
    }

    public final void defineConstant(Object object2) {
        Environment environment = this.constraint.getEnvironment(this);
        if (environment.locked) {
            this.set(object2);
        } else {
            this.constraint = ConstantConstraint.getInstance(environment);
            this.value = object2;
        }
    }

    public final void set(Object object2) {
        this.constraint.set(this, object2);
    }

    public final Constraint getConstraint() {
        return this.constraint;
    }

    public final void setConstraint(Constraint constraint) {
        this.constraint = constraint;
    }

    public boolean isBound() {
        return this.constraint.isBound(this);
    }

    public Symbol() {
    }

    public Symbol(String string) {
        this.setName(string);
        this.constraint = UnboundConstraint.getInstance((Environment)null);
    }

    public static Symbol makeUninterned(Object object2, String string) {
        Symbol symbol = new Symbol(string);
        symbol.value = object2;
        symbol.constraint = TrivialConstraint.getInstance((Environment)null);
        return symbol;
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("#<binding ");
        String string = this.getName();
        if (string != null) {
            printWriter.print(string);
        }
        if (this.isBound()) {
            printWriter.print(" -> ");
            printWriter.print(this.get());
        } else {
            printWriter.print("(unbound)");
        }
        printWriter.print('>');
    }

    public final Object getKey() {
        return this.getName();
    }

    public final Object getValue() {
        return this.constraint.get(this);
    }

    public final Object setValue(Object object2) {
        Object object3 = this.constraint.get(this);
        this.constraint.set(this, object2);
        return object3;
    }

    public boolean equals(Object object2) {
        return this == object2;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public static int hashSearch(Symbol[] symbolArray, int n, int n2, String string, int n3) {
        int n4 = n3 & n2;
        Symbol symbol = symbolArray[n4];
        if (symbol == null || symbol.getName() == string) {
            return n4;
        }
        int n5 = -1;
        int n6 = ((n3 >> n ^ n4) << 1) + 1;
        do {
            if (symbol == hashDELETED && n5 < 0) {
                n5 = n4;
            }
            if ((symbol = symbolArray[n4 = n4 + n6 & n2]) != null) continue;
            return n5 < 0 ? n4 : n5;
        } while (symbol.getName() != string);
        return n4;
    }

    public static int hashSearch(Symbol[] symbolArray, int n, String string) {
        return Symbol.hashSearch(symbolArray, n, (1 << n) - 1, string, System.identityHashCode(string));
    }

    public static Symbol hashGet(Symbol[] symbolArray, int n, String string) {
        int n2 = Symbol.hashSearch(symbolArray, n, (1 << n) - 1, string, System.identityHashCode(string));
        Symbol symbol = symbolArray[n2];
        if (symbol == null || symbol == hashDELETED) {
            return null;
        }
        return symbol;
    }

    public static Symbol hashSet(Symbol[] symbolArray, int n, Symbol symbol) {
        String string = symbol.getName();
        int n2 = Symbol.hashSearch(symbolArray, n, (1 << n) - 1, string, System.identityHashCode(string));
        Symbol symbol2 = symbolArray[n2];
        symbolArray[n2] = symbol;
        return symbol2 == hashDELETED ? null : symbol2;
    }

    public static Symbol hashDelete(Symbol[] symbolArray, int n, String string) {
        int n2 = Symbol.hashSearch(symbolArray, n, (1 << n) - 1, string, System.identityHashCode(string));
        Symbol symbol = symbolArray[n2];
        symbolArray[n2] = hashDELETED;
        return symbol == hashDELETED ? null : symbol;
    }

    public static int hashInsertAll(Symbol[] symbolArray, int n, Symbol[] symbolArray2, int n2) {
        int n3 = 0;
        int n4 = 1 << n2;
        int n5 = 1 << n;
        int n6 = (1 << n) - 1;
        int n7 = n4;
        while (--n7 >= 0) {
            Symbol symbol = symbolArray2[n7];
            if (symbol == null || symbol == hashDELETED) continue;
            String string = symbol.getName();
            int n8 = Symbol.hashSearch(symbolArray, n, n6, string, System.identityHashCode(string));
            Symbol symbol2 = symbolArray[n8];
            if (symbol2 != null && symbol2 != hashDELETED) {
                ++n3;
            }
            symbolArray[n8] = symbol;
        }
        return n3;
    }

    public final Object getFunctionValue() {
        Object object2 = this.constraint.getFunctionValue(this);
        if (object2 == UNBOUND) {
            throw new UnboundSymbol(this.getName());
        }
        return object2;
    }

    public final Object getFunctionValue(Object object2) {
        Object object3 = this.constraint.getFunctionValue(this);
        return object3 == UNBOUND ? object2 : object3;
    }

    public boolean hasFunctionValue() {
        Object object2 = this.constraint.getFunctionValue(this);
        return object2 != UNBOUND;
    }

    public void setFunctionValue(Object object2) {
        this.constraint.setFunctionValue(this, object2);
    }

    public void removeFunctionValue() {
        this.constraint.setFunctionValue(this, UNBOUND);
    }

    public final Environment getEnvironment() {
        return this.constraint.getEnvironment(this);
    }

    public String toString() {
        String string = this.getNamespaceURI();
        if (string == null || string.length() == 0) {
            return this.getName();
        }
        return '{' + this.getNamespaceURI() + "}" + this.getName();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getEnvironment());
        objectOutput.writeObject(this.getName());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Environment environment = (Environment)objectInput.readObject();
        this.constraint = environment == null ? UnboundConstraint.getInstance((Environment)null) : environment.unboundConstraint;
        String string = (String)objectInput.readObject();
        if (string != null) {
            this.setName(string.intern());
        }
    }

    public Object readResolve() throws ObjectStreamException {
        if (this.constraint == null) {
            return this;
        }
        Environment environment = this.constraint.getEnvironment(this);
        if (environment == null) {
            return this;
        }
        return Symbol.make(environment, this.getName());
    }
}

