/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.DQuantity;
import gnu.math.Quantity;
import gnu.math.Unit;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;

public class NamedUnit
extends Unit
implements Externalizable {
    String name;
    double scale;
    Unit base;
    NamedUnit chain;

    public NamedUnit() {
    }

    public NamedUnit(String string, DQuantity dQuantity) {
        this.name = string.intern();
        this.scale = dQuantity.factor;
        this.base = dQuantity.unt;
        this.init();
    }

    public NamedUnit(String string, double d, Unit unit) {
        this.name = string;
        this.base = unit;
        this.scale = d;
        this.init();
    }

    protected void init() {
        this.factor = this.scale * this.base.factor;
        this.dims = this.base.dims;
        this.name = this.name.intern();
        int n = this.name.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % table.length;
        this.chain = table[n2];
        NamedUnit.table[n2] = this;
    }

    public String getName() {
        return this.name;
    }

    public static NamedUnit lookup(String string) {
        string = string.intern();
        int n = string.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % table.length;
        NamedUnit namedUnit = table[n2];
        while (namedUnit != null) {
            if (namedUnit.name == string) {
                return namedUnit;
            }
            namedUnit = namedUnit.chain;
        }
        return null;
    }

    public static NamedUnit lookup(String string, double d, Unit unit) {
        string = string.intern();
        int n = string.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % table.length;
        NamedUnit namedUnit = table[n2];
        while (namedUnit != null) {
            if (namedUnit.name == string && namedUnit.scale == d && namedUnit.base == unit) {
                return namedUnit;
            }
            namedUnit = namedUnit.chain;
        }
        return null;
    }

    public static NamedUnit make(String string, double d, Unit unit) {
        NamedUnit namedUnit = NamedUnit.lookup(string, d, unit);
        return namedUnit == null ? new NamedUnit(string, d, unit) : namedUnit;
    }

    public static NamedUnit make(String string, Quantity quantity) {
        double d;
        if (quantity instanceof DQuantity) {
            d = ((DQuantity)quantity).factor;
        } else {
            if (quantity.imValue() != 0.0) {
                throw new ArithmeticException("defining " + string + " using complex value");
            }
            d = quantity.re().doubleValue();
        }
        Unit unit = quantity.unit();
        NamedUnit namedUnit = NamedUnit.lookup(string, d, unit);
        return namedUnit == null ? new NamedUnit(string, d, unit) : namedUnit;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.name);
        objectOutput.writeDouble(this.scale);
        objectOutput.writeObject(this.base);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.name = objectInput.readUTF();
        this.scale = objectInput.readDouble();
        this.base = (Unit)objectInput.readObject();
    }

    public Object readResolve() throws ObjectStreamException {
        NamedUnit namedUnit = NamedUnit.lookup(this.name, this.scale, this.base);
        if (namedUnit != null) {
            return namedUnit;
        }
        this.init();
        return this;
    }
}

