/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Language;
import gnu.mapping.Environment;
import gnu.mapping.Location;
import gnu.mapping.Named;
import gnu.mapping.Symbol;
import gnu.mapping.UnboundLocationException;
import gnu.mapping.WrappedException;
import java.lang.reflect.Field;

public class ClassMemberLocation
extends Location {
    Object instance;
    ClassType type;
    String mname;
    Field rfield;

    public final Object getInstance() {
        return this.instance;
    }

    public final void setInstance(Object object2) {
        this.instance = object2;
    }

    public ClassMemberLocation(Object object2, ClassType classType, String string) {
        this.instance = object2;
        this.type = classType;
        this.mname = string;
    }

    public ClassMemberLocation(Object object2, Class clazz, String string) {
        this.instance = object2;
        this.type = (ClassType)Type.make(clazz);
        this.mname = string;
    }

    public String getMemberName() {
        return this.mname;
    }

    public ClassType getDeclaringClass() {
        return this.type;
    }

    public ClassMemberLocation(Object object2, Field field) {
        this.instance = object2;
        this.rfield = field;
        this.mname = field.getName();
    }

    void setup() {
        if (this.rfield == null) {
            Class clazz;
            try {
                clazz = this.type.getReflectClass();
            }
            catch (RuntimeException runtimeException) {
                UnboundLocationException unboundLocationException = new UnboundLocationException(null, "Unbound location - " + runtimeException.toString());
                unboundLocationException.initCause(runtimeException);
                throw unboundLocationException;
            }
            try {
                this.rfield = clazz.getField(this.mname);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                UnboundLocationException unboundLocationException = new UnboundLocationException(null, "Unbound location  - no field " + this.mname + " in " + this.type.getName());
                unboundLocationException.initCause(noSuchFieldException);
                throw unboundLocationException;
            }
        }
    }

    public Field getRField() {
        Field field = this.rfield;
        if (field == null) {
            Class clazz = null;
            try {
                clazz = this.type.getReflectClass();
                this.rfield = field = clazz.getField(this.mname);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return field;
    }

    public Object get(Object object2) {
        Field field = this.getRField();
        if (field == null) {
            return object2;
        }
        try {
            return field.get(this.instance);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw WrappedException.wrapIfNeeded(illegalAccessException);
        }
    }

    public boolean isConstant() {
        Field field = this.getRField();
        return field != null && (this.rfield.getModifiers() & 0x10) != 0;
    }

    public boolean isBound() {
        Field field = this.getRField();
        return field != null;
    }

    public void set(Object object2) {
        this.setup();
        try {
            this.rfield.set(this.instance, object2);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw WrappedException.wrapIfNeeded(illegalAccessException);
        }
    }

    public static void define(Object object2, Field field, String string, Language language, Environment environment) throws IllegalAccessException {
        Location location2;
        Object object3;
        Object object4 = field.get(object2);
        Type type = Type.make(field.getType());
        boolean bl = type.isSubtype(Compilation.typeLocation);
        boolean bl2 = type.isSubtype(Compilation.typeProcedure);
        Object object5 = object3 = object4 instanceof Named && !bl ? ((Named)object4).getSymbol() : Compilation.demangleName(field.getName(), true);
        Symbol symbol = object3 instanceof Symbol ? (Symbol)object3 : Symbol.make(string == null ? "" : string, object3.toString().intern());
        boolean bl3 = (field.getModifiers() & 0x10) != 0;
        Object object6 = null;
        if (bl && bl3) {
            location2 = (Location)object4;
        } else {
            if (bl3) {
                object6 = language.getEnvPropertyFor(field, object4);
            }
            location2 = new ClassMemberLocation(object2, field);
        }
        environment.addLocation(symbol, object6, location2);
    }

    public static void defineAll(Object object2, Environment environment) throws IllegalAccessException {
        Class<?> clazz = object2.getClass();
        Language language = Language.getDefaultLanguage();
        Field[] fieldArray = clazz.getFields();
        int n = fieldArray.length;
        while (--n >= 0) {
            Field field = fieldArray[n];
            String string = field.getName();
            if (string.startsWith("$Prvt$") || string.endsWith("$instance")) continue;
            ClassMemberLocation.define(object2, field, null, language, environment);
        }
    }
}

