/*
 * Decompiled with CFR 0.152.
 */
package kawa;

import gnu.expr.Language;
import gnu.expr.ModuleBody;
import gnu.expr.ModuleExp;
import gnu.lists.AbstractFormat;
import gnu.lists.Consumer;
import gnu.lists.VoidConsumer;
import gnu.mapping.CallContext;
import gnu.mapping.CharArrayInPort;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.TtyInPort;
import gnu.mapping.WrongArguments;
import gnu.text.SourceError;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import kawa.standard.load;

public class Shell {
    private static Class[] noClasses = new Class[0];
    private static Class[] boolClasses = new Class[]{Boolean.TYPE};
    private static Class[] xmlPrinterClasses = new Class[]{class$gnu$lists$Consumer == null ? (class$gnu$lists$Consumer = Shell.class$("gnu.lists.Consumer")) : class$gnu$lists$Consumer, class$java$lang$Object == null ? (class$java$lang$Object = Shell.class$("java.lang.Object")) : class$java$lang$Object};
    private static Class[] httpPrinterClasses = new Class[]{class$gnu$mapping$OutPort == null ? (class$gnu$mapping$OutPort = Shell.class$("gnu.mapping.OutPort")) : class$gnu$mapping$OutPort};
    private static Object portArg = "(port)";
    static Object[][] formats = new Object[][]{{"scheme", "gnu.kawa.functions.DisplayFormat", "getSchemeFormat", boolClasses, Boolean.FALSE}, {"readable-scheme", "gnu.kawa.functions.DisplayFormat", "getSchemeFormat", boolClasses, Boolean.TRUE}, {"elisp", "gnu.kawa.functions.DisplayFormat", "getEmacsLispFormat", boolClasses, Boolean.FALSE}, {"readable-elisp", "gnu.kawa.functions.DisplayFormat", "getEmacsLispFormat", boolClasses, Boolean.TRUE}, {"clisp", "gnu.kawa.functions.DisplayFormat", "getCommonLispFormat", boolClasses, Boolean.FALSE}, {"readable-clisp", "gnu.kawa.functions.DisplayFormat", "getCommonLispFormat", boolClasses, Boolean.TRUE}, {"commonlisp", "gnu.kawa.functions.DisplayFormat", "getCommonLispFormat", boolClasses, Boolean.FALSE}, {"readable-commonlisp", "gnu.kawa.functions.DisplayFormat", "getCommonLispFormat", boolClasses, Boolean.TRUE}, {"xml", "gnu.xml.XMLPrinter", "make", xmlPrinterClasses, portArg, null}, {"html", "gnu.xml.XMLPrinter", "make", xmlPrinterClasses, portArg, "html"}, {"xhtml", "gnu.xml.XMLPrinter", "make", xmlPrinterClasses, portArg, "xhtml"}, {"cgi", "gnu.kawa.xml.HttpPrinter", "make", httpPrinterClasses, portArg}, {"ignore", "gnu.lists.VoidConsumer", "getInstance", noClasses}, {null}};
    public static String defaultFormatName;
    public static Object[] defaultFormatInfo;
    public static Method defaultFormatMethod;
    static /* synthetic */ Class class$gnu$lists$Consumer;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$gnu$mapping$OutPort;

    public static void setDefaultFormat(String string) {
        defaultFormatName = string = string.intern();
        int n = 0;
        while (true) {
            Object[] objectArray;
            Object object2;
            if ((object2 = (objectArray = formats[n])[0]) == null) {
                System.err.println("kawa: unknown output format '" + string + "'");
                System.exit(-1);
            } else if (object2 == string) {
                defaultFormatInfo = objectArray;
                try {
                    Class<?> clazz = Class.forName((String)objectArray[1]);
                    defaultFormatMethod = clazz.getMethod((String)objectArray[2], (Class[])objectArray[3]);
                }
                catch (Throwable throwable) {
                    System.err.println("kawa:  caught " + throwable + " while looking for format '" + string + "'");
                    System.exit(-1);
                }
                break;
            }
            ++n;
        }
        if (!defaultFormatInfo[1].equals("gnu.lists.VoidConsumer")) {
            ModuleBody.setMainPrintValues(true);
        }
    }

    public static Consumer getOutputConsumer(OutPort outPort) {
        Object[] objectArray = defaultFormatInfo;
        if (outPort == null) {
            return VoidConsumer.getInstance();
        }
        if (objectArray == null) {
            return Language.getDefaultLanguage().getOutputConsumer(outPort);
        }
        try {
            Object[] objectArray2 = new Object[objectArray.length - 4];
            System.arraycopy(objectArray, 4, objectArray2, 0, objectArray2.length);
            int n = objectArray2.length;
            while (--n >= 0) {
                if (objectArray2[n] != portArg) continue;
                objectArray2[n] = outPort;
            }
            Object object2 = defaultFormatMethod.invoke(null, objectArray2);
            if (object2 instanceof AbstractFormat) {
                outPort.objectFormat = (AbstractFormat)object2;
                return outPort;
            }
            return (Consumer)object2;
        }
        catch (Throwable throwable) {
            throw new RuntimeException("cannot get output-format '" + defaultFormatName + "' - caught " + throwable);
        }
    }

    public static void run(Language language, Environment environment) {
        Procedure procedure;
        InPort inPort = InPort.inDefault();
        if (inPort instanceof TtyInPort && (procedure = language.getPrompter()) != null) {
            ((TtyInPort)inPort).setPrompter(procedure);
        }
        Shell.run(language, environment, inPort, OutPort.outDefault(), OutPort.errDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(Language language, Environment environment, InPort inPort, OutPort outPort, OutPort outPort2) {
        AbstractFormat abstractFormat = null;
        if (outPort != null) {
            abstractFormat = outPort.objectFormat;
        }
        Consumer consumer = Shell.getOutputConsumer(outPort);
        try {
            Shell.run(language, environment, inPort, consumer, outPort2);
        }
        finally {
            if (outPort != null) {
                outPort.objectFormat = abstractFormat;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void run(Language var0, Environment var1_1, InPort var2_2, Consumer var3_3, OutPort var4_4) {
        var5_5 = new SourceMessages();
        var6_6 = Language.getDefaultLanguage();
        var7_7 = var0.getLexer(var2_2, var5_5);
        var8_8 = var2_2 instanceof TtyInPort;
        var7_7.setInteractive(var8_8);
        var9_9 = CallContext.getInstance();
        var10_10 = null;
        if (var3_3 != null) {
            var10_10 = var9_9.consumer;
            var9_9.consumer = var3_3;
        }
        if (var0 != var6_6) {
            Language.setDefaultLanguage(var0);
        }
        try {
            while (true) {
                var11_11 = 3;
                try {
                    var12_12 = var0.parse(var7_7, var11_11);
                    var13_18 = var5_5.checkErrors(var4_4, 20);
                    if (var12_12 == null) break;
                    if (var13_18) continue;
                    var12_12.getModule().setName("atInteractiveLevel$" + ++ModuleExp.interactiveCounter);
                    while ((var14_20 = var2_2.read()) >= 0 && var14_20 != 13 && var14_20 != 10) {
                        if (var14_20 == 32 || var14_20 == 9) continue;
                        var2_2.unread();
                        break;
                    }
                    ModuleExp.evalModule(var1_1, var9_9, var12_12);
                    if (var5_5.checkErrors(var4_4, 20)) continue;
                    var9_9.runUntilDone();
                    if (var14_20 >= 0) continue;
                }
                catch (WrongArguments var12_13) {
                    var5_5.printAll(var4_4, 20);
                    if (var12_13.usage != null) {
                        var4_4.println("usage: " + var12_13.usage);
                    }
                    var12_13.printStackTrace(var4_4);
                    continue;
                }
                catch (ClassCastException var12_14) {
                    var5_5.printAll(var4_4, 20);
                    var4_4.println("Invalid parameter, was: " + var12_14.getMessage());
                    var12_14.printStackTrace(var4_4);
                    continue;
                }
                catch (SyntaxException var12_15) {
                    var12_15.printAll(var4_4, 20);
                    var12_15.clear();
                    if (var8_8) continue;
                    var16_21 = null;
                    if (var3_3 != null) {
                        var9_9.consumer = var10_10;
                    }
                    if (var0 != var6_6) {
                        Language.setDefaultLanguage(var6_6);
                    }
                    return;
                }
                catch (IOException var12_16) {
                    var5_5.printAll(var4_4, 20);
                    var13_19 = new SourceError(var2_2, 'e', "").toString();
                    var13_19 = var13_19.substring(0, var13_19.length() - 2);
                    var4_4.println(var13_19 + " (or later): caught IOException");
                    var12_16.printStackTrace(var4_4);
                    if (var8_8) continue;
                    var16_22 = null;
                    if (var3_3 != null) {
                        var9_9.consumer = var10_10;
                    }
                    if (var0 != var6_6) {
                        Language.setDefaultLanguage(var6_6);
                    }
                    return;
                }
                catch (Throwable var12_17) {
                    var5_5.printAll(var4_4, 20);
                    var12_17.printStackTrace(var4_4);
                    if (!var8_8) ** break;
                    continue;
                    var16_23 = null;
                    if (var3_3 != null) {
                        var9_9.consumer = var10_10;
                    }
                    if (var0 != var6_6) {
                        Language.setDefaultLanguage(var6_6);
                    }
                    return;
                }
                break;
            }
            var16_24 = null;
            if (var3_3 != null) {
                var9_9.consumer = var10_10;
            }
            ** if (var0 == var6_6) goto lbl-1000
        }
        catch (Throwable var15_26) {
            var16_25 = null;
            if (var3_3 != null) {
                var9_9.consumer = var10_10;
            }
            if (var0 != var6_6) {
                Language.setDefaultLanguage(var6_6);
            }
            throw var15_26;
        }
lbl-1000:
        // 1 sources

        {
            Language.setDefaultLanguage(var6_6);
        }
lbl-1000:
        // 2 sources

        {
        }
    }

    public static void runString(String string, Language language, Environment environment) {
        Shell.run(language, environment, (InPort)new CharArrayInPort(string), ModuleBody.getMainPrintValues() ? OutPort.outDefault() : null, OutPort.errDefault());
    }

    public static void runFile(String string) {
        Environment environment = Environment.getCurrent();
        try {
            if (string.equals("-")) {
                load.loadSource(InPort.inDefault(), environment);
            } else {
                load.apply(string, environment, false);
            }
        }
        catch (SyntaxException syntaxException) {
            syntaxException.printAll(OutPort.errDefault(), 20);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Cannot open file " + string);
            System.exit(1);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
            System.exit(1);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

